/* t4test.c   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif
#include "t4test.h"

#ifdef S4WINDOWS
   #ifdef __ZTC__
      #ifndef NULL
         #define NULL 0
      #endif
   #endif
   #ifdef DLL
      #define TEST_EXPORT _export
   #endif
#else
   #ifdef S4UNIX
      #ifdef S4CURSES
/*       #include <curses.h>  */
      #else
/*       #include <tinfo.h>   */
      #endif
   #else
      #include <conio.h>
   #endif
#endif

#ifdef S4WINDOWS
   HCURSOR hHourGlass, hSaveCursor ;
#endif

#ifdef S4WINDOWS
   void S4FUNCTION d4display_init( D4DISPLAY *disp, HWND h )
   {
      HDC hdc ;
      TEXTMETRIC tm ;

      memset( disp, 0, sizeof(D4DISPLAY) ) ;
      disp->hWnd = h ;
      disp->lpmsg = &(disp->msg) ;
      hdc = GetDC(disp->hWnd) ;
      GetTextMetrics( hdc, &tm ) ;
      disp->tm = tm ;
      ReleaseDC(disp->hWnd,hdc) ;
      disp->x = 0 ;
      disp->y = 0 ;
      disp->did_close = 0 ;
      disp->did_quit  = 0 ;
   }

   #ifdef S4MEDIUM
      char pointer[100] ;   /* argument list for medium memory model */
   #endif
#endif

void  S4FUNCTION d4display_str( D4DISPLAY *disp, char *str, int is_new_line )
{
   #ifdef S4WINDOWS
      RECT rect ;
      HDC hdc ;
      int len, height, width ;
      DWORD dword ;
      char blank_line[180] ;

      memset(blank_line, 32, 179) ;
      blank_line[179] = '\0' ;

      hdc = GetDC(disp->hWnd) ;
      len = strlen(str) ;

      dword = GetTextExtent( hdc, str, len ) ;
      height = HIWORD( dword ) ;
      width  = LOWORD( dword ) ;

      if ( is_new_line )
      {
         disp->x = 0 ;
         disp->y += height + disp->tm.tmExternalLeading ;
      }

      GetClientRect( disp->hWnd, &rect ) ;

      if ( (disp->y+height) > rect.bottom )
      {
         disp->y = 0 ;
         InvalidateRect( disp->hWnd, &rect, 1 ) ;
      }

      TextOut( hdc, disp->x,disp->y, str, len ) ;

      if ( (disp->y+(2*height)) > rect.bottom )
         TextOut( hdc, 0, 0, blank_line, strlen(blank_line) ) ;
      else   
         TextOut( hdc, 0, (disp->y+height+disp->tm.tmExternalLeading), blank_line, strlen(blank_line) ) ;

      disp->x += width ;

      ReleaseDC(disp->hWnd,hdc) ;
   #else
      if ( is_new_line )
      {
         printf( "\n%s", str ) ;
         disp->x = 1 ;
      }
      else
      {
         if (disp->x == 0)
         {
            printf( "\r%s", str ) ;
            disp->x = 1 ;
         }
         else
         {
            printf( "%s", str ) ;
            disp->x = 1 ;
         }
      }
   #endif
}

void  S4FUNCTION d4display_num( D4DISPLAY *disp, long num, int is_new_line )
{
   char str[13] ;
   char *ptr ;

   ptr = str ;
   c4ltoa45( num, ptr, sizeof(str)-1 ) ;
   str[12] = '\0' ;
   d4display_str( disp, str, is_new_line ) ;
}

int S4FUNCTION d4display_quit( D4DISPLAY *disp )
{
   #ifdef S4WINDOWS
      /* If there is a message, the message is processed. */
      /* If the message says quit, then TRUE is returned. */
      if ( disp->did_quit ) return 1 ;

      for (;;)
      {
         if ( ! disp->did_close )
            if ( ! PeekMessage( disp->lpmsg, disp->hWnd, 0, 0, PM_NOREMOVE ) )
               return 0 ;

         if ( ! GetMessage( disp->lpmsg, disp->hWnd, 0, 0 ) )
         {
            MessageBox( disp->hWnd, "", "Program Completed", MB_OK ) ;
            disp->did_quit = 1 ;
            return 1 ;
         }

         TranslateMessage(disp->lpmsg);
         DispatchMessage(disp->lpmsg);
      }
   #else
      return 0 ;
   #endif
}

int S4FUNCTION d4display_getch( D4DISPLAY *disp )
{
   #ifdef S4WINDOWS
      /* If there is a message, the message is processed. */
      /* If the message says quit, then TRUE is returned. */
      if ( disp->did_quit ) return 1 ;

      for (;;)
      {
         if ( ! GetMessage( disp->lpmsg, disp->hWnd, 0, 0 ) )
         {
            MessageBox( disp->hWnd, "", "Program Completed", MB_OK ) ;
            disp->did_quit = 1 ;
            return 1 ;
         }

         if ( disp->lpmsg->message == WM_KEYDOWN )
            return 0 ;

         TranslateMessage(disp->lpmsg);
         DispatchMessage(disp->lpmsg);
      }
   #else
      #ifdef S4UNIX
         return getchar() ;
      #else
         return getch() ;
      #endif
   #endif
}

void  S4FUNCTION d4display_wait( D4DISPLAY *disp )
{
   #ifdef S4WINDOWS
      hHourGlass = LoadCursor( NULL, IDC_WAIT ) ;

      SetCapture( disp->hWnd ) ;
      hSaveCursor = SetCursor(hHourGlass) ;
   #endif
}


void  S4FUNCTION d4display_start()
{
   #ifdef S4WINDOWS
      SetCursor(hSaveCursor) ;
      ReleaseCapture() ;
   #endif
}


#ifdef S4WINDOWS
   void S4FUNCTION d4parsestring_init( D4PARSE_STR *p_str, LPSTR p )
   {
      memset( p_str, 0, sizeof(D4PARSE_STR) ) ;

      #ifdef S4MEDIUM
         lstrcpy( pointer, p ) ;
         p_str->ptr = pointer ;
      #else
         p_str->ptr = p ;
      #endif
   }
#else
   void S4FUNCTION d4parsestring_init( D4PARSE_STR *p_str, int n, char **p )
   {
      p_str->n_parms = n - 1 ;
      p_str->parms   = p ;
      p_str->i_parm  = 0 ;
   }
#endif


char *S4FUNCTION d4parsestring_nparm( D4PARSE_STR *p_str )
{
   #ifdef S4WINDOWS
      unsigned i ;
      char *new_ptr ;

      if ( p_str->ptr == 0 )
         return (char *) p_str->ptr ;

      while (p_str->ptr[0] == ' ' )
         p_str->ptr++ ;

      for ( i = 0; ; i++ )
         if ( p_str->ptr[i] == 0 || p_str->ptr[i] == ' ' )
         {
            new_ptr = p_str->ptr ;
            p_str->ptr += i ;
            return  (char *) new_ptr ;
         }
   #else
      p_str->i_parm++ ;
      if (p_str->i_parm > p_str->n_parms)
         return (char *) "" ;
      return  (char *) p_str->parms[p_str->i_parm] ;
   #endif
}
