/* t4skip.c  (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* tests Code Base 'd4skip' routine. */ 

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif


#include "t4test.h"

static FIELD4INFO fields[] =
{
   {"FLD",   'N',    13,    1 },
   {"CHR",   'C',     8,    0 },
   { 0,       0 ,     0,    0 },
};

static TAG4INFO tags[] =
{
   {"TAG",     "CHR",     "", 0, 0 },
   {"TAG_TWO", "101-VAL(CHR)", "", 0, 0 },
   { 0,     0,   0, 0, 0 },
} ;

CODE4   cb;
DATA4  *data;
INDEX4 *index ;
FIELD4 *field ;
TAG4   *tag ;


static void t4test_eof( DATA4 *data, int bof_cond, int eof_cond )
{
   int  rc ;

   rc = 0 ;
   
   if ( bof_cond )
   {
      if ( ! d4bof( data ) )
         rc = -1 ;
   }
   else
   {
      if ( d4bof( data ) )
         rc = -1 ;
   }
   if ( rc )
      e4severe( e4result, "t4skip:  d4bof()" ) ;
   
   if ( eof_cond )
   {
      if ( ! d4eof( data ) )
         rc = -1 ;
   }
   else
   {
      if ( d4eof( data ) )
         rc = -1 ;
   }
   if ( rc )
      e4severe( e4result, "t4skip:  d4eof()" ) ;
}

static void rec( DATA4 *data, long rec_no )
{
   if ( d4recno( data ) != rec_no )
      e4severe( e4result, "t4skip:  d4recno()" ) ;
}

static int  test_skip( D4DISPLAY *display, int do_open )
{
   char  buff[9] ;
   long  i_rec ;

   cb.safety = 0 ;

   if ( do_open )
   {
      cb.auto_open = 0 ;
      data = d4open( &cb, "T4SKIP" ) ;
      d4zap( data, 1L, d4reccount( data ) ) ;
   }
   else
      data = d4create( &cb, "T4SKIP", fields, 0 ) ;

   if ( data == 0 )
      e4severe( e4result, "t4skip.c" ) ;

   d4opt_start( &cb ) ;

   /* First Execute Skips on an Empty Database */
   if ( d4bottom( data ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;    rec( data, 1L ) ;

   if ( d4top( data ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;    rec( data, 1L ) ;

   if ( d4skip( data, -1L ) != r4bof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;    rec( data, 1L ) ;

   if ( d4skip( data, 1L )  != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;    rec( data, 1L ) ;

   if (do_open)
   {
      index = i4open( data, "T4SKIP" ) ;
      if( d4reindex( data ) != 0 )
         e4severe( e4result, "t4skip:  d4reindex" ) ;
   }
   else
      index = i4create( data, "T4SKIP", tags ) ;

   if ( index == 0 )
      e4severe( e4result, "t4skip:  Error" ) ;

   t4test_eof( data, 1, 1 ) ;
   rec( data, 1L ) ;

   /* Index File Skips on an Empty Database */
   if ( d4bottom( data ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;    rec( data, 1L ) ;

   if ( d4top( data ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;    rec( data, 1L ) ;

   if ( d4skip( data, -1L ) != r4bof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;
   rec( data, 1L ) ;

   if ( d4skip( data, 1L )  != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1, 1 ) ;
   rec( data, 1L ) ;

   /* Index File Skips on a One Record Database */
   if ( d4append_blank( data ) < 0 )
      e4severe( e4result, "t4skip:  d4append_blank" ) ;

   t4test_eof( data, 0, 0 ) ;
   rec( data, 1L ) ;

   if ( d4skip( data,  1L ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 1 ) ;
   rec( data, 2L ) ;

   if ( d4skip( data, -1L ) != 0 )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 0 ) ;
   rec( data, 1L ) ;

   if ( d4skip( data, -1L ) != r4bof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1,0 ) ;
   rec( data, 1L ) ;

   /* Database Skips on a One Record Database */
   tag = d4tag( data, "TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4skip:  d4tag" ) ;
   d4tag_select( data, tag ) ;

   if ( d4skip( data,  1L ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 1 ) ;
   rec( data, 2L ) ;

   if ( d4skip( data, -1L ) != 0 )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 0 ) ;
   rec( data, 1L ) ;

   if ( d4skip( data, -1L ) != r4bof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1,0 ) ;
   rec( data, 1L ) ;

   if ( d4zap( data, 1L, d4reccount( data ) ) != 0 )
      e4severe( e4result, "t4skip:  d4zap" ) ;
   t4test_eof( data, 1, 1 ) ;

   d4display_str( display,  "  Writing 100 Records . . .  ", 1 ) ;

   /* Write  100  Records */
   for ( i_rec = 1; i_rec <= 100; i_rec++ )
   {
   if ( d4display_quit( display ) )  return 1 ;

      if ( d4append_start( data, 0 ) < 0 )
         e4severe( e4result, "t4skip.c" ) ;
      f4assign_long( d4field_j( data, 2 ), (i_rec+1)/3 ) ;
      c4ltoa45( (long) (101 - i_rec), buff, 8 ) ;
      f4assign_n( d4field( data, "CHR" ), buff, 8 ) ;
      if ( d4append( data ) < 0 )
         e4severe( e4result, "t4skip.c" ) ;

      t4test_eof( data, 0, 0 ) ;
      rec( data, i_rec ) ;
   }

   if ( d4top( data ) != 0 )
      e4severe( e4result, "t4skip:  d4top" ) ;
   if ( d4recno( data ) != 100 )
      e4severe( e4result, "t4skip:  Error" ) ;

   if ( d4skip( data, 60L ) != 0 )
      e4severe( e4result, "t4skip:  d4skip" ) ;
   if ( d4recno( data ) != 40 )
      e4severe( e4result, "t4skip:  Error" ) ;

   if ( d4skip( data, 22L ) != 0 )
      e4severe( e4result, "t4skip:  d4skip" ) ;
   if ( d4recno( data ) != 18 )
      e4severe( e4result, "t4skip:  Error" ) ;

   if ( d4skip( data, -74L ) != 0 )
      e4severe( e4result, "t4skip:  d4skip" ) ;
   if ( d4recno( data ) != 92 )
      e4severe( e4result, "t4skip:  Error" ) ;

   if ( d4skip( data, -20L ) != r4bof )
      e4severe( e4result, "t4skip:  d4skip" ) ;
   if ( !d4bof( data ) )
      e4severe( e4result, "t4skip:  error eof()" ) ;

   /* Skip Test Without Index File */

   d4tag_select( data, 0 ) ;

   if ( d4bottom( data ) != 0 )
      e4severe( e4result, "t4skip:  d4bottom()" ) ;

   if ( d4skip( data, -99L ) != 0 )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 0 ) ;
   rec( data, 1L ) ;

   if ( d4skip( data, -1L ) != r4bof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1,0 ) ;
   rec( data, 1L ) ;

   for ( i_rec = 2; i_rec <= 100; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4skip( data, 1L ) != 0 )
         e4severe( e4result, "t4skip:  Error" ) ;
      t4test_eof( data, 0, 0 ) ;
      rec( data, i_rec ) ;
   }

   if ( d4skip( data, 1L ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 1 ) ;
   rec( data, 101L ) ;

   for ( i_rec = 100; i_rec >=1; i_rec-- )
   {
      if ( d4display_quit( display ) )  return 1 ;

      if ( d4skip( data, -1L ) != 0 )
         e4severe( e4result, "t4skip:  Error" ) ;
      t4test_eof( data, 0, 0 ) ;
      rec( data, i_rec ) ;
   }

   /* Skip Test With an Index File */

   d4tag_select( data, d4tag( data, "TAG_TWO" ) ) ;

   if ( d4bottom( data ) != 0 )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 0 ) ;
   rec( data, 100L ) ;

   if ( d4skip( data, -99L ) != 0 )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 0 ) ;
   rec( data, 1L ) ;

   if ( d4skip( data, -1L ) != r4bof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 1,0 ) ;
   rec( data, 1L ) ;

   for ( i_rec = 2; i_rec <= 100; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4skip( data, 1L ) != 0 )
         e4severe( e4result, "t4skip:  Error" ) ;
      t4test_eof( data, 0, 0 ) ;
      rec( data, i_rec ) ;
   }

   if ( d4skip( data, 1L ) != r4eof )
      e4severe( e4result, "t4skip:  Error" ) ;
   t4test_eof( data, 0, 1 ) ;
   rec( data, 101L ) ;

   for ( i_rec = 100; i_rec >=1; i_rec-- )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4skip( data, -1L ) != 0 )
         e4severe( e4result, "t4skip:  Error" ) ;
      t4test_eof( data, 0, 0 ) ;
      rec( data, i_rec ) ;
   }

   if ( d4close_all( &cb ) < 0 )
      e4severe( e4result, "t4skip:  d4close_all()" ) ;

   return 0 ;
}

static int  test_with_mem_check( D4DISPLAY *display )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_skip( display, 0 ) )
      return 1 ;
   if ( test_skip( display, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4skip.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}


int  S4FUNCTION t4test( D4DISPLAY *display )
{
   d4display_str( display,  "T4SKIP Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;

   if ( test_with_mem_check( display ) )
      e4exit(&cb) ;

   display->y += 2 ;
   d4display_str( display, "T4SKIP:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
