/* t4opt.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved.

   1. Verifies that the CodeBase optimization code is optimizing according to
      specification.
*/

#define T4NUM_RECS 200

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
   #ifndef S4WINDOWS
      #include <alloc.h>
   #endif
#endif

#include  "t4test.h"

static FIELD4INFO test_fields[] =
{
   { "C" , 'C' , 100, 0 },
   { "D", 'D', 8, 0 },
   { "M", 'M',10, 0 },
   { "N", 'N', 7, 2 },
   { 0,  0, 0, 0 },
} ;

static TAG4INFO tag_info[] =
{
   /* name, expression, filter, unique,descending */
   { "C_TAG",  "C", 0, 0, 0 },
   { "N_TAG",  "N", "", 0, 0 },
   { "D_TAG",  "D", 0, 0, 0 },
   { 0,0,0,0,0 },
} ;

CODE4 cb ;
DATA4 *database ;
FIELD4 *c_field, *n_field, *m_field, *d_field ;

static int do_test( D4DISPLAY *disp, char is_low )
{
   OPT4 *opt ;
   long i ;
   FILE4 file ;
   char buffer[4096], nm[13], nm2[13], was_created ;

   cb.safety = 0 ;
   cb.optimize = 1 ;

   database = d4create( &cb, "T4OPT", test_fields, tag_info ) ;

   if ( database == 0 )
      e4severe( e4result, "t4opt.c" ) ;

   n_field = d4field( database, "N" ) ;

   d4display_str( disp,  "Appending records:   ", 1 ) ;
   for ( i = 1 ; i <= T4NUM_RECS ; i++ )
   {
      if ( d4append_start( database, 0 ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;

      f4assign_int( n_field, (int)i ) ;

      if ( d4append( database ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;
   }

   if ( d4opt_start( &cb ) < 0 )
   {
      d4display_str( disp,  "Optimization unavailable for testing:   ", 1 ) ;
      d4close_all( &cb ) ;
      return 1 ;
   }

   opt = &cb.opt ;
   if ( opt == 0 )
      e4severe( e4result, "t4opt.c" ) ;

   if ( is_low == 1 )
   {
      if ( opt->prio[0] != &opt->dbf_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[1] != &opt->index_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[2] != &opt->other_lru )
         e4severe( e4result, "t4opt.c" ) ;
   }

   for ( i = 1 ; i <= T4NUM_RECS ; i++ )
      if ( d4go( database, i ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;

   if ( is_low == 1 )
   {
      if ( opt->prio[0] != &opt->dbf_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[1] != &opt->index_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[2] != &opt->other_lru )
         e4severe( e4result, "t4opt.c" ) ;
   }

   d4tag_select( database, d4tag( database, "N_TAG" ) ) ;

   for ( i = 1 ; i <= T4NUM_RECS ; i++ )
   {
      if ( d4seek_double( database, (double)i ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;
   }

   if ( is_low == 1 )
   {
      if ( opt->prio[2] != &opt->other_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[1] != &opt->dbf_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[0] != &opt->index_lru )
         e4severe( e4result, "t4opt.c" ) ;
   }

   d4display_str( disp,  "Appending records:   ", 1 ) ;
   for ( i = T4NUM_RECS + 1 ; i <= T4NUM_RECS * 2 ; i++ )
   {
      if ( d4append_start( database, 0 ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;

      f4assign_int( n_field, (int)i ) ;

      if ( d4append( database ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;
   }

   if ( is_low == 1 )
   {
      if ( opt->prio[2] != &opt->other_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[1] != &opt->index_lru )
         e4severe( e4result, "t4opt.c" ) ;
      if ( opt->prio[0] != &opt->dbf_lru )
         e4severe( e4result, "t4opt.c" ) ;
   }

//   if ( d4reindex( database ) != 0  )
//      e4severe( e4result, "t4opt.c" ) ;

//   if ( is_low == 1 )
//   {
//      if ( opt->prio[0] != &opt->index_lru )
//         e4severe( e4result, "t4opt.c" ) ;
//      if ( opt->prio[1] != &opt->dbf_lru )
//         e4severe( e4result, "t4opt.c" ) ;
//      if ( opt->prio[2] != &opt->other_lru )
//         e4severe( e4result, "t4opt.c" ) ;
//   }

   d4close_all( &cb ) ;

   memset( buffer, 0, sizeof( buffer ) ) ;

   if ( file4temp( &file, &cb, 0, 1 ) != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( file.name != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   file4write( &file, 0, buffer, sizeof( buffer ) ) ;
   if ( file.name != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( is_low == 2 )
   {
      d4opt_suspend( &cb ) ;
      if ( file.name == 0 )
         e4severe( e4result, "t4opt.c" ) ;
      file4close( &file ) ;
      return 0 ;
   }
   else
      file4close( &file ) ;

   memset( nm, 0, 13 ) ;
   memset( nm2, 0, 13 ) ;
   if (  file4temp( &file, &cb, nm, 0 ) != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( file.name != nm || memcmp( nm, nm2, sizeof( nm ) ) == 0 )
      e4severe( e4result, "t4opt.c" ) ;
   file4write( &file, 0, buffer, sizeof( buffer ) ) ;
   if ( file.name != nm || memcmp( nm, nm2, sizeof( nm ) ) == 0 )
      e4severe( e4result, "t4opt.c" ) ;
   file4close( &file ) ;  /* but now the file should exist... */
   if ( memcmp( nm, nm2, sizeof( nm ) ) == 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( file4open( &file, &cb, nm, 0 ) != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   file4close( &file ) ;

   was_created = 0 ;
   if ( file4temp( &file, &cb, 0, 1 ) != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( file.name != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   for ( i = 0 ; i < 10 ; i++ )
   {
      file4write( &file, i * sizeof(buffer), buffer, sizeof( buffer ) ) ;
      if ( i * (long)(sizeof( buffer )) >= (long)cb.opt.num_buffers * (long)cb.mem_size_buffer )  /* file should now exist */
      {
         if ( file.name == 0 )
            e4severe( e4result, "t4opt.c" ) ;
         if ( was_created == 0 )
         {
            was_created = 1 ;
            memcpy( nm, file.name, sizeof( nm ) ) ;
         }
      }
      else
         if ( file.name != 0 )
            e4severe( e4result, "t4opt.c" ) ;
   }
   file4close( &file ) ;  /* but now the file should exist... */

   was_created = 0 ;
   if ( file4temp( &file, &cb, 0, 0 ) != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( file.name == 0 )
      e4severe( e4result, "t4opt.c" ) ;
   file4close( &file ) ;  /* but now the file should exist... */
   if ( was_created )
   {
      if ( file4open( &file, &cb, nm, 0 ) != 0 )
         e4severe( e4result, "t4opt.c" ) ;
      file4close( &file ) ;
   }

   was_created = 0 ;
   memset( nm, 0, 13 ) ;
   memset( nm2, 0, 13 ) ;
   if ( file4temp( &file, &cb, nm, 1 ) != 0 )
      e4severe( e4result, "t4opt.c" ) ;
   if ( file.name != nm || memcmp( nm, nm2, sizeof( nm ) ) )
      e4severe( e4result, "t4opt.c" ) ;
   for ( i = 0 ; i < 10 ; i++ )
   {
      file4write( &file, i * sizeof(buffer), buffer, sizeof( buffer ) ) ;
      if ( i * (long)(sizeof( buffer )) >= (long)cb.opt.num_buffers * (long)cb.mem_size_buffer )  /* file should now exist */
      {
         if ( file.name != nm || memcmp( nm, nm2, sizeof( nm ) ) == 0 )
            e4severe( e4result, "t4opt.c" ) ;
         if ( was_created == 0 )
         {
            was_created = 1 ;
            memcpy( nm, file.name, sizeof( nm ) ) ;
         }
      }
      else
         if ( file.name != nm || memcmp( nm, nm2, sizeof( nm ) ) )
            e4severe( e4result, "t4opt.c" ) ;
   }
   file4close( &file ) ;  /* but now the file should exist... */

   return 0 ;
}

static int  test_with_mem_check( D4DISPLAY *disp )
{
   int i ;
   #ifdef __TURBOC__
      #ifndef S4WINDOWS
         unsigned long avail ;
         void *ptrs[50] ;
         int ptr_cnt ;

         for ( ptr_cnt = 0 ; ptr_cnt < 50 ; ptr_cnt++ )
         {
            avail = farcoreleft() - 32000 ;
            if ( avail <= 92000 )
            {
               ptrs[ptr_cnt] = u4alloc( avail - 32000 ) ;
               break ;
            }
            else
               ptrs[ptr_cnt] = u4alloc( 60000 ) ;
         }
      #endif
   #endif

   d4init( &cb ) ;
   cb.hWnd = disp->hWnd ;
   cb.mem_start_max = 16384L ;   /* 16k for optimization */
   cb.mem_size_buffer = 2048 ;   /* 2k buffers */

   for ( i = 0 ; i < 5 ; i++ )
      if ( do_test( disp, 1 ) )
         return 1 ;

   #ifdef __TURBOC__
      #ifndef S4WINDOWS
         cb.mem_start_max = 0x20000L ;
         cb.mem_size_buffer = 8096 ;   /* 8k buffers */
         d4opt_suspend( &cb ) ;
         for ( ; ptr_cnt >= 0 ; ptr_cnt-- )
         {
            u4free( ptrs[ptr_cnt] ) ;
            if ( do_test( disp, 0 ) )
               return 1 ;
         }
      #endif
   #endif

   if ( do_test( disp, 2 ) )   /* check temp files in a opt_suspend case */
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4opt:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{
   if ( test_with_mem_check( disp ) )
      e4exit(&cb) ;

   disp->y += 2 ;
   d4display_str( disp, "T4OPT:   SUCCESS", 1) ;
   d4display_str( disp, "", 1) ;
   return 1 ;
}
