/* t4main.c   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */
/*  Main test program for running CodeBase test code */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif
#include "t4test.h"

#ifdef __ZTC__
#ifdef S4WINDOWS
   #ifndef NULL
      #define NULL 0
   #endif
#endif
#endif

#ifdef __TURBOC__
   extern unsigned _stklen = 28000;
#endif

D4DISPLAY display ;

#ifndef S4WINDOWS
   main( int argc, char **argv )
   {
      d4parsestring_init( &display.parse_str, argc, argv ) ;
      return t4test( &display ) ;
   }

#else

   int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
   BOOL InitApplication(HANDLE);
   BOOL InitInstance(HANDLE, int);

   long FAR PASCAL _export MainWndProc(HWND, UINT, UINT, LONG);


   int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine,
                       int nCmdShow)
   {
      long num_recs ;

      if (!hPrevInstance)
         if (!InitApplication(hInstance))
            return (FALSE);

      if (!InitInstance(hInstance, nCmdShow))
         return (FALSE);

      d4parsestring_init( &display.parse_str, lpCmdLine ) ;

      t4test( &display ) ;

      PostQuitMessage(0) ;

      for (;;)
      {
         if (d4display_quit( &display ) )
            return (display.msg.wParam) ;
      }
   }

   BOOL InitApplication(HANDLE hInstance)
   {
       WNDCLASS  wc;

       wc.style = NULL;
       wc.lpfnWndProc = MainWndProc;

       wc.cbClsExtra = 0;
       wc.cbWndExtra = 0;
       wc.hInstance = hInstance;
       wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
       wc.hCursor = LoadCursor(NULL, IDC_ARROW);
       wc.hbrBackground = GetStockObject(WHITE_BRUSH);
       wc.lpszMenuName =  "TestMenu";
       wc.lpszClassName = "TestWClass";

       return (RegisterClass(&wc));
   }


   BOOL InitInstance( HANDLE hInstance, int nCmdShow)
   {
      HWND   hWnd;

      hWnd = CreateWindow(
           "TestWClass",
           "Test CodeBase",
           WS_OVERLAPPEDWINDOW,
           CW_USEDEFAULT,
           CW_USEDEFAULT,
           CW_USEDEFAULT,
           CW_USEDEFAULT,
           NULL,
           NULL,
           hInstance,
           NULL
      );

      if ( !hWnd )
         return (FALSE);

      SetTimer( hWnd, hWnd, 1000, NULL ) ;

      d4display_init( &display, hWnd ) ;
      display.hInst = hInstance ;     /* for t4filter.c */

      ShowWindow(hWnd, nCmdShow);
      UpdateWindow(hWnd);
      return (TRUE);
   }

   long FAR PASCAL _export MainWndProc( HWND hWnd, UINT message, UINT wParam,
                                LONG lParam)
   {
      switch (message)
      {
         case WM_DESTROY:
            PostQuitMessage(0);
            break;

         case WM_CLOSE:
            display.did_close =  1 ;
            return (DefWindowProc(hWnd, message, wParam, lParam));

         default:
            return (DefWindowProc(hWnd, message, wParam, lParam));
       }
       return (NULL);
   }
#endif


