/* t4large.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved.
   Tests CodeBase with a large data file.
*/

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif
#include  "t4test.h"

static FIELD4INFO fields[] =
{
   { "C", 'C',  6, 0 },
   { "N", 'N',  2, 0 },
   { 0,  0, 0, 0 },
} ;

static TAG4INFO tags[] =
{
   /* name, expression, filter, unique,descending */
   { "TAG", "C", 0, 0, 0 },
   { 0,  0,  0, 0, 0 },
} ;

CODE4 cb;
DATA4  *t4large;
INDEX4 *t4large_index;
FIELD4 *field;

static int add( D4DISPLAY *display, DATA4 *database, FIELD4 *field, long start_rec, long end_rec )
{
   long i_rec ;

   d4display_str( display,  "  Adding Record:  ", 1 ) ;

   for ( i_rec = start_rec; i_rec <= end_rec; i_rec++)
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( (i_rec % 500 == 0) || (i_rec == end_rec) )
      {
         display->x = 0 ;
         d4display_str( display,  "  Adding Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }
      if ( d4append_start( database, 0 ) != 0 )
         e4severe( e4result, "t4large.c" ) ;
      f4assign_long( field, i_rec ) ;
      if ( d4append(database) < 0 )
         e4severe( e4result, "t4large.c" ) ;
   }
   return 0 ;
}


static int test_large( D4DISPLAY *display, long middle_rec, long end_rec )
{
   int rc ;
   long i_rec ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   cb.safety = 0 ;

   t4large = d4create( &cb, "T4LARGE", fields, 0 );                    
   if ( cb.error_code || t4large == 0 )
      e4severe( e4result, "t4large.c" ) ;

   d4opt_start( &cb ) ;

   field = d4field( t4large, "C" ) ;
   if ( field == 0 )
      e4severe( e4result, "t4large.c" ) ;

   add( display, t4large, field, 1L, middle_rec ) ;

   d4display_str( display,  "        Creating Index File . . .", 1 ) ;

   d4display_wait( display ) ;

   t4large_index = i4create( t4large, "T4LARGE", tags ) ;
   if ( t4large_index == 0 )
      e4severe( e4result, "t4large.c" ) ;

   d4display_str( display,  "        Adding Records with Index file . . .", 1 ) ;

   if ( add( display, t4large, field, middle_rec+1L, end_rec ) )
      return 1 ;

   rc = d4check( t4large ) ;
   d4display_start() ;
   if ( rc != 0 )
      e4severe( e4result, "t4large.c" ) ;

   d4display_str( display,  "        Skipping. . .", 1 ) ;

   if ( d4bottom( t4large ) != 0 )
      e4severe( e4result, "t4large.c" ) ;

   d4display_str( display,  "        Skipping on Record. . .", 1 ) ;

   for ( i_rec = end_rec; i_rec >= 1; i_rec -- )
   {
      if ( cb.error_code < 0 )
         e4severe( e4result, "t4large.c" ) ;

      if ( d4display_quit( display ) )
         return 1 ;
      if ( i_rec % 500 == 1 )
      {
         display->x = 0 ;
         d4display_str( display,  "        Skipping on Record. . .", 0 ) ;
         d4display_num( display, d4recno( t4large ), 0 ) ;
         d4display_str( display,  "      ", 0 ) ;
      }

      if ( atol(f4str(field)) != i_rec || d4recno(t4large) != i_rec )
         e4severe( e4result, "t4large.c" ) ;

      rc = d4skip( t4large, -1L ) ;
      if ( rc != 0 )
         if ( ! d4bof( t4large )  ||  i_rec != 1L )
            e4severe( e4result, "t4large.c" ) ;
   }

   d4display_str( display,  "        Finished Skipping. . .", 1 ) ;

   if ( d4close_all ( &cb ) != 0 )
      e4severe( e4result, "t4large.c" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long middle_rec, long end_rec )
{
   d4init( &cb ) ;

   if ( test_large( display, middle_rec, end_rec ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4large:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *display )
{
   long middle_rec = 0x10010L ;
   long end_rec = 0x10200L ;
   long temp_rec ;

   temp_rec = atol( d4parsestring_nparm( &display->parse_str ) ) ;

   if (temp_rec > 0)
      middle_rec = temp_rec ;

   temp_rec = atol( d4parsestring_nparm( &display->parse_str ) ) ;

   if (temp_rec > 0)
      end_rec = temp_rec ;

   if ( d4display_quit( display ) )
      return 1 ;
   d4display_str( display,  "        T4LARGE TEST", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Warning: this test program creates large database and index", 1 ) ;
   d4display_str( display,  "files that are not deleted upon completion.  It requires", 1 );
   d4display_str( display,  "several megabytes of hard disk space.", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Warning: This program requires a significant amount of time", 1 ) ;
   d4display_str( display,  "         to run.  On a standard 386 time requirements may be", 1 ) ;
   d4display_str( display,  "         as high as 30 minutes.", 1 );
   d4display_str( display,  " ", 1 ) ;

   d4display_str( display,  "Middle Rec: ", 1 ) ;
   d4display_num( display,   middle_rec, 0 ) ;
   d4display_str( display,  "End Rec:    ", 1 ) ;
   d4display_num( display,   end_rec, 0 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;

   if ( test_with_mem_check( display, middle_rec, end_rec ) )
      e4severe( e4result, "t4large.c" ) ;

   display->y += 2 ;
   d4display_str( display, "T4LARGE:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
  

