/* t4index5.c (c)Copyright Sequiter Software Inc., 1990-1993 All rights reserved.
*/

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

static FIELD4INFO test_fields[] =
{
   { "C", 'C', 100, 0 },
   { "D", 'D', 8, 0 },
   { "M", 'M',10, 0 },
   { "N", 'N', 7, 2 },
   { 0,  0, 0, 0 },
} ;

static TAG4INFO tag_info[] =
{
   /* name, expression, filter, unique,descending */
   #ifdef N4OTHER
      { "C_TAG",  "C", "C <= 0", 0, 0 },
      { "D_TAG",  "D", 0, 0, 1 },
      { "N_TAG",  "N", "N > 100", r4unique_continue, 0 },
   #else
      { "C_TAG",  "C", 0, 0, 0 },
      { "D_TAG",  "D", 0, 0, 0 },
      { "N_TAG",  "N", 0, r4unique_continue, 0 },
   #endif
   { 0,  0,  0, 0, 0 },
} ;

static TAG4INFO tag_info2[] =
{
   /* name, expression, filter, unique,descending */
   #ifdef N4OTHER
      { "C2_TAG",  "C", 0, r4unique_continue, 0 },
      { "D2_TAG",  "D", 0, r4unique_continue, 1 },
      { "N2_TAG",  "N", "N < 100", 0, 1 },
   #else
      { "C2_TAG",  "C", 0, r4unique_continue, 0 },
      { "D2_TAG",  "D", 0, r4unique_continue, 0 },
      { "N2_TAG",  "N", 0, 0, 0 },
   #endif
   { 0,  0,  0, 0, 0 },
} ;

CODE4 cb;
DATA4 *data;
INDEX4 *test_index, *test_index2 ;
FIELD4 *c_fld, *d_fld, *n_fld ;
TAG4 *tag ;
TAG4INFO *t1 ;

static int do_test( D4DISPLAY *disp, int do_open )
{
   long i_rec ;
   int i ;

   cb.hWnd = disp->hWnd ;
   cb.safety = 0 ;

   if ( do_open )
   {
      cb.auto_open = 0 ;
      data = test_index = test_index2 = 0 ;
      data = d4open( &cb, "T4INDEX" ) ;
      test_index = i4open( data, "T4INDEX" ) ;
      test_index2 = i4open( data, "T4INDEX5" ) ;

      if ( cb.error_code || data == 0 || test_index == 0 || test_index2 == 0 )
         e4severe( 0, "t4index:  d4create" ) ;
   }
   else
   {
      data = d4create( &cb, "T4INDEX", test_fields, 0 ) ;

      if ( cb.error_code || data == 0 )
         e4severe( 0, "t4index5:  d4create()" ) ;

      c_fld = d4field( data, "C" ) ;
      d_fld = d4field( data, "D" ) ;
      n_fld = d4field( data, "N" ) ;

      if ( c_fld == 0 || d_fld == 0 || n_fld == 0 )
         e4severe( 0, "t4index5:  d4field()" ) ;

      test_index = i4create( data, "T4INDEX", tag_info ) ;
      if ( test_index == 0 )
         e4severe( 0, "t4index5:  failure to create" ) ;

      d4opt_start( &cb ) ;

      for ( i_rec = 1L; i_rec <= 10L; i_rec++ )
      {
         if ( d4append_start( data, 0 ) < 0 )
            e4severe( 0, "t4index5:  d4append_blank" ) ;

         f4assign_int( c_fld, i_rec ) ;
         f4assign_int( d_fld, i_rec ) ;
         f4assign_int( n_fld, i_rec ) ;

         if ( d4append( data ) < 0 )
            e4severe( 0, "t4index5:  d4append_blank" ) ;
      }

      if ( d4display_quit( disp ) )
         return 1 ;
      disp->y += 2 ;

      test_index2 = i4create( data, "T4INDEX5", tag_info2 ) ;
      if ( test_index == 0 )
         e4severe( 0, "t4index5:  failure to create" ) ;
   }

   if ( d4check( data ) != 0 )
      e4severe( 0, "t4index5:  d4check" ) ;

   tag = d4tag( data, "C_TAG" ) ;
   if ( tag == 0 )
      e4severe( 0, "t4index5:  d4tag()" ) ;

   tag = d4tag( data, "N_TAG" ) ;
   if ( tag == 0 )
      e4severe( 0, "t4index5:  d4tag()" ) ;

   tag = d4tag( data, "D_TAG" ) ;
   if ( tag == 0 )
      e4severe( 0, "t4index5:  d4tag()" ) ;

   tag = d4tag( data, "C2_TAG" ) ;
   if ( tag == 0 )
      e4severe( 0, "t4index5:  d4tag()" ) ;

   tag = d4tag( data, "N2_TAG" ) ;
   if ( tag == 0 )
      e4severe( 0, "t4index5:  d4tag()" ) ;

   tag = d4tag( data, "D2_TAG" ) ;
   if ( tag == 0 )
      e4severe( 0, "t4index5:  d4tag()" ) ;

   t1 = i4tag_info( test_index ) ;
   for ( i = 0 ; i < ( sizeof( tag_info ) / sizeof (TAG4INFO) - 1 ) ; i++ )
   {
      if ( strcmp( t1[i].name, tag_info[i].name ) != 0 )
         e4severe( 0, "t4index5.c" ) ;
      if ( strcmp( t1[i].expression, tag_info[i].expression ) != 0 )
         e4severe( 0, "t4index5.c" ) ;
      if ( tag_info[i].filter == 0 )
      {
         if ( t1[i].filter != 0 )
            e4severe( 0, "t4index5.c" ) ;
      }
      else
      {
         if ( t1[i].filter == 0 )
            e4severe( 0, "t4index5.c" ) ;
         if ( strcmp( t1[i].filter, tag_info[i].filter ) != 0 )
            e4severe( 0, "t4index5.c" ) ;
      }
      if ( tag_info[i].unique != t1[i].unique )
         e4severe( 0, "t4index5.c" ) ;
      if ( tag_info[i].descending != t1[i].descending )
         e4severe( 0, "t4index5.c" ) ;
   }

   t1 = i4tag_info( test_index2 ) ;
   for ( i = 0 ; i < ( sizeof( tag_info2 ) / sizeof (TAG4INFO) - 1 ) ; i++ )
   {
      if ( strcmp( t1[i].name, tag_info2[i].name ) != 0 )
         e4severe( 0, "t4index5.c" ) ;
      if ( strcmp( t1[i].expression, tag_info2[i].expression ) != 0 )
         e4severe( 0, "t4index5.c" ) ;
      if ( tag_info2[i].filter == 0 )
      {
         if ( t1[i].filter != 0 )
            e4severe( 0, "t4index5.c" ) ;
      }
      else
      {
         if ( t1[i].filter == 0 )
            e4severe( 0, "t4index5.c" ) ;
         if ( strcmp( t1[i].filter, tag_info2[i].filter ) != 0 )
            e4severe( 0, "t4index5.c" ) ;
      }
      if ( tag_info2[i].unique != t1[i].unique )
         e4severe( 0, "t4index5.c" ) ;
      if ( tag_info2[i].descending != t1[i].descending )
         e4severe( 0, "t4index5.c" ) ;
   }

   if ( d4close_all( &cb ) != 0 )
      e4severe( 0, "T4INDEX.C" ) ;

   return 0 ;
}

static int  test_with_mem_check( D4DISPLAY *disp, int i )
{
   d4init( &cb ) ;

   if ( do_test( disp, i ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4index5:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{
   long num_recs ;

   if ( test_with_mem_check( disp, 0 ) )
      e4severe( 0, "t4index5.c" ) ;

   if ( test_with_mem_check( disp, 1 ) )
      e4severe( 0, "t4index5.c" ) ;

   disp->y += 2 ;
   d4display_str( disp, "T4INDEX:   SUCCESS", 1 ) ;
   d4display_str( disp, "", 1 ) ;
   return 1 ;
}

