/* t4index4.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests CodeBase++ Date class. */

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include  "t4test.h"

static FIELD4INFO field_list[] =
{
   {"NUM", 'N', 18, 2 },
   { 0,0,0,0 },
};

static TAG4INFO tag_list[] =
{
   { "T_NUM", "NUM", 0, 0, 0 },
   { 0,0,0,0,0 },
};

CODE4   cb;
DATA4  *data;

static int do_test( D4DISPLAY *display, int do_open )
{
   int i, delete_cycle ;
   long rec_num, l_count, del_rec, start, block_no ;
   FIELD4 *num_field ;
   TAG4 *tag ;
   double save_dbl ;

   d4init( &cb ) ;
   cb.safety =  0 ;

   if ( do_open )
      data = d4open( &cb, "T4INDEX4" ) ;
   else
      data = d4create( &cb, "T4INDEX4", field_list, tag_list ) ;

   if ( data == 0 )
      e4severe( e4result, "t4index4:create()" ) ;

   d4display_str( display,  "        Appending Record:   ", 1 ) ;
   num_field = d4field( data, "NUM" ) ;

   for ( rec_num = 1L; rec_num <= 2000; rec_num++)
   {
      if ( (rec_num % 25) == 0 )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Appending Record:   ", 0 ) ;
         d4display_num( display, rec_num, 0 ) ;
      }

      if ( d4append_start(data, 0) < 0 )
         e4severe( e4result, "append_start()" ) ;

      f4assign_double( num_field, (double)rec_num*2 ) ;

      if ( d4append(data) < 0 )
         e4severe( e4result, "append()" ) ;
   }

   if ( d4check( data ) != 0 )
      e4severe( e4result, "t4index4:  d4check" ) ;

   /* now do some smart maneuvering to test that things actually do work */
   tag = d4tag( data, "T_NUM" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4index4.c" ) ;
   d4tag_select( data, tag ) ;

   d4top( data ) ;
   for( block_no = t4block( tag )->file_block ; block_no == t4block( tag )->file_block ; d4skip( data, 1L ) ) ;

   save_dbl = f4double( num_field ) ;
   if ( d4append_start( data, 0 ) < 0 )
      e4severe( e4result, "append_start()" ) ;

   f4assign_double( num_field, save_dbl - 1 ) ;

   if ( d4append(data) < 0 )
      e4severe( e4result, "t4index4:  d4append" ) ;
   

   if ( d4close( data ) != 0 )
      e4severe( e4result, "t4index4:  d4close" ) ;

   d4init_undo( &cb ) ;

   return 0 ;
}

int  S4FUNCTION t4test( D4DISPLAY *display )
{
   if ( d4display_quit( display ) )
      return 1 ;
   d4display_str( display,  "  Index4 Test", 1 ) ;
   display->y += 2 ;

   if ( do_test( display, 0 ) )
      e4exit( &cb ) ;
   if ( do_test( display, 1 ) )
      e4exit( &cb ) ;

   display->y += 2 ;
   d4display_str( display, "T4INDEX4:   SUCCESS", 1 ) ;
   d4display_str( display, "", 1 ) ;
   
   return 1 ;
}
