/* t4group.c   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */
/* Tests data file and index opening, closing and group file integrity. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

static FIELD4INFO test_fields[] =
{
   { "C" , 'C' , 100, 0 },
   { "D", 'D', 8, 0 },
   { "M", 'M',10, 0 },
   { "N", 'N', 7, 2 },
   { 0,  0, 0, 0 },
} ;

static TAG4INFO tag_info[] =
{
   /* name, expression, filter, unique,descending */
   { "C_TAG", "C", 0, 0, 0 },
   { "N_TAG", "N", "", 0, 0 },
   { "D_TAG", "D", 0, 0, 0 },
   { 0,  0,  0,  0,  0 },
} ;

CODE4 cb ;
DATA4 *database ;
FIELD4 *c_field ;
FIELD4 *n_field ;
FIELD4 *m_field ;
FIELD4 *d_field ;

static int do_test( D4DISPLAY *disp )
{
   TAG4 *c_tag, *d_tag, *n_tag ;
   long i_rec ;

   cb.safety = 0 ;
   cb.auto_open = 1 ;
   cb.tag_name_error = 1 ;

   d4display_str( disp,  "Group Test (t4group); ", 1 ) ;
   disp->y += 2 ;

   database = d4create( &cb, "T4GROUP", test_fields, tag_info ) ;
   c_field = d4field( database, "C" ) ;
   d_field = d4field( database, "D" ) ;
   n_field = d4field( database, "N" ) ;
   m_field = d4field( database, "M" ) ;
   if ( c_field == 0 || d_field == 0 || n_field == 0 || m_field == 0 )
      e4severe( e4result, "t4group:  d4field()" ) ;

   if ( d4check( database ) != 0 )
      e4severe( e4result, "t4group:  d4check()" ) ;
   e4exit_test( &cb ) ;
   d4display_str( disp,  "Appending Records:   ", 1 ) ;

   for ( i_rec = 1L ; i_rec <= 10 ; i_rec++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;
      if ( i_rec % 25 == 0 )
      {
         disp->x = 0 ;
         d4display_str( disp,  "Appending Record:   ", 0 ) ;
         d4display_num( disp, i_rec, 0 ) ;
      }

      if ( d4append_start( database, 0 ) < 0 )
         return -1 ;

      if (i_rec % 3 == 0 )
         f4assign( c_field, "A") ;
      else
         f4assign( c_field, "B") ;

      f4assign_long( d_field, date4long("19830208") + i_rec ) ;
      f4assign_long( n_field, i_rec ) ;

      if ( d4append( database ) != 0 )
         e4severe( e4result, "t4group:  d4append()" ) ;
   }
   disp->y += 2 ;
   d4display_str( disp,  "          Creating Index File . . .", 1 ) ;

   d4opt_start( &cb ) ;

   if ( d4check( database ) != 0 )
      e4severe( 0, "t4group:  d4check" ) ;

   if ( d4close_all( &cb ) < 0 )
      e4severe( 0, "t4group:  d4close_all" ) ;

   database = d4open( &cb, "T4GROUP" ) ;
   if ( database == 0 )
      e4severe( 0, "t4group:  d4check" ) ;

   if ( d4check( database ) != 0 )
      e4severe( 0, "t4group:  d4check" ) ;

   if ( d4reindex( database ) != 0 )
      e4severe( 0, "t4group:  d4reindex" ) ;

   if ( d4check( database ) != 0 )
      e4severe( 0, "t4group:  d4check" ) ;

   if ( d4close_all( &cb ) < 0 )
      e4severe( 0, "t4group:  d4close_all" ) ;

   database = d4open( &cb, "T4GROUP" ) ;
   if ( database == 0 )
      e4severe( 0, "t4group:  d4check" ) ;

   if ( d4check( database ) != 0 )
      e4severe( 0, "t4group:  d4check" ) ;

   if ( d4tag( database, "C_TAG" ) == 0 )
      e4severe( 0, "t4group:  d4tag() - expected C_TAG not found" ) ;

   if ( d4tag( database, "N_TAG" ) == 0 )
      e4severe( 0, "t4group:  d4tag() - expected N_TAG not found" ) ;

   if ( d4tag( database, "D_TAG" ) == 0 )
      e4severe( 0, "t4group:  d4tag() - expected D_TAG not found" ) ;

   if ( d4close_all( &cb ) < 0 )
      e4severe( 0, "t4group:  d4close_all" ) ;

   #ifdef N4OTHER
      cb.auto_open = 0 ;
      cb.tag_name_error = 0 ;
      database = d4open( &cb, "T4GROUP" ) ;
      if ( database == 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( d4check( database ) != 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( d4tag( database, "C_TAG" ) != 0 )
         e4severe( 0, "t4group:  d4tag() - expected C_TAG not found" ) ;

      if ( d4tag( database, "N_TAG" ) != 0 )
         e4severe( 0, "t4group:  d4tag() - expected N_TAG not found" ) ;

      if ( d4tag( database, "D_TAG" ) != 0 )
         e4severe( 0, "t4group:  d4tag() - expected D_TAG not found" ) ;

      if ( d4close_all( &cb ) < 0 )
         e4severe( 0, "t4group:  d4close_all" ) ;

      database = d4open( &cb, "T4GROUP" ) ;
      if ( database == 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( d4check( database ) != 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( i4open( database, "T4GROUP" ) == 0 )
         e4severe( 0, "t4group:  i4open" ) ;

      if ( d4tag( database, "C_TAG" ) == 0 )
         e4severe( 0, "t4group:  d4tag() - expected C_TAG not found" ) ;

      if ( d4tag( database, "N_TAG" ) == 0 )
         e4severe( 0, "t4group:  d4tag() - expected N_TAG not found" ) ;

      if ( d4tag( database, "D_TAG" ) == 0 )
         e4severe( 0, "t4group:  d4tag() - expected D_TAG not found" ) ;

      if ( d4check( database ) != 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( d4close_all( &cb ) < 0 )
         e4severe( 0, "t4group:  d4close_all" ) ;

      database = d4open( &cb, "T4GROUP" ) ;
      if ( database == 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( d4check( database ) != 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( t4open( database, 0, "C_TAG" ) == 0 )
         e4severe( 0, "t4group:  t4open" ) ;

      if ( t4open( database, 0, "D_TAG" ) == 0 )
         e4severe( 0, "t4group:  t4open" ) ;

      #ifdef S4NDX
         if ( t4open( database, 0, "N_TAG.NDX" ) == 0 )
      #else
         if ( t4open( database, 0, "N_TAG.NTX" ) == 0 )
      #endif
         e4severe( 0, "t4group:  t4open" ) ;

      if ( d4tag( database, "C_TAG" ) == 0 )
         e4severe( 0, "t4group:  d4tag() - expected C_TAG not found" ) ;

      if ( d4tag( database, "N_TAG" ) == 0 )
         e4severe( 0, "t4group:  d4tag() - expected N_TAG not found" ) ;

      if ( d4tag( database, "D_TAG" ) == 0 )
         e4severe( 0, "t4group:  d4tag() - expected D_TAG not found" ) ;

      if ( d4check( database ) != 0 )
         e4severe( 0, "t4group:  d4check" ) ;

      if ( d4close_all( &cb ) < 0 )
         e4severe( 0, "t4group:  d4close_all" ) ;
   #endif

   return 0 ;
}

static int  test_with_mem_check( D4DISPLAY *disp )
{
   d4init( &cb ) ;
   cb.hWnd = disp->hWnd ;

   if ( do_test( disp ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check( 100 ) != 0 )
            e4severe( e4result, "t4group:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{
   if ( test_with_mem_check( disp ) )
      e4exit(&cb) ;

   disp->y += 2 ;
   d4display_str( disp, "T4GROUP:   SUCCESS", 1) ;
   d4display_str( disp, "", 1) ;
   return 1 ;
}
