/* t4data.c   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */
/* Test data file and field routines */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

CODE4 cb ;
DATA4 *test, *test2 ;
FIELD4 *name, *num, *num2, *flt, *dt, *logic ;

static FIELD4INFO field_info[] =
{
   { "NAME",  'C', 20, 0 },
   { "NUM",   'N',  5, 2 },
   { "NUM2",  'N',  1, 0 },
   { "FLT",   'F', 17, 0 },
   { "DT",    'D',  8, 0 },
   { "LOGIC",   'L',  1, 0 },
   { 0, 0, 0, 0 },
} ;

static int  check_record( D4DISPLAY *display, DATA4 *data )
{
   double d ;
   long l ;

   if ( d4display_quit( display ) )
      return 1 ;

   name = d4field( data,  "NAME" ) ;
   num = d4field( data, "NUM" ) ;
   num2 = d4field( data, "NUM2" ) ;
   flt = d4field( data, "FLT"  ) ;
   dt  = d4field( data, "DT" ) ;
   logic = d4field( data,  "LOGIC" ) ;

   if ( name == 0 || num == 0 || num2 == 0 || flt == 0 || dt == 0 || logic == 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( memcmp( f4str(name), "Test Name           ", 20) )
      e4severe( e4result, "T4DATA.C" ) ;

   f4double2( num, &d ) ;
   if ( d != 14.3 )
      e4severe( e4result, "T4DATA.C" ) ;

   l = f4long( num2 ) ;
   if ( l != 1L )
      e4severe( e4result, "T4DATA.C" ) ;

   l = f4long( flt ) ;
   if ( l != 182L )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( memcmp( f4str( dt ), "19901012", 8 ) )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( ! f4true( logic ) )
      e4severe( e4result, "Field Values" ) ;

   return 0 ;
}

static void check_count( DATA4 *data, long count )
{
   if ( d4reccount( data ) != count )
      e4severe( e4result, "Record Count" ) ;
}

static void check_data( D4DISPLAY *display, DATA4 *data )
{
   long count, r ;

   count = d4reccount( data ) ;

   for ( r = 1L ; r <= count ; r++ )
   {
      if ( d4go( data, (long)r ) != 0 )
         e4severe( e4result, "T4DATA.C" ) ;
      check_record( display, data ) ;
   }
}

static int test_data( D4DISPLAY *display, int do_open )
{
   char *dum ;
   cb.safety = 0 ;
   cb.auto_open = 0 ;

   if (do_open)
   {
      d4display_str( display,  "        Opening T4DATA.  ", 1 ) ;
      test = d4open( &cb, "T4DATA" ) ;
      if ( d4zap( test, 1L, d4reccount( test ) ) != 0 )
         e4severe( e4result, "T4DATA.C" ) ;
   }
   else
   {
      d4display_str( display,  "        Creating T4DATA.  ", 1 ) ;
      test = d4create( &cb, "T4DATA", field_info, 0 ) ;
   }
  
   if ( test == 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   d4opt_start( &cb ) ;

   name = d4field( test,  "NAME" ) ;
   num = d4field( test, "NUM" ) ;
   num2 = d4field( test, "NUM2" ) ;
   flt = d4field( test, "FLT"  ) ;
   dt = d4field( test, "DT" ) ;
   logic  = d4field( test,  "LOGIC" ) ;
   if ( name == 0 || num == 0 || num2 == 0 || flt == 0 || dt == 0 || logic == 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4append_blank( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   f4assign( name , "Test Name" ) ;
   f4assign_double( num , 14.3 ) ;
   f4assign_int( num2, 1 ) ;
   f4assign_double( flt, 182.0 ) ;
   f4assign( dt, "19901012" ) ;
   f4assign_char( logic , 'Y' ) ;

   if ( check_record( display, test ) )
      return 1 ;
   check_count( test, 1L ) ;
   if ( d4write( test, 1L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( d4close( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   test = d4open( &cb, "T4DATA" ) ;
   check_count( test, 1L ) ;
   if ( d4go( test, 1L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( check_record( display, test ) )
      return 1 ;

   if ( d4write( test,  1L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   check_count( test, 1L ) ;
   if ( check_record( display, test ) )
      return 1 ;

   d4display_str( display,  "        Appending Records.  ", 1 ) ;

   if ( d4lock_append( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( d4append_data( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4update_header( test, 1, 1 ) ;  /* update reccount */
   if ( d4append_data( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4update_header( test, 1, 1 ) ;  /* update reccount */
   if ( d4append_data( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4update_header( test, 1, 1 ) ;  /* update reccount */
   if ( d4append_data( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4update_header( test, 1, 1 ) ;  /* update reccount */
   if ( d4unlock_append( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   check_count( test, 5L ) ;
   check_data( display, test ) ;

   if ( d4close( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   test = d4open( &cb, "T4DATA" ) ;

   if ( test == 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   check_count( test, 5L ) ;
   check_data( display, test ) ;

   if ( d4go( test, 1L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4delete( test ) ;
   if ( d4write( test, 1L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4go( test, 3L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4delete( test ) ;
   if ( d4write( test, 3L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4go( test, 5L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4delete( test ) ;
   if ( d4write( test, 5L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( d4recno( test ) != 5L )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4go( test, 3L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( ! d4deleted( test ) )
      e4severe( e4result, "T4DATA.C" ) ;
   d4recall( test ) ;
   if ( d4deleted( test ) )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( d4write( test, 3L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4pack( test ) !=0 )
      e4severe( e4result, "T4DATA.C" ) ;
   check_count( test, 3L ) ;
   check_data( display, test ) ;

   if ( d4close( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   test = d4open( &cb, "T4DATA" ) ;
   if ( test == 0 ) 
      e4severe( e4result, "T4DATA.C" ) ;
   check_count( test, 3L ) ;
   check_data( display, test ) ;

   if ( d4go( test, 1L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( d4lock_append( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( d4append_data( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4update_header( test, 1, 1 ) ;  /* update reccount */
   if ( d4unlock_append( test ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4display_quit( display ) )
      return 1 ;
   if ( d4zap( test, 2L, 2L ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   check_count( test, 3L ) ;
   check_data( display, test ) ;

   if ( d4num_fields( test ) != 6 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( memcmp( test->file.name, "T4DATA.DBF", sizeof("T4DATA.DBF") ) )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( memcmp(test->alias, "T4DATA", sizeof("T4DATA") ) )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4display_quit( display ) )
      return 1 ;
   d4display_str( display,  "        Creating T4DATA2.  ", 1 ) ;

   #ifdef S4OPEN_FILE
      test2 = d4open( &cb, "T4DATA2" ) ;
   #else
      test2 = d4create( &cb, "T4DATA2", field_info, 0 ) ;
   #endif

   if ( test2 == 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   d4close( test2 ) ;
   test2 = d4open( &cb, "T4DATA2" ) ;
   if ( test2 == 0 )
      e4severe( e4result, "T4DATA.C" ) ;

   d4alias_set( test2, "ALIAS_NAME" ) ;

   if ( d4data( &cb, "ALIAS_NAME") != test2 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4data( &cb, "T4DATA2") == test2 )
      e4severe( e4result, "T4DATA.C" ) ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "T4DATA.C" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_data( display, 0 ) )
      return 1 ;
   if ( test_data( display, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

     #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4data.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}


int  S4FUNCTION t4test( D4DISPLAY *display )
{
   d4display_str( display,  "T4DATA Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;

   if ( test_with_mem_check( display ) )
      e4severe( e4result, "T4DATA.C" ) ;
   if ( test_with_mem_check( display ) )
      e4severe( e4result, "T4DATA.C" ) ;

   display->y += 2 ;
   d4display_str( display, "T4DATA:   SUCCESS", 1 ) ;
   d4display_str( display, "", 1 ) ;
   return 1 ;
}
