/* t4bcd.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests CodeBase 4.5 bcd conversion and comparison */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

CODE4 cb ;

#ifdef S4MDX

typedef struct
{
   double  d_val ;
   char   *s1 ;
   char   *s2 ;
   int     r ;
} T4BCD_TEST ;

static T4BCD_TEST test[] = 
{
   { 1.0, "1.0", "01.00", 0 },
   { 2.2, "2.2", "  2.20", 0 },
   { .01, ".01", "  .0100 ", 0 },
   {   0, "", " 0.00 ", 0 },
   {   0, "0", ".0", 0 },
   { 0, ".1", "  .2 ", -1 },
   { 9, "8.7", " 8.66 ", 1 },
   { 100, "99", " 88.88 ", 1 },
   { .04, " .03 ", ".00999", 1 },
   {   1, "0", "-1", 1 },
   { -1.0, "-1.0", "-01.00", 0 },
   { -2.2, "-2.2", " -2.20", 0 },
   { -.01, "-.01", "-  .0100 ", 0 },
   {   -0, "-", " -0.00 ", 0 },
   {   -0, "-0", "-.0", 0 },
   { -0, "-.1", "  -.2 ", 1 },
   { -9, "-8.7", "- 8.66 ", -1 },
   { -100, "-99", " -88.88 ", -1 },
   { -.04, " -.03 ", "-.00999", -1 },
   { 0,0,0 }
} ;

static void check( int r1, int r2 )
{
   if ( r1 == 0 && r2 == 0 )
      return ;
   if ( r1 < 0 && r2 < 0 )
      return ;
   if ( r1 > 0 && r2 > 0 )
      return ;

   e4severe( e4result, "t4bcd.c" ) ;
}


static int  test_with_mem_check( D4DISPLAY *display )
{
   int i ;
   C4BCD bcd[3] ;

   d4init( &cb ) ;
   d4display_str( display,  "        i: ", 1 ) ;

   for ( i = 0; test[i].s1 != 0; i++ )
   {
      display->x = (int) 0 ;
      d4display_str( display,  "        i: ", 0 ) ;
      d4display_num( display, i, 0 ) ;

      c4bcd_from_d( (char *)&bcd[0], test[i].d_val ) ;
      c4bcd_from_a( (char *)&bcd[1], test[i].s1, strlen(test[i].s1) ) ;
      c4bcd_from_a( (char *)&bcd[2], test[i].s2, strlen(test[i].s2) ) ;

      check( (int)c4bcd_cmp( &bcd[0], &bcd[1], 0), test[i].r ) ;
      check( (int)c4bcd_cmp( &bcd[0], &bcd[2], 0), test[i].r ) ;
      check( (int)c4bcd_cmp( &bcd[1], &bcd[2], 0), test[i].r ) ;
   }
   d4init_undo( &cb ) ;
   return 0 ;
}

#endif

int  S4FUNCTION t4test( D4DISPLAY *display )
{
   d4display_str( display,  "T4BCD Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;

   #ifndef S4MDX
      d4display_str( display,  "T4BCD: Test for MDX format only  ", 1 ) ;
      return 0 ;
   #else
      test_with_mem_check( display ) ;
   
      display->y += 2 ;
      d4display_str( display, "T4BCD:   SUCCESS", 1 ) ;
      d4display_str( display, "", 1) ;
      return 1 ;
   #endif
}
