/* u4util.c   (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

#include "d4all.h"
#ifndef S4UNIX
   #ifdef __TURBOC__
      #pragma hdrstop
   #endif
#endif

char v4buffer[257] ;

#include <time.h>

/* '*was_old_len' contains the old len and will contain the new.
   'new_len' contains the new length.
   memory is only allocated if the  'new_len' paramater is greater than the
   was_old_len paramater.
*/
int S4FUNCTION u4alloc_again( CODE4 *c4, char **ptr_ptr, unsigned *was_old_len, unsigned new_len )
{
   char *new_ptr ;

   #ifdef S4DEBUG
      if ( *ptr_ptr == 0 && *was_old_len != 0 )
         e4severe( e4parm, E4_U4ALLOC_AGN ) ;
   #endif

   if ( new_len <= *was_old_len )
      return 0 ;

   new_ptr = (char *)u4alloc_free( c4, new_len ) ;

   if ( new_ptr == 0 )
   {
      if ( c4 )
         e4( c4, e4memory, 0 ) ;
      return e4memory ;
   }

   if ( *ptr_ptr != 0 )
   {
      memcpy( new_ptr, *ptr_ptr, (size_t) *was_old_len ) ;
      u4free( *ptr_ptr ) ;
   }
   *ptr_ptr = new_ptr ;
   *was_old_len = new_len ;
   return 0 ;
}

void *S4FUNCTION u4alloc_free( CODE4 *c4, long n )
{
   void *ptr ;

   #ifdef S4OS2SEM
   #ifdef S4OS2
      #ifdef S4DEBUG
         /* the debug u4alloc uses global tracking pointers, so semaphore */
         if ( mem4start( c4 ) != 0 )
            return 0 ;
      #endif
   #endif
   #endif

   ptr = u4alloc( n ) ;
   #ifndef S4OPTIMIZE_OFF
      if ( ptr == 0 && c4 )
      {
         if ( c4->has_opt )
         {
            d4opt_suspend( c4 ) ;
            ptr = u4alloc( n ) ;
            d4opt_start( c4 ) ;
         }
      }
   #endif

   #ifdef S4OS2SEM
   #ifdef S4OS2
      #ifdef S4DEBUG
         mem4stop( c4 ) ;
      #endif
   #endif
   #endif

   return ptr ;
}

/* delays one second, allows other windows applications to run, etc. */
void S4FUNCTION u4delay_sec()
{
   #ifdef S4WINDOWS
      MSG msg;
   #endif

   time_t old_time ;

   time( &old_time) ;

   #ifdef S4WINDOWS
      while (  time( (time_t *) 0 ) <= old_time )
         /* Give some other application a chance to run. */
         PeekMessage( &msg, 0, 0, 0, PM_NOREMOVE ) ;

        #ifdef S4NO_COMPILE
         if ( PeekMessage( &msg, 0, 0, 0, PM_NOREMOVE ) )
         {
            if ( msg.message == 275 )  /* remove the timer messages */
               GetMessage( &msg, 0, 0, 0 ) ;
            else
            {
               if ( !GetMessage( &msg, 0, 0, 0 ) )
                  return ;
               TranslateMessage((LPMSG)&msg) ;
               if( msg.message == WM_DESTROY)
                  return ;
               DispatchMessage((LPMSG)&msg) ;
            }
         }
        #endif
   #else
      while (  time( (time_t *) 0 ) <= old_time ) ;
   #endif
   return ;
}


unsigned S4FUNCTION u4ncpy( char *to, char *from, unsigned len )
{
   unsigned i ;

   #ifdef S4DEBUG
      if ( len == 0 )
         e4severe( e4parm, E4_U4NCPY ) ;
   #endif
   len-- ;
   for ( i = 0;; i++ )
   {
      if ( i >= len )
      {
         to[len] = 0 ;
         return len ;
      }
      to[i] = from[i] ;
      if ( from[i] == 0 )
         return i ;
   }
}

int S4FUNCTION u4ptr_equal( void *p1, void *p2 )
{
   return( p1 == p2 ) ;
}

void S4FUNCTION u4yymmdd( char *yymmdd )
{
   time_t time_val ;
   struct tm *tm_ptr ;

   time( (time_t *) &time_val ) ;
   tm_ptr =  localtime( (time_t *) &time_val ) ;
   yymmdd[0] = (char) tm_ptr->tm_year ;
   yymmdd[1] = (char) tm_ptr->tm_mon+ (char) 1 ;
   yymmdd[2] = (char) tm_ptr->tm_mday ;
}

int  S4FUNCTION u4remove( char *ptr )
{
   #ifdef S4NO_REMOVE
      char  buf[80] ;
      memset( buf, 0, sizeof(buf) ) ;
      strncpy( buf, ptr, sizeof(buf)-1 ) ;
      c4lower( buf ) ;
      return( unlink( buf ) ) ;
   #else
      #ifdef S4UNIX
         char  buf[127] ;
         memset( buf, 0, sizeof(buf) ) ;
         memcpy( buf, ptr, sizeof(buf)-1 ) ;
         c4lower( buf ) ;
         return remove( buf ) ;
      #else
         return remove( ptr ) ;
      #endif
   #endif
}

int S4FUNCTION u4rename( char *old_name, char *new_name )
{
   #ifdef S4NO_RENAME
      char  buf[250] ;
      memset( (void *)buf, 0, sizeof(buf) ) ;
      #ifdef S4UNIX
         memcpy( (void *)buf, "mv ", 3 ) ; /* system rename or move call */
      #else
         memcpy( (void *)buf, "rename ", 7 ) ; /* system copy call */
      #endif
      strcat( buf, old_name ) ;
      strcat( buf, " " ) ;
      strcat( buf, new_name ) ;
      #ifdef S4UNIX
         c4lower( buf ) ;
      #endif
      return system( buf ) ;
   #else
      #ifdef S4UNIX
         char  old_buf[127], new_buf[127] ;
         memset( (void *)old_buf, 0, sizeof(old_buf) ) ;
         memset( (void *)new_buf, 0, sizeof(new_buf) ) ;
         memcpy( (void *)old_buf, old_name, sizeof(old_buf)-1 ) ;
         memcpy( (void *)new_buf, new_name, sizeof(new_buf)-1 ) ;
         c4lower( old_buf ) ;
         c4lower( new_buf ) ;
         return rename( old_buf, new_buf ) ;
      #else
         return rename( old_name, new_name ) ;
      #endif
   #endif
}

/*   memory comparison routines for foreign languages */

/*  v4map structure :  There are three lines of numbers in each row.
                       The upper line (commented out) represents ascii
                       characters.  The middle line represents the
                       ascii value.  The lower line is the precedence value
                       of the corresponding ascii value as compared to 
                       the other ascii values. There are two v4map
                       structures: one uses the ANSI (Windows) char set,
                       which will handle English, French and German.
                       The second is an OEM (ASCII) set for German and
                       French character sets. 
*/
#ifdef S4ANSI
   unsigned char v4map[256] =
   {                            
/*                                                   */                                               
/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
     194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,   

/*                                                   */
/*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
     210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,

/*         !   "   #   $   %   &   '   (   )   *   +   ,   -   .   / */
/*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
       1,156,162,170,157,135,154,163,123,124,136,132,167,133,152,153,

/*     0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ? */
/*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
       3,  4,  5,  6,  7,  8,  9, 10, 11, 12,168,169,129,131,130,171,

/*     @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O */
/*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
     174, 13, 20, 21, 23, 24, 29, 30, 31, 32, 37, 39, 40, 41, 42, 44,

/*     P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _ */
/*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
      50, 51, 52, 53, 54, 55, 60, 61, 62, 63, 66,125,172,126,151,173,

/*     `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o */
/*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
     164, 67, 74, 75, 77, 78, 83, 84, 85, 86, 91, 93, 94, 95, 96, 98,

/*     p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~    */
/*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
     104,105,106,107,109,110,115,116,117,118,122,127,155,128,150,226,

/*                                                   */
/*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
     227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,

/*        `   '                                        */
/*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
     243,165,166,244,245,246,247,248,249,250,251,252,253,254,255,256,

/*                XXX      |      " XXX            - XXX XXX */
/*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
       2,175,158,159,160,161,176,177,178,179,181,147,149,134,180,183,

/*            XXX   '       XXX   , XXX             XXX    */
/*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
     140,139,142,143,184,185,186,187,188,141,182,148,144,145,146,189,

/*     A   A   A   A               E      E   E   I   I   I   I */
/*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
      16, 15, 17, 19, 14, 18,192, 22, 27, 26, 28, 25, 35, 34, 36, 33,

/*     D      O   O   O   O      X   0   U   U   U      Y   b    */
/*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
      38, 43, 47, 46, 48, 49, 45,137,190, 58, 57, 59, 56, 64, 65,108,

/*              a                                     */
/*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
      70, 69, 71, 73, 68, 72,193, 76, 81, 80, 82, 79, 89, 88, 90, 87,

/*                    o         0               y   b    */
/*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
      92, 97,101,100,102,103, 99,138,191,113,112,114,111,120,121,119,
   } ;

   #ifndef S4LANGUAGE
      int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
      {
         int i ;

	 for (i=0; i<len; i++)
	    if ( ((unsigned char *)s1)[i] != ((unsigned char *)s2)[i] )
	    {
	       if ( v4map[((unsigned char *)s1)[i]] < v4map[((unsigned char *)s2)[i]] )
                  return -1 ;
               return 1 ;
            }
      
	 return 0 ;
      }
   #endif
#endif

#ifdef S4LANGUAGE

#ifdef S4GERMAN
   #ifdef S4ANSI
         typedef struct
         {
            unsigned char ext_char ;
            char exp_chars[3] ;
         } LANGUAGE_CONVERT ;
      
         LANGUAGE_CONVERT v4table[] =
         {
            { 246, "oe" },  /*  */
            { 223, "ss" },  /*  */
            { 228, "ae" },  /*  */
            { 252, "ue" },  /*  */
            { 235, "ee" },  /*  */
         #ifdef S4CLIPPER
            { 196, "AE" },  /*  */
            { 214, "OE" },  /*  */
            { 220, "UE" },  /*  */
         #else
            { 196, "Ae" },
            { 214, "Oe" },
	    { 220, "Ue" },
         #endif
            { 233, "e " },  /*  */
            { 226, "a " },  /*  */
            { 224, "a " },  /*  */
            { 229, "a " },  /*  */
            { 234, "e " },  /*  */
            { 232, "e " },  /*  */
            { 238, "i " },  /*  */
            { 236, "i " },  /*  */
            { 197, "A " },  /*  */
      /* The angstrom is not indexed in German correctly, so this is used instead*/
            { 244, "o " },  /*  */
            { 242, "o " },  /*  */
            { 251, "u " },  /*  */
            { 249, "u " },  /*  */
            { 255, "y " },  /*  */
            { 225, "a " },  /*  */
            { 237, "i " },  /*  */
            { 243, "o " },  /*  */
            { 250, "u " },  /*  */
            { 241, "n " },  /*  */
            {   0, "  " },   /* A blank entry to make the u4valid work better */
         };
   #else  /* ifndef S4ANSI  */

      unsigned char v4map[256] =
      {
   #ifndef N4OTHER
   /*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
   /*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
          0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
   /*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
         16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
   
   /*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
   /*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
         32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   
   /*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
   /*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
        158,159,160,161,162,163,164,165,166,167, 48, 49, 50, 51, 52, 53,
   
   /*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
   /*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
         54,168,172,173,175,176,178,179,180,181,182,183,184,185,186,188,
   
   /*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
   /*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
        190,191,192,193,194,195,197,198,199,200,201, 55, 56, 57, 58, 59,
   
   /*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
   /*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
         60,202,210,211,213,214,219,220,221,222,227,228,229,230,231,233,
   
   /*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
   /*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
        239,240,241,242,244,245,250,251,252,253,255, 61, 62, 63, 64, 65,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
        174,249,215,205,206,204,207,212,217,218,216,226,225,224,169,170,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
        177,208,171,236,237,235,248,247,254,189,196, 66, 67, 68, 69, 70,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
        203,223,234,246,232,187,209,238, 71, 72, 73, 74, 75, 76, 77, 78,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
         95, 96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
        111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
   /*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
        127,243,128,129,130,131,132,133,134,135,136,137,138,139,140,141,
   
   /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
   /*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
        142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157
      } ;
   #else
      #ifdef S4CLIPPER
      /*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
      /*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
             0,  1,  2,  3,  4,  5,  6,  7,  8, 30,  9, 10, 11, 31, 12, 13,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
      /*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
            14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
      
      /*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
      /*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
            32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
      
      /*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
      /*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
            48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
      
      /*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
      /*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
            64, 65, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
      
      /*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
      /*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
            82, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
      
      /*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
      /*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
            99,100,102,103,104,105,106,107,108,109,110,111,112,113,114,115,
      
      /*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
      /*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
           117,118,119,120,122,123,125,126,127,128,129,130,131,132,133,134,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
           135,124,136,137,101,138,139,140,141,142,143,144,145,146, 66,147,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
           148,149,150,151,116,152,153,154,155, 81, 88,156,157,158,159,160,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
           161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
           177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
           193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
           209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
           225,121,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
      /*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
           240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
         } ;
      
      #else  /* if S4NDX */
      /*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
      /*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
             0,140,141,142,143,144,145,146,147,  1,148,149,150,  2,151,152,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
      /*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
           153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,
      
      /*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
      /*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
             3,117,132,123,124,109,122,134, 98, 99,110,107,112,108,111,118,
      
      /*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
      /*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
             4,  5,  6,  7,  8,  9, 10, 11, 12, 13,114,113,104,106,105,116,
      
      /*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
      /*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
           121, 14, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33,
      
      /*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
      /*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
            35, 36, 37, 38, 39, 40, 42, 43, 44, 45, 46,100,119,101,135,137,
      
      /*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
      /*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
           133, 47, 53, 54, 56, 57, 62, 63, 64, 65, 70, 71, 72, 73, 74, 76,
      
      /*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
      /*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
            81, 82, 83, 84, 86, 87, 92, 93, 94, 95, 97,102,120,103,136,169,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
            19, 88, 58, 49, 48, 50, 51, 55, 59, 60, 61, 66, 67, 68, 15, 16,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
            22,130,131, 78, 77, 79, 89, 90, 96, 34, 41,125,126,127,129,128,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
            52, 69, 80, 91, 75, 32,138,139,115,170,171,172,173,174,175,176,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
           177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
           193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
           209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
      /*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
           225, 85,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
      
      /*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
      /*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
           240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
         } ;
      #endif   /* ifdef S4CLIPPER */
   #endif   /* ifndef N4OTHER */
   
      typedef struct
      {
         unsigned char ext_char ;
         char exp_chars[3] ;
      } LANGUAGE_CONVERT ;
   
      LANGUAGE_CONVERT v4table[] =
      {
         { 148, "oe" },
         { 225, "ss" },
         { 132, "ae" },
         { 129, "ue" },
         { 130, "ee" },
      #ifdef S4CLIPPER
         { 142, "AE" },
         { 153, "OE" },
         { 154, "UE" },
      #else
         { 142, "Ae" },
         { 153, "Oe" },
         { 154, "Ue" },
      #endif
         { 131, "a " },
         { 133, "a " },
         { 134, "a " },
         { 136, "e " },
         { 137, "e " },
         { 138, "e " },
         { 140, "i " },
         { 141, "i " },
         { 143, "A " },
   /* The angstrom is not indexed in German correctly, so this is used instead*/
         { 147, "o " },
         { 149, "o " },
         { 150, "u " },
         { 151, "u " },
         { 152, "y " },
         { 160, "a " },
         { 161, "i " },
         { 162, "o " },
         { 163, "u " },
         { 164, "n " },
         {   0, "  " },   /* A blank entry to make the u4valid work better */
      };
   
   #endif /* ifdef S4ANSI */

#ifdef S4DICTIONARY
/* sort method uses the dictionary sort order */
   int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
   {
      int i ;
   
      for (i=0; i<len; i++)
         if ( ((unsigned char *)s1)[i] != ((unsigned char *)s2)[i] )
         {
	    if ( v4map[((unsigned char *)s1)[i]] < v4map[((unsigned char *)s2)[i]] )
               return -1 ;
            return 1 ;
         }
   
      return 0 ;
   }
#else   /* if PHONEBOOK SORT (default) */
/* sort method uses the phone book sort order */
   static unsigned char *u4valid( unsigned char * parm )
   {
      int x = 0 ;
   
      while ( v4table[x].ext_char != 0 )
      {
         if( v4table[x].ext_char == *(unsigned char *)parm )
	    return v4table[x].exp_chars ;
         x++ ;
      }
      return parm ;
   }
   
   int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
   {
      short  s1_ext, s2_ext ;
      unsigned char *compare1, *compare2 ;
      unsigned char *string1_ptr, *string2_ptr ;
   
      string1_ptr = (unsigned char *)s1 ;
      string2_ptr = (unsigned char *)s2 ;
   
      while( len-- )
      {
         if( *string1_ptr != *string2_ptr )
         {
	    /* The characters are not equal.  Check for extended characters
	       as in German the extended characters are equivalent to
	       expanded characters  */
   
	    s1_ext = ( (short)*string1_ptr > 127 ) ;
	    s2_ext = ( (short)*string2_ptr > 127 ) ;
   
	    if( s1_ext ^ s2_ext )
	    {
	       /* Only one is an extended character. Check to see if valid and
	       expand to full length */
   
	       compare1 = (s1_ext) ? u4valid(string1_ptr) : string1_ptr ;
	       compare2 = (s2_ext) ? u4valid(string2_ptr) : string2_ptr ;
   
	       /* Expansion has been done to one string (maximum 2 chars in expansion) */
	       /* now compare the two characters */
   
	       if ( compare1[0] == compare2[0] )    /* do if first chars equal */
	       {
	          /* if there are not two valid second chars to check */
	          if ( compare1[1] == ' ' || compare2[1] == ' ' ||
		       compare1[1] == 0   || compare2[1] == 0 )
	          {
		     if (v4map[*string1_ptr] < v4map[*string2_ptr])  return -1 ;
		     return 1 ;
	          }
   
	          if ( compare1[1] == compare2[1] )
	          {
		     (s1_ext) ? string2_ptr++ : string1_ptr++ ;
		     if (len) len-- ;
	          }
	          else
	          {
		     if (v4map[*(compare1+1)] < v4map[*(compare2+1)])  return -1 ;
		     return 1 ;
	          }
	       }
	       else
	       {
	          if (v4map[*compare1] < v4map[*compare2])  return -1 ;
	          return 1 ;
	       }
	    }
	    else
	    {
	       /* Neither character is extended so return according to
	          v4map[].  */
	       if (v4map[*string1_ptr] < v4map[*string2_ptr])  return -1 ;
	       return 1 ;
	    }
         }
         /* Characters are equal. Increment the pointers and loop again. */
   
         string1_ptr++ ;
         string2_ptr++ ;
      }
      return 0 ;
   }
#endif  /*  ifdef S4DICTIONARY */
#endif  /*  ifdef S4GERMAN  */


#ifdef S4FRENCH

#ifndef S4ANSI

   /* This mapping is for French. */
   unsigned char v4map[256] =
   {
/*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
       0,140,141,142,143,144,145,146,147,  1,148,149,150,  2,151,152,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
/*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
     153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,

/*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
/*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
       3,117,132,123,124,109,122,134, 98, 99,110,107,112,108,111,118,

/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
/*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
       4,  5,  6,  7,  8,  9, 10, 11, 12, 13,114,113,104,106,105,116,

/*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
/*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
     121, 14, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33,

/*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
/*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
      35, 36, 37, 38, 39, 40, 42, 43, 44, 45, 46,100,119,101,135,137,

/*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
/*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
     133, 47, 53, 54, 56, 57, 62, 63, 64, 65, 70, 71, 72, 73, 74, 76,

/*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
/*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
      81, 82, 83, 84, 86, 87, 92, 93, 94, 95, 97,102,120,103,136,169,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
      19, 88, 58, 49, 48, 50, 51, 55, 59, 60, 61, 66, 67, 68, 15, 16,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
      22,130,131, 78, 77, 79, 89, 90, 96, 34, 41,125,126,127,129,128,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
      52, 69, 80, 91, 75, 32,138,139,115,170,171,172,173,174,175,176,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
     177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
     193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
     209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
     225, 85,226,227,228,229,230,231,232,233,234,235,236,237,238,239,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
/*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
   } ;

#endif /* ifndef S4ANSI */

int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
{
   int i ;

   for (i=0; i<len; i++)
      if ( ((unsigned char *)s1)[i] != ((unsigned char *)s2)[i] )
      {
	 if ( v4map[((unsigned char *)s1)[i]] < v4map[((unsigned char *)s2)[i]] )
            return -1 ;
         return 1 ;
      }

   return 0 ;
}

#endif  /*   ifdef S4FRENCH  */

#ifdef S4SWEDISH

#ifndef S4ANSI

   /* This mapping is for Swedish. */
   unsigned char v4map[256] =
   {
/*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
       0,140,141,142,143,144,145,146,147,  1,148,149,150,  2,151,152,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
/*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
     153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,

/*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
/*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
       3,119,132,125,126,111,124,134,100,101,112,109,114,110,113,120,

/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
/*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
       4,  5,  6,  7,  8,  9, 10, 11, 12, 13,116,115,106,108,107,118,

/*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
/*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
     123, 14, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31,

/*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
/*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
      32, 33, 34, 35, 36, 37, 39, 40, 41, 42, 43,102,121,103,135,137,

/*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
/*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
     133, 48, 52, 53, 55, 56, 61, 62, 63, 64, 69, 70, 71, 72, 73, 75,

/*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
/*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
      79, 80, 81, 82, 84, 85, 90, 91, 92, 93, 95,104,122,105,136,169,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
      17, 86, 57, 49, 97, 50, 96, 54, 58, 59, 60, 65, 66, 67, 45, 44,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
      20, 98, 46, 76, 99, 77, 87, 88, 94, 47, 38,127,128,129,131,130,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
      51, 68, 78, 89, 74, 30,138,139,117,170,171,172,173,174,175,176,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
     177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
     193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
     209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
     225, 83,226,227,228,229,230,231,232,233,234,235,236,237,238,239,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
/*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
   } ;

#endif /* ifndef S4ANSI */

int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
{
   int i ;

   for (i=0; i<len; i++)
      if ( ((unsigned char *)s1)[i] != ((unsigned char *)s2)[i] )
      {
	 if ( v4map[((unsigned char *)s1)[i]] < v4map[((unsigned char *)s2)[i]] )
            return -1 ;
         return 1 ;
      }

   return 0 ;
}

#endif  /*   ifdef S4SWEDISH */

#ifdef S4FINISH 
#ifndef S4ANSI

   /* This mapping is for Finnish. */
   unsigned char v4map[256] =
   {
/*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
       0,140,141,142,143,144,145,146,147,  1,148,149,150,  2,151,152,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
/*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
     153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,

/*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
/*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
       3,119,132,125,126,111,124,134,100,101,112,109,114,110,113,120,

/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
/*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
       4,  5,  6,  7,  8,  9, 10, 11, 12, 13,116,115,106,108,107,118,

/*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
/*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
     123, 14, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31,

/*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
/*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
      32, 33, 34, 35, 36, 37, 39, 40, 41, 42, 43,102,121,103,135,137,

/*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
/*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
     133, 48, 52, 53, 55, 56, 61, 62, 63, 64, 69, 70, 71, 72, 73, 75,

/*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
/*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
      79, 80, 81, 82, 84, 85, 90, 91, 92, 93, 95,104,122,105,136,169,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
      17, 86, 57, 49, 97, 50, 96, 54, 58, 59, 60, 65, 66, 67, 45, 44,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
      20, 98, 46, 76, 99, 77, 87, 88, 94, 47, 38,127,128,129,131,130,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
      51, 68, 78, 89, 74, 30,138,139,117,170,171,172,173,174,175,176,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
     177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
     193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
     209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
     225, 83,226,227,228,229,230,231,232,233,234,235,236,237,238,239,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
/*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
   } ;

#endif /* ifndef S4ANSI */

int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
{
   int i ;

   for (i=0; i<len; i++)
      if ( ((unsigned char *)s1)[i] != ((unsigned char *)s2)[i] )
      {
	 if ( v4map[((unsigned char *)s1)[i]] < v4map[((unsigned char *)s2)[i]] )
            return -1 ;
         return 1 ;
      }

   return 0 ;
}

#endif  /*   ifdef S4FINISH */

#ifdef S4NORWEGIAN 
#ifndef S4ANSI

   /* This mapping is for Norwegian. */
   unsigned char v4map[256] =
   {
/*      ,  ,  ,  ,  ,  ,  ,  ,  ,   ,   ,  ,  ,   ,  ,   */
/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 */
       0,140,141,142,143,144,145,146,147,  1,148,149,150,  2,151,152,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,EOF,  ,  ,  ,  ,   */
/*    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 */
     153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,

/*      ,  !,  ",  #,  $,  %,  &,  ',  (,  ),  *,  +,  ,,  -,  .,  / */
/*    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 */
       3,119,132,125,126,111,124,134,100,101,112,109,114,110,113,120,

/*     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  :,  ;,  <,  =,  >,  ? */
/*    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 */
       4,  5,  6,  7,  8,  9, 10, 11, 12, 13,116,115,106,108,107,118,

/*     @,  A,  B,  C,  D,  E,  F,  G,  H,  I,  J,  K,  L,  M,  N,  O */
/*    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 */
     123, 14, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31,

/*     P,  Q,  R,  S,  T,  U,  V,  W,  X,  Y,  Z,  [,  \,  ],  ^,  _ */
/*    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95 */
      32, 33, 34, 35, 36, 37, 39, 40, 41, 42, 43,102,121,103,135,137,

/*     `,  a,  b,  c,  d,  e,  f,  g,  h,  i,  j,  k,  l,  m,  n,  o */
/*    96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111 */
     133, 48, 52, 53, 55, 56, 61, 62, 63, 64, 69, 70, 71, 72, 73, 75,

/*     p,  q,  r,  s,  t,  u,  v,  w,  x,  y,  z,  {,  |,  },  ~,   */
/*   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127 */
      79, 80, 81, 82, 84, 85, 90, 91, 92, 93, 95,104,122,105,136,169,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143 */
      17, 86, 57, 49, 97, 50, 96, 54, 58, 59, 60, 65, 66, 67, 45, 44,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159 */
      20, 98, 46, 76, 99, 77, 87, 88, 94, 47, 38,127,128,129,131,130,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175 */
      51, 68, 78, 89, 74, 30,138,139,117,170,171,172,173,174,175,176,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191 */
     177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207 */
     193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223 */
     209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,   */
/*   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239 */
     225, 83,226,227,228,229,230,231,232,233,234,235,236,237,238,239,

/*     ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,    */
/*   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 */
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
   } ;

#endif /* ifndef S4ANSI */

int S4CALL u4memcmp( S4CMP_PARM s1, S4CMP_PARM s2, size_t len )
{
   int i ;

   for (i=0; i<len; i++)
      if ( ((unsigned char *)s1)[i] != ((unsigned char *)s2)[i] )
      {
	 if ( v4map[((unsigned char *)s1)[i]] < v4map[((unsigned char *)s2)[i]] )
            return -1 ;
         return 1 ;
      }

   return 0 ;
}

#endif  /*   ifdef S4NORWEGIAN */

#endif  /*  ifdef S4LANGUAGE  */
