/***********************************************************************\
*                                                                       *
*   SHOWDATA.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

int main(int argc,char *argv[])
{
   CODE4    code_base;
   DATA4    *data_file = NULL;
   FIELD4   *field_ref = NULL;

   int      rc,j,num_fields;
   char     *field_contents;


   if(argc != 2)
   {
     printf(" USAGE: SHOWDATA <FILENAME.DBF> \n");      exit(0);
   }


   d4init(&code_base);

   data_file = d4open(&code_base,argv[1]);
   e4exit_test(&code_base);

   num_fields = d4num_fields(data_file);
   for(rc = d4top(data_file);rc == r4success
                      ;rc = d4skip(data_file, 1L))
   {
      for(j = 1;j <= num_fields;j ++)
      {
         field_ref = d4field_j(data_file,j);
         field_contents = f4memo_str(field_ref);
         printf("%s ",field_contents);
      }
      printf("\n");
   }

   d4close(data_file);
   return 0;
}
