/***********************************************************************\
*                                                                       *
*   SHOWDAT2.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4    code_base;
DATA4    *data_file = NULL;
FIELD4   *field_ref = NULL;
TAG4     *tag = NULL;

int      rc,j;
char     *field_contents;

void print_records( void )
{
   for(rc = d4top(data_file);rc == r4success
                       ;rc = d4skip(data_file, 1L))
   {
      for(j = 1;j <= d4num_fields(data_file);j ++)
      {
         field_ref = d4field_j(data_file,j);
         field_contents = f4memo_str(field_ref);
         printf("%s ",field_contents);
      }
      printf("\n");
   }
}

int main(int argc,char *argv[])
{

   if(argc != 2){  exit(0); }

   d4init(&code_base);

   data_file = d4open(&code_base,argv[1]);
   e4exit_test(&code_base);

   printf("Data File %s in Natural Order\n"
                                        ,argv[1]);
   print_records();
   for(tag = d4tag_next(data_file,NULL);tag !=NULL
                ; tag = d4tag_next(data_file,tag))
   {
      printf("\nPress ENTER to continue:");
      getchar();

      printf("\nData File %s sorted by Tag %s\n"
                             ,argv[1],tag->alias);
      d4tag_select(data_file,tag);
      print_records();
   }

   d4close(data_file);
   return 0;

}
