/***********************************************************************\
*                                                                       *
*   SEEKER.C      Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4    code_base;
DATA4    *data_file = 0;
FIELD4   *f_name,*l_name,*address,*age,*birth_date
                       ,*married,*amount,*comment;
TAG4     *name_tag,*age_tag,*amount_tag
                     ,*address_tag,*birthdate_tag;

void  OpenDataFile( void )
{

   data_file = d4open(&code_base,"DATA1.DBF");

   f_name = d4field(data_file,"F_NAME");
   l_name = d4field(data_file,"L_NAME");
   address = d4field(data_file,"ADDRESS");
   age = d4field(data_file,"AGE");
   birth_date = d4field(data_file,"BIRTH_DATE");
   married = d4field(data_file,"MARRIED");
   amount = d4field(data_file,"AMOUNT");
   comment = d4field(data_file,"COMMENT");

   name_tag = d4tag(data_file,"NAME");
   address_tag = d4tag(data_file,"ADDRESS");
   age_tag = d4tag(data_file,"AGE_TAG");
   birthdate_tag = d4tag(data_file,"DATE_TAG");
   amount_tag = d4tag(data_file,"AMNT_TAG");
}


void seek_status(int rc,char *status)
{
   switch(rc)
   {
      case r4success:
         strcpy(status,"r4success");
         break;

      case r4eof:
         strcpy(status,"r4eof");
         break;

      case r4after:
         strcpy(status,"r4after");
         break;

      default:
         strcpy(status,"other");
         break;
   }
}

void print_record(int rc)
{

   int      age_value;
   double   amount_value;
   char     f_name_str[15],l_name_str[15];
   char     address_str[20];
   char     date_str[9];
   char     married_str[2];
   char     *comment_str;
   char     status[15];

   f4ncpy(f_name,f_name_str,sizeof(f_name_str));
   f4ncpy(l_name,l_name_str,sizeof(l_name_str));
   f4ncpy(address,address_str
                           ,sizeof(address_str));
   age_value = f4int(age);

   amount_value = f4double(amount);

   f4ncpy(birth_date,date_str,sizeof(date_str));

   f4ncpy(married,married_str
                            ,sizeof(married_str));

   comment_str = f4memo_str(comment);

   seek_status(rc,status);

   printf("Seek status : %s\n",status);
   printf("---------------------------------\n");
   printf("Name     : %10s %10s\n"
                          ,f_name_str,l_name_str);
   printf("Address  : %15s\n",address_str);
   printf("Age:%3d BirthDate:%8s Married : %1s\n"
                 ,age_value,date_str,married_str);
   printf("Comment: %s\n",comment_str);
   printf("Amount purchased : $%5.2lf \n"
                                   ,amount_value);

   printf("\n");

}

int main( void )
{
   int rc;

   d4init(&code_base);

   OpenDataFile();

   d4tag_select(data_file,address_tag);

   rc = d4seek(data_file,"123 - 45 Ave   ");
   print_record(rc);

   rc = d4seek(data_file,"12");
   print_record(rc);

   rc = d4seek(data_file,"12             ");
   print_record(rc);


   d4tag_select(data_file,name_tag);

   rc = d4seek(data_file,"Krammer   David     ");
   print_record(rc);

   d4tag_select(data_file,birthdate_tag);

   rc = d4seek(data_file,"19500101");
   print_record(rc);

   d4tag_select(data_file,amount_tag);

   rc = d4seek_double(data_file,47.23);
   print_record(rc);

   rc = d4seek(data_file," 47.23");
   print_record(rc);


   d4close_all(&code_base);
   return 0;
}
