/***********************************************************************\
*                                                                       *
*   LIST2.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

typedef struct
{
    LINK4   link;
    int     age;
} AGES;

void print_list(LIST4 *);
AGES *add_age(LIST4 *,int);
void remove_age(LIST4 *,AGES *);
void free_ages(LIST4 *);

void main( void )
{

    LIST4   age_list;
    AGES    *age_ptr;

    memset(&age_list,NULL,sizeof(age_list));

    add_age(&age_list,3);
    age_ptr = add_age(&age_list,5);
    add_age(&age_list,7);
    add_age(&age_list,6);
    add_age(&age_list,2);

    age_list.selected = age_ptr;

    print_list(&age_list);

    remove_age(&age_list,age_ptr);

    print_list(&age_list);

    free_ages(&age_list);

    print_list(&age_list);
}


void print_list(LIST4 *list)
{
    AGES    *age_ptr;

    printf("\nThere are %d links\n",list->n_link);

    age_ptr = (AGES *) l4first(list);
    while(age_ptr != NULL)
    {
        printf("%d\n",age_ptr->age);
        age_ptr = (AGES *) l4next(list,age_ptr);
    }

}


AGES *add_age(LIST4 *list,int age)
{
    AGES* age_ptr;

    age_ptr = (AGES *) u4alloc(sizeof(AGES));

    age_ptr->age = age;
    l4add(list,age_ptr);

    return(age_ptr);
}

void remove_age(LIST4 *list,AGES *age_ptr)
{
    l4remove(list,age_ptr);
    u4free(age_ptr);
}

void free_ages(LIST4 *list)
{
    AGES *age_ptr;

    while(age_ptr = (AGES *) l4pop(list))
        u4free(age_ptr);

}
