/*********************************************************************
d4owl.cpp   (c)Copyright Sequiter Software Inc., 1990-1993.
All rights reserved.

Borland Object Windows Example using CodeBase 5.0 C++ DLL 

*********************************************************************/

#include <owl.h>
#include "d4all.h"
#include "d4data.hpp"

class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow
{
public:
  TMyWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle) {};
  virtual BOOL CanClose();
  virtual void WMLButtonDown(RTMessage Msg)
    = [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMRButtonDown(RTMessage Msg)
    = [WM_FIRST + WM_RBUTTONDOWN];
};

void TMyWindow::WMLButtonDown(RTMessage Msg)
{
  HDC DC;
  char S[10];
  char Title[] = "CONTENTS OF DATAFILE.DBF: " ;
  Code4 code ;
  Data4 data ;
  int X = 100 , Y = 50;

  DC = GetDC(HWindow);

  data.open( &code, "DATAFILE" ) ;

  TextOut(DC, X, Y-30 , Title, sizeof(Title) ) ;

   for ( data.top(); ! data.eof(); data.skip(1) )
   {
      for ( int j = 1; j <= data.num_fields(); j++ )
      {
	 Field4memo  field( data, j ) ;
	 TextOut(DC, X, Y, field.str(), field.len() );
	 X += (field.len() * 6 );
      }
      Y+= 20 ;
      X = 100 ;
   }
   code.close_all() ;

  ReleaseDC(HWindow, DC);
}

BOOL TMyWindow::CanClose()
{
  return MessageBox(HWindow, "Exiting Program", "", MB_OK ) ;
}

void TMyWindow::WMRButtonDown(RTMessage)
{
  InvalidateRect(HWindow, NULL, TRUE);
}

void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("Press Left Mouse Button to List Database", hInstance, hPrevInstance,
	       lpCmdLine, nCmdShow);
  MyApp.Run();
  return MyApp.Status;
}
