/*********************************************************************

d4list.c     (c)Copyright Sequiter Software Inc., 1990-1993.
All rights reserved.

This example program is discussed in the CodeBase manual on page 4

NOTE: Make sure that the accompanying database files, 'DATABASE.DBF' 
and 'DATABASE.MDX' are with this file when executing the program.

*********************************************************************/

#include "d4all.h"

#ifdef __TURBOC__
   extern unsigned  _stklen =  10000 ;  /* Borland only */
#endif

void main()
{

   CODE4   code_base ;
   DATA4  *base ;
   FIELD4 *field_ptr ;
   int      j ;
   
   d4init( &code_base ) ;
   
   /* Open the data file.  If there is a production MDX and/or MEMO file 
      file, they are also automatically opened. */
   
   base =  d4open( &code_base, "DATAFILE" ) ;
   e4exit_test( &code_base ) ;
   
   /* Loop through the entire data file. */
   for ( d4top(base); ! d4eof(base); d4skip(base,1) )
   {
      printf( "\n" ) ;  /* Display the record on a new line. */
      
       /* Loop through every field */
      for ( j = 1; j <= d4num_fields(base); j++ )
      {
         field_ptr =  d4field_j( base, j ) ;
         printf( "  %s", f4memo_str( field_ptr ) ) ; /* Display the field. */
      }
   }
   d4close_all(&code_base) ;
   
   e4exit(&code_base) ;
}

