/*********************************************************************
d4ex2.c   (c)Copyright Sequiter Software Inc., 1990-1992.
All rights reserved.

This example program creates and places data into a database.     
The contents are then displayed using the selected tags.

*********************************************************************/

#include "d4all.h"

#ifdef __TURBOC__
   #pragma hdrstop                     /* use pre-defined headers */
#endif

#ifdef __TURBOC__                      /* if Borland C is the compiler */
   extern unsigned _stklen = 10000 ;   /* set stack length to 10000 */
#endif

CODE4   cb ;                          /* initialize global variables */
DATA4  *data ;
FIELD4 *f_name, *l_name, *grade, *student_id, *birthdate, *will_pass ;
TAG4 *name, *class_list ;

static FIELD4INFO field_info[] =     /* define database field structure */
{
   /* field name,   type, width, decimals */
   { "F_NAME",      'C',   17,     0 },
   { "L_NAME",      'C',   17,     0 },
   { "GRADE",       'N',    5,     2 },
   { "STUDENT_ID",  'N',    6,     0 },
   { "BIRTHDT",     'D',    8,     0 },
   { "WILL_PASS",   'L',    1,     0 },
   { 0, 0, 0, 0 },
} ;

static TAG4INFO tag_info[] =         /* define multiple tags */
{
   /* name,        expression,      filter, unique,           descending */
   { "NAME",       "L_NAME+F_NAME", "",    r4unique_continue,      0       },
   { "CLASS_LIST", "GRADE",         "",      0,               r4descending },
   { 0,  0,  0, 0, 0 },
};


void main()
{
   FIELD4 *field_ptr ;
   int  j ;
   double d ;

   d4init( &cb ) ;
   cb.safety = 0 ;        /* will create new database, regardless of */
                          /* it's current existence  */
   printf("Creating Database. . .\n") ;

   data = d4create( &cb, "EXAMPLE", field_info, tag_info ) ;

   f_name   =  d4field( data, "F_NAME" ) ;     /* assign pointers to fields */
   l_name   =  d4field( data, "L_NAME" ) ;
   grade    =  d4field( data, "GRADE" ) ;
   student_id  =  d4field( data, "STUDENT_ID" ) ;
   birthdate   =  d4field( data, "BIRTHDT" ) ;
   will_pass   =  d4field( data, "WILL_PASS" ) ;

   d4append_start( data, 0 ) ;              /* append records */
   f4assign( f_name , "Fred" ) ;
   f4assign( l_name , "Jones" ) ;
   d = 76.8 ;
   f4assign_double( grade , d ) ;
   f4assign_long( student_id, 164534L ) ;
   f4assign( birthdate, "19651012" ) ;
   f4assign_char( will_pass , 'Y' ) ;
   d4append( data ) ;

   d4append_start( data, 0 ) ;
   f4assign( f_name , "Mary" ) ;
   f4assign( l_name , "Borgerson" ) ;
   d = 89.2 ;
   f4assign_double( grade , d ) ;
   f4assign_long( student_id, 145464L ) ;
   f4assign( birthdate, "19640821" ) ;
   f4assign_char( will_pass , 'Y' ) ;
   d4append( data ) ;

   d4append_start( data, 0 ) ;
   f4assign( f_name , "Larry" ) ;
   f4assign( l_name , "Smith" ) ;
   d = 45.4 ;
   f4assign_double( grade , d ) ;
   f4assign_long( student_id, 134578L ) ;
   f4assign( birthdate, "19650430" ) ;
   f4assign_char( will_pass , 'N' ) ;
   d4append( data ) ;

   d4append_start( data, 0 ) ;
   f4assign( f_name , "Sara" ) ;
   f4assign( l_name , "Abbott" ) ;
   d = 54.0 ;
   f4assign_double( grade , d ) ;
   f4assign_long( student_id, 124344L ) ;
   f4assign( birthdate, "19641102" ) ;
   f4assign_char( will_pass , 'Y' ) ;
   d4append( data ) ;

   d4go( data, 2L ) ;   /* go to record #2 */
                                            /* print record two to screen */
   printf(" Record number: %ld \n", d4recno( data ) ) ;
   for ( j = 1; j <= d4num_fields( data ); j++ )
   {
      field_ptr =  d4field_j( data, j ) ;
      printf( "  %s", f4str( field_ptr ) ) ; /* Display the field. */
   }
                                 /* print database ordered by first tag */
   printf("\n\nThe listing of the Database ordered using last name,first name:");
   printf("\n FIRST NAME           LAST NAME        GRADE  I.D.    BIRTHDATE  PASS?\n");

   d4tag_select( data , d4tag_default( data )) ;
   /* Loop through the entire data file. */
   for ( d4top( data ); ! d4eof( data ); d4skip( data, 1L ) )
   {
      printf( "\n" ) ;  /* Display the record on a new line. */

       /* Loop through every field */
      for ( j = 1; j <= d4num_fields( data ); j++ )
      {
         field_ptr =  d4field_j( data, j ) ;
         printf( "  %s", f4memo_str( field_ptr ) ) ; /* Display the field. */
      }
   }
                                 /* print database ordered by second tag */
   printf("\n\nThe listing of the Database ordered using grades (descending ):");
   printf("\n FIRST NAME           LAST NAME        GRADE  I.D.    BIRTHDATE  PASS?\n");

   d4tag_select( data, d4tag_next( data, d4tag_selected( data ) ) ) ;
   /* Loop through the entire data file. */
   for ( d4top( data ); ! d4eof( data ); d4skip( data, 1L ) )
   {
      printf( "\n" ) ;  /* Display the record on a new line. */

       /* Loop through every field */
      for ( j = 1; j <= d4num_fields( data ); j++ )
      {
         field_ptr =  d4field_j(  data, j ) ;
         printf( "  %s", f4memo_str( field_ptr ) ) ; /* Display the field. */
      }
   }

   d4close_all( &cb ) ;     /* close all database, index and/or memo files */
   printf("\nFINISHED\n") ;
}
