/***********************************************************************\
*                                                                       *
*   CUSTLIST.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif


int main( void )
{
   CODE4    code_base;
   DATA4    *data_file = 0;
   FIELD4   *f_name = 0
            ,*l_name = 0
            ,*address = 0
            ,*age = 0
            ,*birth_date = 0
            ,*married = 0
            ,*amount = 0
            ,*comment = 0;

   int      rc,j,age_value;
   double   amount_value;
   char     name_str[25];
   char     address_str[20];
   char     date_str[9];
   char     married_str[2];
   char     *comment_str;

   d4init(&code_base);

   data_file = d4open(&code_base,"DATA1.DBF");
   e4exit_test(&code_base);

   f_name = d4field(data_file,"F_NAME");
   l_name = d4field(data_file,"L_NAME");
   address = d4field(data_file,"ADDRESS");
   age = d4field(data_file,"AGE");
   birth_date = d4field(data_file,"BIRTH_DATE");
   married = d4field(data_file,"MARRIED");
   amount = d4field(data_file,"AMOUNT");
   comment = d4field(data_file,"COMMENT");

   for(rc = d4top(data_file);rc == r4success;rc = d4skip(data_file, 1L))
   {
      u4ncpy(name_str,f4str(f_name),sizeof(name_str));
      u4ncpy(address_str,f4str(address),sizeof(address_str));
      age_value = f4int(age);
      amount_value = f4double(amount);
 
      u4ncpy(date_str,f4str(birth_date),sizeof(date_str));
      u4ncpy(married_str,f4str(married),sizeof(married_str));
      comment_str = f4memo_str(comment);


      printf("-------------------------------\n");
      printf("Name     : %20s\n",name_str);
      printf("Address  : %15s\n",address_str);
      printf("Age : %3d   Married : %1s\n",age_value,married_str);
      printf("Comment: %s\n",comment_str);
      printf("Purchased this year:$%5.2lf \n",amount_value);
      printf("\n");
   }
   d4close(data_file);
   return 0;
}
