/***********************************************************************\
*                                                                       *
*   COPYDAT2.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

void main(int argc,char *argv[])
{
   CODE4      code_base;
   DATA4      *data_file,*data_copy;
   INDEX4     *index;
   FIELD4INFO *field_info;
   TAG4INFO   *tag_info;

   if(argc != 3)
   {
     printf("USAGE:COPYDATA <FROMFILE> <TOFILE>");
     exit(1);
   }

   d4init(&code_base);
   code_base.safety = 0;
   data_file = d4open(&code_base,argv[1]);
   e4exit_test(&code_base);


   index = d4index(data_file,argv[1]);
   if(index) tag_info = i4tag_info(index);

   field_info = d4field_info(data_file);
   d4create(&code_base,argv[2]
                           ,field_info,tag_info);
   u4free(field_info);
   u4free(tag_info);
   d4close_all(&code_base);
}