#include "d4all.h"
#include <commdlg.h>

#define M_QUERY   101
#define M_SORT    102
#define M_PRINTER 103
#define M_OPEN    104
#define M_CLOSE   105
#define M_EXIT    106
#define M_DISPLAY 107
#define M_PRINT   108

#define D_EXPR         100 
#define D_FIELDS       102 
#define D_FUNCTIONS    103 
#define D_OPERATORS    104 
#define D_CALCULATIONS 105 
#define D_TOTALS       106 
#define D_OK           IDOK 
#define D_CANCEL       IDCANCEL 

extern _stklen = 10000;

long FAR PASCAL _export WndProc( HWND, UINT, WPARAM, LPARAM );
BOOL CALLBACK _export expr_entry_proc( HWND, WORD, WORD, LONG );
BOOL CALLBACK _export print_option_proc( HWND, UINT, WPARAM, LPARAM );
int GetSortExpression( HWND, char *);
int GetQueryExpression( HWND, char *);
int GetPrinterName( HWND );

CODE4 cb;
REPORT4 *report = NULL;
char *expression_buf;
HANDLE hInstance;
WORD textpos;
E4FUNCTIONS *mv4functions ;


int PASCAL WinMain( HANDLE hInst, HANDLE hPrevInstance, 
                    LPSTR lpszCmdLine, int nCmdShow )
{
   HWND     hWnd;
   MSG      msg;
   WNDCLASS wc;
   HMENU    hMenu;

   hInstance = hInst;

   if( ! hPrevInstance )
   {
      wc.style          = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc    = WndProc;
      wc.cbClsExtra     = 0;
      wc.cbWndExtra     = 0;
      wc.hInstance      = hInstance;
      wc.hIcon          = LoadIcon(NULL,IDI_APPLICATION);
      wc.hCursor        = LoadCursor(NULL,IDC_ARROW);
      wc.hbrBackground  = GetStockObject(WHITE_BRUSH);
      wc.lpszMenuName   = NULL;
      wc.lpszClassName  = "BaseClass";

      RegisterClass( &wc );
   }

   d4init(&cb);

   SetHandleCount(100);

   hMenu = LoadMenu( hInstance, "LAUNCHMENU" );
   hWnd = CreateWindow( "BaseClass","Report Launch Utitlity",
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, hMenu, hInstance, NULL );

   ShowWindow( hWnd, nCmdShow );
   UpdateWindow( hWnd );

   while( GetMessage (&msg, NULL, 0, 0) )
   {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

   return msg.wParam;
}

long FAR PASCAL _export WndProc(HWND hWnd,UINT message,WPARAM wParam,
                                 LPARAM lParam)
{
   HBITMAP hBit;
   BITMAP  bm;
   HDC     hDC, hDCMem;
   RECT    rect;
   HMENU   hMenu;
   PAINTSTRUCT ps;
   static char query_expr[512], sort_expr[512];
   OPENFILENAME ofn;
   char szDirName[256], szFile[256], szFileTitle[256],szFilter[256];
   int i;

   switch(message)
   {
      case WM_CREATE:
         hMenu = GetMenu(hWnd);
         EnableMenuItem(hMenu,101,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
         EnableMenuItem(hMenu,102,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
         EnableMenuItem(hMenu,103,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
         EnableMenuItem(hMenu,107,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
         EnableMenuItem(hMenu,108,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
         DrawMenuBar(hWnd);
         break;


      case WM_DESTROY:
         if(report)
            report4free(report,1,1);
         d4init_undo(&cb);
         PostQuitMessage(0);
         return 0;

      case WM_COMMAND:
         switch( wParam )
         {
            case M_EXIT:
               if(report)
                  report4free(report,1,1);
               d4init_undo(&cb);
               PostQuitMessage(0);
               return 0;

            case M_OPEN:
               strcpy(szFilter,"Report Files|*.rep");
               for(i=0;szFilter[i] != '\0';i++)
                  if(szFilter[i] == '|')szFilter[i] = '\0';
               memset( &ofn, 0, sizeof(OPENFILENAME) );
               ofn.lStructSize = sizeof( OPENFILENAME );
               ofn.hwndOwner = hWnd;
               ofn.lpstrFilter = szFilter;
               ofn.nFilterIndex = 1;
               ofn.lpstrFile = szFile;
               ofn.nMaxFile = sizeof( szFile );
               ofn.lpstrFileTitle = szFileTitle;
               ofn.nMaxFileTitle = sizeof( szFileTitle );
               ofn.lpstrInitialDir = NULL;
               ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
               if(GetOpenFileName(&ofn))
               {
                  if(report)
                     report4free(report,1,1);

                  report = report4retrieve(&cb,szFile,TRUE);
                  if(report)
                  {
                     sprintf(sort_expr,"Report Launch Utility:  %s",report->report_name);
                     SendMessage(hWnd,WM_SETTEXT,0,(LPARAM)((LPCSTR)sort_expr));
                     hMenu = GetMenu(hWnd);
                     EnableMenuItem(hMenu,101,MF_BYCOMMAND | MF_ENABLED );
                     EnableMenuItem(hMenu,102,MF_BYCOMMAND | MF_ENABLED );
                     EnableMenuItem(hMenu,103,MF_BYCOMMAND | MF_ENABLED );
                     EnableMenuItem(hMenu,107,MF_BYCOMMAND | MF_ENABLED );
                     EnableMenuItem(hMenu,108,MF_BYCOMMAND | MF_ENABLED );
                     DrawMenuBar(hWnd);
                  }
                  else
                  {
                     SendMessage(hWnd,WM_SETTEXT,0,(LPARAM)((LPCSTR)"Report Launch Utility"));
                     hMenu = GetMenu(hWnd);
                     EnableMenuItem(hMenu,101,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                     EnableMenuItem(hMenu,102,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                     EnableMenuItem(hMenu,103,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                     EnableMenuItem(hMenu,107,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                     EnableMenuItem(hMenu,108,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                     DrawMenuBar(hWnd);
                  }
               }
               break;

            case M_CLOSE:
               if(report)
               {
                  report4free(report,1,1);
                  report = NULL;
                  SendMessage(hWnd,WM_SETTEXT,0,(LPARAM)((LPCSTR)"Report Launch Utility"));
                  hMenu = GetMenu(hWnd);
                  EnableMenuItem(hMenu,101,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                  EnableMenuItem(hMenu,102,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                  EnableMenuItem(hMenu,103,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                  EnableMenuItem(hMenu,107,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                  EnableMenuItem(hMenu,108,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED );
                  DrawMenuBar(hWnd);
               }
               break;

            case M_QUERY:
               GetQueryExpression( hWnd, query_expr );
               if( query_expr[0] )
                  relate4query_set( report->relate, query_expr );
               break;

            case M_SORT:
               GetSortExpression( hWnd, sort_expr );
               if( sort_expr[0] )
                  relate4query_set( report->relate, sort_expr );
               break;

            case M_PRINTER:
               GetPrinterName( hWnd );
               break;

            case M_DISPLAY:
               report4parent(report,hWnd);
               report->to_screen = 1;
               report4do(report);
               break;

            case M_PRINT:
               report4parent(report, hWnd);
               report->to_screen = 0;
               report4do(report);
               break;
         }
         break;
   }

   return DefWindowProc( hWnd, message, wParam, lParam );
}


int GetSortExpression( HWND hWndParent, char *expression )
{
   
   DLGPROC proc;
   int return_value;
   EXPR4 *expr = NULL;

   expression_buf = expression;

   while(!expr)
   {
      proc = (DLGPROC)MakeProcInstance( (FARPROC) expr_entry_proc, hInstance ) ;
      return_value = DialogBox(hInstance,"EXPRESSION", hWndParent, proc ) ;
   
      FreeProcInstance( (FARPROC) proc ) ;

      if(return_value == IDCANCEL)
      {
         strcpy(expression,"");
         return 0;
      }
      c4trim_n( expression_buf, 512 ) ;
      if( expression_buf[0] == 0 )
         return 0 ;
   
      expr = expr4parse( report->relate->data, expression_buf ) ;

      if( expr != 0 )
      {
         strcpy( expression, expression_buf );
         return 0 ;
      }
      expr = 0;
      e4set( &cb, 0 ) ;

   }
   return 0;
}

int GetQueryExpression( HWND hWndParent, char *expression )
{
   
   DLGPROC proc;
   int return_value;
   EXPR4 *expr = NULL;

   expression_buf = expression;

   while(!expr)
   {
      proc = (DLGPROC)MakeProcInstance( (FARPROC) expr_entry_proc, hInstance ) ;
      return_value = DialogBox(hInstance,"EXPRESSION", hWndParent, proc ) ;
   
      FreeProcInstance( (FARPROC) proc ) ;

      if(return_value == IDCANCEL)
      {
         strcpy(expression,"");
         return 0;
      }
      c4trim_n( expression_buf, 512 ) ;
      if( expression_buf[0] == 0 )
         return 0 ;
   
      expr = expr4parse( report->relate->data, expression_buf ) ;

      if( expr != 0 && expr4type(expr) == r4log )
      {
         strcpy( expression, expression_buf );
         return 0 ;
      }

      if( expr4type(expr) != r4log)
      {
         MessageBox(hWndParent,"The query expression must be a logical expression.",
          "Query Expression Error", MB_OK);
      }

      expr = 0;
      e4set( &cb, 0 ) ;

   }
   return 0;
}


void get_cursorpos( HWND hWnd )
{
   DWORD posit;
   
   posit = SendDlgItemMessage( hWnd, D_EXPR, EM_GETSEL, 0, 0L ) ;
   textpos = LOWORD( posit );
}

void addstr(HWND hWnd, char *str )
{

   SendDlgItemMessage( hWnd, D_EXPR, EM_REPLACESEL, 0,(LPARAM)((LPSTR) str ) ) ;
}

void init_expr_dialog(HWND hWnd)
{
   int i ;
   EXPR4CALC *calc_on;
   RELATE4 *relate_on ;
   DATA4 *d4 ;
   FIELD4 *field_on ;
   char name_buf[256] ;

   SendMessage(hWnd,WM_SETTEXT,0,(LPARAM)((LPSTR) "Enter Expression") ) ;

   SendDlgItemMessage(hWnd,D_EXPR,WM_SETTEXT,0,(LPARAM)((LPSTR)expression_buf));

   for(i = E4FIRST_FUNCTION; mv4functions[i].code >= 0; i++ )
   {
      if( mv4functions[i].name == 0 )  continue ;
      SendDlgItemMessage(hWnd, D_FUNCTIONS,LB_ADDSTRING,0,(LPARAM)((LPCSTR)mv4functions[i].name));

   }

   for(i = E4FIRST_OPERATOR-1; i <= E4LAST_OPERATOR; i++ )
   {
      if( mv4functions[i].name == 0 )  continue ;
      SendDlgItemMessage(hWnd, D_OPERATORS,LB_ADDSTRING,0,(LPARAM)((LPCSTR)mv4functions[i].name));
   }

   for( calc_on = 0; calc_on = (EXPR4CALC *) l4next( &cb.calc_list, calc_on); )
   {
      if( calc_on->total == 0 )
         SendDlgItemMessage(hWnd, D_CALCULATIONS,LB_ADDSTRING,0,(LPARAM)((LPCSTR)calc_on->name));
      else
         SendDlgItemMessage(hWnd, D_TOTALS,LB_ADDSTRING,0,(LPARAM)((LPCSTR)calc_on->name));
   }

   relate_on =  report->relate ;
   while( relate_on )
   {
      d4 =  relate_on->data ;
      for( i = 1; i <= d4num_fields(d4); i++ )
      {
         field_on =  d4field_j( d4, i ) ;

         strcpy( name_buf, d4alias(d4) ) ;
         strcat( name_buf, "->" ) ;
         strcat( name_buf, f4name(field_on) ) ;
         SendDlgItemMessage(hWnd,D_FIELDS,LB_ADDSTRING,0,(LPARAM)((LPCSTR)name_buf));

      }
      relate4next( &relate_on ) ;
   }
}

BOOL CALLBACK _export expr_entry_proc( HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
   int ndx ;
   char expr_info[512];


   switch( message )
   {
      case WM_INITDIALOG:
         expr4functions(&(mv4functions));
         init_expr_dialog(hWnd);
         SetFocus(GetDlgItem(hWnd,100));
         break;

      case WM_COMMAND:
         switch ( wParam )
         {
            case D_OK:
               SendDlgItemMessage(hWnd,D_EXPR,WM_GETTEXT,(WPARAM)(511),
                  (LPARAM)((LPCSTR)expression_buf));
               EndDialog(hWnd,IDOK);
               break;

            case D_CANCEL:
               EndDialog(hWnd,IDCANCEL);
               break;

            case D_FIELDS:
               if(HIWORD(lParam) == LBN_DBLCLK )
               {
                  memset(expr_info,0,sizeof(expr_info));
                  ndx = SendDlgItemMessage(hWnd,D_FIELDS,LB_GETCURSEL, 0, 0L ) ;
                  SendDlgItemMessage(hWnd,D_FIELDS,LB_GETTEXT,(WPARAM)ndx,
                     (LPARAM)((LPCSTR)expr_info));
                  addstr( hWnd, expr_info ) ;
                  SetFocus(GetDlgItem(hWnd,100));
               }
               break ;

            case D_FUNCTIONS:
               if(HIWORD(lParam) == LBN_DBLCLK)
               {
                  memset( expr_info, 0, sizeof(expr_info) ) ;
                  ndx = SendDlgItemMessage(hWnd,D_FUNCTIONS,LB_GETCURSEL, 0, 0L ) ;
                  SendDlgItemMessage(hWnd,D_FUNCTIONS,LB_GETTEXT,(WPARAM)ndx,
                     (LPARAM)((LPCSTR)expr_info));
                  strcat( expr_info, "()" ) ;
                  addstr( hWnd, expr_info );
                  SetFocus(GetDlgItem(hWnd,100));
               }
               break;

            case D_OPERATORS:
               if(HIWORD(lParam) == LBN_DBLCLK)
               {
                  memset( expr_info, 0, sizeof(expr_info) ) ;
                  ndx = SendDlgItemMessage(hWnd,D_OPERATORS,LB_GETCURSEL, 0, 0L ) ;
                  SendDlgItemMessage(hWnd,D_OPERATORS,LB_GETTEXT,(WPARAM)ndx,
                     (LPARAM)((LPCSTR)expr_info));
                  addstr( hWnd, expr_info );
                  SetFocus(GetDlgItem(hWnd,100));
               }
               break;

            case D_TOTALS:
               if(HIWORD(lParam) == LBN_DBLCLK)
               {
                  memset( expr_info, 0, sizeof(expr_info) ) ;
                  ndx = SendDlgItemMessage(hWnd,D_TOTALS,LB_GETCURSEL, 0, 0L ) ;
                  SendDlgItemMessage(hWnd,D_TOTALS,LB_GETTEXT,(WPARAM)ndx,
                     (LPARAM)((LPCSTR)expr_info));
                  strcat(expr_info,"()");
                  addstr( hWnd, expr_info );
                  SetFocus(GetDlgItem(hWnd,100));
               }
               break;

            case D_CALCULATIONS:
               if(HIWORD(lParam) == LBN_DBLCLK)
               {
                  memset( expr_info, 0, sizeof(expr_info) ) ;
                  ndx = SendDlgItemMessage(hWnd,D_CALCULATIONS,LB_GETCURSEL, 0, 0L ) ;
                  SendDlgItemMessage(hWnd,D_CALCULATIONS,LB_GETTEXT,(WPARAM)ndx,
                     (LPARAM)((LPCSTR)expr_info));
                  strcat(expr_info,"()");
                  addstr( hWnd, expr_info );
                  SetFocus(GetDlgItem(hWnd,100));
               }
               break;
         }
         break;


   }

   return 0 ;
}


char printer[40] ;

BOOL CALLBACK _export print_option_proc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
   int ndx , n_chars, i, pos, do_select ;
   char printer_buf[500] ;

   switch( message )
   {
      case WM_INITDIALOG:
         pos = u4ncpy( printer_buf, "Default (", sizeof(printer_buf) ) ;
         GetProfileString( "windows", "device", "", printer_buf+pos, sizeof(printer_buf)-pos) ;
         u4ncat( printer_buf, ")", sizeof(printer_buf) ) ;
         SendDlgItemMessage(hWnd,100,LB_ADDSTRING,0,(LPARAM)((LPCSTR)printer_buf));
         if( report->printer_name == 0)
            SendDlgItemMessage( hWnd,100,LB_SETCURSEL,0, 0L ) ;

         n_chars = GetProfileString( "devices", 0, 0, printer_buf, sizeof(printer_buf) ) ;
         for( i = 0; i < n_chars; i += strlen(printer_buf+i)+1 )
         {
            do_select =  0 ;
            if( report->printer_name != 0 )
               do_select =  strcmp(printer_buf+i,report->printer_name) == 0 ;

            ndx = SendDlgItemMessage(hWnd,100,LB_ADDSTRING,0,(LPARAM)((LPCSTR)printer_buf+i));
            if(do_select)
               SendDlgItemMessage(hWnd,100,LB_SETCURSEL,ndx,0L);
         }
         SetFocus(GetDlgItem(hWnd,100));
         break;

      case WM_COMMAND:
         switch( wParam )
         {

            case IDOK:
               ndx = SendDlgItemMessage(hWnd,100,LB_GETCURSEL,0,0L);
               SendDlgItemMessage(hWnd,100,LB_GETTEXT,(WPARAM)ndx,(LPARAM)((LPSTR)printer));
               EndDialog(hWnd,IDOK);
               break;
         }
         break;
   }
   return 0;
}

GetPrinterName( HWND hWnd )
{
   DLGPROC proc;
   int retvalue ;

   memset( &printer, 0, sizeof(printer) ) ;

   proc = (DLGPROC)MakeProcInstance((FARPROC)print_option_proc,hInstance);
   retvalue = DialogBox(hInstance,"PRINT_OPTIONS",hWnd,proc);
   FreeProcInstance((FARPROC)proc);

   c4trim_n( printer, sizeof(printer) ) ;
   if( memcmp( printer, "Default (", 9 ) == 0 )
      report4printer( report, 0 ) ;
   else
      report4printer( report, printer ) ;

   return 0 ;
}

