/* cid_2.c  (c)Copyright Sequiter Software Inc., 1992-1993.  All rights reserved. */

#include    <conio.h>
#include    <dos.h>
#include    "d4all.h"
#include    "e4error.h"
#include    "w4.h"
#include    "cid.h"
#include    "g4char.h"

extern  CODE4  CodeBase;
extern  struct  DATALIST    *FirstData;
extern  int     Aborted,FuctionType;
extern  char    *DefaultPath;
extern  CB_WINDOW  *v4window;
extern  int     DataRef,LastEntry,DataEntry,LastError;

extern  long    BackGroundColor,NormalBord,NormalText,WarningBord,
        WarningText,ReturnBord,ReturnText,MenuText,
        MenuSelected,PopUpText,GetColor,TitleBarColor,SelectedColor;


int     Busy(   char *Line1,char *Line2,char *Line3,char *Line4)
{
    int BoxWin;

    BoxWin = w4define(5,19,12,59);
    w4border(DOUBLE,ReturnBord);
    w4attribute(ReturnBord);
    w4popup();

    w4activate(BoxWin);
    w4centre(1,Line1);
    w4centre(2,Line2);
    w4centre(3,Line3);
    w4centre(4,Line4);
    return(BoxWin);
}

void    ClearBusy(int   WinRef)
{
    w4deactivate(WinRef);
    w4close(WinRef);
}
/***************************************************************************\
\***************************************************************************/

void        Message(    char *Line1,
                    char *Line2,
                    char *Line3,
                    char *Line4,
                    char *Opt)
{
    int CurrentWin,BoxWin,Menu,Length;

    CurrentWin = w4select(-1);

    BoxWin = w4define(5,19,15,59);
    w4border(DOUBLE,WarningBord);
    w4attribute(WarningText);
    w4popup();

    w4activate(BoxWin);
    w4centre(1,Line1);
    w4centre(2,Line2);
    w4centre(3,Line3);
    w4centre(4,Line4);

    Menu = w4define(12,20,14,58);
    w4border(SINGLE,WarningText);
    w4attribute(WarningText);
    n4horizontal();
    n4attribute(WarningText,SelectedColor);

    Length = strlen(Opt);
    n4item(0,18-(Length/2),Opt);
    n4parm(0);
    n4activate(Menu);
    w4close(Menu);

    w4deactivate(BoxWin);
    w4close(BoxWin);

    w4select(CurrentWin);

}

/***************************************************************************\
\***************************************************************************/

int     Continue(   char *Line1,
                    char *Line2,
                    char *Line3,
                    char *Line4,
                    char *TrueOpt,
                    char *FalseOpt)
{
    int CurrentWin,BoxWin,Menu,Choice,Length;

    CurrentWin = w4select(-1);

    BoxWin = w4define(5,19,15,59);
    w4border(DOUBLE,WarningBord);
    w4attribute(WarningText);
    w4popup();

    w4activate(BoxWin);
    w4centre(1,Line1);
    w4centre(2,Line2);
    w4centre(3,Line3);
    w4centre(4,Line4);

    Menu = w4define(12,20,14,58);
    w4border(SINGLE,WarningText);
    w4attribute(WarningText);
    n4horizontal();
    n4attribute(WarningText,SelectedColor);
    n4item(0,3,TrueOpt);
    n4parm(1);
    Length = strlen(FalseOpt);
    n4item(0,34-Length,FalseOpt);
    n4parm(0);
    Choice = n4activate(Menu);
    w4close(Menu);

    w4deactivate(BoxWin);
    w4close(BoxWin);

    w4select(CurrentWin);
    return(Choice);
}

/***************************************************************************\
\***************************************************************************/


void    AddData(DATA4 *Data)
{
    struct  DATALIST    *Current,*New;

    Current = FirstData;
    New = (struct DATALIST *) u4alloc(sizeof(struct DATALIST));

    if(New)
    {
        New->Data = Data;
        New->Next = Current;
        FirstData = New;
    }
    else
	e4severe( e4memory, "AddData");
}


void    FreeData( void )
{
    struct  DATALIST    *Current,*Temp;
    Current = FirstData;
    while(Current != NULL)
    {
        Temp = Current->Next;
        u4free(Current);
        Current = Temp;
    }
    FirstData = NULL;
}

void    RemoveData( DATA4 *Data)
{
    struct  DATALIST  *Current,*Temp;
    int     Done = FALSE;

    Current = FirstData;Temp = FirstData;

    if(Current != NULL)
    {
        if(Current->Data == Data)
        {
            Done = TRUE;
            FirstData = Current->Next;
            u4free(Current);
        }
        else
        {
            Temp = Current->Next;

            while(Temp != NULL && !Done)
            {
                if(Temp->Data == Data)
                {
                    Done = TRUE;
                    Current->Next = Temp->Next;
                    u4free(Temp);
                }
                else
                {
                    Current = Temp;
                    Temp = Temp->Next;
                }
            }
        }
    }
    if(!Done)
        e4severe( e4info, "RemoveData()");

}

/***************************************************************************\
\***************************************************************************/

void    ReturnCode(char *ReturnString,int ReturnInt)
{
    switch(ReturnInt)
    {
        case r4success      :   strcpy(ReturnString," r4success        ");break;
        case r4found        :   strcpy(ReturnString," r4found          ");break;
        case r4after        :   strcpy(ReturnString," r4after          ");break;
        case r4eof          :   strcpy(ReturnString," r4eof            ");break;
        case r4bof          :   strcpy(ReturnString," r4bof            ");break;
        case r4entry        :   strcpy(ReturnString," r4entry          ");break;
        case r4descending   :   strcpy(ReturnString," r4descending     ");break;
        case r4unique       :   strcpy(ReturnString," r4unique         ");break;
        case r4unique_continue: strcpy(ReturnString," r4unique_continue");break;
        case r4ignore       :   strcpy(ReturnString," r4ignore         ");break;
        case r4keep         :   strcpy(ReturnString," r4keep           ");break;
        case r4locked       :   strcpy(ReturnString," r4locked         ");break;
        case r4no_create    :   strcpy(ReturnString," r4no_create      ");break;
        case r4no_open      :   strcpy(ReturnString," r4no_open        ");break;
        case r4no_tag       :   strcpy(ReturnString," r4no_tag         ");break;

        default:
            sprintf(ReturnString," %d ",ReturnInt);
    }
}

/***************************************************************************\
\***************************************************************************/

int     CheckDir(GET *Get)
{
    int Ret,DirLength,NoSlash = 1;
    char    Dir[62];

    strcpy(Dir,(char *) (Get->data));
    c4trim_n(Dir,strlen(Dir)+1);
    DirLength = strlen(Dir);
    if(DirLength == 0)
        Ret = 0;
    else if(DirLength == 2 && Dir[1] == ':')
        Ret = 0;
    else if(DirLength == 3 && Dir[1] == ':' && Dir[2] == '\\')
    {
        NoSlash = 1;
        Ret = access(Dir,0);
    }
    else
    {
        NoSlash = 0;

        if(Dir[DirLength-1] == '\\')
        {
            Dir[DirLength-1] = 0;
        }
        else
            DirLength ++;

        Ret = access(Dir,0);

        if(Ret < 0)
        {
	    Message(CID_DCT,Dir,CID_EXS,"",CID_CON);
            Ret = 1;
        }
        else
            Ret = 0;
    }
    if(!NoSlash)
    {
        Dir[DirLength-1] = '\\';
        Dir[DirLength] =0;
    }
    strcpy((char *) (Get->data),Dir);
    return(Ret);
}

/***************************************************************************\
\***************************************************************************/

int     CheckFileName(GET *Get)
{
    int count1,count2;
    char    FileName[10],NewFileName[10];

    strcpy(FileName,(char *) (Get->data));
    memset(NewFileName,32,8);
    NewFileName[8] = 0;
    count2 = 8;
    for(count1 = 8;count1 >= 0;count1 --)
    {
        if(FileName[count1] != ' ')
        {
            NewFileName[count2] = FileName[count1];
            count2 --;
        }
    }

    strcpy((char *) (Get->data),NewFileName);
    if(count2 == 7)
        return(1);
    else
        return(0);
}

/***************************************************************************\
\***************************************************************************/

int     CheckBlank(GET *Get)
{
    int Ret=1,count,Length;
    char    *Str;

    Str = (char *) (Get->data);
    Length = strlen(Str);
    for(count =0;count < Length && Ret;count++)
        Ret = (Str[count] == ' ');

    return(Ret);
}

/***************************************************************************\
\***************************************************************************/

int     CheckType(GET *Get)
{
    char    Type,TypeStr[2];

    strcpy(TypeStr,(char *) (Get->data));
    Type = TypeStr[0];
    if(Type == 'C' || Type == 'L' || Type == 'N' || Type == 'M'
    || Type == 'D' || Type == 'F')
        return(0);
    else
    {
        strcpy((char *) (Get->data),"C");
        return(1);
    }
}

/***************************************************************************\
\***************************************************************************/

void FreeFields(struct FIELDLIST *First)
{
    struct  FIELDLIST *Current;

    while(First != NULL)
    {
        Current = First->Next;
        u4free(First);
        First = Current;
    }
}

/***************************************************************************\
\***************************************************************************/

void FreeTags(struct TAGLIST *First)
{
    struct  TAGLIST *Current;

    while(First != NULL)
    {
        Current = First->Next;
        u4free(First);
        First = Current;
    }
}

/***************************************************************************\
\***************************************************************************/

int EmptyStr(char *Str)
{
    int count =0,Blank = 1;

     while(Str[count] != 0 && Blank)
     {
        Blank = (Str[count] == ' ');
        count ++;
     }
     return(Blank);
}


/***************************************************************************\
*                                                                           *
*   FUNCTION    e4                                                          *
*                                                                           *
*****************************************************************************
*                                                                           *
*       This function replaces the e4() that comes standard with the        *
*   CodeBase 4.5 library.  Some linkers do not allow replace functions that *
*   are in libraries.  In that case, you can either comment out this        *
*   function or comment out the function in the library source code.        *
*                                                                           *
\***************************************************************************/


int S4FUNCTION e4( CODE4 S4PTR *c4, int err_code, char *desc )
{
   return e4describe( c4, err_code, desc, 0, 0 ) ;
}

int S4FUNCTION e4describe( CODE4 S4PTR *c4, int err_code, char *desc1, char *desc2, char *desc3 )
{
   #ifdef S4ERROR_HOOK
      e4hook( c4, err_code, desc1, desc2, desc3 ) ;
   #else
      char *ptr,Text[80] ;
      int desc_number = 1 ;

      c4->error_code =  err_code ;
      sprintf(Text,CID_ERR, err_code);

   Message(Text,desc1,desc2,desc3,CID_CON);


   #endif  /* ifdef S4ERROR_HOOK  */

   return( err_code ) ;
}

/***************************************************************************\
*                                                                           *
*   FUNCTION    e4severe                                                    *
*                                                                           *
*****************************************************************************
*                                                                           *
*       This function replaces the e4severe() that comes standard with the  *
*   CodeBase 4.5 library.  Some linkers do not allow replace functions that *
*   are in libraries.  In that case, you can either comment out this        *
*   function or comment out the function in the library source code.        *
*                                                                           *
\***************************************************************************/

void S4FUNCTION e4severe( int err_code, char *desc )
{
   #ifdef S4ERROR_HOOK
      e4hook( (char *)0, err_code, desc, (char *)0, (char *)0 ) ;
   #else

      char *ptr,Text[80] ;
      int desc_number = 1 ;

      sprintf(Text,CID_SEV, err_code);

      Message(Text,NULL,desc,NULL,CID_TER);


   #endif   /* ifdef S4ERROR_HOOK */

   exit(1) ;
}

/***************************************************************************\
*                                                                           *
*   Function    TitleScreen                                                 *
*                                                                           *
*       This function creates a fullscreen popup window and fills it with   *
*   a background pattern.  The window reference number is returned so it    *
*   can be deallocated later.                                               *
*                                                                           *
\***************************************************************************/

int     TitleScreen(char Title[])
{
    int BackWindow,Count,TitleLength,Offset;
    char TitleBar[MAXCOL+2],BackGround[MAXCOL+2];

    memset(BackGround,'',MAXCOL);
    memset(TitleBar,' ',MAXCOL+1);

    BackGround[MAXCOL-1 ] =0;
    TitleBar[MAXCOL+1] = 0;

    TitleLength = strlen(Title);

    Offset = MAXCOL / 2 - (TitleLength / 2) -1;

    for(Count = 0;Count < TitleLength; Count ++)
            TitleBar[Offset + Count+1] = Title[Count];

    BackWindow = w4define(0,0,MAXROW,MAXCOL);
    w4popup();
    w4border("",BackGroundColor);
    w4title(MAXROW,0,TitleBar,TitleBarColor);
    w4attribute( BackGroundColor);
    w4activate(BackWindow);
    for(Count = 0 ; Count < MAXROW -1;Count ++)
        w4(Count,0,BackGround);

    w4attribute(F_BLUE|F_GREEN|F_INTENSE|B_GREEN|B_BLUE);

    return(BackWindow);
}

int     EntryWindow(char *Title)
{
    int     Win,TitleLength,Offset;

    TitleLength = strlen(Title);

    Offset = 37 - (TitleLength / 2) ;


    Win = w4define(2,3,22,76);
    w4border(DOUBLE,NormalBord);
    w4attribute(NormalBord);
    w4title(0,Offset,Title,NormalBord);
    w4popup();

    w4activate(Win);

    return(Win);
}
int     EntryWindowSmall(char *Title)
{
    int     Win,TitleLength,Offset;

    TitleLength = strlen(Title);

    Offset = 37 - (TitleLength / 2) ;


    Win = w4define(6,3,14,76);
    w4border(DOUBLE,NormalBord);
    w4attribute(NormalBord);
    w4title(0,Offset,Title,NormalBord);
    w4popup();

    w4activate(Win);

    return(Win);
}

/***************************************************************************\
\***************************************************************************/

void HelloMessage( void )
{
    int CurrentWin,BoxWin;

    CurrentWin = w4select(-1);

 #ifndef S4LANGUAGE
    BoxWin = EntryWindow(" CodeBase Interactive for Dos ");
    w4attribute(MenuText);
   #ifndef S4FOX
       #ifdef N4OTHER
           #ifdef S4CLIPPER
           w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [NTX version] ");
           #else
           w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [NDX version] ");
           #endif
       #else
           w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [MDX version] ");
       #endif
   #else
       w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [CDX version] ");
   #endif
    w4( 1,1,"                                                                    ");
    w4( 2,1,"This program allows you to quickly access the core functions of the ");
    w4( 3,1,"CodeBase library.  You can use this program to familarize yourself  ");
    w4( 4,1,"with the functions of CodeBase 5.0 .                                 ");
    w4( 5,1,"                                                                    ");
    w4( 6,1,"Instructions:   Use the cursor keys to select a function from the   ");
    w4( 7,1,"menu.  You will then be prompted to enter all the applicable        ");
    w4( 8,1,"parameters through a series of menus or entry boxes.                ");
    w4(10,1,"For example, to open a database select `d4open' from the DATA4 menu");
    w4(11,1,"and then type in a directory.  A list of the *.DBF files will be    ");
    w4(12,1,"presented.  Select the database which you wish to open.             ");
 #else
    #ifdef S4GERMAN
       BoxWin = EntryWindow(" CodeBase Interactive fr Dos ");
       w4attribute(MenuText);
      #ifndef S4FOX
          #ifdef N4OTHER
              #ifdef S4CLIPPER
              w4( 0,1,"       Welcome to CodeBase Interactive fr Dos   [NTX version] ");
              #else
              w4( 0,1,"       Welcome to CodeBase Interactive fr Dos   [NDX version] ");
              #endif
          #else
              w4( 0,1,"       Welcome to CodeBase Interactive fr Dos   [MDX version] ");
          #endif
      #else
          w4( 0,1,"       Welcome to CodeBase Interactive fr Dos   [CDX version] ");
      #endif
       w4( 1,1,"                                                                    ");
       w4( 2,1,"This program allows you to quickly access the core functions of the ");
       w4( 3,1,"CodeBase library.  You can use this program to familarize yourself  ");
       w4( 4,1,"with the functions of CodeBase 5.0 .                                 ");
       w4( 5,1,"                                                                    ");
       w4( 6,1,"Instructions:   Use the cursor keys to select a function from the   ");
       w4( 7,1,"menu.  You will then be prompted to enter all the applicable        ");
       w4( 8,1,"parameters through a series of menus or entry boxes.                ");
       w4(10,1,"For example, to open a database select `d4open' from the DATA4 menu");
       w4(11,1,"and then type in a directory.  A list of the *.DBF files will be    ");
       w4(12,1,"presented.  Select the database which you wish to open.             ");
    #endif
   
    #ifdef S4FRENCH
       BoxWin = EntryWindow(" CodeBase Interactive for Dos ");
       w4attribute(MenuText);
      #ifndef S4FOX
          #ifdef N4OTHER
              #ifdef S4CLIPPER
              w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [NTX version] ");
              #else
              w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [NDX version] ");
              #endif
          #else
              w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [MDX version] ");
          #endif
      #else
          w4( 0,1,"       Welcome to CodeBase Interactive for Dos   [CDX version] ");
      #endif
       w4( 1,1,"                                                                    ");
       w4( 2,1,"This program allows you to quickly access the core functions of the ");
       w4( 3,1,"CodeBase library.  You can use this program to familarize yourself  ");
       w4( 4,1,"with the functions of CodeBase 4.5.                                 ");
       w4( 5,1,"                                                                    ");
       w4( 6,1,"Instructions:   Use the cursor keys to select a function from the   ");
       w4( 7,1,"menu.  You will then be prompted to enter all the applicable        ");
       w4( 8,1,"parameters through a series of menus or entry boxes.                ");
       w4(10,1,"For example, to open a database select `d4open' from the DATA4 menu");
       w4(11,1,"and then type in a directory.  A list of the *.DBF files will be    ");
       w4(12,1,"presented.  Select the database which you wish to open.             ");
    #endif
 #endif 

    w4attribute(NormalBord);

    w4(14,1,"   Copyright 1993                          S E Q U I T E R  ޳");
    w4(15,1,"                                           Software   Inc   ޳");

    w4box(SINGLE,16,16,18,55);
    w4attribute(GetColor);

    w4centre(17,CID_CON);
    g4char();
    w4deactivate(BoxWin);
    w4close(BoxWin);

    w4select(CurrentWin);

}

/***************************************************************************\
*                                                                           *
*   Function SingleGet                                                      *
*                                                                           *
\***************************************************************************/

void    GetSet(int Row,int Col,int GetType,int Length,int Max,char *Picture
        ,int *GetInt,long *GetLong,double *GetDouble,char *GetChar)
{

    g4attribute(GetColor);
    switch(GetType)
    {
        case INTTYPE:
            memset(Picture,'#',Length);
            Picture[Length] = 0;
            g4int(Row+1,Col+1,GetInt);
            break;
        case LONGTYPE:
            memset(Picture,'#',Length);
            Picture[Length] = 0;
            g4long(Row+1,Col +1,GetLong);
            break;
        case DOUBLETYPE:
            memset(Picture,'#',Length);
            Picture[Length] = 0;
            Picture[Length-3] = '.';
            g4double(Row+1,Col +1,GetDouble);
            break;
        case CHARTYPE:
            memset(Picture,'X',Length);
            Picture[Length] = 0;
            g4(Row+1,Col+1,GetChar);
        break;
    }
    g4width(Length,Max);
    g4picture(Picture);

}

void    ConvertGet(int GetType,int GetInt,long GetLong,double GetDouble,char *ReturnStr)
{
    switch(GetType)
    {
        case INTTYPE:
            sprintf(ReturnStr," %d ",GetInt);
            break;
        case LONGTYPE:
            sprintf(ReturnStr," %ld ",GetLong);
            break;
        case DOUBLETYPE:
            sprintf(ReturnStr," %lf ",GetDouble);
            break;
    }
}

int     SingleGet(int Row,int Col,int GetType,int Length,int Max,char *ReturnStr)
{
    int Choice = 27,GetInt,Ret,Aborted=0;
    double  GetDouble;
    long    GetLong;
    char    Picture[60];

    if(Length > 58)
        Length = 58;
    w4box(SINGLE,Row,Col,Row+2,Col+Max+1);
    while(Choice == 27 && !Aborted)
    {
        memset(ReturnStr,' ',Length);
        ReturnStr[Length] = 0;
        GetDouble = 0.0;
        GetLong = 0L;
        GetInt = 0;
        GetSet(Row,Col,GetType,Length,Max,Picture,&GetInt,&GetLong,&GetDouble,ReturnStr);
        Choice = g4read();
        if(Choice == 27)
        {
            Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
            if(Ret == 0)
                Aborted = TRUE;
        }
    }
    if(!Aborted)
    {
        ConvertGet(GetType,GetInt,GetLong,GetDouble,ReturnStr);
    }
    return(Aborted);
}

/***************************************************************************\
*                                                                           *
*   Function DoubleGet                                                      *
*                                                                           *
\***************************************************************************/

int     DoubleGet(int Row1,int Col1,int GetType1,int Length1,int Max1,char *ReturnStr1,
                  int Row2,int Col2,int GetType2,int Length2,int Max2,char *ReturnStr2)
{
    int Choice = 27,GetInt1,GetInt2,Ret,Aborted=0;
    double  GetDouble1,GetDouble2;
    long    GetLong1,GetLong2;
    char    Picture1[60],Picture2[60];

    if(Length1 > 58)
        Length1 = 58;
    if(Length2 > 58)
        Length2 = 58;
    w4box(SINGLE,Row1,Col1,Row1+2,Col1+Max1+1);
    w4box(SINGLE,Row2,Col2,Row2+2,Col2+Max2+1);
    while(Choice == 27 && !Aborted)
    {
        memset(ReturnStr1,' ',Length1);
        ReturnStr1[Length1] = 0;
        memset(ReturnStr2,' ',Length2);
        ReturnStr2[Length2] = 0;
        GetDouble1 = 0.0;
        GetDouble2 = 0.0;
        GetLong1 = 0L;
        GetLong2 = 0L;
        GetInt1 = 0;
        GetInt2 = 0;
        GetSet(Row1,Col1,GetType1,Length1,Max1,Picture1,&GetInt1,&GetLong1,&GetDouble1,ReturnStr1);
        GetSet(Row2,Col2,GetType2,Length2,Max2,Picture2,&GetInt2,&GetLong2,&GetDouble2,ReturnStr2);
        Choice = g4read();
        if(Choice == 27)
        {
            Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
            if(Ret == 0)
                Aborted = TRUE;
        }
    }
    if(!Aborted)
    {
        ConvertGet(GetType1,GetInt1,GetLong1,GetDouble1,ReturnStr1);
        ConvertGet(GetType2,GetInt2,GetLong2,GetDouble2,ReturnStr2);
    }
    return(Aborted);
}




/***************************************************************************\
\***************************************************************************/

void    FunctionReturn(char *Title,char *Usage,DATA4 *Data,char *ReturnValue)
{
    int ReturnWin,Length,Offset,Menu,Current;
    long Recount,RecNum,LockStat;
    char DataAlias[20],Temp[256];

    Current = w4select(-1);
    Length = strlen(Title);

    Offset = 37 - (Length / 2) ;


    ReturnWin = w4define(3,3,21,76);
    w4border(DOUBLE,ReturnBord);
    w4attribute(ReturnBord);
    w4title(0,Offset,Title,ReturnBord);
    w4popup();

    w4activate(ReturnWin);

    w4(1,4,CID_USA);
    w4(4,4,CID_DTB);
    w4(6,4,CID_RET);
    w4(8,4,CID_REC);
    w4(10,4,CID_CUR);
    w4(12,4,CID_LOC);

    if(Data == 0)
    {
        Recount = 0;
        RecNum  = 0;
        LockStat= 0;
        strcpy(DataAlias,"------------");
    }
    else
    {
        Recount = d4reccount(Data);
        RecNum = d4recno(Data);
        strcpy(DataAlias,d4alias(Data));
        LockStat = d4lock_test(Data,RecNum);
    }
    w4attribute(ReturnText);
    w4(1,12,Usage);
    w4(4,29,DataAlias);
    Length = strlen(ReturnValue);
    if(Length > 50)
        Length = 50;
    w4num(6,29,ReturnValue,Length);
    sprintf(Temp," %ld ",Recount);
    w4(8,29,Temp);
    sprintf(Temp," %ld ",RecNum);
    w4(10,29,Temp);
    sprintf(Temp," %ld ",LockStat);
    w4(12,29,Temp);
    LastError = 0;

    Menu = w4define(18,20,20,58);
    w4border(SINGLE,ReturnBord);
    w4attribute(ReturnText);
    n4horizontal();
    n4attribute(ReturnBord,SelectedColor);


    n4item(0,13,CID_CON);
    n4parm(0);
    n4activate(Menu);
    w4close(Menu);

    w4deactivate(ReturnWin);
    w4close(ReturnWin);
    w4select(Current);
}
