



			Why use the Turbo Pascal HLLAPI

	Every multitasker that I have examined insists on managing INT
	14h.  The FOSSIL specification is basically an extension of the
	normal BIOS INT 14h functions.  However, in implementing a FOSSIL
	with features that are not supported by BIOS's INT 14h, additional
	registers were used to pass additional parameters.  Some
	multitaskers will intercept the INT 14h calls and will alter
	registers that are not normally used by BIOS.	 Quarterdeck's tech
	support confirmed to me that they may change the DS register when
	DESQview intercepts an INT 14h  (when released, version 2.26  of
	DESQview is supposed to correct this).  What this means is that
	some FOSSIL functions will work correctly with a multitasker and
	others will not.  Additionally, it means that if one application
	program uses a FOSSIL function that another application does not
	use, then one of the programs may work fine with a multitasker
	and the other may not.

	My first task in solving problems with multitaskers was to
	eliminate the need for X00 to be called using an INT 14h.  Starting
	with version 1.20  of X00, I have included quick and dirty HLLAPI
	routines for some high level languages.  More are yet to come.
	Applications programmers should replace references to library
	routines in their existing source with the replacement routine(s)
	included in the X00 distribution file. Then include the appropriate
	object module in the linking process.  At this writing, HLLAPIs are
	included for:

	   Microsoft C, all models
	   Borland's Turbo C
	   Borland's Turbo Pascal
	   Microsoft Quick Basic

        The first time the HLLAPI is called, it will determine if X00 is
        the active FOSSIL.  If X00 is the active FOSSIL, then it will be
        directly called instead of using INT 14h.  If X00 is not the
        active FOSSIL, or if there is no FOSSIL, the HLLAPI will issue an
        INT 14h.  After the first call to the HLLAPI, a maximum of only 4
        assembly instructions are added to the execution thread no matter
        what FOSSIL is installed.  The addition of 4 instructions to the
        execution thread should have no effect on execution speed of the
        application program.
 
	Using the HLLAPIs to access X00 with a multitasking system can
	result in significantly faster execution because the multitasker's
	management of INT 14h is not executed.  Additionally, the
	multitasker has no opportunity to change the registers and all
	FOSSIL functions should work correctly.

	Those using assembly language to access X00 should replace INT 14h
	instructions with a CALL BYPASS and include BYPASS.OBJ in the linked
	program.  BYPASS should be declared as a FAR external,
	i.e.	EXTRN	BYPASS:FAR

 
 
 
 
                                TPHLLAPI
 
        I am not a Pascal programmer, so please forgive any documentation
        blunders and/or syntax errors in the Pascal code fragments.
 
        Now included in the X00 distribution is an object module that allows
        access to all X00 functions from Turbo Pascal.  That module is:
 
                TPX00.OBJ
 
        A single routine, TPX00, is defined, and is intended to be a direct
        replacement for the Turbo Pascal INTR function when used with
        interrupt 14h.  The only difference in the calling sequence is that
        the interrupt number is not passed as a parameter.
 
        To use this interfacing routine, the programmer basically sets
        variables in a structure that corresponds to the processor's
        registers and passes the structure address to TPX00.  When TPX00
        is invoked, it copies the variables in the structure to the
        processor's registers and then calls the installed FOSSIL.  Upon
        return from the FOSSIL, all of the processor's registers are
        copied into the output structure.  The input structure and output
        structure are the same.  That is, this structure is used as both
        input and output for register values passed to and returned from
        X00.
 
        For a more complete description of the Pascal structures and their
        uses,  read the documentation about the function INTR in the
        appropriate Turbo Pascal reference manual.  TPX00 may work with
        other Pascal compilers, but has only been tested with Borland's
        Turbo Pascal.
 
        The code fragments below are intended to provide examples of
        replacing INTR calls with TPX00 calls.
 
        My thanks to Bob Klahn and Chris Irwin for helping with
        documentation and testing the Turbo Pascal HLLAPI.

        CONST
          Buffer_Size = 1024;
 
        VAR
          Regs : REGISTERS;
          Input_Buffer : ARRAY [1..Buffer_Size] OF BYTE;
 
        PROCEDURE Bypass; EXTERNAL;           {for inline code, yet to be doc'd}
        PROCEDURE TPX00( VAR Regs : REGISTERS ); EXTERNAL;
        {$L TPX00}
 
        PROCEDURE FOSSIL_Stuff;
 
        BEGIN
          { Check for active FOSSIL }
          Regs.AH := $04;  Regs.BX := 0;  Regs.DX := $00FF;
          { INTR( $14, Regs ); is replaced with }
          TPX00( Regs );
          FOSSIL_Active := Regs.AX = $1954;
 
          IF FOSSIL_Active THEN
            BEGIN
              { Open FOSSIL port 0, COM1 }
              Regs.AH := $04;  Regs.BX := 0;  Regs.DX := $0000;
              { INTR( $14, Regs ); is replaced with }
              TPX00( Regs );
 
              { Do a block read from the FOSSIL input buffer for COM1 }
 
              Regs.AH := $18;                  { Block read func code }
              Regs.DI := OFS( Input_Buffer );  { Input buffer offset  to DI }
              Regs.ES := SEG( Input_Buffer );  { Input buffer segment to ES }
              Regs.CX := Buffer_Size;          { Max bytes to read to CX }
              Regs.DX := 0;                    { Data from COM1 }
              { INTR( $14, Regs ); is replaced with }
              TPX00( Regs );
 
      { Upon return, Regs.AX will contain the number of bytes that X00 }
      { placed into Input_Buffer. }
 
            END;
 
