UNIT OnLine;
{$X+,I-,F-,O-}

{ This unit contains the BackGround Online SysOp Commands }

INTERFACE

USES Dos,GenTypes,Crt,Mercury;

TYPE
  StatusLineArr=Array[1..160] of Byte;

CONST
  Line_1:StatusLineArr=(179,120,91,112,70,116,49,116,93,112,32,112,85,112,
  115,112,101,112,114,112,32,112,83,112,116,112,117,112,102,112,102,112,32,
  112,179,120,91,112,70,116,50,116,93,112,32,113,83,112,121,112,115,112,116,
  112,101,112,109,112,32,112,67,112,111,112,110,112,102,112,105,112,103,112,
  32,113,179,120,91,112,70,116,51,116,93,112,32,113,79,112,110,112,108,112,
  105,112,110,112,101,112,32,112,67,112,111,112,109,112,109,112,97,112,110,
  112,100,112,115,112,32,113,179,120,91,112,70,116,52,116,93,112,32,112,77,
  112,105,112,115,112,99,112,32,112,67,112,111,112,109,112,109,112,97,112,
  110,112,100,112,115,112,32,120,179,120);

  Line_2:StatusLineArr=(32,113,85,112,115,112,101,112,114,112,58,112,32,112,
  32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,113,32,
  113,32,113,32,113,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,
  32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,
  112,83,112,108,112,47,112,68,112,115,112,108,112,58,112,32,112,32,112,32,
  112,32,112,32,112,32,112,32,112,32,112,32,112,32,113,84,112,105,112,109,
  112,101,112,32,112,76,112,101,112,102,112,116,112,58,112,32,112,32,112,32,
  112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,
  32,113);

  Line_3:StatusLineArr=(32,113,85,112,115,112,101,112,114,112,32,112,104,112,
  97,112,115,112,32,112,116,112,121,112,112,112,101,112,100,112,58,112,32,
  113,32,113,32,113,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,
  32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,
  112,32,112,85,112,115,112,101,112,114,112,32,112,109,112,117,112,115,112,
  116,112,32,112,116,112,121,112,112,112,101,112,58,112,32,112,32,112,32,
  112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,
  32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,112,32,
  112,32,112,32,112);

{$I WINDOWS.INC}

PROCEDURE TimeUp;
PROCEDURE PopLines;
PROCEDURE FastWriteXY(X,Y:Byte; S:String);
PROCEDURE Window1;
PROCEDURE Window3;
FUNCTION SysOpWinOpen:Boolean;
PROCEDURE Win(B:Boolean);
PROCEDURE UpDateTop;
PROCEDURE ToggleWindows;
PROCEDURE UserInfo;
PROCEDURE TopHidden(S:String);
PROCEDURE PutUp(C:Char);

(*             Status
  --------------------------------------------------------------------------
    [0] [1] [2] [3] [4] [5] [6] [7]
     |   |   |   |   |   |   |   \----]
     |   |   |   |   |   |   \--------] 
     |   |   |   |   |   \------------]
     |   |   |   |   \----------------]
     |   |   |   \--------------------] On=SysOp Working; Off=Not
     |   |   \------------------------] On=User Data; Off=Hidden Input
     |   \----------------------------] On=User Info Available; Off=Not
     \--------------------------------] On=Window Open;  Off=Window Closed
*)

CONST Hidden:Boolean=False; Input:String='';

IMPLEMENTATION

TYPE SaveArr=Array[0..3999] of Byte;
VAR Screen:ScreenArr absolute $B800:0000;
    SaveScr:SaveArr;
    Ux,Uy:Byte;

PROCEDURE SaveScreen;
Begin
  Move(Screen,SaveScr,3999);
End;

PROCEDURE RestoreScreen;
Begin
  Move(SaveScr,Screen,3999);
End;

PROCEDURE FastWriteXY(X,Y:Byte; S:String);
CONST VioSeg:Word=$B800;
VAR Address:Word; I:Byte;
Begin
  Dec(X);
  Dec(Y);
  Address:=X*2+Y*160;
  For I:=1 to Length(S) do
    Begin
      If S[I] in [#0..#15] then TextColor(Ord(S[I])) else
      If S[I] in [#16..#31] then TextBackGround(Ord(S[I])-16) else
        Begin
          Mem[VioSeg:Address]:=Ord(S[I]);
          Inc(Address);
          Mem[VioSeg:Address]:=TextAttr;
          Inc(Address);
        End;
    End;
End;

PROCEDURE Win(B:Boolean);
Begin
  If B then Window(1,1,80,24) else Window(1,27,80,43);
End;

PROCEDURE Window1;
Begin
  If Not Bit(Status,0) then ToggleWindows;
  UnCrunch(Win_1,Screen[(17*2)+(29*160)-162],Win_1_Length);
End;

PROCEDURE Window3;
Begin
  If Not Bit(Status,0) then ToggleWindows;
  UnCrunch(Win_3,Screen[(1*2)+(27*160)-162],Win_3_Length);
End;

PROCEDURE PopLines;
VAR Color:Word;
Begin
  Color:=TextAttr;
  Move(Line_1,Screen[25*160],SizeOf(Line_1));
  Color:=TextAttr;
  Tb(7);
  If Not Bit(Status,1) then
    Begin
      Tc(4);
      FastWriteXY(1,43,' User Information not Available.'+Fill(' ',48));
      FastWriteXY(76,43,'mins');
      TimeUp;
      TextAttr:=Color;
      Exit;
    End;
  Tc(1);
  FastWriteXY(1,43,Fill(' ',80));
  FastWriteXY(2,43,'[ Alias ]:');
  FastWriteXY(32,43,'[ Note ]:');
  FastWriteXY(62,43,'[ Time ]:');
(*
  FastWriteXY(10,43,']:');
  FastWriteXY(39,43,']:');
  FastWriteXY(69,43,']:');
*)
  Tc(4);
(*
  FastWriteXY(4,43,'Alias');
  FastWriteXY(34,43,'Note');
  FastWriteXY(64,43,'Time');
*)
  FastWriteXY(76,43,'mins');
  TimeUp;
  TextAttr:=Color;
End;

PROCEDURE PassToProc(C:Char);
Begin
End;

FUNCTION SysOpWinOpen:Boolean;
{ Returns true if anything except status line and no status line are open,
  including scroll-back buffer! }
Begin
  SysOpWinOpen:=False;
End;

PROCEDURE UpDateTop;
VAR C:Char; X,Y:Byte; Color:Word;
Begin
  If Not Bit(Status,0) then Exit;
  X:=WhereX; Y:=WhereY;
  Win(False);
  Color:=TextAttr;
  TextAttr:=0;
  ClrScr;
  TextAttr:=Color;
  PopLines;
  UserInfo;
  Win(True);
  GotoXY(X,Y);
End;

PROCEDURE ToggleWindows;
VAR X,Y:Byte; Color:Word;
Begin
  SetBit(Status,0,Not Bit(Status,0));
  Sys.LastWin:=Not Sys.LastWin;
  If Not Bit(Status,0) then
    Begin
      X:=WhereX; Y:=WhereY;
      Color:=TextAttr;
      SaveScreen;
      TextMode(co80);
      RestoreScreen;
      TextAttr:=Color;
    End else
    Begin
      X:=WhereX; Y:=WhereY;
      Color:=TextAttr;
      SaveScreen;
      TextMode(258);
      Win(False);
      PopLines;
      UserInfo;
      Win(True);
      RestoreScreen;
      TextAttr:=Color;
    End;
  Window(1,1,80,24);
  GotoXY(X,Y);
End;

PROCEDURE UserInfo;
VAR Color,I,B:Word; S:String;
Begin
  If Not Bit(Status,1) then Exit;
  Color:=TextAttr;
  Tc(4);
  Tb(7);
  FastWriteXY(13,43,User.Alias);
  FastWriteXY(42,43,User.Note);
  TextAttr:=Color;
End;

PROCEDURE TopHidden(S:String);
VAR Color:Word;
Begin
  Color:=TextAttr;
  If Not Hidden then
    Begin
      Tc(1);
      Tb(7);
      FastWriteXY(1,43,Fill(' ',80));
      FastWriteXY(2,43,'[ User Typed ]:');
      FastWriteXY(46,43,'[ '+S+' ]');
      Ux:=18;
      Uy:=43;
    End;
  TextAttr:=Color;
End;

PROCEDURE PutUp(C:Char);
VAR Color:Word;
Begin
  If Not Bit(Status,0) then Exit;
  Color:=TextAttr;
  Tc(4);
  Tb(7);
  If C=#8 then Dec(Input[0]) else Input:=Input+C;
  If Not Bit(Status,0) then Begin TextAttr:=Color; Exit; End;
  If C=#8 then
    Begin
      Dec(Ux);
      FastWriteXY(Ux,Uy,#32);
    End else
    Begin
      FastWriteXY(Ux,Uy,C);
      Inc(Ux);
    End;
  TextAttr:=Color;
End;

PROCEDURE TimeUp;
VAR S:String; Color:Word;
Begin
  If Not Bit(Status,0) then Exit;
  Color:=TextAttr;
  If TimeLeft=0 then S:='  ' else
    Begin
      S:=Strr(TimeLeft);
      If Length(S)<3 then While Length(S)<3 do Insert(' ',S,1);
    End;
  Tc(4);
  Tb(7);
  FastWriteXY(72,43,S);
  TextAttr:=Color;
End;

End.
