UNIT MenuGen;
{$I-,X+}
{ Menu Routines for Calling Throughout OTERA }

INTERFACE

USES GenTypes,Files,Modem,Misc,Crt,Config,Dos,Swap,Messages;

TYPE Kstring=String[3];

PROCEDURE LoadStandard;
FUNCTION LoadMenuSet(B:Byte):Boolean;
FUNCTION InsertCommand(Loc:Byte):Boolean;
FUNCTION DeleteCommand(Loc:Byte):Boolean;
PROCEDURE CreateMenu;
PROCEDURE MenuPrompt;
PROCEDURE MenuInput;
PROCEDURE RunAutos;
FUNCTION RunMenu(S:String):Boolean;
FUNCTION RunData(Cmd:Byte; B:Boolean):Boolean;
FUNCTION RunCommand(Key:Kstring; Cmd:Byte):Boolean;
PROCEDURE HelpMenu;
PROCEDURE GenericMenu(N:Boolean);
FUNCTION LoadCommands(S:String):Boolean;
FUNCTION ReadCommands(S:String):Boolean;
FUNCTION SaveCommands(S:String):Boolean;
FUNCTION SaveMenu:Boolean;
FUNCTION LoadLibrary(I:Integer):Boolean;
FUNCTION SaveLibrary(I:Integer):Boolean;
FUNCTION DeleteLibrary(I:Integer):Boolean;
FUNCTION Libraries:Integer;

VAR LibF:File of LibraryRec;
    MenF:File of MenuRec;
    CmdF:File of CommandRec;
    MenuS:String;
    DataS:String;  { Unknown String in Data String }
    DataI:Integer; { Unknown Byte in Data String }
    MenuQuit:Boolean;
    Fcmd:Byte;
    Nor:Boolean;
    NoQuitMatrix:Boolean;
    CurrentBar:Byte;

CONST
    QuitLoop:Boolean=False;
    MustRun:Boolean=False;
    MustRunCmd:Byte=0;

IMPLEMENTATION

CONST Columns:Array[1..6] of Byte=(80,40,26,20,16,13);
      OldEmulation:Emulation_Set=Ansi;
      ScanCommand:Integer=0;
      OldBar:Boolean=False;
      Up:Boolean=(False);
      Down:Boolean=(False);
      Left:Boolean=(False);
      Right:Boolean=(False);

PROCEDURE QuitFromMenu; Forward;

PROCEDURE LoadStandard;
Begin
  MenuLib.Location:=Sys.MenuDir;
  MenuLib.Name:='Default Menus';
End;

PROCEDURE UserConfig;
VAR I,B:Integer; S:String;
Begin
  B:=Libraries;
  If B=0 then Exit;
  Println('Sorry, but no fancy config yet.  I haven''t had much time, even');
  Println('though it is Christmas Vacation to get much done.');
  For I:=1 to B do
    Begin
      LoadLibrary(I);
      Println(Strr(I)+':'+MenuLib.Name);
    End;
  Print('New Menu Library: '); Limit(S,3,0); Cr;
  LoadLibrary(User.MenuSet);
  If S='' then Exit;
  I:=Intt(S);
  If (I<1) or (I>B) then Exit;
  User.MenuSet:=I;
  If LoadLibrary(User.MenuSet) then RunMenu(DataS);
End;

FUNCTION LoadMenuSet(B:Byte):Boolean;
VAR I:Byte;
Begin
  LoadMenuSet:=False;
  If Libraries=0 then Exit;
  If Not LoadLibrary(B) then Exit;
  LoadMenuSet:=True;
End;

FUNCTION InsertCommand(Loc:Byte):Boolean;
VAR I:Byte;
Begin
  InsertCommand:=False;
  If (Menu.Commands=MaxMenuCmds) then Exit;
  If (Loc<1) or (Loc>Menu.Commands) then Exit;
  Inc(Menu.Commands);
  New(MenCmd[Menu.Commands]);
  I:=Loc;
  For I:=Menu.Commands downto Loc+1 do MenCmd[I]^:=MenCmd[I-1]^;
  InsertCommand:=True;
End;

FUNCTION DeleteCommand(Loc:Byte):Boolean;
VAR I:Byte;
Begin
  If (Menu.Commands=0) then Exit;
  If (Loc<1) or (Loc>Menu.Commands) then Exit;
  If Loc=Menu.Commands then
    Begin
      Dispose(MenCmd[Menu.Commands]);
      Dec(Menu.Commands);
    End else
    Begin
      For I:=Loc to Menu.Commands-1 do MenCmd[I]^:=MenCmd[I+1]^;
      Dispose(MenCmd[Menu.Commands]);
      Dec(Menu.Commands);
    End;
End;

PROCEDURE ClearMenu;
VAR I:Byte;
Begin
  If Menu.Commands<>0 then For I:=Menu.Commands downto 1 do Dispose(MenCmd[I]);
End;

FUNCTION Figure(S:String; Cmd:Byte):Boolean;
VAR B:Boolean; I:Byte; C:Char;
Begin
  Figure:=True;
  If S='' then Exit;
  If (S[1] in ['''','"','^']) and (S[Length(S)] in ['''','"','^']) then
    Begin
      Delete(S,1,1);
      Dec(S[0]);
      Tran(S);
    End else
  If (Upcase(S[1])='Y') and (UpCase(S[2])='N') and (S[3]='-') and (Length(S)=4) then
    Begin
      B:=UpCase(S[Length(S)])='Y';
      Figure:=YesNo(B,User.YesNoBar); SSC(1);
    End else
  If (Upcase(S[1])='O') and (Upcase(S[2])='N') and (S[3]='[') then
    Begin
    End else
  If (Upcase(S[1])='O') and (Upcase(S[2])='F') and (Upcase(S[3])='F') and (S[4]='[') then
    Begin
    End else
  If S='SF:R:Y' then User.Flag['R',1]:=True else
  If S='SF:R:N' then User.Flag['R',1]:=False else
  If (Upcase(S[1])='F') and (Upcase(S[5])='T') and (UpcasE(S[6])='O') then
    Begin
      Delete(S,1,7);
      Dec(S[0]); { FILLTO[X,C] is now X,C }
      C:=S[Length(S)];
      Dec(S[0],2);
      For I:=WhereX to Intt(S) do Print(C);
    End else
  If Pos('FORCECMD[',S)=1 then
    Begin
      Dec(S[0]);
      Delete(S,1,9);
      OldBar:=True;
      CurrentBar:=Intt(S);
    End else
  If (Upcase(S[1])='F') and (Upcase(S[3])='L') and (Upcase(S[4])='L') then
    Begin
      Delete(S,1,5);
      Dec(S[0]);
      C:=S[Length(S)];
      Dec(S[0],2);
      For I:=1 to Intt(S) do Print(C);
    End else
  If (S='CLS') then Cls Else
  If Intt(S)>0 then DataI:=DataI+Intt(S) else DataS:=DataS+S;
End;

FUNCTION RunData(Cmd:Byte; B:Boolean):Boolean;
VAR S,S1:String; I:Byte; Quit:Boolean;
Begin
  If B then DataI:=0;
  If B then DataS:='';
  RunData:=True;
  If Not B then S:=MenCmd[Cmd]^.AfterData else S:=MenCmd[Cmd]^.Data;
  If S='' then Exit;
  I:=1;
  Quit:=False;
  Nor:=False;
  Repeat
    S1:='';
    Repeat
      If S[I]<>';' then S1:=S1+S[I];
      Inc(I);
    Until (Logoff) or (S[I]=';') or (I>Length(S));
    If S1<>'' then Quit:=Not Figure(S1,Cmd);
  Until (Logoff) or (I>Length(S)) or (Quit);
  If Quit then RunData:=False else RunData:=True;
  Nor:=False;
End;

PROCEDURE MenuPrompt;
Begin
  Cr;
  SSC(1);
  Print('[ ');
  SSC(3); Tran(Menu.Area);
  SSC(1); Print(' ] [ ');
  SSC(3); Print('?');
  SSC(1); Print('/');
  SSC(3); Print('Help');
  SSC(1); Print(' ]: ');
  SSC(0);
End;

PROCEDURE FindCommand;
VAR I:Byte; Try:Boolean;
Begin
  Try:=True;
  If (Menu.Commands=0) then
    Begin
      If Upper(MenuS)='GOODBYE' then QuickLogoff:=True;
      If Not Logoff then
        Begin
          SSC(4);
          Println(#13'No Commands Exist! [GOODBYE] to Logoff!');
        End;
      Exit;
    End;
  I:=1;
  Repeat
    If Upper(MenuS)=Upper(MenCmd[I]^.Input) then
      Begin
        RunCommand(MenCmd[I]^.Key,I);
        Try:=False;
      End;
    Inc(I);
  Until (Logoff) or (I>=Menu.Commands+1);
  If ((Try) and (MenuS<>'^M')) and (Menu.ErrStr<>'') then Tran(Menu.ErrStr);
End;

PROCEDURE RunLoopers;
VAR I:Byte;
Begin
  For I:=1 to Menu.Commands do
    If MenCmd[I]^.EveryCommand then RunCommand(MenCmd[I]^.Key,I);
End;

PROCEDURE GetOn(S:String; B:Byte);
VAR I:Byte; S1:String;
Begin
  S1:='';
  Repeat
    S1:=S1+S[B];
    Inc(B);
  Until (B>Length(S)) or (Logoff) or (S[B]=';');
  Delete(S1,1,3);
  Dec(S1[0]);
  CmdOnStr[Bars+1]:=S1;
End;

PROCEDURE GetOff(S:String; B:Byte);
VAR I:Byte; S1:String;
Begin
  S1:='';
  Repeat
    S1:=S1+S[B];
    Inc(B);
  Until (B>Length(S)) or (Logoff) or (S[B]=';');
  Delete(S1,1,4);
  Dec(S1[0]);
  CmdOffStr[Bars+1]:=S1;
End;

PROCEDURE DrawAll;
VAR I:Byte;
Begin
  If Bars=0 then Exit;
  If Menu.DrawCmds then
  For I:=1 to Bars do
    Begin
      GoXY(MenCmd[CmdBar[I]]^.pX,MenCmd[CmdBar[I]]^.pY);
      If I=CurrentBar then Tran(CmdOnStr[I]) else Tran(CmdOffStr[I]);
    End else
    Begin
      GoXY(MenCmd[CmdBar[CurrentBar]]^.pX,MenCmd[CmdBar[CurrentBar]]^.pY);
      Tran(CmdOnSTr[CurrentBar]);
    End;
End;

PROCEDURE CreateMenu;
VAR I,B:Byte; S,S1:String;
Begin
  Bars:=0;
  If OldBar then OldBar:=False else CurrentBar:=1;
  For I:=1 to Menu.Commands do
    Begin
      S:=MenCmd[I]^.Data;
      B:=Pos('ON[',Upper(S));
      If B>0 then
        Begin
          GetOn(S,B);
          B:=Pos('OFF[',Upper(S));
          If B>0 then
            Begin
              GetOff(S,B);
              Inc(Bars);
              CmdBar[Bars]:=I;
            End;
        End;
    End;
End;

PROCEDURE GetNextInput;
VAR C:Char; S,S1:String; I,II:Byte; B,B2,B3:Boolean; N:String[3];

PROCEDURE Forward;
Begin
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOffStr[CurrentBar]);
  If CurrentBar>=Bars then CurrentBar:=1 else Inc(CurrentBar);
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOnStr[CurrentBar]);
End;

PROCEDURE Backward;
Begin
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOffStr[CurrentBar]);
  If CurrentBar<=1 then CurrentBar:=Bars else Dec(CurrentBar);
  GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
  Tran(CmdOnStr[CurrentBar]);
End;

PROCEDURE RunCmd(B:Byte);
Begin
  S:=MenCmd[B]^.Input;
  S1:=MenCmd[B]^.Key;
  RunCommand(MenCmd[B]^.Key,CmdBar[B]);
  I:=B+1;
  B2:=False;
  If Not ((S1='GTM') or (S1='FQM') or (S1='FGM') or (S='')) then
  Repeat
    If (Upper(MenCmd[I]^.Input)=Upper(S)) then
      Begin
        RunCommand(MenCmd[I]^.Key,I);
        N:=MenCmd[I]^.key;
        B2:=((N='GTM') or (N='FQM') or (N='FGM'));
      End;
    Inc(I);
  Until (B2) or (I>Menu.Commands) or (Logoff) or (MustRun);
End;

LABEL Die;
Begin
  C:=^M;
  Repeat
    If (C=^M) and (Not MustRun) then
      Begin
        RunLoopers;
        DrawAll;
      End;
    If MustRun then
      Begin
        MustRun:=False;
        RunCmd(MustRunCmd);
      End;
    If Not MenuQuit then C:=Getkey;
    If (C=#32) then Forward else
    If (C=#8) then Backward else
    If (C=#0) and (NextGK) then
      Begin
        C:=Getkey;
        Case C of
          #72:S1:='^U';
          #80:S1:='^D';
          #77:S1:='^R';
          #75:S1:='^L';
        End;
        I:=1;
        B:=False;
        B2:=False;
        Repeat
          If Upper(MenCmd[I]^.Input)=S1 then
            Begin
              S:=Upper(MenCmd[I]^.Key);
              If (S='GTM') or (S='FQM') or (S='FGM') then B2:=True;
              RunCommand(MenCmd[I]^.Key,I);
              B:=True;
            End;
          Inc(I);
        Until (I>Menu.Commands) or (Logoff) or (B2) or (MustRun);
        If Not B then
          Begin
            Case C of
              #72:BackWard;
              #80:Forward;
              #77:Forward;
              #75:Backward;
            End;
          End else C:=^M;
      End else
    If (C=#27) and (Not ChWait) then
      Begin
        I:=1;
        Repeat
          If MenCmd[I]^.Input='^<' then
            Begin
              RunCommand(MenCmd[I]^.Key,I);
              C:=^M;
            End;
          Inc(I);
        Until (I>Menu.Commands) or (Logoff) or (MustRun);
      End else
    If (C=#27) and (ChWait) then
      Begin
        S:='';
        Repeat
          S:=S+Getkey;
        Until (S[Length(S)] in ['A'..'Z','a'..'z']) or (Not ChWait);
        If S='[[B' then S1:='^U';
        If S='[[A' then S1:='^D';
        If S='[[C' then S1:='^L';
        If S='[[D' then S1:='^R';
        I:=1;
        B:=False;
        B2:=False;
        Repeat
          If Upper(MenCmd[I]^.Input)=S1 then
            Begin
              N:=MenCmd[I]^.Key;
              If (N='FQM') or (N='FGM') or (N='GTM') then B2:=True;
              RunCommand(MenCmd[I]^.Key,I);
              B:=True;
            End;
          Inc(I);
        Until (I>Menu.Commands) or (Logoff) or (B2) or (MustRun);
        If Not B then
          Begin
            If S='[[B' then BackWard;
            If S='[[A' then Forward;
            If S='[[C' then Backward;
            If S='[[D' then Forward;
          End else C:=^M;
      End else
    If (C=^M) then
      Begin
        S:=MenCmd[CmdBar[CurrentBar]]^.Input;
        S1:=MenCmd[CmdBar[CurrentBar]]^.Key;
        RunCommand(MenCmd[CmdBar[CurrentBar]]^.Key,CmdBar[CurrentBar]);
        I:=1;
        B2:=False;
        If Not ((S1='GTM') or (S1='FQM') or (S1='FGM') or (S='')) then
        Repeat
          If (Upper(MenCmd[I]^.Input)=Upper(S)) and (CmdBar[CurrentBar]<>I) then
            Begin
              RunCommand(MenCmd[I]^.Key,I);
              N:=MenCmd[I]^.key;
              B2:=((N='GTM') or (N='FQM') or (N='FGM'));
            End;
          Inc(I);
        Until (B2) or (I>Menu.Commands) or (Logoff) or (MustRun);
      End else
    If C in [#33..#255] then
      Begin
        I:=1;
        B3:=False;
        Repeat
          If Upper(MenCmd[CmdBar[I]]^.Input)=Upper(C) then
            Begin
              GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
              Tran(CmdOffStr[CurrentBar]);
              CurrentBar:=I;
              GoXY(MenCmd[CmdBar[CurrentBar]]^.Px,MenCmd[CmdBar[CurrentBar]]^.Py);
              Tran(CmdOnStr[CurrentBar]);
              B3:=True;
            End;
          Inc(I);
        Until (I>Bars) or (Logoff) or (B3) or (MustRun);
      End;
  Until (Logoff) or (Not Menu.PullDown) or (MenuQuit);
End;

PROCEDURE RunPullDowns;
Begin
  Repeat
    If Menu.PullDown then GetNextInput;
  Until (MenuQuit) or (Logoff) or (Not Menu.Pulldown);
End;

PROCEDURE MenuInput;
Begin
  Repeat
    If Menu.PullDown then RunPullDowns else
      Begin
        RunLoopers;
        If Menu.Prompt then MenuPrompt;
        Limit(MenuS,64,0);
        If (Menu.Return) and (MenuS<>'') then Cr;
        If MenuS='' then MenuS:='^M';
        FindCommand;
      End;
  Until (MenuQuit) or (Logoff);
End;

PROCEDURE GetInput;
VAR C:Char;
Begin
  If Not Menu.PullDown then
    Begin
      If Menu.Prompt then MenuPrompt;
      If (Menu.HotKey) or (User.HotKeys) then GetHotKey else Limit(MenuS,64,0);
      If (Menu.Return) and (MenuS<>'') and (Not Menu.PullDown) then Cr;
    End else
    Begin
      C:=GetKey;
      If (C=#27) and (Not ChWait) then Esc:=True else
      If (C=#27) and (ChWait) then
        Begin
          MenuS:='';
          Repeat
            MenuS:=MenuS+Getkey;
          Until (Logoff) or (MenuS[Length(MenuS)] in ['A'..'Z','a'..'z']);
          If (MenuS='[[A') or (MenuS='[A') then Up:=True;
          If (MenuS='[[B') or (MenuS='[B') then Down:=True;
          If (MenuS='[[C') or (MenuS='[C') then Right:=True;
          If (MenuS='[[D') or (MenuS='[D') then Left:=True;
        End else
      If (C=#0) and (ChWait) then
        Begin
        End else MenuS:=C;
    End;
End;
PROCEDURE TheBBS;
Begin
  LoadFirstMenu;
  Repeat
    RunLoopers;
    GetInut;
    FindCommand;
  Until (MenuQuit) or (Logoff);
End;

PROCEDURE RunAutos;
VAR I:Byte; 
Begin
  If Menu.Commands=0 then Exit;
  QuitLoop:=False;
  I:=1;
  Repeat
    If (Not QuitLoop) and (MenCmd[I]^.Key='MSM') and (MenCmd[I]^.AutoRun) then
      Begin
        RunCommand(MenCmd[I]^.Key,I);
        RunCommand(MenCmd[ScanCommand]^.Key,ScanCommand);
      End else
    If MenCmd[I]^.AutoRun then RunCommand(MenCmd[I]^.Key,I);
    If (MenCmd[I]^.Key='MLP') and (Not QuitLoop) then
      Begin
        If NextArea then I:=DataI-1;
      End;
    Inc(I);
  Until (I>Menu.Commands) or (Logoff);
End;

FUNCTION RunMenu(S:String):Boolean;
VAR B:Boolean;
Begin
  ClearMenu;
  B:=ReadCommands(S);
  RunMenu:=B;
  If B then UpdateOnLine(S+' Menu');
  If (B) and (Menu.PullDown) then CreateMenu;
  If B then RunAutos;
End;

FUNCTION OnOff(S:String):Boolean;
Begin
  OnOff:=Upper(S)='ON';
End;

PROCEDURE RunMessageStuff(Key:Kstring);
Begin
  If Key='MSM' then ScanCommand:=Scan4Msgs(DataS);
  If Key='MPM' then PostMessage;
  If Key='MNM' then
    Begin
      If Not NextMessage then
        Begin
          If DataI=0 then RunAutos else MustRunCmd:=DataI;
          MustRun:=True;
        End;
    End;
  If Key='MPM' then PreviousMessage;
  If Key='MNS' then
    Begin
      CurrentMessage:=FirstMessage;
      If (CurrentMessage=0) then
        Begin
          If DataI=0 then RunAutos else MustRunCmd:=DataI;
          MustRun:=True;
        End else LoadFirstMessage;
    End;
  If Key='MSM' then ShowMessage;
  If Key='MNA' then NextBase;
  If Key='MPA' then PreviousBase;
  If Key='MFA' then
    Begin
      LoadFirstBase;
      If BasePos=0 then QuitFromMenu;  {-- No bases! Can't Newscan! --}
    End;
End;

PROCEDURE RunUserStuff(Key:Kstring);
Begin
End;

PROCEDURE RunSystemStuff(Key:Kstring);
Begin
  If (Key='SSC') and
     ((Upper(User.Alias)='DARKENED ENMITY')  or
     (Upper(User.Alias)='THE FLY') or
     (Upper(User.Alias)='MERCURY') or
     (Upper(User.Alias)='LORD TRACER')) then SystemConfig;
End;

PROCEDURE UpdateBBS;
CONST FileName:String='OTERA.ZIP';
VAR C:Char; F:File;

PROCEDURE Refresh;
Begin
  Show('UPDATE',True,False);
  GoXY(18,2);
  Print(FileName);
End;

PROCEDURE Shell(S:String);
Begin
  If DiskFree(0) div 1024 > 640 then
  ExecPrg(GetEnv('COMSPEC')+' /C '+S) else
  Begin
    SwapVectors;
    Exec(GetEnv('COMSPEC'),'/C '+S);
    SwapVectors;
  End;
End;

Begin
  Refresh;
  Repeat
    GotoXY(44,10); Print(#32#8);
    Repeat
      C:=Upcase(Getkey);
    Until (Logoff) or (C in ['F','P','I','U','1'..'5','R','Q']);
    If C in [#33..#255] then Print(C);
    If C='R' then Refresh;
    If C='U' then
      Begin
        GotoXY(1,24);
        Shell('DSZ port '+Strr(Sys.ComPort)+' speed 2400 rz -rr ');
        Refresh;
      End;
    If C='F' then
      Begin
        GoXY(18,2);
        Print('            ');
        GoXY(18,2);
        Limit(FileName,12,2);
      End;
    If C='1' then Shell('PKUNZIP -o '+FileName+' '+Sys.WorkDir+' > NUL');
    If C='2' then Shell('PKUNZIP -o '+Sys.WorkDir+'\ANSI.ZIP '+Sys.AnsiDir+' > NUL');
    If C='3' then Shell('PKUNZIP -o '+Sys.WorkDir+'\MENUS.ZIP -D > NUL');
    If C='4' then Shell('PKUNZIP -o '+Sys.WorkDir+'\DATA.ZIP '+Sys.DataDir+' > NUL');
    If C='5' then
      Begin
        EraseDir(Sys.WorkDir);
        Assign(F,FileName);
        Erase(F);
      End;
    If C='P' then Shell('UPDATE > NUL');
    If C='I' then Shell('INSTALL > NUL');
  Until (Logoff) or (C='Q');
  Cls;
End;

PROCEDURE LoadNextMenu;
VAR P:Pointer;
Begin
  P:=Nil;
  If NestedMenus=0 then New(MenuSav) else
    Begin
      P:=MenuSav;
      New(MenuSav^.Next);
      MenuSav:=MenuSav^.Next;
    End;
  Inc(NestedMenus);
  MenuSav^.Previous:=P;
  MenuSav^.Next:=Nil;
  MenuSav^.CurrentCmd:=CurrentBar;
  MenuSav^.Name:=Menu.Name;
  RunMenu(DataS);
End;

PROCEDURE QuitFromMenu;
VAR S:String; P:Pointer;
Begin
  If NestedMenus=0 then
    Begin
      Println('Dropping to Fallback Menu!');
      RunMenu(Sys.FallBackMenu);
      Exit;
    End;

  CurrentBar:=MenuSav^.CurrentCmd;
  S:=MenuSav^.Name;

  If NestedMenus=1 then
    Begin
      Dispose(MenuSav);
      Dec(NestedMenus);
    End else
    Begin
      P:=MenuSav^.Previous;
      Dispose(MenuSav);
      MenuSav:=P;
      Dec(NestedMenus);
    End;
  OldBar:=True;
  RunMenu(S);
End;

PROCEDURE RunFunctions(Key:Kstring);
Begin
  If Key='FFH' then User.HotKeys:=OnOff(DataS) else
  If Key='FMS' then
    Begin
      QuitLoop:=True;
    If LoadLibrary(DataI) then User.MenuSet:=DataI else
      Begin
        SSC(4);
        Println('Error Loading Menu Set! Inform SysOp!');
      End;
     End else
  If Key='FSF' then Show(DataS,False,False) else
  If Key='FGM' then LoadNextMenu else
  If Key='FQM' then QuitFromMenu else
  If Key='FPS' then Pause else
  If Key='FAA' then
    Begin
      Apply;
      Runautos;
    End;
  If Key='FLB' then
    If Enter(1)<>0 then
      Begin
        MenuQuit:=True;
        NoQuitMatrix:=True;
      End else RunAutos;
  If Key='FNE' then { Force NO emulation }
    Begin
      OldEmulation:=Emulation;
      Emulation:=Ascii;
    End;
  If Key='FRE' then Emulation:=OldEmulation; { Restore OLD emulation }
(*If Key='FFC' then User.Caps:=OnOff(DataS);*)
End;

FUNCTION RunCommand(Key:Kstring; Cmd:Byte):Boolean;
Begin
  RunCommand:=False;
  If Not CheckAccess(MenCmd[Cmd]^.Access) then Exit;
  RunCommand:=True;
  If Not RunData(Cmd,True) then Exit;

  If Key[1]='F' then RunFunctions(Key);
  If Key[1]='M' then RunMessageStuff(Key);
  If Key[1]='U' then RunUserStuff(Key);
  If Key[1]='S' then RunSystemStuff(Key);

  If Key='GMS' then GenericMenu(Menu.Clear);
  If Key='BYE' then MenuQuit:=True;
  If Key='HLP' then HelpMenu;
  If Key='CLS' then Cls;
  If Key='NLU' then UsersOnLine(DataS);
  If Key='TWL' then TheWall;
  If Key='CFG' then
    Begin
      QuitLoop:=True;
      UserConfig;
    End;
  If Key='UPD' then UpdateBBS;

  If (Key='GTM') and (DataS<>'') then
    Begin
      QuitLoop:=True;
      If Not RunMenu(DataS) then
        Begin
          USC(4);
          Println('Menu not found! Dropping to Fallback Menu!');
          ReadCommands(Sys.FallBackMenu);
          RunAutos;
        End;
    End;

  If (Key<>'GTM') and (Key<>'#ME') and (Key<>'CFG') and
     (Key<>'FGM') and (Key<>'FQM') then RunData(Cmd,False);
End;

PROCEDURE HelpMenu;
Begin
  If Menu.Clear then Cls;
  If Not Show(Menu.Ansifile,False,True) then GenericMenu(False);
End;

PROCEDURE GenericMenu(N:Boolean);
VAR I,B,Z:Byte;
Begin
  If N then Cls;
  If Menu.Commands=0 then
    Begin
      SSC(4);
      Println('Warning: No Commands in Menu! [G] to Logoff.');
      Cr;
      Exit;
    End;
  SSC(3);
  For Z:=1 to 3 do
    If Menu.Title[Z]<>'' then
      Begin
        If Menu.MidTitle then
          Begin
            For B:=1 to (80-TranLen(Menu.Title[Z])) div 2 do Print(#32);
            Tran(Menu.Title[Z]); Cr;
          End else
          Begin
            Tran(Menu.Title[Z]); Cr;
          End;
      End;
  B:=1;
  For I:=1 to Menu.Commands do
    If Not MenCmd[I]^.Hidden then
      Begin
        LenTran(MenCmd[I]^.Command,Columns[Menu.Columns]);
        If B=Menu.Columns then
          Begin
            B:=1;
            Cr;
          End else
          Begin
            For Z:=WhereX to Columns[Menu.Columns] * B do Print(#32);
            Inc(B);
          End;
      End;
  If B<>1 then Cr;
End;

FUNCTION LoadCommands(S:String):Boolean;
VAR I:Integer;
LABEL Finish,OtherFinish;
Begin
  LoadCommands:=False;
  GetSem(S+'.SDT');
  Menu.Commands:=0;
  Assign(MenF,S+'.DAT');
  Reset(MenF);
  If IOresult<>0 then Goto Finish;
  Read(MenF,Menu);
  If IOresult<>0 then Goto Finish;
  LoadCommands:=True;  { If error, menu should have no commands! }

  GetSem(S+'.SLS');
  Assign(CmdF,S+'.LST');
  Reset(CmdF);
  If IOresult<>0 then Goto OtherFinish;
  If FileSize(CmdF)=0 then Goto OtherFinish;
  I:=1;
  Repeat
    New(MenCmd[I]);
    Seek(CmdF,I-1);
    Read(CmdF,MenCmd[I]^);
    Inc(I);
  Until (I=FileSize(CmdF)+1) or (Logoff);
  Menu.Commands:=I-1;
  ReleaseSem(S+'.SLS');

  Finish:
  ReleaseSem(S+'.SDT');
  Close(CmdF);
  Close(MenF);
  I:=IOresult;
  Exit;
  OtherFinish:
  Menu.Commands:=0;
  ReleaseSem(S+'.SDT');
  ReleaseSem(S+'.SLS');
  Close(MenF);
  Close(CmdF);
  I:=IOresult;
End;

FUNCTION ReadCommands(S:String):Boolean;
Begin
  ReadCommands:=True;
  If Not LoadCommands(MenuLib.Location+'\'+S) then
    If Not LoadCommands(Sys.MenuDir+'\'+S) then ReadCommands:=False;
End;

FUNCTION SaveCommands(S:String):Boolean;
VAR I:Byte;
Begin
  SaveMenu;
  GetSem(MenuLib.Location+'\'+S+'.SLS');
  {-- C:\OTERA\MENUS **SHOULD** be in memory as Library.Location! --}
  Assign(CmdF,MenuLib.Location+'\'+S+'.LST');
  If Menu.Commands=0 then
    Begin
      Erase(CmdF);
      ReleaseSem(MenuLib.Location+'\'+S+'.SLS');
      Exit;
    End;
  Reset(CmdF);
  If IOresult<>0 then Rewrite(CmdF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\'+S+'.SLS');
      Exit;
    End;
  For I:=1 to Menu.Commands do
    Begin
      Seek(CmdF,I-1);
      If IOresult<>0 then
        Begin
          ReleaseSem(MenuLib.Location+'\'+S+'.SLS');
          Exit;
        End;
      Write(CmdF,MenCmd[I]^);
      If IOresult<>0 then
        Begin
          ReleaseSem(MenuLib.Location+'\'+S+'.SLS');
          Exit;
        End;
      Dispose(MenCmd[I]);
    End;
  Truncate(CmdF);
  Close(CmdF);
  ReleaseSem(MenuLib.Location+'\'+S+'.SLS');
End;

FUNCTION SaveMenu:Boolean;
Begin
  GetSem(MenuLib.Location+'\'+Menu.Name+'.SDT');
  SaveMenu:=False;
  Assign(MenF,MenuLib.Location+'\'+Menu.Name+'.DAT');
  Rewrite(MenF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\'+Menu.Name+'.SDT');
      Exit;
    End;
  Write(MenF,Menu);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\'+Menu.Name+'.SDT');
      Exit;
    End;
  Close(MenF);
  SaveMenu:=True;
  ReleaseSem(MenuLib.Location+'\'+Menu.Name+'.SDT');
End;

FUNCTION LoadLibrary(I:Integer):Boolean;
Begin
  GetSem(Sys.DataDir+'\MENUS.SEM');
  LoadLibrary:=False;
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Seek(LibF,I-1);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Read(LibF,MenuLib);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Close(LibF);
  LoadLibrary:=True;
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

FUNCTION SaveLibrary(I:Integer):Boolean;
Begin
  GetSem(Sys.DataDir+'\MENUS.SEM');
  SaveLibrary:=False;
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Seek(LibF,I-1);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Write(LibF,MenuLib);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Close(LibF);
  SaveLibrary:=True;
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

FUNCTION DeleteLibrary(I:Integer):Boolean;
VAR B:Integer;
Begin
  GetSem(Sys.DataDir+'\MENUS.SEM');
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult=0 then
    Begin
      For B:=I-1 to FileSize(LibF)-2 do
        Begin
          Seek(LibF,B+1);
          Read(LibF,MenuLib);
          Seek(LibF,B);
          Write(LibF,MenuLib);
          Truncate(LibF);
          Close(LibF);
        End;
    End;
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

FUNCTION Libraries:Integer;
Begin
  GetSem(Sys.DataDir+'\MENUS.SEM');
  Libraries:=0;
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib.Location+'\MENUS.SEM');
      Exit;
    End;
  Libraries:=FileSize(LibF);
  Close(LibF);
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

End.
