UNIT Messages;
{$X+,F+,O+,I-}

(* If you have this source code, (don't know how you got it) and if you
   don't know what this Unit is for, your screwed!  Go program something
   different! *)

INTERFACE

USES Dos,Crt,Files,Modem,Mercury,Configu,Editors,PckdTime,
     BcShare,Fossil,Menu2,Misc,Gentypes,Users;

PROCEDURE GenericNewScan;
FUNCTION GenericRead:Boolean;
PROCEDURE ShowMessage;
FUNCTION Scan4Mail(VAR ToUser,FromUser:Word):Boolean;
PROCEDURE SendMail;
FUNCTION NextMessage(Read:ReadType):Boolean;
PROCEDURE ListTitles;
FUNCTION PreviousMessage:Boolean;
FUNCTION ToggleDelete:Boolean;
FUNCTION GotoMessage(I:Integer):Boolean;
{ ^^ Sets it to Date of Last Message Read!! ^^ }
PROCEDURE LoadFirstBase;
FUNCTION NextBase:Boolean;
FUNCTION PreviousBase:Boolean;
PROCEDURE ReplyToMessage;
PROCEDURE PostMessage;
FUNCTION WriteMessage:Boolean;
FUNCTION AppendMessage:Boolean;
FUNCTION LoadBase(I:Word; VAR Base:BaseRec):Boolean;
FUNCTION SaveBase(I:Word; Base:BaseRec):Boolean;
FUNCTION Bases:Integer;
PROCEDURE EditBases;
FUNCTION SelectRead:ReadType;

CONST NextArea:Boolean=True;

IMPLEMENTATION

PROCEDURE ReplyData;
Begin
  New(ReplyHeader);
  ReplyHeader^:=Header^;
  Reply:=True;
End;

PROCEDURE ClearReply;
Begin
  Reply:=False;
  Dispose(ReplyHeader);
End;

FUNCTION GenericRead:Boolean;
Begin
End;

PROCEDURE GenericNewScan;
Begin
End;

PROCEDURE ShowMessage;
VAR I:Integer; Y:Byte;
Begin
  If NoMsgs then Exit;
  If MessageNum=0 then Exit;
  Y:=1;
  I:=1;
  Top:=TopPtr;
  SSC(7);
  SavePointer;
  If Bit(Header^.Status,4) then
    Begin
      USC(4);
      Println('Message Deleted!');
      Exit;
    End;
  Repeat
    If Top^.Text[1] in ['>','',':'] then
      Begin
        SSC(6);
        Tran(Top^.Text);
        Cr;
        SSC(7);
      End else
      Begin
       Tran(Top^.Text);
       Cr;
      End;
    If Y=24 then
      Begin
        Y:=1;
        If User.Pause then
          Begin
            Tran(Strings^.Pause);
            Getkey;
          End;
      End else Inc(Y);
    NextLine;
    Inc(I);
  Until (I>Deep) or (Logoff) or (ChWait);
  If ChWait then Getkey;
End;

FUNCTION GotoMessage(I:Integer):Boolean;
VAR B:Boolean;
Begin
  Repeat Until IOresult=0;
  GotoMessage:=True;
  If Firstmsg then
    Begin
      LoadFirstMessage;
      FirstMsg:=False;
    End;
  SavePointer;
  If GenRead=Next then
    Begin
      GotoMessage:=ReadMessage(I,True);
      CurrentMessage:=I-1;
      MessageNum:=I;
      Exit;
    End;
  If I=MessageNum then Exit;
  If I>MessageNum then
    Begin
      Repeat
        B:=NextMessage(NotDeleted);
      Until (MessageNum=I) or (Logoff) or (Not B) or (MessageNum=1);
    End else
    Begin
      Repeat
        B:=PreviousMessage;
      Until (MessageNum=I) or (Logoff) or (Not B) or (MessageNum>TotalMessages);
    End;
  If (B) and (MessageNum=I) then
    Begin
      GotoMessage:=True;
      Dec(Header^.Code);
      SavePointer;
      Inc(Header^.Code);
    End else GotoMessage:=False;
  Repeat Until IOresult=0;
End;

FUNCTION WriteHeader:Boolean;
Begin
  Repeat Until IOResult=0;
  Repeat
    BlockWrite(HdrFile,Header^,SizeOf(Header^));
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  Repeat Until IOresult=0;
  WriteHeader:=(Ignore=0);
End;

FUNCTION WriteMessage:Boolean;
VAR I:Integer;
Begin
  Top:=TopPtr;
  I:=1;
  Repeat
    Seek(MsgFile,(Header^.Start+I-1)*81);
    Repeat
      BlockWrite(MsgFile,Top^.Text,81);
      Ignore:=IOresult;
      If Ignore=5 then Delay(300);
    Until Ignore<>5;
    NextLine;
    Inc(I);
  Until (I>Header^.Lines) or (Ignore<>0);
  WriteMessage:=(Ignore=0);
End;

FUNCTION AppendMessage:Boolean;
VAR Bah:Boolean;
LABEL Done;
Begin
  Repeat Until IOresult=0;
  AppendMessage:=False;

  {* What should Code be set to? *}

  CloseFile;
  If Not Open(WriteDenyNone) then Goto Done;
  Seek(HdrFile,FileSize(HdrFile));
  Seek(MsgFile,FileSize(MsgFile));
  Header^.Start:=FileSize(MsgFile) div 81;
  Bah:=WriteMessage;
  If Not WriteHeader then Bah:=False;
  CloseFile;
  Open(ReadDenyNone);
  AppendMessage:=Bah;
  If Not NoMsgs then
    Begin
      ReadMessage(CurrentMessage+1,True);
      If Bah then Inc(TotalMessages);
    End;
  Done:
  Repeat Until IOresult=0;
End;

FUNCTION NextMessage(Read:ReadType):Boolean;
VAR OldHeader:HeaderPtr; Quit,B:Boolean; Old:Word; ThreadS:String;

FUNCTION NextGood:Boolean;
Begin
  NextGood:=False;
  If Not B then Exit;
  Case Read of
    Next        :NextGood:=True;
    NotDeleted  :NextGood:=(Not Bit(Header^.Status,4));
    MailTo      :NextGood:=(Upper(Header^.SentTo)=Upper(User.Alias)) and Email;
    MailFrom    :NextGood:=(Upper(Header^.From)=Upper(User.Alias)) and Email;
    Thread      :NextGood:=Upper(Header^.Title)=Upper(ThreadS);
    ToUser      :NextGood:=Upper(Header^.SentTo)=Upper(User.Alias);
    FromUser    :NextGood:=Upper(Header^.From)=Upper(User.Alias);
    Date        :NextGood:=SameDay(Header^.Sent,SearchDate);
    UserSentFrom:NextGood:=Upper(Header^.From)=Upper(SearchS);
    UserSentTo  :NextGood:=Upper(Header^.SentTo)=Upper(SearchS);
  End;
End;

PROCEDURE IncMessageNum;
Begin
  If Not B then Exit;
  If (Sys.CompressNums) and (Bit(Header^.Status,4)) then Exit;
  If Read in [MailTo,MailFrom] then Exit;
  Inc(MessageNum);
End;

Begin
  Repeat Until IOresult=0;
  NextMessage:=False;
  SavePointer;
  If FirstMsg then
    Begin
      LoadFirstMessage;
      NextMessage:=True;
      Exit;
    End;
  New(OldHeader);
  OldHeader^:=Header^;
  ThreadS:=Header^.Title;
  Old:=CurrentMessage;
  Repeat
    Inc(CurrentMessage);
    Writeln('Current Message=',CurrentMessage);
    Writeln('FilePos=',FilePos(HdrFile) div SizeOf(HeaderRec));
    Seek(HdrFile,CurrentMessage*SizeOf(HeaderRec));
    B:=ReadHeader(Header);
    Quit:=NextGood;
    If Not Quit then IncMessageNum;
  Until (Not B) or (Quit) or (Logoff);
  If (B) and (Quit) then
    Begin
      Inc(MessageNum);
      NextMessage:=ReadMessage(CurrentMessage+1,False);
    End else
    Begin
      CurrentMessage:=Old;
      Header^:=OldHeader^;
    End;
  Dispose(OldHeader);
  Repeat Until IOresult=0;
End;

FUNCTION SetEmail:Boolean;
Begin
  SetEmail:=LoadBase(1,Base);
End;

FUNCTION Scan4Mail(VAR ToUser,FromUser:Word):Boolean;
Begin
  Scan4Mail:=SetEmail;
End;

PROCEDURE SendMail;
Begin
  Email:=True;
  PostMessage;
  Email:=False;
End;

FUNCTION ToggleDelete:Boolean;
LABEL Done;
Begin
  Repeat Until IOresult=0;
  ToggleDelete:=False;
  If Not ((Upper(User.Alias)=Upper(Base.Sponsor)) or
     (User.Sl>199) or (Upper(User.Alias)=Upper(Header^.From))) then
     Exit;
  CloseFile;
  If Not Open(WriteDenyNone) then Goto Done;
  Seek(HdrFile,CurrentMessage*SizeOf(HeaderRec));
  SetBit(Header^.Status,4,Not Bit(Header^.Status,4));
  ToggleDelete:=WriteHeader;
  Done:
  CloseFile;
  Open(ReadDenyNone);
  Repeat Until IOresult=0;
End;

FUNCTION UlMessage(B:Boolean):Boolean;
Begin
End;

FUNCTION Send:Boolean;
VAR S:String; Urt:UserExistRec;
Begin
  Send:=False;
  USC(1);
  Tran(Strings^.Destination);
  If Not Reply then Limit(S,30,0);
  If Reply then
    Begin
      S:=ReplyHeader^.From;
      Print(S);
    End;
  If (Email) and (S<>'') then
    Begin
      If Not UserExist(S,Urt) then
        Begin
          Cr;
          Exit;
        End else S:=Urt.Alias; { Just in case User's Number was Typed }
    End else
  If (Email) and (S='') then Exit;
  If S='' then
    Begin
      S:='All';
      Print(S);
    End;
  Header^.SentTo:=S;
  Cr;
  Send:=True;
End;

FUNCTION Title:Boolean;
VAR S:String;
Begin
  If Reply then
    Begin
      If Pos('Re: ',ReplyHeader^.Title)=0 then
        Insert('Re: ',ReplyHeader^.Title,1);
      USC(1); Println(ReplyHeader^.Title);
    End;
  USC(1); Tran(Strings^.Title); Limit(S,64,0);
  If (S='') and (Reply) then
    Begin
      S:=ReplyHeader^.Title;
      Print(S);
    End;
  Cr;
  Header^.Title:=S;
  Title:=(S<>'');
End;

PROCEDURE Anon;
Begin
  If {(Base.Anon) and} (Strings^.Anon<>'') then
    Begin
      USC(1);
      Tran(Strings^.Anon);
      If YesNo(False,User.YesNoBar) then SetBit(Header^.Status,3,True);
      Cr;
    End;
End;

PROCEDURE HeaderDefaults;
Begin
  Header^.From:=User.Alias;
  Header^.Note:=User.Note;
  If Email then Header^.Code:=0 else Header^.Code:=Base.LastMsg+1;
  Header^.ReplyTo:=0;
  Header^.Status:=0;
  SetTime(Header^.Sent);
  Header^.Start:=0;
  Header^.Lines:=1;
End;

PROCEDURE ReplyToMessage;
Begin
  Repeat Until IOresult=0;
  ReplyData;
  PostMessage;
  ClearReply;
  Repeat Until IOresult=0;
End;

PROCEDURE PostMessage;
Begin
  StartMessage;
  HeaderDefaults;
  Send;
  If Not Title then Exit;
  Anon;
  If EditMessage(78,Sys.MessageLen) then
   Begin
    If Header^.Lines>0 then
      If Not AppendMessage then
        Begin
          USC(4);
          Println('Error saving message!');
        End else
        Begin
          Inc(Base.LastMsg);
          SaveBase(BasePos,Base);
        End;
   End else ReadMessage(CurrentMessage+1,True);
End;

PROCEDURE ListTitles;
VAR B:Boolean; C,I:Byte; S1,S2:String;
Begin
  S1:='|U3';
  S2:='';
  If DataS<>'' then
    Begin
      I:=Pos(';',DataS);
      If I<>0 then
        Begin
          S1:='';
          For C:=1 to I-1 do S1:=S1+DataS[C];
          For C:=I+1 to Length(DataS) do S2:=S2+DataS[C];
        End else S1:=DataS;
    End;
  I:=0;
  Repeat
    Inc(I);
    B:=NextMessage(NotDeleted);
    If B then
      Begin
        Tran(S1);
        Print(Strr(MessageNum));
        Repeat Print(#32); Until WhereX=5;
        If Upper(Header^.From)=Upper(User.Alias) then USC(0);
        Print(Header^.From);
        If Upper(Header^.From)=Upper(User.Alias) then USC(3);
        Repeat Print(#32); Until WhereX=25;
        If Upper(Header^.SentTo)=Upper(User.Alias) then USC(0);
        Print(Header^.SentTo);
        If Upper(Header^.SentTo)=Upper(User.Alias) then USC(3);
        Repeat Print(#32); Until WhereX=46;
        Print(Header^.Title);
        Tran(S2);
        Cr;
      End;
  Until (Not B) or (Logoff) or (I=20);
End;

FUNCTION PreviousMessage:Boolean;
VAR B,Quit:Boolean; Old:Word;
Begin
  Repeat Until IOresult=0;
  PreviousMessage:=False;
  SavePointer;
  If CurrentMessage<1 then Exit;
  Old:=CurrentMessage;
  Repeat
    Dec(CurrentMessage);
    Seek(HdrFile,CurrentMessage*SizeOf(HeaderRec));
    B:=ReadHeader(Header);
    Quit:=(Not Bit(Header^.Status,4));
    If Email then Quit:=(Quit) and (Upper(User.Alias)=Upper(Header^.SentTo));
  Until (Not B) or (Quit) or (Logoff) or (CurrentMessage=0);
  If (B) and (Quit) then
    Begin
      Dec(MessageNum);
      B:=ReadMessage(CurrentMessage+1,False);
    End else CurrentMessage:=Old;
  PreviousMessage:=B;
  Repeat Until IOresult=0;
End;

PROCEDURE CloseBase; Forward;

FUNCTION OpenBase(Mode:Byte):Boolean;
VAR S:String; B:Byte;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  CloseBase; { Make sure Base File is closed }
  OpenBase:=False;
  S:=Sys.DataDir+'\MSGBASES.LST';
  SetFileMode(Mode);
  Assign(BaseFile,S);
  If Not Exist(S) then Rewrite(BaseFile,1) else
    Repeat
      Reset(BaseFile,1);
      B:=IOresult;
      If B=5 then Delay(300);
    Until (Logoff) or (B<>5);
  If B<>0 then Exit;
  SetFileMode(NormalMode);
  OpenBase:=True;
  Repeat Until IOresult=0;
End;

PROCEDURE CloseBase;
Begin
  Repeat Until IOresult=0;
  Close(BaseFile);
  CloseFile;
  Open(ReadDenyNone);
  Repeat Until IOresult=0;
End;

FUNCTION LoadBase(I:Word; VAR Base:BaseRec):Boolean;
VAR L:Integer;
LABEL Done,Done2;
Begin
  Repeat Until IOresult=0;
  LoadBase:=False;
  BasePos:=I;
  If Not OpenBase(ReadDenyNone) then Goto Done;
  Seek(BaseFile,(I-1)*SizeOf(Base));
  If IOresult<>0 then Goto Done2;
  Repeat
    BlockRead(BaseFile,Base,SizeOf(Base),L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  If (L>0) and (Ignore=0) then LoadBase:=True;
  Done2:
  CloseBase;
  Done:
  Repeat Until IOresult=0;
End;

FUNCTION SaveBase(I:Word; Base:BaseRec):Boolean;
VAR B:Byte; D:Word;
LABEL Done,Done2;
Begin
  Repeat Until IOresult=0;
  SaveBase:=False;
  If Not OpenBase(WriteDenyNone) then Goto Done2;
  Seek(BaseFile,(I-1)*SizeOf(Base));
  If IOresult<>0 then Goto Done;
  Repeat
    BlockWrite(BaseFile,Base,SizeOf(Base));
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  SaveBase:=(Ignore=0);
  Done:
  CloseBase;
  Done2:
  Repeat Until IOresult=0;
End;

PROCEDURE LoadFirstBase;
VAR I:Word; L:Integer;
Begin
  If Not OpenBase(ReadDenyNone) then Exit;
  BasePos:=0;
  I:=0;
  Repeat
    Seek(BaseFile,I*SizeOf(Base));
    Repeat
      BlockRead(BaseFile,Base,SizeOf(Base),L);
      Ignore:=IOresult;
      If Ignore=5 then Delay(300);
    Until Ignore<>5;
    Inc(I);
  Until (L<SizeOf(Base)) or (Logoff) or (CheckAccess(Base.Access));
  If CheckAccess(Base.Access) then BasePos:=I else FillChar(Base,SizeOf(Base),#0);
  CloseBase;
End;

PROCEDURE EditBase;
VAR S:String; C:Char; Current:Word;

PROCEDURE Draw;
Begin
  Cls;
  SSC(1); Print('Area: ['); SSC(3); Print(Strr(Current));
  SSC(1); Print('/'); SSC(3); Print(Strr(Bases)); SSC(1); Println(']');
  FunctionTop;
  Command('A','Description',Base.Description);
  Command('B','Access',Base.Access);
  Command('C','Input',Base.Input);
  Command('D','File Name',Base.Name);
  Command('E','Net Base',Yn(Base.Net));
  Command('F','Which Net',Strr(Base.Feed));
  Command('G','Origin Line',Base.Origin);
  Command('H','Sponsor',Base.Sponsor);
  If Base.Net then Command('I','Net Base Dir',Base.NetDir);
  Command(' ','Scan Code',Strr(Hi(Base.Code))+':'+Strr(Lo(Base.Code)));
  FunctionBottom;
End;

FUNCTION Getit(S:String; Len,Dat:Byte):String;
Begin
  SSC(1); Print('New '+S+': '); SSC(0); Limit(S,Len,Dat); Cr;
  Getit:=S;
End;

LABEL Die;
Begin
  SSC(1);
  Print('Base to Edit: '); SSC(0); Limit(S,6,2); Cr;
  Current:=Intt(S);
  If Current=0 then Exit;
  If Not LoadBase(Current,Base) then Exit;
  Repeat
    Draw;
    Die:
    Prompt;
    Repeat C:=Upcase(Getkey); Until (C in ['A'..'I','L','Q','+','=','_','-','?']) or (Logoff);
    Cr;
    If C='A' then
      Begin
        S:=GetIt('Description',64,0);
        If S<>'' then Base.Description:=S;
      End;
   If Current<>1 then
   Begin
    If (C='I') and (Base.Net) then
      Begin
        S:=GetIt('Net Base Dir',64,0);
        While S[Length(S)]='\' do Dec(S[0]);
        Base.NetDir:=S;
      End;
    If C='B' then Base.Access:=Getit('Access',15,0);
    If C='C' then
      Begin
        S:=GetIt('Input',64,2);
        If S<>'' then Base.Input:=S;
      End;
   End;
    If C='D' then
      Begin
        S:=GetIt('File Name',8,2);
        If S<>'' then Base.Name:=S;
      End;
   If Current<>1 then
   Begin
    If C='E' then
      Begin
        Base.Net:=Not Base.Net;
        Base.NetDir:=Sys.MsgDir+'\1';
      End;
    If C='F' then Base.Feed:=Intt(GetIt('Net Feed',5,2));
    If C='G' then Base.Origin:=GetIt('Origin',80,0);
   End;
    If C='H' then
      Begin
        S:=GetIt('Sponsor',30,0);
        If S<>'' then Base.Sponsor:=S;
      End;
    If C in ['+','='] then
      Begin
        SaveBase(Current,Base);
        If Current=Bases then Current:=1 else Inc(Current);
        LoadBase(Current,Base);
      End;
    If C in ['-','_'] then
      Begin
        SaveBase(Current,Base);
        If Current=1 then Current:=Bases else Dec(Current);
        LoadBase(Current,Base);
      End;
    If C='?' then
      Begin
        MenuTop;
        MenuCmd('+','Forward 1 Message Area');
        MenuCmd('-','Backwards 1 Message Area');
        MenuCmd('L','List Commands');
        MenuCmd('Q','Quit');
        MenuBottom;
        Goto Die;
      End;
  Until (C='Q') or (Logoff);
  SaveBase(Current,Base);
End;

PROCEDURE ClearBase(I:Integer);
VAR B:Byte;
Begin
  If I=1 then Base.Description:='Private Mail' else
  Base.Description:='General Discussion';
  If I=1 then Base.Access:='MAIL' else Base.Access:='c1';
  Base.Input:=Strr(I-1);
  If I=1 then Base.Name:='PRIVATE' else Base.Name:='GENDISC';
  Base.Net:=False;
  Base.Feed:=1;
  Base.Origin:=Strings^.Fill[20];
  Base.Sponsor:=Sys.Sysop;
  Base.NetDir:='';
  Base.Code:=Random(32767);
  If Random(2)=1 then Base.Code:=Base.Code*2;
  Base.LastMsg:=0;
  Base.FirstMsg:=1;
  If I=1 then Base.Mail:=True else Base.Mail:=False;
  For I:=1 to 9 do Base.Fill[I]:=0;
End;

PROCEDURE AddBase;
VAR I:Word;
Begin
  Repeat Until IOresult=0;
  I:=Bases+1;
  ClearBase(I);
  SaveBase(I,Base);
  Repeat Until IOresult=0;
End;

PROCEDURE DeleteBase;
Begin
End;

PROCEDURE InsertBase;
Begin
End;

FUNCTION PreviousBase:Boolean;
VAR I,L:Integer; B:BaseRec;
LABEL Done;
Begin
  Repeat Until IOresult=0;
  PreviousBase:=False;
  If Not OpenBase(ReadDenyNone) then Exit;
  I:=BasePos-1;
  If I=1 then Exit;  { 1=Private Mail }
  Repeat
    Dec(I);
    Seek(BaseFile,I*SizeOf(B));
    BlockRead(BaseFile,B,SizeOf(B),L);
  Until (I=1) or (CheckAccess(B.Access)) or (L<SizeOf(B)) or (Logoff);
  If (CheckAccess(B.Access)) and (L=SizeOf(B)) then
    Begin
      PreviousBase:=True;
      BasePos:=I+1;
      Base:=B;
    End;
  Done:
  Repeat Until IOresult=0;
End;

FUNCTION NextBase:Boolean;
VAR L,I:Integer; B:BaseRec;
LABEL Done;
Begin
  Repeat Until IOresult=0;
  NextBase:=False;
  If Not OpenBase(ReadDenyNone) then Goto Done;
  I:=BasePos;
  Repeat
    Seek(BaseFile,I*SizeOf(B));
    BlockRead(BaseFile,B,SizeOf(B),L);
    Inc(I);
  Until (L<SizeOf(B)) or (Logoff) or (CheckAccess(B.Access));
  If (CheckAccess(B.Access)) and (L=SizeOf(B)) then
    Begin
      NextBase:=True;
      BasePos:=I;
      Base:=B;
    End;
  CloseBase;
  Done:
  Repeat Until IOresult=0;
End;

FUNCTION Bases:Integer;
Begin
  Repeat Until IOresult=0;
  Bases:=0;
  If Not OpenBase(ReadDenyNone) then Exit;
  Bases:=FileSize(BaseFile) div SizeOf(BaseRec);
  CloseBase;
  Repeat Until IOresult=0;
End;

PROCEDURE EditBases;
VAR C:Char;

PROCEDURE Draw;
VAR I:Word; L:Integer;
Begin
  Cls;
  If Bases=0 then
    Begin
      SSC(4); Println('There happens to be no message areas right now!');
      Exit;
    End;
  MenuTop;
  If Not OpenBase(ReadDenyNone) then Exit;
  I:=1;
  Repeat
    BlockRead(BaseFile,Base,SizeOf(BaseRec),L);
    If L=SizeOf(BaseRec) then ListCmd(I,Base.Description);
    Inc(I);
  Until (L<SizeOf(BaseRec)) or (Logoff) or (ChWait);
  CloseBase;
  MenuBottom;
End;

LABEL It;
Begin
  Cursor(True);
  Repeat
    Draw;
    It:
    Prompt;
    Repeat C:=Upcase(Getkey); Until (C in ['L','Q','A','D','M','I','P','?']) or (Logoff);
    Cr;
    If Bases>0 then
      Begin
        If C='D' then DeleteBase;
        If C='M' then EditBase;
        If C='I' then InsertBase;
      End;
    If C='A' then AddBase;
    If C='?' then
      Begin
        MenuTop;
        MenuCmd('A','Add a Base');
        MenuCmd('D','Delete a Base');
        MenuCmd('I','Insert a Base');
        MenuCmd('P','Move a Base');
        MenuCmd('M','Edit a Base');
        MenuCmd('L','Relist Bases');
        MenuCmd('Q','Quit');
        MenuBottom;
        Goto It;
      End;
  Until (C='Q') or (Logoff);
  CloseFile;
End;

FUNCTION SelectRead:ReadType;
VAR C:Char;
Begin
  SelectRead:=GenRead;
  Show('RSELECT',False,False);
  Repeat C:=Upcase(Getkey); Until (C in ['4','N','D','T','F','U','H','Q',^M]) or (Logoff);
  Case C of
    'N':Println('Next');
    'D':Println('Date');
    'T':Println('To You');
    'F':Println('From You');
    'U':Println('From User');
    '4':Println('For User');
    'H':Println('Topic Thread');
    'Q',^M:Println('Quit');
  End;
  Case C of
    'N':If Sys.CompressNums then SelectRead:=NotDeleted else SelectRead:=Next;
    'D':Begin
        End;
    'T':SelectRead:=ToUser;
    'F':SelectRead:=FromUser;
    'U':SelectRead:=UserSentFrom;
    '4':SelectRead:=UserSentTo;
    'H':SelectRead:=Thread;
  End;
End;

End.
