UNIT Menugen;
{$X+,I-}

{** Make a Command to load the last Conference/Menu Set/Ansi Set/Prompt Set! **}

INTERFACE

USES Dos,Crt,Gentypes,Files,Modem,Misc,Config,Messages,BcShare,Users,
     Menu2,PckdTime,Xfer,Online,Files2;

PROCEDURE HighLight(I:Byte; T:Boolean);
PROCEDURE ClearMenu;
PROCEDURE DrawAll;
PROCEDURE MakeMenu;
PROCEDURE RunAutos;
PROCEDURE LoadStandard;
PROCEDURE HelpMenu;
FUNCTION RunData(Cmd:Byte; B:Boolean):Boolean;
FUNCTION InsertCommand(Loc:Byte):Boolean;
FUNCTION DeleteCommand(Loc:Byte):Boolean;
PROCEDURE TheBBS;

PROCEDURE GenericMenu(N:Boolean);
PROCEDURE RunCommand(I:Byte);
FUNCTION RunMenu(S:String):Boolean;
FUNCTION ReadCommands(S:String):Boolean;
FUNCTION SaveCommands(S:String):Boolean;
FUNCTION SaveMenu(S:String):Boolean;
FUNCTION LoadLibrary(I:Integer):Boolean;
FUNCTION SaveLibrary(I:Integer):Boolean;
FUNCTION DeleteLibrary(I:Integer):Boolean;
FUNCTION Libraries:Integer;
PROCEDURE UserConfig;

IMPLEMENTATION

CONST Columns:Array[1..6] of Byte=(80,40,26,20,16,13);
      AutoJump:Boolean=False;
      SaveBase:Word=1;

VAR AutoFinish:Byte;

PROCEDURE HighLight(I:Byte; T:Boolean);
Begin
  If (I=0) or (I>PdCmds) then Exit;
  If Not Menu.PullDown then Exit;
  GoXY(MenCmd[PdPtr[I]]^.pX,MenCmd[PdPtr[I]]^.pY);
  Case T of
    True:Tran(MenCmd[PdPtr[I]]^.On);
    False:Tran(MenCmd[PdPtr[I]]^.Off);
  End;
End;

PROCEDURE DrawAll;
VAR I:Byte;
Begin
  If PdCmds=0 then Exit;
  If Not Menu.PullDown then Exit;
  For I:=1 to PdCmds do
    If I=PdCmd then HighLight(I,True) else HighLight(I,False);
  GoXY(MenCmd[PdPtr[PdCmd]]^.pX+
       TranLen(MenCmd[PdPtr[PdCmd]]^.On),
       MenCmd[PdPtr[PdCmd]]^.Py);
End;

PROCEDURE MakeMenu;
VAR I:Byte;
Begin
  If Logoff then Exit;
  PdCmds:=0;
  If Not Menu.PullDown then Exit;
  If Menu.Commands=0 then Exit;
  If ForceCommand then ForceCommand:=False else PdCmd:=1;
  I:=1;
  Repeat
    If (MenCmd[I]^.On<>'') and
       (MenCmd[I]^.Off<>'') then
      Begin
        Inc(PdCmds);
        PdPtr[PdCmds]:=I;
      End;
    Inc(I);
  Until (I>Menu.Commands);
End;

PROCEDURE LoadStandard;
Begin
  MenuLib^.Location:=Sys.MenuDir;
  MenuLib^.Name:='Default Menus';
End;

PROCEDURE HelpMenu;
Begin
  If Menu.Clear then Cls;
  If Not Show(Menu.Ansifile,False,True) then GenericMenu(False);
End;

PROCEDURE ClearMenu;
VAR I:Byte;
Begin
  If Menu.Commands=0 then Exit;
  I:=Menu.Commands;
  Repeat
    Dispose(MenCmd[I]);
    Dec(I);
  Until (I=0);
  Menu.Commands:=0;
End;

PROCEDURE RunLoopers;
VAR I:Byte;
Begin
  If MenuQuit then Exit;
  If Logoff then Exit;
  If Menu.Commands=0 then Exit;
  I:=1;
  Repeat
    If (MenCmd[I]^.EveryCommand) and (CheckAccess(MenCmd[I]^.Access)) then
      If RunData(I,True) then RunCommand(I);
    { Data for Menu Changing stuff is still run, but the actuall
      commands themselves are not run. }
    Inc(I);
  Until (I>Menu.Commands) or (MenuQuit) or (Logoff);
  If Menu.PullDown then
    If Menu.DrawCmds then DrawAll else HighLight(PdCmd,True);
End;

FUNCTION LoadMatrix:Boolean;
Begin
End;

FUNCTION Figure(S:String; Cmd:Byte):Boolean;
VAR B:Boolean; I:Byte; C:Char; S1:String;
Begin
  Figure:=True;
  If S='' then Exit;
  If (S[1] in ['''','"','^']) and (S[Length(S)] in ['''','"','^']) then
    Begin
      Delete(S,1,1);
      Dec(S[0]);
      Tran(S);
    End else
  If Upper(S)='PAUSE' then Pause else
  If (Pos('YN-',S)=1) and (Length(S)=4) then
    Begin
      B:=UpCase(S[Length(S)])='Y';
      Figure:=YesNo(B,User.YesNoBar); SSC(1);
    End else
  If (S[1]='{') and (S[Length(S)]='}') then
    Begin
    End else
  If Pos('%%',S)=1 then
    Begin
      Delete(S,1,2);
      If S[Length(S)] in ['|','!'] then Dec(S[0]);
      Show(S,False,S[Length(S)+1]='|');
    End else
  If Pos('ON:',S)=1 then
    Begin
      Delete(S,1,3);
      User.Flag[Intt(S)]:=True;
    End else
  If Pos('OFF:',S)=1 then
    Begin
      Delete(S,1,4);
      User.Flag[Intt(S)]:=False;
    End else
  If Pos('NOT:',S)=1 then
    Begin
      Delete(S,1,4);
      User.Flag[Intt(S)]:=Not User.Flag[Intt(S)];
    End else
  If Pos('FILLTO[',S)=1 then
    Begin
      Delete(S,1,7);
      Dec(S[0]); { FILLTO[X,C] is now X,C }
      C:=S[Length(S)];
      Dec(S[0],2);
      For I:=WhereX to Intt(S) do Print(C);
    End else
  If Pos('GOTOXY[',S)=1 then
    Begin
      Delete(S,1,7);
      Dec(S[0]);
      S1:='';
      I:=Pos(',',S)+1;
      If I=1 then Exit;
      Repeat S1:=S1+S[I]; Inc(I); Until I>Length(S);
      I:=Intt(S1);
      Repeat Dec(S[0]) until S[Length(S)]=',';
      Dec(S[0]);
      Goxy(Intt(S),I);
    End else
  If Pos('FORCECMD[',S)=1 then
    Begin
      Dec(S[0]);
      Delete(S,1,9);
      ForceCommand:=True;
      PdCmd:=Intt(S);
    End else
  If Pos('PWD[',S)=1 then
    Begin
      Delete(S,1,4);
      Dec(S[0]);
      TopHidden(S);
      Limit(S1,64,1); Cr;
      Figure:=(Upper(S1)=Upper(S));
    End else
  If Pos('CMD[',S)=1 then
    Begin
      Dec(S[0]);
      Delete(S,1,4);
      PdCmd:=Intt(S);
    End else
  If Pos('FILL[',S)=1 then
    Begin
      Delete(S,1,5);
      Dec(S[0]);
      C:=S[Length(S)];
      Dec(S[0],2);
      For I:=1 to Intt(S) do Print(C);
    End else
  If (S='DRAWALL') then DrawAll else
  If (S='DRAW') then HighLight(PdCmd,True) else
  If (S='CLS') then Cls Else
  If Intt(S)>0 then DataI:=DataI+Intt(S) else DataS:=DataS+S;
End;

FUNCTION RunData(Cmd:Byte; B:Boolean):Boolean;
VAR S,S1:String; I:Byte; Quit,Nor:Boolean;
Begin
  If B then DataI:=0;
  If B then DataS:='';
  RunData:=True;
  If Not B then S:=MenCmd[Cmd]^.AfterData else S:=MenCmd[Cmd]^.Data;
  If S='' then Exit;
  I:=1;
  Quit:=False;
  Nor:=False;
  Repeat
    S1:='';
    Repeat
      If S[I]<>';' then S1:=S1+S[I] else
      If (S[I]=';') and (S[I+1]=';') and (I+1<=Length(S)) then
        Begin
          Inc(I);
          S1:=S1+';';
        End;
      Inc(I);
    Until (Logoff) or (S[I]=';') or (I>Length(S));
    If S1<>'' then Quit:=Not Figure(S1,Cmd);
  Until (Logoff) or (I>Length(S)) or (Quit);
  If Quit then RunData:=False else RunData:=True;
  Nor:=False;
End;

FUNCTION RunMenu(S:String):Boolean;
VAR B:Boolean;
Begin
  ClearMenu;
  B:=ReadCommands(S);
  If B then
    Begin
      MakeMenu;
      RunAutos;
    End;
  RunMenu:=B;
  Repeat Ignore:=IOresult Until Ignore=0;
End;

PROCEDURE ResetDate;
VAR I:Integer;
Begin
  I:=0;
  Repeat
    Inc(I);
  Until (User.Bases[I]=Base.Code) or (I>1024);
  If I<1025 then User.Bases[I]:=0;
End;

PROCEDURE PageSysop;
VAR S:String; I,B:Integer;
Begin
  If DataS='' then
    Begin
      USC(1);
      Print('Reason for Chat: ');
      USC(0);
    End else Tran(DataS);
  Limit(S,30,0);
  Cr;
  If S<>'' then
    Begin
      Show('PAGE',False,False);
      I:=1;
      Repeat
        Tran(Strings^.Fill[18]);
        B:=1;
        SendStr(^G^G);
        Repeat
          Sound(500);
          Delay(150);
          Sound(750);
          Delay(150);
          Inc(B);
       Until (B>10) or (ChWait) or (Logoff);
       Inc(I);
     Until (ChWait) or (Logoff) or (I=10);
     If ChWait then Getkey;
     NoSound;
    End;
End;

PROCEDURE Jump;
VAR S:String;
Begin
  Limit(S,5,2);
  If (Intt(S)>0) and (Intt(S)<=TotalMessages) then
    NoMsgs:=Not GotoMessage(Intt(S)) else NoMsgs:=True;
End;

PROCEDURE RunCommand(I:Byte);
VAR Key:String[3]; S:String;
Begin
  If Not CheckAccess(MenCmd[I]^.Access) then Exit;
  Key:=Upper(MenCmd[I]^.Key);

  If Key='MRD' then ResetDate;
  If Key='MSM' then ShowMessage;
  If Key='MNA' then If Not NextBase then
    Begin
      If DataS<>'' then Tran(DataS);
      LastBase:=True;
    End else LastBase:=False;
  If Key='MPA' then If Not PreviousBase then
    Begin
      If DataS<>'' then Tran(DataS);
      LastBase:=True;
    End else LastBase:=False;
  If Key='MLA' then AreaList;
  If Key='MGN' then GenericNewScan;
  If Key='#GA' then GotoArea;
  If Key='MEA' then EditBases;
  If Key='MPM' then PostMessage;
  If Key='MFA' then LoadFirstBase;
  If Key='MRM' then ReplyToMessage;
  If Key='MR+' then NoMsgs:=Not NextMessage(GenRead);
  If Key='MLT' then ListTitles;
  If Key='MR-' then NoMsgs:=Not PreviousMessage;
  If Key='MFM' then FirstMessage;
  If Key='MDM' then If Not ToggleDelete then If DataS<>'' then Tran(DataS);
  If Key='SLR' then GenRead:=SelectRead;

(*
  If Key='ESC' then NoMsgs:=Not Scan4Mail(Waiting,OutGoing);
  If Key='ER+' then NoMsgs:=Not NextMail(True);
  If Key='ER-' then NoMsgs:=Not PreviousMail(True);
  If Key='EO+' then NoMsgs:=Not NextMail(False);
  If Key='EO-' then NoMsgs:=Not PreviousMail(False);
  If Key='EFI' then NoMsgs:=Not FirstLetter(True);
  If Key='EFO' then NoMsgs:=Not FirstLetter(False);
*)
  If Key='EML' then SendMail;

  If Key='#GM' then Jump;
  If Key='XLF' then ListFiles;
  If Key='XTF' then TypeFile;
  If Key='XFA' then LoadFirstFileBase;
  If Key='XNA' then If Not NextFileArea then If DataS<>'' then Tran(DataS);
  If Key='XPA' then If Not PreviousFileArea then If DataS<>'' then Tran(DataS);
  If Key='XLA' then FileAreaList;
  If Key='XEF' then EditFile;
  If Key='XNS' then FileNewScan;
  If Key='#FA' then GotoFileArea;

  If Key='FNC' then GotoConference;
  If Key='FLU' then ListUsers;
  If Key='FSB' then SaveBase:=BasePos;
  If Key='FRB' then LoadBase(SaveBase,Base);
  If Key='FSF' then Show(DataS,False,True);
  If Key='FSN' then Show(DataS,False,False);
  If Key='FRS' then ReadScript(DataS);
  If Key='FUE' then UserEditor;
  If Key='NUV' then NewUserVoting;
  If Key='BYE' then MenuQuit:=True;
  If Key='GMS' then GenericMenu(Menu.Clear);
  If Key='SFE' then EditFileBases;
  If Key='OBJ' then If Not RunObject then Tran('|U4Object file not found!|CR');
  If Key='SCE' then ForumEditor;
  If Key='GMR' then GenericRead;
  If Key='HLP' then HelpMenu;
  If Key='DSZ' then ReadDSZlog;
  If Key='CLS' then Cls;
  If Key='FSC' then SystemConfig;
  If Key='TWL' then TheWall;
  If Key='CFG' then UserConfig;
  If Key='REG' then RegisterMessage;
  If Key='SWS' then Shell2(DataS,True);
  If Key='EXE' then Shell2(DataS,True);
  If Key='SNS' then Shell2(DataS,False);
  If Key='DLF' then DownloadFile;
  If Key='ULF' then UploadFile;
  If Key='PGE' then PageSysOp;
  If Key='MNE' then
    Begin
      ClearMenu;
      S:=Menu.Name;
      Asm
        Call MenuPtr;
      End;
      ClearMenu;
      RunMenu(S);
    End;

  RunData(I,False);
End;

PROCEDURE PushMenu(I:Byte; Menu:String; Autos:Boolean);
VAR P:Pointer;
Begin
  P:=Nil;
  If NestedMenus=0 then
    Begin
      New(MenuSav);
    End else
    Begin
      P:=MenuSav;
      New(MenuSav^.Next);
      MenuSav:=MenuSav^.Next;
    End;
  Inc(NestedMenus);
  MenuSav^.Previous:=P;
  MenuSav^.Next:=Nil;
  MenuSav^.Input:=MenuS;
  MenuSav^.CurrentCmd:=I;
  MenuSav^.Name:=Menu;
  MenuSav^.Autos:=Autos;
End;

FUNCTION PopMenu(VAR I:Byte; VAR Autos:Boolean):String;
VAR S:String; P:Pointer;
Begin
  I:=MenuSav^.CurrentCmd;
  S:=MenuSav^.Name;
  Autos:=MenuSav^.Autos;

  MenuS:=MenuSav^.Input;

  If NestedMenus=1 then
    Begin
      Dispose(MenuSav);
      Dec(NestedMenus);
    End else
    Begin
      P:=MenuSav^.Previous;
      Dispose(MenuSav);
      MenuSav:=P;
      Dec(NestedMenus);
    End;
  PopMenu:=S;
End;

PROCEDURE MenuInput; Forward;

CONST Quit:Boolean=False;
      QuitMenu:Boolean=False;

FUNCTION AutoRunMenu(S:String):Boolean;
Begin
  ClearMenu;
  If ReadCommands(S) then
    Begin
      AutoRunMenu:=True;
      MakeMenu;
    End else AutoRunMenu:=False;
  Repeat Ignore:=IOresult Until Ignore=0;
End;

PROCEDURE FallBackMsg;
Begin
  SSC(4);
  Println('Dropping to Fallback Menu!');
  If Not RunMenu(Sys.FallBackMenu) then
    Begin
      Println('Could not drop to Fallback Menu!');
      MenuQuit:=True;
    End;
End;

PROCEDURE RunAutos;
VAR I:Byte; S:String; Autos:Boolean;
Begin
  If MenuQuit then Exit;
  If Menu.Commands=0 then Exit;
  I:=1;
  Repeat
    If MenCmd[I]^.AutoRun then
      If CheckAccess(MenCmd[I]^.Access) then
        If RunData(I,True) then
          Begin
            If MenCmd[I]^.Key='GTM' then
              Begin
                If Not RunMenu(DataS) then FallBackMsg;
                Quit:=True;
              End else
            If MenCmd[I]^.Key='FGM' then
              Begin
                PushMenu(I,Menu.Name,True);
                If Not RunMenu(DataS) then
                  Begin
                    FallBackMsg;
                    Exit;
                  End;
                If Quit then
                  Begin
                    Quit:=False;
                    Exit;
                  End else MenuInput;
                S:=PopMenu(I,Autos);
                If Quit then
                  Begin
                    Quit:=False;
                    Exit;
                  End;
                If AutoRunMenu(S) then RunData(I,False) else
                  Begin
                    FallBackMsg;
                    Exit;
                  End;
              End else RunCommand(I);
          End;
    Inc(I);
  Until (Logoff) or (MenuQuit) or (I>Menu.Commands) or (Quit);
End;

FUNCTION ExecuteInput:Boolean;
VAR I:Byte; Err,Good:Boolean; S:String; Autos:Boolean;
Begin
  I:=1;
  Err:=True;
  If MenuS='.' then
    Begin
      RegisterMessage;
      Err:=False;
      ExecuteInput:=Not Err;
      Quit:=False;
      Exit;
    End;
  Repeat
    Good:=False;
    If (Pos('//*\\:',MenuS)=1) and (Length(MenuS)=9) then
      Begin
        Err:=False;
        Inc(Menu.Commands);
        Delete(MenuS,1,6);
        New(MenCmd[Menu.Commands]);
        MenCmd[Menu.Commands]^.Access:='';
        MenCmd[Menu.Commands]^.Data:='';
        MenCmd[Menu.Commands]^.AfterData:='';
        MenCmd[Menu.Commands]^.Key:=Upper(MenuS);
        RunCommand(Menu.Commands);
        Dispose(MenCmd[Menu.Commands]);
        Dec(Menu.Commands);
      End else
    If MenuS<>'' then
      Begin
        If Upper(MenCmd[I]^.Input)=Upper(MenuS) then Good:=True;
      End else
    If Upper(MenCmd[I]^.Input)='^M' then Good:=True;
    If (Intt(MenuS)>0) and (Upper(MenCmd[I]^.Input)='^NUMBER') then Good:=True;
    If (Good) and (CheckAccess(MenCmd[I]^.Access)) then
      Begin
        Err:=False;
        If RunData(I,True) then
          Begin
            If MenCmd[I]^.Key='GTM' then
              Begin
                If Not RunMenu(DataS) then FallBackMsg;
                Quit:=True;
              End else
            If MenCmd[I]^.Key='FGM' then
              Begin
                PushMenu(I,Menu.Name,False);  { False, not Autos! }
                If Not RunMenu(DataS) then
                  Begin
                    FallBackMsg;
                    Exit;
                  End;
                If Quit then
                  Begin
                    Quit:=False;
                    Exit;
                  End else MenuInput;
                S:=PopMenu(I,Autos);
                If Quit then
                  Begin
                    Quit:=False;
                    Exit;
                  End;
                If AutoRunMenu(S) then RunData(I,False) else
                  Begin
                    FallBackMsg;
                    Exit;
                  End;
              End else
            If MenCmd[I]^.Key='FQM' then
              Begin
                Quit:=True;
                QuitMenu:=True;
              End else
            If (MenCmd[I]^.Key='#GM')
               and (Upper(MenCmd[I]^.Input)='^NUMBER') then
              Begin
                If Not GotoMessage(Intt(MenuS)) then
                  Begin
                    NoMsgs:=True;
                    Tran(DataS);
                  End else NoMsgs:=False;
                RunData(I,False);
              End else RunCommand(I);
          End;
      End;
    Inc(I);
  Until (I>Menu.Commands) or (Logoff) or (MenuQuit) or (Quit);
  If (Err) and (MenuS<>'') and (Menu.ErrStr<>'') and
     (Not Menu.Pulldown) then Tran(Menu.ErrStr);
  Quit:=False;
  ExecuteInput:=Not Err;
End;

PROCEDURE GenericPrompt;
LABEL Blah,Blah2;
Begin
  If Menu.PromptN=0 then
    Begin
      Blah:
      If User.Prompt<>Prompt^.Number then
        Begin
          If Not LoadThePrompt(User.Prompt) then
            Begin
              User.Prompt:=1;
              If Not LoadThePrompt(User.Prompt) then Exit;
            End;
        End;
      Goto Blah2;
    End else
  If Menu.PromptN<>Prompt^.Number then
    If Not LoadThePrompt(Menu.PromptN) then Goto Blah;
  Blah2:
  If TimeMessage<>'' then
    Begin
      SSC(4);
      Println(TimeMessage);
      TimeMessage:='';
    End;
  ShowPrompt;
End;

PROCEDURE GetHotKeys;
VAR C:Char; Good:Boolean; I:Byte; NumPut:Boolean;
Begin
  I:=1;
  NumPut:=False;
  Repeat
    If MenCmd[I]^.Key[1]='#' then NumPut:=True;
    Inc(I);
  Until (Logoff) or (I>Menu.Commands) or (NumPut);
  Good:=False;
  MenuS:='';
  Repeat
    C:=Getkey;
    I:=1;
    MenuS:=C;
    Repeat
      Good:=(Upper(MenuS)=Upper(MenCmd[I]^.Input));
      Inc(I);
    Until (Good) or (I>Menu.Commands) or (Logoff);
    If Good then Print(C);
  Until (C=^M) or (Good) or (Logoff);
  If (C=^M) and (Not Good) then MenuS:='';
  If Menu.Return then Cr;
End;

PROCEDURE GoUp;
Begin
  MenuS:='^[[A';
End;

PROCEDURE GoDown;
Begin
  MenuS:='^[[B';
End;

PROCEDURE GoLeft;
Begin
  MenuS:='^[[D';
End;

PROCEDURE GoRight;
Begin
  MenuS:='^[[C';
End;

PROCEDURE BackPd;
Begin
  if PdCmds=0 then Exit;
  HighLight(PdCmd,False);
  If PdCmd=1 then PdCmd:=PdCmds else Dec(PdCmd);
  HighLight(PdCmd,True);
End;

PROCEDURE ForwardPd;
Begin
  if PdCmds=0 then Exit;
  HighLight(PdCmd,False);
  If PdCmd=PdCmds then PdCmd:=1 else Inc(PdCmd);
  HighLight(PdCmd,True);
End;

PROCEDURE PullDownInput;
VAR C:Char; S:String; Good:Boolean; I:Byte;
Begin
  Good:=False;
  Repeat
    C:=Getkey;
    If (C=#27) and (Not ChWait) then Delay(300);
    If (C=#27) and (Not ChWait) then
      Begin
        MenuS:='^[';
        Good:=True;
      End else
    If (C=#27) and (ChWait) then
      Begin
        S:='';
        Repeat
          S:=S+Getkey;
        Until (S[Length(S)] in ['A'..'Z','a'..'z']) or (Logoff) or
              (Not ChWait) or (Length(S)>15);
        If (S='[[A') or (S='[A') then Begin Good:=True; GoUp; End else
        If (S='[[B') or (S='[B') then Begin Good:=True; GoDown; End else
        If (S='[[C') or (S='[C') then Begin Good:=True; GoRight; End else
        If (S='[[D') or (S='[D') then Begin Good:=True; GoLeft; end else
          Begin
            Good:=True;
            C:=S[Length(S)];
          End;
      End else
    If (C=#0) and (NextGk) then
      Begin
        C:=Getkey;
        Case C of
          #72:GoUp;
          #80:GoDown;
          #75:GoLeft;
          #77:GoRight;
        End;
       If C in [#72,#80,#75,#77] then Good:=True;
     End else
     If C=^M then
      Begin
        Good:=True;
        MenuS:=MenCmd[PdPtr[PdCmd]]^.Input;
      End else
      Begin
        MenuS:=C;
        If Menu.PdHighLight then
          Begin
            I:=0;
            Repeat
              inc(I);
            Until (I=PdCmds) or (Logoff) or
                  (Upper(MenCmd[PdPtr[I]]^.Input)=Upper(MenuS));
            If (Upper(MenCmd[PdPtr[I]]^.Input)=Upper(MenuS))
               and (I<>PdCmd) then
              Begin
                HighLight(PdCmd,False);
                PdCmd:=I;
                HighLight(PdCmd,True);
              End;
          End else
          Begin
            I:=0;
            Repeat
              inc(I);
            Until (I=PdCmds) or (Logoff) or
            (Upper(MenCmd[PdPtr[I]]^.Input)=Upper(MenuS));
            If Upper(MenCmd[PdPtr[I]]^.Input)=Upper(MenuS) then HighLight(PdCmd,False);
          End;
        If Menu.PdHk then Good:=True;
      End;
  Until (Good) or (Logoff);
End;

PROCEDURE GetInput;
Begin
  MenuS:='';
  DataS:='';
  DataI:=0;
  If Menu.PullDown then PullDownInput else
    Begin
      If Menu.Prompt then GenericPrompt;
      If (User.HotKeys) or (Menu.HotKey) then GetHotKeys else Limit(MenuS,255,0);
      If Menu.Return then Cr;
      If Menu.Prompt then If Prompt^.EndFile<>'' then Show(Prompt^.EndFile,False,False);
    End;
End;

PROCEDURE MenuInput;
VAR B:Boolean;
Begin
  B:=True;
  Repeat
    If (Not MenuQuit) and (not Logoff) and (Not QuitMenu) then
      Begin
        If (B) or ((Not Menu.PullDown) and (Not B)) then RunLoopers;
        GetInput;
        B:=ExecuteInput;
        If (Not B) and ((Menu.PullDown) and (MenuS[1]='^') and (MenuS[2]='[')
           and (MenuS[3]='[') and (MenuS[4] in ['A'..'D'])) then
           Case MenuS[4] of
             'A','D':BackPd;
             'B','C':ForwardPd;
           End;
      End;
  Until (MenuQuit) or (Logoff) or (QuitMenu);
  ClearMenu;
  QuitMenu:=False;
End;

PROCEDURE TheBBS;
Begin
  MenuQuit:=False;
  If Not LoadMatrix then Exit;
  MenuInput;
  ClearMenu;
  While NestedMenus>0 do
    Begin
      MenuSav:=MenuSav^.Previous;
      Dispose(MenuSav^.Next);
      Dec(NestedMenus);
    end;
End;

FUNCTION InsertCommand(Loc:Byte):Boolean;
VAR I:Byte;
Begin
  InsertCommand:=False;
  If (Menu.Commands=MaxMenuCmds) then Exit;
  If (Loc<1) or (Loc>Menu.Commands) then Exit;
  Inc(Menu.Commands);
  New(MenCmd[Menu.Commands]);
  I:=Loc;
  For I:=Menu.Commands downto Loc+1 do MenCmd[I]^:=MenCmd[I-1]^;
  InsertCommand:=True;
End;

FUNCTION DeleteCommand(Loc:Byte):Boolean;
VAR I:Byte;
Begin
  If (Menu.Commands=0) then Exit;
  If (Loc<1) or (Loc>Menu.Commands) then Exit;
  If Loc=Menu.Commands then
    Begin
      Dispose(MenCmd[Menu.Commands]);
      Dec(Menu.Commands);
    End else
    Begin
      For I:=Loc to Menu.Commands-1 do MenCmd[I]^:=MenCmd[I+1]^;
      Dispose(MenCmd[Menu.Commands]);
      Dec(Menu.Commands);
    End;
End;

PROCEDURE GenericMenu(N:Boolean);
VAR I,B,Z:Byte;
Begin
  If N then Cls;
  If Menu.Commands=0 then
    Begin
      SSC(4);
      Println('Warning: No Commands in Menu! [G] to Logoff.');
      Cr;
      Exit;
    End;
  SSC(3);
  For Z:=1 to 3 do
    If Menu.Title[Z]<>'' then
      Begin
        If Menu.MidTitle then
          Begin
            For B:=1 to (80-TranLen(Menu.Title[Z])) div 2 do Print(#32);
            Tran(Menu.Title[Z]); Cr;
          End else
          Begin
            Tran(Menu.Title[Z]); Cr;
          End;
      End;
  B:=1;
  For I:=1 to Menu.Commands do
    If (Not MenCmd[I]^.Hidden) then
      Begin
        LenTran(MenCmd[I]^.Command,Columns[Menu.Columns]);
        If B=Menu.Columns then
          Begin
            B:=1;
            Cr;
          End else
          Begin
            For Z:=WhereX to Columns[Menu.Columns] * B do Print(#32);
            Inc(B);
          End;
      End;
  If B<>1 then Cr;
End;

FUNCTION LoadCommands(S:String):Boolean;
VAR I:Byte; L:Integer; F:File;
LABEL Finish;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  LoadCommands:=False;
  Assign(F,S+'.DAT');
  SetFileMode(ReadDenyNone);
  Reset(F,1);
  SetFileMode(ReadOnly);
  If IOresult<>0 then Exit;
  BlockRead(F,Menu,SizeOf(Menu),L);
  Close(F);
  Repeat I:=IOresult; Until I=0;
  Assign(F,S+'.LST');
  SetFileMode(ReadDenyNone);
  Reset(F,1);
  SetFileMode(ReadOnly);
  If IOresult=0 then
   Begin
    If FileSize(F)>0 then
      Begin
        I:=1;
        Repeat
          New(MenCmd[I]);
          BlockRead(F,MenCmd[I]^,SizeOf(CommandRec),L);
          Inc(I);
        Until (L=0) or (I>Menu.Commands);
        Dec(I);
      End;
    Close(F);
    Repeat I:=IOresult Until I=0;
   End;
  LoadCommands:=True;

  SetFileMode(ReadDenyNone);
  { To Prevent other Problems until entire system is Multi-Node Compliant }

  Exit;
  Finish:
  Close(F);
  Erase(F);
  Repeat I:=IOresult Until I=0;
  SetFileMode(ReadDenyNone);

End;

FUNCTION ReadCommands(S:String):Boolean;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  ReadCommands:=False;
  Repeat Ignore:=IOresult Until Ignore=0;
  If Not LoadCommands(MenuLib^.Location+'\'+S) then
    If Not LoadCommands(Sys.MenuDir+'\'+S) then Exit;
  ReadCommands:=True;
  Repeat Ignore:=IOresult Until Ignore=0;
End;

FUNCTION SaveCommands(S:String):Boolean;
VAR I:Byte; F:File;
Begin
  SaveCommands:=False;
  Repeat Ignore:=IOresult Until Ignore=0;
  If Not SaveMenu(S) then Exit;
  Assign(F,MenuLib^.Location+'\'+S+'.LST');
  SetFileMode(ReadDenyNone);
  If Menu.Commands=0 then
    Begin
      SetFileMode(NormalMode);
      Erase(F);
      If IOResult=0 then SaveCommands:=True;
      SetFileMode(ReadDenyNone);
      Exit;
    End;
  Rewrite(F,1);
  SetFileMode(ReadDenyNone);
  If IOresult<>0 then Exit;
  I:=1;
  Repeat
    BlockWrite(F,MenCmd[I]^,SizeOf(CommandRec));
    Inc(I);
  Until (I>Menu.Commands);
  Close(F);
  Repeat I:=IOresult Until I=0;
  SetFileMode(ReadDenyNone);

  SaveCommands:=True;
  ClearMenu;
End;

FUNCTION SaveMenu(S:String):Boolean;
VAR F:File; I:Byte;
Begin
  SaveMenu:=False;
  Repeat Ignore:=IOresult Until Ignore=0;
  Assign(F,MenuLib^.Location+'\'+S+'.DAT');
  SetFileMode(ReadDenyNone);
  Rewrite(F,1);
  If IOresult<>0 then {} Begin SetFileMode(ReadDenyNone); {} Exit; {} End;
  SetFileMode(NormalMode);
  BlockWrite(F,Menu,SizeOf(Menu));
  Close(F);
  Repeat I:=IOresult Until I=0;
  SaveMenu:=True;

  SetFileMode(ReadDenyNone);

End;

FUNCTION LoadLibrary(I:Integer):Boolean;
VAR B:Byte;
Begin
  Repeat B:=IOresult Until B=0;
  Repeat Ignore:=IOresult Until Ignore=0;
  GetSem(Sys.DataDir+'\MENUS.SEM');
  LoadLibrary:=False;
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Seek(LibF,I-1);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Read(LibF,MenuLib^);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Close(LibF);
  LoadLibrary:=True;
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
  Repeat B:=IOresult Until B=0;
End;

FUNCTION SaveLibrary(I:Integer):Boolean;
Begin
  GetSem(Sys.DataDir+'\MENUS.SEM');
  Repeat Ignore:=IOresult Until Ignore=0;
  SaveLibrary:=False;
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Seek(LibF,I-1);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Write(LibF,MenuLib^);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Close(LibF);
  SaveLibrary:=True;
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

FUNCTION DeleteLibrary(I:Integer):Boolean;
VAR B:Integer;
Begin
  DeleteLibrary:=False;
  GetSem(Sys.DataDir+'\MENUS.SEM');
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult=0 then
    Begin
      If I=FileSize(LibF) then
        Begin
          Seek(LibF,I-1);
          Truncate(LibF);
        End else
      For B:=I-1 to FileSize(LibF)-2 do
        Begin
          Seek(LibF,B+1);
          Read(LibF,MenuLib^);
          Seek(LibF,B);
          Write(LibF,MenuLib^);
          Truncate(LibF);
        End;
      Close(LibF);
    End else Exit;
  Repeat B:=IOresult Until B=0;
  DeleteLibrary:=True;
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

FUNCTION Libraries:Integer;
Begin
  GetSem(Sys.DataDir+'\MENUS.SEM');
  Libraries:=0;
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(MenuLib^.Location+'\MENUS.SEM');
      Exit;
    End;
  Libraries:=FileSize(LibF);
  Close(LibF);
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
End;

PROCEDURE UserConfig;
VAR C:Char; I,B:Integer; S:String; Old:LibraryRec;

PROCEDURE Draw(I:Integer);
Begin
  Case I of
    1:GoXY(13,7);
    2..4:GoXY(21,7+I);
    5..9:GoXY(52,4+I);
    10..13:GoXY(68,I-1);
    14:GoXY(21,12);
    15:GoXY(21,13);
  End;
  Case I of
    2:Print(User.Note);
    3:Print(Yn(User.YesNoBar)+#32);
    4:Tran(MenuLib^.name);
    5..13:Begin
            USC(I-5);
            Print('Color '+Strr(I-5));
          End;
    14:Print(Yn(User.Pause)+#32);
    15:Print(Prompt^.Name);
  End;
End;

PROCEDURE GetColor(B:Integer);
VAR Top,Bot:Byte; Blink:Boolean; C:Char;

PROCEDURE TopIt;
Begin
  GoXY(21+Top,14);
  Print('');
End;

PROCEDURE BotIt;
Begin
  GoXY(21+Bot,16);
  Print('');
End;

Begin
  If User.Colors[B].Fore>15 then
    Begin
      Blink:=True;
      Top:=User.Colors[B].Fore-16;
    End else
    Begin
      Top:=User.Colors[B].Fore;
      Blink:=False;
    End;
  Bot:=User.Colors[B].Back;
  Color(15,0);
  TopIt;
  BotIt;
  Repeat
    C:=Upcase(Getkey);
    If C='P' then
      Begin
        Color(0,0);
        TopIt;
        If Top=15 then Top:=0 else Inc(Top);
        Color(15,0);
        TopIt;
      End else
    If C='O' then
      Begin
        Color(0,0);
        TopIt;
        If Top=0 then Top:=15 else Dec(Top);
        Color(15,0);
        TopIt;
      End else
    If C='K' then
      Begin
        Color(0,0);
        BotIt;
        If Bot=0 then Bot:=15 else Dec(Bot);
        Color(15,0);
        BotIt;
      End else
    If C='L' then
      Begin
        Color(0,0);
        BotIt;
        If Bot=15 then Bot:=0 else Inc(Bot);
        Color(15,0);
        BotIt;
      End;
    If C='B' then Blink:=Not Blink;
  Until (C=#13) or (Logoff);
  User.Colors[B].Fore:=Top;
  If Blink then User.Colors[B].Fore:=User.Colors[B].Fore+16;
  User.Colors[B].Back:=Bot;
  Color(0,0);
  TopIt;
  BotIt;
  Color(3,0);
End;

LABEL Top2;
Begin
  Top2:
  Show('USERCFG',False,False);
  Color(3,0);
  For I:=1 to 4 do Draw(I);
  Draw(14);
  Draw(15);
  For I:=5 to 13 do Draw(I);
  Repeat
    Draw(1);
    Color(3,0);
    Print(#32#8);
    C:=Upcase(Getkey);
    Color(11,0);
    Print(C);
    Color(3,0);
    If C='N' then
      Begin
        GoXY(21,9);
        Print(Fill(#32,Length(User.Note)));
        GoXY(21,9);
        Limit(S,30,0);
        If S<>'' then User.Note:=S;
        If S='' then Draw(2);
      End else
    If C='-' then
      Begin
        GoXY(21,13);
        Print(Fill(#32,Length(Prompt^.Name)));
        GoXY(21,13);
        Repeat
          If Not LoadThePrompt(Prompt^.Number+1) then LoadThePrompt(1);
        Until (Logoff) or (Prompt^.Select);
        User.Prompt:=Prompt^.Number;
        Draw(15);
      End else
    If C='B' then
      Begin
        User.YesNoBar:=Not User.YesNoBar;
        Draw(3);
      End else
    If C='P' then
      Begin
        User.Pause:=Not User.Pause;
        Draw(14);
      End else
    If C in ['0'..'8'] then
      Begin
        GetColor(Intt(C));
        Draw(Intt(C)+5);
      End else
    If C='9' then
      Begin
        User.Colors:=Sys.Colors;
        For I:=5 to 13 do Draw(I);
      End;
  Until (C='Q') or (C='M');
  Cls;
  If C='Q' then Exit;
  Old:=MenuLib^;
  Show('MNSETLST',False,True);
  B:=Libraries;
  For I:=1 to B do
    Begin
      If LoadLibrary(I) then
        Begin
          SSC(1); Print('[');
          SSC(3); Print(Strr(I));
          SSC(1); Print('] ');
          SSC(3); Tran(MenuLib^.Name);
          Cr;
        End;
    End;
  Show('CFGPRMPT',False,False);
  Limit(S,5,2);
  Cr;
  If (Intt(S)>0) and (Intt(S)<=B) then
    Begin
      If LoadLibrary(Intt(S)) then
        Begin
          If Not RunMenu(Menu.Name) then FallBackMsg;
        End else MenuLib^:=Old;
    End else MenuLib^:=Old;
 Goto Top2;
End;


End.
