UNIT GenTypes;
{$I-}
{ All TYPEs CONSTs and VARs }
(*{$DEFINE PowerMail}*)

INTERFACE

USES Crt;

CONST
  Connect:Boolean=False;
  Version='v1.06';
  Year='1992-1993';
  NewUsers:Byte=0;
  RipGraphics:Boolean=False;

  SystemInfo : Array [1..3] of String = (
    ' OTERA(c) Bulletin Board System ',
    'Copyright 1993 Power Systems Inc',
    'Programmed by Mercury in 1992-93');

  BaudType : array [1..7] of Word = (300,1200,2400,4800,9600,19200,38400);

  MaxMenuCmds=50;
  MaxBuffLines=125; { 5 Screen Buffer for Now }

  MaxLines=255;
  { This variable (^) contains the maximum number of Line IN memory at one
    time.  Subsequent lines are shown after a second read statement, up to
    the maximum lines (65536 internal) specified by SysOp }

  Flags : Array [1..4] of Boolean =(False,False,False,False);
  {
    1=Local Logon
    2=SysOp Function Locally
  }

  NodeSysOp:Boolean=False;
  OtherNode:Integer=2;

  NextGK:Boolean=False;
  NestedMenus:Byte=0;

  MaxFileBytes=2147483647;

  ForceCommand:Boolean=False;

TYPE
  Emulation_Set=(Ascii,Ansi,Avatar,OGi_OGt);
  ScreenArr = Array [0..160*42-1] of Byte;
  DataArr = Array [1..32767] of Char;
  CommandStringArr=Array[1..MaxMenuCmds] of String;
  TimeArr = Array [1..6] of Byte;
  FlagArr=Array[1..30] of Boolean;

  ColorArray = Array [0..8] of
    Record
      Fore,Back:Byte;
    End;

  StatusRec = Record
    Name      : String;
    SysOp     : String;
    Number    : String[15];
    MainDir   : String;
    DataDir   : String;
    FilesDir  : String;
    MsgDir    : String;
    AnsiDir   : String;
    MenuDir   : String;
    WorkDir   : String;
    BaudRate  : Word;
    ComPort   : Byte;
    DataBits  : Byte;
    Parity    : Char;
    StopBits  : Byte;
    UseFossil : Boolean;
    Bios      : Boolean;
    LastWin   : Boolean;
    Colors    : ColorArray;
    SnowChecking   : Boolean;
    MaxWaitingMail : Integer;
    LogonTries     : Byte;
    BlankMins      : Byte;
    ChatAttempts   : Byte;
    SoundSource    : Byte;
    ModSpeed       : Integer; { 1193182 div Rate }
    MaxMsgLength   : Word;
    ManualAnswer   : Boolean;
    SpecialEffects : Boolean;
    OverlayEMS     : Boolean;
    PointChecking  : Boolean;
    RatioChecking  : Boolean;
    OffHookLogon   : Boolean;
    UseRumors      : Boolean;
    UseTheWall     : Boolean;
    LockComPort    : Boolean;
    StatusLine     : Boolean;
    Matrixes       : Byte;
    CompressNums   : Boolean;
    Fill           : Array[1..3] of Byte;
    TotalFiles     : Word;
    TotalPosts     : Word;
    NewUserPassword: String;
    SwaponShell    : Boolean;
    SystemPassword : String;
    BaudSupported  : Array [1..7] of Boolean;
    LockOutPassword: String;
    FPCredit       : Byte;
    DeletionVotes  : Byte;
    NewUserSL      : Byte;
    NewUserDSL     : Byte;
    BarOnFore      : Byte;
    BarOnBack      : Byte;
    BarOffFore     : Byte;
    BarOffBack     : Byte;
    PauseType      : Byte; { 1:at 1,24 2:at current spot 3:no string }
    InfoForms      : Array [1..5] of Record
      Name         : String[30];
      Required     : Boolean;
      Permanent    : Boolean;
    End;
    NodeNumber     : Integer;
    NodeType       : (MainNode,SecondaryNode,LocalNode);
    MultiNodes     : Boolean;
    FallBackMenu   : String[8];
    MainNodeDir    : String[75];
    MessageLen     : Integer;
    NewUsers       : Word;
    YesVotes       : Byte;
    NoVotes        : Byte;
    Nodes          : Integer;
    LastUpdate     : TimeArr;
    KupToday       : Integer;
    KdownToday     : Integer;
    PostsToday     : Integer;
  End;

  UserRec = Record
    Deleted    : Boolean;
    Number     : Integer;
    Alias      : String;
    Name       : String;
    Note       : String;
    Password   : String;
    Address    : String;
    City       : String;
    Zip        : String[10];
    State      : String[2];
    Phone      : String[15];
    BirthDay   : String[8];
    Expiration : String[8];
    Sl         : Byte;
    Dsl        : Byte;
    Flag       : FlagArr;
    TimeLimit  : Integer;
    TimeToday  : Integer;
    Posts      : Integer;
    Calls      : Integer;
    FilePoints : Integer;
    Lines      : Byte;
    Emulation  : Emulation_Set;
    Prompt     : Byte;
    LineFeeds  : Boolean;
    Pause      : Boolean;
    YesNoBar   : Boolean;
    HotKeys    : Boolean;
    LastOn     : TimeArr;
    Fill       : Byte;
    NUVloc     : Word;
    Colors     : ColorArray;
    LastMsgNewScan  : LongInt;
    LastFileNewScan : LongInt;
    BankMaximum     : Integer;
    Balance         : Integer;
    MaximumDeposit  : Integer;
    DepositToday    : Integer;
    PostCallRatio   : Integer;
    FilesRatio      : Integer;
    Kuploaded       : Word;
    Kdownloaded     : Word;
    FilesUploaded   : Integer;
    FilesDownLoaded : Integer;
    MenuSet         : Integer;
    FilePointRatio  : Integer;
    Form            : Array[1..5] of Word;
    AnsiSet         : Array[1..5] of Integer;
    LastScan        : Array[1..1024] of Word;
    Bases           : Array[1..1024] of Word;
    EmailScan       : Word;
  End;

  UserExistRec = Record
    Name       : String;
    Alias      : String;
    Password   : String;
    Number     : Integer;
    Sl,Dsl     : Byte;
    Note       : String;
  End;

  StringRec = Record
    Detect,Ansi,Avatar,Ogi,None,
    Pause,
    Init,Hang,Dial,Answer,OffHook,
    Shell,
    Title,ULmsg,AskPhone,AskName,
    SysOpIn,SysOpOut,ChatStart,ChatEnd,
    Anon,
    Destination,
    Quote,BadNUP,
    TheWall,SystemNews,
    AreaList,BBSlist,
    EditorLine:String;
    Fill:Array[1..30] of String;
    Suffix,Hidden:Char;
  End;

  MenuSavPtr= ^MenuSavRec;
  MenuSavRec = Record
    Name     : String[8];
    CurrentCmd: Byte;
    Input    : String;
    Autos    : Boolean;
    Previous : MenuSavPtr;
    Next     : MenuSavPtr;
  End;

  PromptRec  = Record
    Name     : String;
    Number   : Byte;
    Data     : Array[1..10] of String;
    EndFile  : String[79];
    Select   : Boolean;
  End;
  PromptPtr = ^PromptRec;

  MenuRec    = Record
    Name     : String[8];
    Title    : Array [1..3] of String;
    Area     : String;
    MidTitle : Boolean;             { Center Titles }
    Clear    : Boolean;             { Clear Screen Before Menu? }
    Prompt   : Boolean;             { Show Prompt?? }
    Return   : Boolean;             { Return after Input }
    PullDown : Boolean;
    DrawCmds : Boolean;
    HotKey   : Boolean;
    PdHk     : Boolean;
    PdHighLight:Boolean;
    PromptN   : Byte;
    AnsiFile : String[8];               { ? file W/O extension }
    errstr   : string;
    Columns  : Byte;
    Commands : Byte; { This is to keep track ONLINE without accessing file.}
  End;

  { /|\ MENUNAME.HDR /|\   |                |  }
  {  |                |   \|/ MENUNAME.DAT \|/ }

  CommandRec = Record
    Key      : String[3];
    Input    : String[64];
    Command  : String[80]; { i.e. [A] AutoMessage }
    Data     : String[255];
    AfterData: String[255];
    Access   : String[15];
    Hidden   : Boolean;
    AutoRun  : Boolean;
    EveryCommand:Boolean;
    HKlight  : Boolean;  { If True then RUN command }
    Flags    : Array[1..6] of Boolean;
    Px       : Byte;
    Py       : Byte;
    On       : String;
    Off      : String;
  End;

  NUVRec = Record
    Alias    : String[30];
    Number   : Word;
    InfoForm : Word; (* Location of InfoForm in InfoForm File | 0/None *)
    YesVotes : Byte;
    NoVotes  : Byte;
    Users    : Byte;
    Comments : Array [1..10] of String;
    Voted    : Array [1..40] of Byte; (* 1:Yes 2:No 3:Abstain 0:Blank *)
    User     : Array [1..40] of Word; { User Number }
    Deleted  : Boolean;
  End;

  WallRec = Record
    Quote : Array[1..15] of String;
    Total : Byte;
  End;

  FileAreaRec = Record
    Description : String;
    Access      : String[15];
    Input       : String;
    Name        : String[8];
    Upload      : Boolean;
    Download    : Boolean;
    NoRatio     : Boolean;
    Flags       : Array[1..7] of Boolean;
    Sponsor     : String;
    Password    : String;
    Dir         : String;
  End;

  FileDataRec = Record
    FileName  : String[12];
    Location  : String[64];
    Date      : TimeArr;
    Uploader  : String;
    Description:String[40];
    Extended  : Array[1..6] of String[40];
    Cost      : Word;
    Size      : Word;
    Password  : String;
    ForWho    : String;
    Disk      : Byte; { [1/_] }
    OfDisk    : Byte; { [_/2] }
    Group     : String[15];
    Status    : Byte;  { Unvalidated, Private, Etc }
  End;

  FileBasePtr=^FileAreaRec;
  FileDataPtr=^FileDataRec;

  BaseRec   = Record
    Description : String;
    Access  : String[15];
    Input   : String; { 1,L,Local. etc. etc. }
    Name    : String[8];
    Net     : Boolean;
    Feed    : Integer; { Which Net? }
    Origin  : String;
    Sponsor : String;
    NetDir  : String; { C:\OTERA\BOARDS\1, etc. }
    Code    : Word;
    LastMsg : Word;
    FirstMsg: Word;
    Mail    : Boolean;
    Fill    : Array[1..9] of Byte;
  End;

  HeaderRec = Record
    SentTo  : String;
    From    : String;
    Note    : String; {-- User Note }
    Title   : String;
    Code    : Byte;
    ReplyTo : Word;
    Status  : Byte;
    { Status Bits:
            [1]:Permanent  [2]:Sent
            [3]:Annonymous [4]:Deleted
            [5]:Private
    }
    Sent    : TimeArr;
    Start   : LongInt;
    Lines   : Integer;
  End;
  HeaderPtr = ^HeaderRec;

  LineRec    = Record
    Next     : Pointer;
    Text     : String;
    Previous : Pointer;
  End;
  LinePtr    = ^LineRec;

  CharRec   = Record
    Letter  : Char;
    Color   : Byte;
  End;

  BuffLine  = Array[1..80] of CharRec;
  BufferPtr = ^BufferRec;
  BufferRec = Record
    Prev    : BufferPtr;
    Line    : BuffLine;
    Next    : BufferPtr;
  End;

  LibraryRec = Record
    Location : String[52]; { Location of Set }
    Name     : String[30]; { Library Name... i.e. ViSiON-X Menu Set }
    Access   : String[15]; { Access Level Needed }
  End;

  ForumSet = (Transfers,Messages,Both);

  ConferenceRec = Record
    Name        : String; { Main Conference }
    Number      : Integer;
    Access      : String[15];
    Input       : String;  { i.e. 1, MAIN, main.MSG.cfnc }
    Ctype       : ForumSet;
  End;

  AccessRec = Record
     Sl     : Byte;
     Dsl    : Byte;
     Flag   : FlagArr;
     Note   : String;
     Expiration : TimeArr;
     TimeLimit  : Integer;
     FilePoints : Integer;
     BankMaximum: Integer;
     MaximumDeposit:Integer;
     PostCallRatio:Integer;
     FileRatio:Integer;
     FilePointRatio:Integer;
  End;

VAR
  Base:BaseRec;
  Header:HeaderPtr;
  Top:LinePtr;
  DoorSys:Boolean;
  QuickLogoff:Boolean;
  Forum:^ConferenceRec;
  ForumNum:Integer;
  Status:Byte;
  Sys:StatusRec;
  User:UserRec;
  Strings:^StringRec;
  Screen:ScreenArr;
  Data:^DataArr;
  Rate:Word;
  ComPort:Byte;
  Node:Word;
  Emulation:Emulation_Set;
  Wall:WallRec;
  AnsiLib:Array [1..5] of LibraryRec;
  MenuLib:^LibraryRec;
  MenCmd:Array [1..MaxMenuCmds] of ^CommandRec;
  PdPtr:Array[1..MaxMenuCmds] of Byte;
  PdCmd:Byte; { Current Command for Pull-Downs }
  PdCmds:Byte; { Total Pull-Down Menu Commands }
  Menu:MenuRec;
  MenuSav:MenuSavPtr;
  Bars:Byte;
  FileBase:FileBasePtr;
  FileInfo:FileDataPtr;
  T:Text;
  Ignore:Byte;
  MenuPtr:Pointer;
  TimeLeft:Integer;
  Nuv:^NuvRec;

(*
    System Status Values
   ----------------------
    : 4 : Screen is blanked out locally
    : 3 : Users account is loaded already
    : 2 : SysOp's Account is loaded SysOp Menu
    : 1 : Local Logon active
*)

FUNCTION Intt(S:String):Integer;
PROCEDURE GetSem(S:String);
PROCEDURE ReleaseSem(S:String);
FUNCTION Bit(TheByte:Word; TBit:Byte):Boolean;
PROCEDURE SetBit(VAR TheByte:Byte; Bit:Byte; Value:Boolean);
Procedure Uncrunch(var Addr1,Addr2; BlkLen:Integer);
FUNCTION Strr(I:Integer):String;
FUNCTION Upper(S:String):String;
FUNCTION Fill(C:Char; Len:Byte):String;

IMPLEMENTATION

FUNCTION Intt(S:String):Integer;
VAR Temp,Code:Integer;
Begin
  If length(S)=0 then Intt:=0 else
    Begin
      Val(S,Temp,Code);
      If Code=0 then Intt:=Temp else Intt:= 0;
    End;
End;

PROCEDURE GetSem(S:String);
VAR F:File; Possible:Boolean; Tries:Byte;
Begin
  If Not Sys.MultiNodes then Exit;
  Possible:=False;
  Tries:=1;
  Assign(F,S);
  Repeat
    Reset(F);
    If IOresult<>0 then Possible:=True else
      Begin
        Close(F);
        Delay(1000); { Approx 1 Second }
        Inc(Tries);
      End;
  Until (Possible) or ((Tries=30) and (Not Possible)); { 30 Seconds }
  Rewrite(F);
  Close(F);
End;

PROCEDURE ReleaseSem(S:String);
VAR F:File;
Begin
  If Not Sys.MultiNodes then Exit;
  Assign(F,S);
  Erase(F);
End;

FUNCTION Bit(TheByte:Word; TBit:Byte):Boolean;
VAR WorkByte:Byte;
Begin
  WorkByte:=$01;
  WorkByte:=WorkByte shl TBit;
  Bit:=(TheByte and WorkByte>0);
End;

PROCEDURE SetBit(VAR TheByte:Byte; Bit:Byte; Value:Boolean);
VAR WorkByte:Byte;
Begin
  WorkByte:=$01 shl Bit;
  If Value then TheByte:=TheByte or WorkByte
  else TheByte:=TheByte xor WorkByte;
End;

Procedure Uncrunch(var Addr1,Addr2; BlkLen:Integer);
(*
 Screen=Array[1..4000] of Byte;
 Syntax: UnCrunch(ImageData,Screen[(X*2)+(Y*160)-162,ImageData_Length)
*)
begin
  inline (
    $1E/               {       PUSH    DS             ;Save data segment.}
    $C5/$B6/ADDR1/     {       LDS     SI,[BP+Addr1]  ;Source Address}
    $C4/$BE/ADDR2/     {       LES     DI,[BP+Addr2]  ;Destination Addr}
    $8B/$8E/BLKLEN/    {       MOV     CX,[BP+BlkLen] ;Length of block}
    $E3/$5B/           {       JCXZ    Done}
    $8B/$D7/           {       MOV     DX,DI          ;Save X coordinate for later.}
    $33/$C0/           {       XOR     AX,AX          ;Set Current attributes.}
    $FC/               {       CLD}
    $AC/               {LOOPA: LODSB                  ;Get next character.}
    $3C/$20/           {       CMP     AL,32          ;If a control character, jump.}
    $72/$05/           {       JC      ForeGround}
    $AB/               {       STOSW                  ;Save letter on screen.}
    $E2/$F8/           {Next:  LOOP    LOOPA}
    $EB/$4C/           {       JMP     Short Done}
                       {ForeGround:}
    $3C/$10/           {       CMP     AL,16          ;If less than 16, then change the}
    $73/$07/           {       JNC     BackGround     ;foreground color.  Otherwise jump.}
    $80/$E4/$F0/       {       AND     AH,0F0H        ;Strip off old foreground.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$F1/           {       JMP     Next}
                       {BackGround:}
    $3C/$18/           {       CMP     AL,24          ;If less than 24, then change the}
    $74/$13/           {       JZ      NextLine       ;background color.  If exactly 24,}
    $73/$19/           {       JNC     FlashBitToggle ;then jump down to next line.}
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output}
    $02/$C0/           {       ADD     AL,AL          ;routines.}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$DA/           {       JMP     Next}
                       {NextLine:}
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,}
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to}
    $EB/$D2/           {       JMP     Next           ;the next line.}
                       {FlashBitToggle:}
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink}
    $72/$07/           {       JC      MultiOutput    ;attribute?}
    $75/$CC/           {       JNZ     Next}
    $80/$F4/$80/       {       XOR     AH,128         ;Done.}
    $EB/$C7/           {       JMP     Next}
                       {MultiOutput:}
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.}
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.}
    $AC/               {       LODSB                  ;Get count of number of times}
    $8A/$C8/           {       MOV     CL,AL          ;to display character.}
    $B0/$20/           {       MOV     AL,32}
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.}
    $AC/               {       LODSB                  ;Otherwise get character to use.}
    $4B/               {       DEC     BX             ;Adjust main counter.}
                       {StartOutput:}
    $32/$ED/           {       XOR     CH,CH}
    $41/               {       INC     CX}
    $F3/$AB/           {       REP STOSW}
    $8B/$CB/           {       MOV     CX,BX}
    $49/               {       DEC     CX             ;Adjust main counter.}
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...}
    $1F);              {Done:  POP     DS             ;Restore data segment.}
end; {UNCRUNCH}

FUNCTION Strr(I:Integer):String;
VAR Temp:String;
Begin
  Str(I,Temp);
  Strr:=Temp;
End;

FUNCTION Upper(S:String):String;
VAR I:Byte;
Begin
  For I:=1 to Length(S) do S[I]:=Upcase(S[I]);
  Upper:=S;
End;

FUNCTION Fill(C:Char; Len:Byte):String;
VAR I:Byte; S:String;
Begin
  S:='';
  For I:=1 to Len do S:=S+C;
  Fill:=S;
End;

Begin
  Top:=Nil;
{$IFNDEF PowerMail}
  New(Header);
  New(MenuLib);
  New(Forum);
  New(FileBase);
  New(FileInfo);
  New(Strings);
{$ENDIF}
End.
