FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 1
Copyright (C) 1987, VEP Software, Naugatuck, CT 06770. All rights reserved.
Copyright (C) 1988, Rick Moore,  Homewood,  IL, 60430. All rights reserved.
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  00h  | Set BaudRate  | AL = Baud/Parity/SB   | AX = Status bits      | BaudRate code in AL:                  |
|       |               | DX = Port number      | (See function 03h)    | Bits [7:5] 000 = 19200, 001 = 38400,  |
|       |               |     (NOP if DX=00FFh) |                       | 010 = 300, 011 = 600, 100 = 1200,     |
|       |               |                       |                       | 101 = 2400, 110 = 4800, 111 = 9600.   |
|       |               |                       |                       | Parity: [4:3] 00 or 10 = none,        |
|       |               |                       |                       | 01 = odd, 11 = even.                  |
|       |               |                       |                       | StopBits: [2:2] 0 = 1, 1 = 2          |
|       |               |                       |                       | CharLength: 5 bits plus value [1:0]   |
|       |               |                       |                       | Support for [4:0] = 00011 required of |
|       |               |                       |                       | driver, others optional               |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  01h  | Transmit      | AL = Character        | AX = Status bits      | Character is queued for transmission. |
|       | character     | DX = Port number      | (See function 03h)    | If there is room in the transmitter   |
|       | (wait for     |     (NOP if DX=00FFh) |                       | buffer when this call is made, the    |
|       |  room in the  |                       |                       | character will be stored and control  |
|       |  buffer)      |                       |                       | returned to caller. If the buffer is  |
|       |               |                       |                       | full, the driver will wait for room.  |
|       |               |                       |                       | This can be dangerous when used in    |
|       |               |                       |                       | combination with flow control (see    |
|       |               |                       |                       | Function 0Fh)                         |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  02h  | Receive       | DX = Port number      | AH = 00h              | The next character in the input ring  |
|       | character     |     (NOP if DX=00FFh) | AL = Input character  | buffer is returned to the caller. If  |
|       | (wait for     |                       |                       | none available, the driver will wait  |
|       | available)    |                       |                       | for input.                            |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  03h  | StatusRequest | DX = Port number      | AX = Status bits      | Bits are:                             |
|       |               |     (NOP if DX=00FFh) |                       | AH[6:6] 1 = Output buffer empty       |
|       |               |                       |                       | AH[5:5] 1 = Output buffer not full    |
|       |               |                       |                       | AH[1:1] 1 = Input buffer overrun      |
|       |               |                       |                       | AH[0:0] 1 = Characters in input buffer|
|       |               |                       |                       | AL[7:7] 1 = Carrier Detect signal     |
|       |               |                       |                       | AL[3:3] 1 = Always (never 0)          |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  04h  | Initialize    | DX = Port number      | AX = 1954h (success)  | Required before I/O can take place on |
|       | driver (port) |    (DX=00FFh special) | BL = Max function     | comm port.  When DX = 00FFh,  then    |
|       |               |                       |      supported,  not  | any initialization needed to make the |
|       |               |                       |      incl. 7Eh - BFh  | keyboard/display available for FOSSIL |
|       |               | {BX = 4F50H           | BH = FOSSIL revision  | use should be performed.  BX = 4F50h  |
|       |               |  ES:CX = ^C flag byte}|      level of driver  | signals that ES:CX points to a flag   |
|       |               |    (Optional)         |                       | byte in the application that the      |
|       |               |                       | DTR raised on port    | driver should increment when its      |
|       |               |                       | BaudRate preserved    | keyboard routines detect a Ctl-C.     |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 2
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  05h  | Deinitialize  | DX = Port number      | None                  | Disengages driver from comm port.     |
|       | driver (port) |    (DX=00FFh special) |                       | Should be done when operations on the |
|       |               |                       | DTR not changed       | port are complete.  IF DX = 00FFh,    |
|       |               |                       |                       | then the initialization that was      |
|       |               |                       |                       | performed when FOSSIL function 04h    |
|       |               |                       |                       | with DX = 00FFh should be undone.     |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  06h  | Raise/lower   | AL = 01h - Raise DTR  | None                  | Used to control Data Terminal Ready   |
|       |     DTR       |    = 00h - Lower DTR  |                       | signal line on com port. This line    |
|       |               | DX = Port number      | DTR TRUE  if AL = 01h | usually has some effect on modem      |
|       |               |     (NOP if DX=00FFh) |     FALSE if AL = 00h | operation (most modems will drop      |
|       |               |                       |                       | carrier if DTR is lowered, for        |
|       |               |                       |                       | example).                             |
|       |               |                       |                       |                                       |
|       |               |                       |                       |                                       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  07h  | Return system | None                  | AL = timer tick       | Returns statistics needed to do some  |
|       | timer params  |                       |      interrupt number | critical timing in any MS-DOS system. |
|       |               |                       |      (NOT vector)     | The interrupt number in AL can be     |
|       |               |                       | AH = number of ticks  | used to intercept a timer interrupt   |
|       |               |                       |      per second       | that happens (AH) times per second.   |
|       |               |                       | DX = (apx.) number    | DX is essentially 1000/AH. Function   |
|       |               |                       |      of mS / tick     | 16h is the preferred way to install   |
|       |               |                       |                       | timer tick code. AH and DX should     |
|       |               |                       |                       | be accurate for the 16h timer tick.   |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  08h  | Flush output  | DX = Port number      | None                  | This is used to wait for all output   |
|       |    buffer     |     (NOP if DX=00FFh) |                       | to complete. If flow control is active|
|       |               |                       |                       | it is possible for this code never to |
|       | (wait for all |                       |                       | return control to the caller. (See    |
|       | output to end)|                       |                       | function 0Fh)                         |
|       |               |                       |                       |                                       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  09h  | Purge output  | DX = Port number      | None                  | Zero the output buffer. Returns to    |
|       |    buffer     |     (NOP if DX=00FFh) |                       | the caller immediately. Characters    |
|       |               |                       |                       | that have not been transmitted yet    |
|       | (immediately  |                       |                       | are lost.                             |
|       | zero buffer)  |                       |                       |                                       |
|       |               |                       |                       |                                       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 3
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  0Ah  | Purge input   | DX = Port number      | None                  | Zeroes the input buffer. If any flow  |
|       |    buffer     |     (NOP of DX=00FFh) |                       | control restraint has been employed   |
|       |               |                       |                       | (dropping RTS or transmitting XOFF)   |
|       |               |                       |                       | the port will be "released" (by doing |
|       |               |                       |                       | the reverse, raising RTS or sending   |
|       |               |                       |                       | XON). Returns to caller immediately.  |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  0Bh  | Transmit      | AL = Character        | AX = 0001h if sent    | Character is queued for transmission. |
|       | character     | DX = Port number      |    = 0000h if not     | If there is room in the transmitter   |
|       | ("no wait")   |     (NOP if DX=00FFh) |         sent          | buffer when this call is made, the    |
|       |               |                       |                       | character will be stored and control  |
|       |               |                       |                       | returned to caller with AX=1. If the  |
|       |               |                       |                       | buffer is full, control is returned   |
|       |               |                       |                       | to caller with AX=0. This allows the  |
|       |               |                       |                       | application to make its own decisions |
|       |               |                       |                       | on how to deal with "buffer full".    |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  0Ch  | "Peek ahead"  | DX = Port number      | AH = 00h              | The next character in the input ring  |
|       | input buffer  |     (NOP if DX=00FFh) | AL = input character  | buffer is returned to the caller. If  |
|       | (non-dest     |                       |      (if available)   | none available, the driver returns a  |
|       | read-ahead)   |                       | AX = FFFFh (if none   | value of FFFFH. This "read" does not  |
|       |               |                       |      (available)      | actually remove a character from the  |
|       |               |                       |                       | input buffer!                         |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  0Dh  | "Peek ahead"  |  None                 | AX = keyboard char    | The next character in the keyboard    |
|       |  KB buffer    |                       |      (if available)   | buffer is returned to the caller. If  |
|       | (non-dest     |                       | AX = FFFFh (if none   | none available, the driver returns a  |
|       |  read-ahead)  |                       |      available)       | value of FFFFH. This "read" does not  |
|       |               |                       |                       | actually remove a character from the  |
|       |               |                       |                       | input buffer! For function keys, IBM  |
|       |               |                       |                       | PC scan codes must be returned.       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  0Eh  | Read Keyboard |  None                 | AX = keyboard char    | Return the next character from the    |
|       | (wait if no   |                       |                       | keyboard buffer. Wait for a keystroke |
|       |  char avail)  |                       |                       | if the buffer is empty. For function  |
|       |               |                       |                       | keys, IBM PC scan codes are required. |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 4
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  0Fh  | Enable/Disable| AL = Flow control     | None                  | AL[0:0] 1= enables remote to restrain |
|       | com port flow |      bit mask         |                       |   FOSSIL transmitter using XON/XOFF;  |
|       |    control    | DX = Port number      |                       | AL[1:1] 1= enables modem restraint of |
|       |               |     (NOP if DX=00FFh) |                       |   FOSSIL transmitter using CTS and    |
|       |               |                       |                       |   FOSSIL restraint of modem using RTS |
|       |               |                       |                       | AL[3:3] 1= enables FOSSIL to restrain |
|       |               |                       |                       |   remote using XON/XOFF.              |
|       |               |                       |                       |                                       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  10h  | Enable/disable| AL = Flags byte       | AX = 0001h - CtlC/K   | AL[0:0] 1 = enable/disable CtlC/CtlK  |
|       |   Ctl-C/Ctl-K | DX = Port number      |        detected since |   check (driver will set internal flag|
|       |   check,      |     (NOP if DX=00FFh) |        last call      |   which is returned by this function  |
|       | Enable/disable|                       |    = 0000h - CtlC/K   |   when it detects a CtlC/CtlK).       |
|       |   transmitter |                       |        not detected   | AL[1:1] 1 = stop transmitter          |
|       |               |                       |        since last     |         0 = release previous stop     |
|       |               |                       |        call           |   This is used primarily for programs |
|       |               |                       |                       |   that can't trust XON/XOFF at FOSSIL |
|       |               |                       |                       |   level (such as BBS software).       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  11h  | Set cursor    | DH = Row (0-based)    | None                  | Identical to IBM PC BIOS INT 10h,     |
|       | location      | DL = Col (0-based)    |                       | subfunction 02h. FOSSIL should do     |
|       |               |                       |                       | sanity checks but software should not |
|       |               |                       |                       | assume that that is the case.         |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  12h  | Read Cursor   | None                  | DH = Row (0-based)    | Identical to IBM PC BIOS INT 10h,     |
|       | Location      |                       | DL = Col (0-based)    | subfunction 03h.                      |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  13h  | Write char    | AL = Character        | None                  | ANSI processing is a requirement of   |
|       | (ANSI support)|                       |                       | this call. It therefore should not be |
|       |               |                       |                       | considered re-entrant, since DOS      |
|       |               |                       |                       | might be used (via ANSI.SYS)          |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  14h  | Enable/disable| AL = 01h - Enable     | None                  | FOSSIL will force the system to reboot|
|       | "watchdog"    |            watchdog   |                       | if Carrier Detect on the specified    |
|       |               |    = 00h - Disable    |                       | port drops while "watchdog" is ON.    |
|       |               |            watchdog   |                       |                                       |
|       |               | DX = Port number      |                       | It is not necessary for the port to   |
|       |               |     (NOP if DX=00FFh) |                       | be "active" (Function 04h) for this   |
|       |               |                       |                       | function to be used.                  |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 5
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  15h  | Write char    | AL = Character        | None                  | Write character to screen using       |
|       | (re-entrant)  |                       |                       | re-entrant code. ANSI processing may  |
|       |               |                       |                       | not be assumed. This call may be used |
|       |               |                       |                       | by DOS device drivers.                |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  16h  | Insert/delete | AL = 01h - Insert     | AX = 0000h - operation| Allows FOSSIL to manage timer tick    |
|       | function from |    = 00h - Delete     |      was successful   | chain, which provides some measure of |
|       | timer tick    | ES = Function segment |    = FFFFh - operation| security over just snagging the       |
|       |               | DX = Function offset  |      was unsuccessful | interrupt. Use "insert" instead of    |
|       |               |                       |                       | grabbing the vector and "remove" in   |
|       |               |                       |                       | place of restoring it.                |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  17h  | Reboot system |  AL = 00h - Cold boot |  None (hopefully!)    | Provides a machine-independent way    |
|       |               |     = 01h - Warm boot |                       | for a "troubled" application to reset |
|       |               |                       |                       | the system. Some machines may not     |
|       |               |                       |                       | support both "flavors" of bootstrap,  |
|       |               |                       |                       | in which case the setting of AL will  |
|       |               |                       |                       | not have any effect.                  |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  18h  | Read block    | CX = Count            | AX = Number of chars  | Transfer as many characters as are    |
|       |               | ES = Segment of       |      actually moved   | available into the specified user     |
|       |               |      user buffer      |                       | buffer, up to the maximum specified   |
|       |               | DI = Offset of        |                       | in CX. ES and DI will not be modified |
|       |               |      user buffer      |                       | by this call. The actual number of    |
|       |               | DX = Port number      |                       | characters transferred will be in AX. |
|       |               |     (NOP if DX=00FFh) |                       | This function does not wait for more  |
|       |               |                       |                       | characters to become available if the |
|       |               |                       |                       | number in CX exceeds the number of    |
|       |               |                       |                       | characters currently stored.          |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  19h  | Write block   | CX = Count            | AX = number of chars  | Transfer as many characters as will   |
|       |               | ES = Segment of       |      actually moved   | fit, from the specified user buffer   |
|       |               |      user buffer      |                       | into the output buffer, up to the     |
|       |               | DI = Offset of        |                       | maximum specified in CX. ES and DI    |
|       |               |      user buffer      |                       | will not be modified by this call.    |
|       |               | DX = Port number      |                       | The actual number of characters       |
|       |               |     (NOP if DX=00FFh) |                       | transferred will be in AX.            |
|       |               |                       |                       |                                       |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 6
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  1Ah  | Start/stop    | AL = 01h - Start break| None                  | Used for special applications such as |
|       | sending break |      001 - Stop break |                       | certain high speed modems. Resets     |
|       |               | DX = Port number      |                       | all transmit flow control restraints  |
|       |               |     (NOP if DX=00FFh) |                       | (such as an XOFF received from remote)|
|       |               |                       |                       | Init (Function 4) or UnInit (Function |
|       |               |                       |                       | 5) will stop an in-progress Break.    |
|       |               |                       |                       | Note: the application must determine  |
|       |               |                       |                       | the "length" of the BREAK.            |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  1Bh  | GetDriverInfo | CX = Size of buffer   | AX = Number of bytes  | Offset 0 (word) = Structure size      |
|       |               | ES = Segment of       |      transferred      |        2 (byte) = FOSSIL spec version |
|       |               |      user buffer      |                       |        3 (byte) = Driver rev level    |
|       |               | DI = Offset of        | User buffer contains  |        4 (dwrd) = Pointer to ASCII ID |
|       |               |      user buffer      | info structure (used  |        8 (word) = Input buffer size   |
|       |               | DX = Port number      | to get special data   |       0A (word) = Bytes avail (input) |
|       |               |      (If DX=00FF,     | from the driver)      |       0C (word) = Output buffer size  |
|       |               |      port data will   |                       |       0E (word) = Bytes avail (output)|
|       |               |      not be valid).   |                       |       10 (byte) = Screen width, chars |
|       |               | For port data to be   |                       |       11 (byte) = Screen height, chars|
|       |               | accurate,  port must  |                       |       12 (byte) = Baud rate mask      |
|       |               | be active.            |                       |                   (See call 00h)      |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 7
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
| Code  |   Function    |  Function Parameters  |  Returned by Function | Explanation                           |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  7Eh  | Install user  | AL = Appendage code   | AX = 1954h - FOSSIL   | Used to install user appendages into  |
|       | appendage     | ES = Segment of user  |      driver present   | the INT 14h dispatcher.  Appendage    |
|       |               |      appendage entry  |    = Anything but     | codes 80h - BF are supported.  Codes  |
|       |               |      point            |      1954h - FOSSIL   | 80h - 83h are reserved.  The error    |
|       |               | DX = Offset of user   |      driver not       | return,  BH = 00h and AX = 1954h,     |
|       |               |      appendage entry  |      present          | should mean that another appendage    |
|       |               |      point            | BL = Code assigned to | has already been installed with the   |
|       |               |                       |      appendage (same  | code specified in AL.  The appendage  |
|       |               |                       |      as AL at entry)  | will be entered via a far call when-  |
|       |               |                       | BH = 01h - Operation  | ever INT 14h call is made with AL     |
|       |               |                       |      successful       | equal to the appendage code.  The     |
|       |               |                       |    = 00h - Operation  | appendage should return to the INT    |
|       |               |                       |      unsuccessful     | 14h dispatcher via a far return.  The |
|       |               |                       |                       | INT 14h dispatcher should not modify  |
|       |               |                       |                       | any registers prior to making the far |
|       |               |                       |                       | call to the appendage and after the   |
|       |               |                       |                       | appendage returns control to the      |
|       |               |                       |                       | dispatcher.                           |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+
|       |               |                       |                       |                                       |
|  7Fh  | Remove user   | AL = Appendage code   | AX = 1954h            | Used to remove a user appendage that  |
|       | appendage     | ES = Segment of user  | BL = Code assigned to | was installed using function 7Fh. An  |
|       |               |      appendage entry  |      appendage (same  | error return means that either the    |
|       |               |      point            |      as AL at entry)  | entry point specified in ES:DX did    |
|       |               | DX = Offset of user   | BH = 01h - Operation  | not match the entry point currently   |
|       |               |      appendage entry  |      successful       | in the dispatcher table for the code  |
|       |               |      point            |    = 00h - Operation  | given in AL,  or that no entry for    |
|       |               |                       |      unsuccessful     | the code given in AL currently exits. |
|       |               |                       |                       |                                       |
+-------+---------------+-----------------------+-----------------------+---------------------------------------+

FOSSIL Function Chart,  Version 5,  February 11,  1988                                                     Page 8


Please do not distribute modified versions of this chart.   Also,  please do not distribute this chart without
the accompanying FOSSIL.DOC specification.  Please report any errors or suggested changes to Rick Moore at the
address given on the title page of FOSSIL.DOC.
