UNIT FidoNet;
{ Unit for FidoNet Types, Procedures, & Functions }
{$X+,F+,O+}
INTERFACE

USES Crt,Dos,GenTypes,PckdTime;

CONST
  Months:Array[1..12] of String[3]=('Jan','Feb','Mar','Apr','May','Jun',
                                    'Jul','Aug','Sep','Oct','Nov','Dec');

TYPE
  T20Arr=Array[1..20] of Char;
  T36Arr=Array[1..36] of Char;
  T72Arr=Array[1..72] of Char;
  FidoMsgRec = Record
    From     : T36Arr;
    ToUser   : T36Arr;
    Title    : T72Arr;
    Date     : T20Arr;
    TimeSRead: Word;
    DestNode : Word;
    OrigNode : Word;
    Cost     : Word;
    OrigNet  : Word;
    DestNet  : Word;
    Fill     : Array[1..8] of Byte;
    ReplyTo  : Word;
    Attr     : Word;
    NextReply: Word;
  End;
(*
      dec hex
              .-----------------------------------------------.
        0   0 |                                               |
              ~                 fromUserName                  ~
              |                   36 bytes                    |
              +-----------------------+-----------------------+
       36  24 |                                               |
              ~                  toUserName                   ~
              |                   36 bytes                    |
              +-----------------------+-----------------------+
       72  48 |                                               |
              ~                    subject                    ~
              |                   72  bytes                   |
              +-----------------------+-----------------------+
      144  90 |                                               |
              ~                    dateTime                   ~
              |                    20 bytes                   |
              +-----------------------+-----------------------+
      164  A4 | timesRead (low order) | timesRead (high order)|
              +-----------------------+-----------------------+
      166  A6 | destNode (low order)  | destNode (high order) |
              +-----------------------+-----------------------+
      168  A8 | origNode (low order)  | origNode (high order) |
              +-----------------------+-----------------------+
      170  AA |   cost (low order)    |   cost (high order)   |
              +-----------------------+-----------------------+
      172  AC | origNet (low order)   | origNet (high order)  |
              +-----------------------+-----------------------+
      174  AE | destNet (low order)   | destNet (high order)  |
              +-----------------------+-----------------------+
      176  B0 |                     fill                      |
              ~                    8 bytes                    ~
              +-----------------------+-----------------------+
      184  B8 |  replyTo (low order)  |  replyTo (high order) |
              +-----------------------+-----------------------+
      186  BA | Attribute (low order) | Attribute (high order)|
              +-----------------------+-----------------------+
      188  BC | nextReply (low order) | nextReply (high order)|
              +-----------------------+-----------------------+
      190  BE |                      text                     |
              ~                    unbounded                  ~
              |                 null terminated               |
              `-----------------------------------------------'

      AttributeWord   bit       meaning
                      ---       --------------------
                        0  +    Private
                        1  + s  Crash
                        2       Recd
                        3       Sent
                        4  +    FileAttached
                        5       InTransit
                        6       Orphan
                        7       KillSent
                        8       Local
                        9    s  HoldForPickup
                       10  +    unused
                       11    s  FileRequest
                       12  + s  ReturnReceiptRequest
                       13  + s  IsReturnReceipt
                       14  + s  AuditRequest
                       15    s  FileUpdateReq

                             s - this bit is supported by SEAdog only
                           + - this bit is not zeroed before packeting

      Bits numbers ascend with arithmetic significance of bit position.

      A 'hard' carriage return, 0DH,  marks the end of a paragraph, and must
      be preserved.

      So   called  'soft'  carriage  returns,  8DH,  may  mark  a   previous
      processor's  automatic line wrap, and should be ignored.  Beware  that
      they may be followed by linefeeds, or may not.

*)

PROCEDURE RevertHeader(VAR Header:HeaderRec; FidoMsg:FidoMsgRec);
PROCEDURE ConvertHeader(Header:HeaderRec; VAR FidoMsg:FidoMsgRec; P:Boolean);

IMPLEMENTATION

FUNCTION Strr(I:Integer):String;
VAR S:string;
Begin
  Str(I:2,S);
  If S[1]=#32 then S[1]:='0';
  Strr:=S;
End;

PROCEDURE NT36(S:String; VAR B:T36Arr);
VAR I:Byte;
Begin
  For I:=1 to Length(S) do B[I]:=S[I];
  B[Length(S)+1]:=#0;
End;

PROCEDURE NT20(S:String; VAR B:T20Arr);
VAR I:Byte;
Begin
  For I:=1 to Length(S) do B[I]:=S[I];
  B[Length(S)+1]:=#0;
End;

PROCEDURE NT72(S:String; VAR B:T72Arr);
VAR I:Byte;
Begin
  For I:=1 to Length(S) do B[I]:=S[I];
  B[Length(S)+1]:=#0;
End;

PROCEDURE X36(VAR S:String; B:T36Arr);
VAR I:Byte;
Begin
  S:='';
  I:=1;
  Repeat
    S:=S+B[I];
    Inc(I);
  Until (B[I]=#0);
End;

PROCEDURE X72(VAR S:String; B:T72Arr);
VAR I:Byte;
Begin
  S:='';
  I:=1;
  Repeat
    S:=S+B[I];
    Inc(I);
  Until (B[I]=#0);
End;

PROCEDURE X20(VAR Time:TimeArr; B:T20Arr);
VAR I:Byte; S1:String;
{
01 Jan 86  02:34:56
}
Begin
  Time[2]:=Intt(B[1]+B[2]);
  S1:='';
  For I:=4 to 6 do S1:=S1+Upcase(B[I]);
  If S1='JAN' then Time[1]:=1 else
  If S1='FEB' then Time[1]:=2 else
  If S1='MAR' then Time[1]:=3 else
  If S1='APR' then Time[1]:=4 else
  If S1='MAY' then Time[1]:=5 else
  If S1='JUN' then Time[1]:=6 else
  If S1='JUL' then Time[1]:=7 else
  If S1='AUG' then Time[1]:=8 else
  If S1='SEP' then Time[1]:=9 else
  If S1='OCT' then Time[1]:=10 else
  If S1='NOV' then Time[1]:=11 else
  If S1='DEC' then Time[1]:=12;
  Time[3]:=Intt(B[8]+B[9]);
  Time[4]:=Intt(B[12]+B[13]);
  Time[5]:=Intt(B[15]+B[16]);
  Time[6]:=Intt(B[18]+B[19]);
End;

PROCEDURE RevertHeader(VAR Header:HeaderRec; FidoMsg:FidoMsgRec);
Begin
  X36(Header.From,FidoMsg.From);
  X36(Header.SentTo,FidoMsg.ToUser);
  X72(Header.Title,FidoMsg.Title);
  X20(Header.Sent,FidoMsg.Date);
  Header.Note:='';
  Header.ReplyTo:=0;
  Header.Status:=0;
  SetBit(Header.Status,3,True); { Don't want to send it back over the net! }
End;

PROCEDURE ConvertHeader(Header:HeaderRec; VAR FidoMsg:FidoMsgRec; P:Boolean);
VAR I:Byte; S:String[20]; S1:String[2];
Begin
  NT36(Header.From,FidoMsg.From);
  NT36(Header.SentTo,FidoMsg.ToUser);
  NT72(Header.Title,FidoMsg.Title);
  S:=Strr(Header.Sent[2]);
  S:=S+#32+Months[Header.Sent[1]]+#32#32;
  S:=S+Strr(Header.Sent[4])+':';
  S:=S+Strr(Header.Sent[5])+':';
  S:=S+Strr(Header.Sent[6]);
  NT20(S,FidoMsg.Date);
  FidoMsg.TimesRead:=0;
  FidoMsg.DestNode:=0;
  FidoMsg.OrigNode:=0;
  FidoMsg.Cost:=1;
  FidoMsg.OrigNet:=0;
  FidoMsg.DestNet:=0;
  For I:=1 to 8 do FidoMsg.Fill[I]:=0;
  FidoMsg.ReplyTo:=0;
  If P then FidoMsg.Attr:=1 else FidoMsg.Attr:=0;
  FidoMsg.NextReply:=0;
End;

End.
