unit TimeFunc;

interface

function Time: string;
(* Returns the current Time *)
function Date: string;
(* Returns the current Date *)
function Timer: word;
(* Returns the time (in minutes since midnight) *)
function TimeTill(Time: word): word;
(* Finds the amount of time until Time *)
function TimeBetween(Time1, Time2: word): word;
(* Finds the amount of time between Time1 and Time2 *)

implementation

uses Dos, Common;

function Time: string;
var H, M, S, Hund: word;
    PM: char;
    Min: string;
begin
  PM:='a';
  GetTime(h,m,s,hund);
  if h > 12 then begin h := h - 12; PM:='p'; end;
  if h = 0 then h := 12;
  if m < 10 then min := '0'+v2str(m) else min := v2str(m);
  Time:=v2str(h)+':'+min+pm;
end;

function Date: string;
var Day, Month, Year, DOW: word;
    temp, temp2: string;
begin
  GetDate(Year, Month, Day, DOW);
  temp2:=v2str(year);
  temp[1]:=temp2[3];
  temp[2]:=temp2[4];
  temp[0]:=chr(2);
  Date:=v2str(month)+'/'+v2str(Day)+'/'+temp;
end;

function Timer: word; assembler;
asm
 mov ah, 2Ch
 int 21h
 mov ax, cx
 mov bx, ax
 mov cl, 8
 shr ax, cl
 mov cx, 60
 mul cx
 xor bh, bh
 add ax, bx
end;

function TimeTill(Time: word): word;
var w: word;
begin
  w := timer;
  if time < w then
    time := time + 1440;
  TimeTill := time - w;
end;

function TimeBetween(Time1, Time2: word): word;
begin
  if Time2 < Time1 then
    Time2 := Time2 + 1440;
  TimeBetween := Time2 - Time1;
end;

end.