
uses common;
type
(* Menu Command Record *)
oldmenucommandrec = record
  Description: string[50];
  Default: string[50];
  CMDKey: string[50];
  FString: string[2];
  PString: string[50];
  Access: integer;
  Hidden: boolean;
end;

(* Menu Record *)
oldmenurec = record
  Name: string[8];
  Command: array[0 .. 99] of OldMenuCommandRec;
end;

pao = array[0 .. 99] of oldmenucommandrec;
pan = array[0 .. 99] of menucommandrec;

var
  f1: file of oldmenurec;
  f2: file of menurec;
  t1: oldmenurec;
  t2: menurec;
  c1: ^pao;
  c2: ^pan;
  x: byte;
begin
  new(c1);
  new(c2);
  assign(f1, paramstr(1));
  assign(f2, paramstr(2));
  reset(f1);
  rewrite(f2);
  read(f1, t1);
  close(f1);
  for x := 0 to 99 do
    c1^[x] := t1.command[x];
  for x := 0 to 99 do
    with c1^[x] do
    begin
      c2^[x].Description:=Description;
      c2^[x].Default:=default;
      c2^[x].CMDKey:=CMDKey;
      c2^[x].FString:=FString;
      c2^[x].PString:=PString;
      c2^[x].Access:=v2str(access);
      c2^[x].Hidden:=hidden;
    end;
  t2.name := t1.name;
  for x := 0 to 99 do
    t2.command[x] := c2^[x];
  write(f2, t2);
  close(f2);
  dispose(c1);
  dispose(c2);
end.