program FileSection;

uses Dos, Crt, Common;

type
  filestr = string[12];
  filerec = record
    Filename: string[12];
    size: longint;
  end;
  filelist = array[0 .. 255] of filerec;

var
  choice: char;
  list: ^filelist;
  currfiles: byte;

function exist(Filename: filestr): boolean;
var s: searchrec;
begin
  findfirst(filename,AnyFile,s);
  if doserror = 0 then exist := true else exist := false;
end;

function existl(Filename: filestr): boolean;
var x: byte;
begin
  if currfiles = 0 then begin existl:=false; exit; end;
  for x:= 1 to currfiles do
  begin
    if ToUpper(filename) = ToUpper(list^[x-1].filename) then
    begin
      existl:=true;
      exit;
    end;
  end;
  existl:=false;
end;

procedure Addfile;

procedure GetFile(F: filestr; var frec: filerec);
var s: searchrec;
    t: byte;
    temp: string[3];
begin
  findfirst(f,AnyFile,s);
  if doserror <> 0 then exit;
  frec.filename := s.name;
  frec.size := s.size;
end;

var
  filename: string[12];
  frec: filerec;
begin
  writeln; writeln;
  write('File: ');
  readln(filename);
  if not exist(filename) then begin writeln('File not found.'); delay(1000); exit; end;
  if existl(filename) then begin writeln('File already there!'); delay(1000); exit; end;
  GetFile(filename,frec);
  list^[currfiles]:= frec;
  inc(currfiles);
end;

procedure Deletefile;
procedure FindFile(filename: filestr; var X: byte);
var Y: byte;
begin
  for y:= 0 to 255 do
    if ToUpper(filename) = ToUpper(list^[y].filename) then
    begin
      x:=y;
      exit;
    end;
end;

var filename: filestr;
    x: byte;
    cnt: byte;
begin
  writeln; writeln;
  write('File: ');
  readln(filename);
  if not existl(filename) then begin writeln('File Not Found!'); delay(1000); exit; end;
  findfile(filename,x);
  list^[x].filename:='';
  for cnt := x to 254 do
    if list^[cnt+1].filename <> '' then
    begin
      list^[cnt].filename := list^[cnt+1].filename;
      list^[cnt].size := list^[cnt+1].size;
    end;
  dec(currfiles);
end;

procedure Listfiles;
var b: byte;
begin
  writeln; writeln;
  writeln('File list -');
  if currfiles = 0 then begin writeln('NO FILES YET!'); exit; end;
  for b := 1 to currfiles do
  begin
    writeln('  ',list^[b-1].filename,'     ',list^[b-1].size);
  end;
  writeln; writeln;
  readkey;
end;

var x: byte;

begin
  new(list);
  for x:= 0 to 255 do
    list^[x].filename:='';
  currfiles:=0;
  repeat
    clrscr;
    writeln('A)dd File');
    writeln('D)elete File');
    writeln('L)ist Files');
    writeln;
    write('Your Choice: ');
    choice := readkey;
    case choice of
      'A','a': begin
                 write('Add file');
                 Addfile;
               end;
      'D','d': begin
                 write('Delete file');
                 Deletefile;
               end;
      'L','l': begin
                 write('List files');
                 Listfiles;
               end;
    end;
  until choice = #27
end.