{$V-}
unit Sysop2;

interface

uses Common, Dos, Crt;

procedure SubEditor(PString: str50);
procedure MenuEdit;

implementation

procedure MenuEdit;
var s: string;
    c,c2: char;
    f: file of menurec;
    menu: menurec;
    command: menucommandrec;

procedure ClearMenu;
var x: byte;
begin
  for x := 1 to 99 do
  begin
    with menu.command[x] do
    begin
      description := '';
      cmdkey := '';
      fstring := '';
      pstring := '';
      access := '';
    end;
  end;
end;

procedure PrintMenus;
var sr: searchrec;
begin
  nl;
  nl;
  prtln('MENUS -');
  nl;
  findfirst(systemf.menupath+'*.MNU',AnyFile,sr);
  while doserror = 0 do
  begin
    prt(sr.name + '    ');
    if wherex > 60 then nl;
    findnext(sr);
  end;
end;

procedure LoadMenu(s: string);
begin
  assign(f, systemf.menupath+s+'.MNU');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then begin prtln('File Corrupt!'); exit; end;
  read(f, menu);
  close(f);
end;

procedure WriteStuff(s: string);
begin
  assign(f, systemf.menupath+s+'.MNU');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then begin prtln('File Corrupt!'); exit; end;
  write(f, menu);
  close(f);
end;

procedure Edit(s: string);
const quit: boolean = false;
var c: char;
    xyz: byte;

procedure ListCmds(x1, x2: byte);
var x: byte;
    ss: string[23];
begin
  clearscreen;
  prtln('Menu: '+s+'.MNU');
  prtln('CmdsDescription               CMDKey    FStrPString           Access ');
  prtln('Ĵ');
  for x := x1 to x2 do
  begin
    if x < 100 then
    begin
      ss := menu.command[x].description;
      prt(' '+formatstring(v2str(x),2)+'  '+formatstring(ss,24));
      prt('  '+formatstring(menu.command[x].cmdkey,8));
      prt('  '+formatstring(menu.command[x].fstring,2)+'  ');
      prt(formatstring(menu.command[x].pstring,16)+'  ');
      prtln(formatstring(menu.command[x].access,5)+' ');
    end;
  end;
end;

procedure Prompt;
var c,d: char;
    temp: string;
    ctemp: menucommandrec;
    wurd,wurd2,cnt: byte;
begin
  prt('R)elist,M)ore,S)how,E)dit,D)elete,M(o)ve,Q)uit? ');
  c := getkey;
  case upcase(c) of
    'R': begin
           ListCmds(xyz-21,xyz);
           exit;
         end;
    'M',#13: begin
           if xyz < 100 then ListCmds(xyz, xyz+20) else quit := true;
           xyz := xyz + 21;
           exit;
         end;
    'S': begin
           goxy(1,wherey);
           prt('                                                         ');
           goxy(1,wherey);
           prt('Number? ');
           input1(temp);
           wurd := str2v(temp);
           if wurd < 100 then
           begin
             clearscreen;
             prtln('Number      : '+v2str(wurd));
             prtln('Description : '+menu.command[wurd].description);
             prtln('CMDKey      : '+menu.command[wurd].cmdkey);
             prtln('FString     : '+menu.command[wurd].fstring);
             prtln('PString     : '+menu.command[wurd].pstring);
             prtln('Access      : '+menu.command[wurd].access);
             nl;
             prt('Press a key...');
             temp := getkey;
           end;
         end;
    'E': begin
           prt('Number? ');
           input1(temp);
           wurd := str2v(temp);
           if wurd < 100 then
           begin
             prt('Description: ');
             input1(temp);
             menu.command[wurd].description := temp;
             prt('CMDKey: ');
             input1(temp);
             menu.command[wurd].cmdkey := temp;
             prt('FString: ');
             input1(temp);
             menu.command[wurd].fstring := temp;
             prt('PString: ');
             input1(temp);
             menu.command[wurd].pstring := temp;
             prt('Access: ');
             input1(temp);
             menu.command[wurd].access := temp;
           end;
         end;
    'D': begin
           goxy(1,wherey);
           prt('                                                         ');
           goxy(1,wherey);
           prt('Number? ');
           input1(temp);
           wurd := str2v(temp);
           if wurd < 100 then
           begin
             prt('Delete #'+v2str(wurd)+'? ');
             d := getkey;
             if upcase(d) = 'Y' then
             begin
               menu.command[wurd].description := '';
               menu.command[wurd].cmdkey := '';
               menu.command[wurd].fstring := '';
               menu.command[wurd].pstring := '';
               menu.command[wurd].access := '';
             end;
           end;
         end;
    'O': begin
           goxy(1,wherey);
           prt('                                                         ');
           goxy(1,wherey);
           prt('Number? ');
           input1(temp);
           wurd := str2v(temp);
           prt('To Which Number? ');
           input1(temp);
           wurd2 := str2v(temp);
           if ((wurd < 100) and (wurd2 < 100) and (wurd <> wurd2)) then
           begin
             ctemp := menu.command[wurd];
             if wurd > wurd2 then
               for cnt := wurd downto wurd2+1 do
                 menu.command[cnt] := menu.command[cnt-1]
             else if wurd < wurd2 then
               for cnt := wurd to wurd2-1 do
                 menu.command[cnt] := menu.command[cnt+1];
             menu.command[wurd2] := ctemp;
           end;
         end;
    'Q': begin quit := true; exit; end;
  end;

end;

begin
  quit := false;
  xyz := 0;
  nl; nl;
  if not exist(systemf.menupath+s+'.MNU') then
  begin
    prtln('Menu not found.');
    delay(2000);
    exit;
  end;
  LoadMenu(s);
  ListCmds(xyz,xyz+20);
  xyz := 21;
  repeat Prompt until quit;
end;

begin
  repeat
    clearscreen;
    nl;
    nl;
    PrintMenus;
    nl;
    nl;
    prt('A)dd,D)elete,R)ename,E)dit,Q)uit? ');
    c := getkey;
    case upcase(c) of
      'A': begin
             nl;
             prt('Filename (8 chars ONLY!): ');
             input1(s);
             s := s+'.MNU';
             assign(f, systemf.menupath+s);
             rewrite(f);
             clearmenu;
             write(f, menu);
             close(f);
           end;
      'D': begin
             nl;
             prt('Which Menu? ');
             input1(s);
             s := s+'.MNU';
             assign(f, systemf.menupath+s);
             {$I-} reset(f); {$I+}
             if IOResult <> 0 then
             begin
               prtln('File invalid or missing.');
               delay(2000);
             end else
             begin
               prt('Delete '+s+'? ');
               c2 := Upcase(getkey);
               if c2 = 'Y' then begin close(f); erase(f); end;
             end;
           end;
      'R': begin
             nl;
             prt('Which Menu? ');
             input1(s);
             s := s+'.MNU';
             assign(f, systemf.menupath+s);
             {$I-} reset(f); {$I+}
             if IOResult <> 0 then
             begin
               prtln('File invalid or missing.');
               delay(2000);
             end else
             begin
               prt('New Filename (w/o extension!): ');
               input1(s);
               close(f);
               rename(f, s);
             end;
           end;
      'E': begin
             nl;
             prt('Which Menu? ');
             input1(s);
             clearscreen;
             Edit(s);
             WriteStuff(s);
           end;
    end;
  until upcase(c) = 'Q';
end;

procedure SubEditor(PString: str50);
var
  temp: string;
  x: word;
  c: char;

procedure ShowSubs;
var f: file of subrec;
    s: subrec;
    x: word;
begin
  assign(f, systemf.messagepath+'CONF'+temp+'.DAT');
  reset(f);
  for x := 1 to filesize(f) do
  begin
    read(f, s);
    prtln(' '+expand(v2str(x),3)+' | '+
           expand(s.name,30)+' | '+expand(s.filen,8));
  end;
  close(f);
  nl;
end;

procedure Bar;
begin
  nl;
  prtln(' Num | Sub Name                       | Filename ');
  prtln('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
  ShowSubs;
end;

procedure AddSub;
var f: file of subrec;
    s: subrec;
    t: string[30];
    d: string[8];
begin
  nl;
  prt('Sub Name: ');
  input1(t);
  s.name := t;
  prt('Filename: ');
  input1(d);
  s.filen := d;
  assign(f, systemf.messagepath+'CONF'+temp+'.DAT');
  reset(f);
  s.num := filesize(f) + 1;
  seek(f, filesize(f));
  write(f,s);
  close(f);
end;

procedure DeleteSub;
var f: file of subrec;
    s: subrec;
    x: word;
    t: string;
begin
  nl;
  prt('Number: ');
  input1(t);
  x := str2v(t);
  assign(f, systemf.messagepath+'CONF'+temp+'.DAT');
  reset(f);
  if x <> filesize(f)  then
  begin
    while x <> filesize(f) do
    begin
      seek(f, x);
      read(f, s);
      seek(f, x - 1);
      write(f, s);
      inc(x);
    end;
    seek(f, x - 1);
    truncate(f);
  end else
  begin
    seek(f, x - 1);
    truncate(f);
  end;
  close(f);
end;

procedure ModifySub;
var f: file of subrec;
    s: subrec;
    t: string;
    x: word;
begin
  nl;
  prt('Number: ');
  input1(t);
  x := str2v(t);
  assign(f, systemf.messagepath+'CONF'+temp+'.DAT');
  reset(f);
  seek(f, x - 1);
  read(f, s);
  prtln('Sub Name: '+s.name);
  prt('New Name: ');
  input1(t);
  s.name := t;
  prtln('Filename: '+s.filen);
  prt('New filename: ');
  input1(t);
  s.filen := t;
  seek(f, x - 1);
  write(f, s);
  close(f);
end;

procedure InsertSub;
var f: file of subrec;
    s: subrec;
    t: string;
    x,z: word;
begin
  nl;
  prt('Before: ');
  input1(t);
  x := str2v(t);
  assign(f, systemf.messagepath+'CONF'+temp+'.DAT');
  reset(f);
  z := filesize(f);
  while z >= x do
  begin
    seek(f, z - 1);
    read(f, s);
    write(f, s);
    dec(z);
  end;
  prt('Sub Name: ');
  input1(t);
  s.name := t;
  prt('Filename: ');
  input1(t);
  s.filen := t;
  seek(f, x - 1);
  write(f, s);
  close(f);
end;

procedure MoveSub;
var f: file of subrec;
    s,s2: subrec;
    t: string;
    x,z,y,a: word;
begin
  nl;
  prt('Number: ');
  input1(t);
  y := str2v(t);
  prt('Before: ');
  input1(t);
  a := str2v(t);
  assign(f, systemf.messagepath+'CONF'+temp+'.DAT');
  reset(f);
  seek(f, y - 1);
  read(f, s2);
  x := y;
  if x <> filesize(f)  then
  begin
    while x <> filesize(f) do
    begin
      seek(f, x);
      read(f, s);
      seek(f, x - 1);
      write(f, s);
      inc(x);
    end;
    seek(f, x - 1);
    truncate(f);
  end else
  begin
    seek(f, x - 1);
    truncate(f);
  end;
  z := filesize(f);
  if y < x then dec(a);
  while z >= a do
  begin
    seek(f, z - 1);
    read(f, s);
    write(f, s);
    dec(z);
  end;
  s.name := s2.name;
  s.filen := s2.filen;
  seek(f, a - 1);
  write(f, s);
  close(f);
end;

begin
  clearscreen;
  nl; nl;
  if PString = '' then
  begin
    prt('Conference: ');
    input1(temp);
    x := str2v(temp);
  end else
    x := str2v(PString);
  repeat
    Bar;
    prt('SubEdit: ');
    c := Upcase(Getkey);
    prtln(c);
    case c of
      'A': AddSub;
      'D': DeleteSub;
      'E': ModifySub;
      'Q': exit;
      'I': InsertSub;
      'M': MoveSub;
    end;
  until 1 < 1;
end;

end.