{$M 50000,0,32767}
{$O+}
(****************************************************************************
 ** UNIT: Setup1.Pas                                                       **
 ** PURPOSE: To general implement the setup functions contained in the     **
 **          other units, to run the setup program built into Onyx.        **
 ****************************************************************************)


unit Setup1;

interface

procedure Setup;
(* Runs the BBS Setup *)

implementation

uses Dos, Crt, Common, DataFunc, Setup2, Setup3;

procedure Setup;
var
  TF: file of subrec;
  CF: file of ConfInfoRec;
  M: file of Modemrec;
  H: file of HistoryRec;
  F: file of SystemRec;
  U: file of UserRec;
  S: file of StringRec;
  menu: menubar;
  i: integer;
  b: byte;
  c: char;
  Directory: string;
  ctemp: confinforec;
  tempsub: subrec;

begin
  textbackground(black);
  textcolor(white);
  clrscr;
  cursoroff;
  assign(f,'setup.dat');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    MessageBox('Creating/Fixing SETUP.DAT...');
    GetYDefaults(systemf);
    rewrite(f);
    write(f,systemf);
    close(f);
  end else
  begin
    read(f, systemf);
    close(f);
  end;
  assign(m, systemf.datapath+'modem.dat');
  {$I-} reset(m); {$I+}
  if IOResult <> 0 then
  begin
    MessageBox('Creating/Fixing MODEM.DAT...');
    GetMDefaults(modemf);
    rewrite(m);
    write(m, modemf);
    close(m);
  end else
  begin
    read(m, modemf);
    close(m);
  end;
  assign(h, systemf.datapath+'history.dat');
  {$I-} reset(h); {$I+}
  if IOResult <> 0 then
  begin
    MessageBox('Creating/Fixing HISTORY.DAT');
    GetHDefaults(historyf);
    rewrite(h);
    write(h, historyf);
    close(h);
  end else
  begin
    read(h, historyf);
    close(h);
  end;
  assign(u, systemf.datapath+'user.lst');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then
  begin
    MessageBox('Creating/Fixing USER.LST...');
    GetUDefaults(thisuser);
    rewrite(U);
    write(u, thisuser);
    close(u);
  end;
  assign(s, systemf.datapath+'string.dat');
  {$I-} reset(s); {$I+}
  if IOResult <> 0 then
  begin
    MessageBox('Creating/Fixing STRING.DAT...');
    GetSDefaults(stringf);
    rewrite(s);
    write(s,stringf);
    close(s);
  end else
  begin
    read(s, stringf);
    close(s);
  end;
  assign(tf, systemf.datapath+'EMAIL.DAT');
  {$I-} reset(tf); {$I+}
  if IOResult <> 0 then
  begin
    MessageBox('Creating/Fixing EMAIL.DAT...');
    GetEMailDefaults(tempsub);
    rewrite(tf);
    write(tf, tempsub);
    close(tf);
  end;
  I:=1;
  repeat
    textbackground(black);
    clrscr;
    i := where(1,7,3,8,False,i);
    case i of
      1: Misc(systemf);
      2: Paths(systemf);
      3: Modem(modemf);
      4: Conf(systemf);
    end;
    reset(f);
    write(f,systemf);
    close(f);
    reset(m);
    write(m,modemf);
    close(m);
    reset(h);
    write(h,historyf);
    close(h);
  until i > 6;
  MessageBox('Writing SETUP.DAT...');
  Rewrite(F);
  Write(F,SystemF);
  Close(F);
  MessageBox('Writing MODEM.DAT...');
  Rewrite(M);
  Write(M,ModemF);
  Close(M);
  MessageBox('Writing HISTORY.DAT...');
  Rewrite(H);
  Write(H,HistoryF);
  Close(H);
  if systemf.useconfs then
  begin
    MessageBox('Writing Conferences...');
    assign(cf, systemf.messagepath+'GLOBAL.MAP');
    rewrite(cf);
    with systemf do
    begin
      for b := 1 to 5 do
      begin
        if useconf[b] then
        begin
          assign(tf, systemf.messagepath+'CONF'+v2str(b)+'.DAT');
          {$I-} reset(tf); {$I+}
          if IOResult <> 0 then rewrite(tf);
          tempsub.name := 'General';
          tempsub.num := 1;
          tempsub.filen := 'GENERAL';
          write(tf, tempsub);
          close(tf);
          ctemp.mname := confa[b];
          ctemp.maccess := '';
          ctemp.fname := confb[b];
          ctemp.faccess := '';
          ctemp.num := 1;
          write(cf, ctemp);
        end;
      end;
    end;
    close(cf);
  end;
  clrscr;
  halt(0);
end;

end.
