unit NewUser;

interface

uses Common, DataFunc;

procedure GetNewUser(var User: userrec);
(* Sets up a new user *)

implementation

procedure GenRandomPass(var S: string);
var x, c, y: byte;
begin
  s := '';
  for x := 1 to random(6)+5 do
  begin
    if random(4) = 1 then
      c := random(10) + 48
    else
      c := random(26) + 65;
    s := s + chr(c);
  end;
end;

procedure GetNewUser(var User: userrec);
var s: string;
    c: char;
begin
  printansi('SYSINFO');
  pause;
  printansi('NEWUSER');
  pause;

  repeat
    nl;
    prt(stringf.newusername);
    input3(s, 30);
    thisuser.handle := s;
    FindUserName(s);
    if s <> '' then
    begin
      prtln(stringf.alreadyuser);
      exit;
    end;
    if thisuser.handle = '' then
    begin
      nl;
      prtln(stringf.handlebad);
    end;
  until thisuser.handle <> '';
  if CheckBlackLst(thisuser.handle) then
  begin
    printansi('BLACKLST.ANS');
    hangup;
    exit;
  end;

  repeat
    nl;
    prt(stringf.realname);
    input3(s, 50);
    if s = '' then
    begin
      nl;
      prtln(stringf.realnamebad);
    end;
  until s <> '';
  thisuser.realname := s;
  if CheckBlackLst(thisuser.realname) then
  begin
    printansi('BLACKLST.ANS');
    hangup;
    exit;
  end;

  c := #0;
  repeat
    if ToUpper(c) = 'M' then nl;
    nl;
    GenRandomPass(s);
    prtln(stringf.randpass+s);
    prt(stringf.userandpass);
    repeat
      c := getkey;
    until c in ['Y','y','N','n','M','m'];
  until not (c in ['M','m']);
  prt(c);
  nl;
  if ToUpper(c) = 'Y' then
    thisuser.password := s
  else
  repeat
    nl;
    prt(stringf.desiredpw);
    input3(s, 15);
    thisuser.password := s;
    if (length(s) < 4) then
    begin
      nl;
      prtln(stringf.dpassshort);
    end;
    if (s = thisuser.handle) or (s = thisuser.realname) then
    begin
      nl;
      prtln(stringf.dpassinvalid);
    end;
  until (length(s) > 3) and (s <> thisuser.handle) and
        (s <> thisuser.realname);

  repeat
    nl;
    prtln(stringf.phonenum1);
    prtln(stringf.phonenum2);
    phoneinput(s);
    if not NumValid(s) then
    begin
      nl;
      prtln(stringf.phonebad);
    end;
  until NumValid(s);
  thisuser.voicenum := s;

  repeat
    nl;
    prtln(stringf.datanum1);
    prtln(stringf.datanum2);
    phoneinput(s);
    if not NumValid(s) then
    begin
      nl;
      prtln(stringf.databad);
    end;
  until NumValid(s);
  thisuser.datanum := s;

  repeat
    nl;
    prt(stringf.address1);
    input3(s, 50);
    if s = '' then
    begin
      nl;
      prtln(stringf.addressbad);
    end;
  until s <> '';
  thisuser.address1 := s;

  repeat
    prt(stringf.address2);
    input3(s, 50);
    if s = '' then
    begin
      nl;
      prtln(stringf.addressbad);
    end;
    nl;
  until s <> '';
  thisuser.address2 := s;

  c := #0;
  repeat
    if c <> #0 then nl;
    prt(stringf.sex);
    c := getkey;
  until c in ['M','m','F','f'];
  if Upcase(c) = 'M' then prtln('Male') else prtln('Female');
  thisuser.sex := Upcase(c);

  repeat
    nl;
    prt(stringf.birthday);
    dateinput(s);
  until DateValid(s);


  AddUser(thisuser);

  prtln('Press a key...');
  getkey;
end;

end.