{$V-}
unit Message3;

interface

uses Common, Crt;

procedure WriteMsg(Sub: Subrec; Info: Inforec);

implementation

procedure WriteMsg(Sub: Subrec; Info: Inforec);
var
  F1: file of indexrec;
  F2: file of byte;
  ndx: indexrec;
  X, X1, Lcount, X2: byte;
  loc, LSpace, Line, T1: longint;
  Words: string;
  c: char;
  Saving: boolean;
  Ofs: byte;

  procedure Quoter(Loc, N2Q: LongInt);
  var
    LC: byte;
    qndx: indexrec;
    xx,xxx,startq, endq, qloc,cnt: longint;
    Size: integer;
    F3: file of char;
    temp: string;

    procedure ReadFile(var Pos: longint; var S: string);
    var c: char;
    begin
      assign(F3,systemf.messagepath+sub.filen+'.SUB');
      {$I-} reset(F3); {$I+}
      if IOResult <> 0 then {error} exit;
      s := '';
      seek(f3, pos);
      read(f3, c);
      inc(pos);
      while (c <> #13) and (c <> #10) do
      begin
        s := s + c;
        read(f3, c);
        inc(pos);
      end;
      inc(pos);
      close(f3);
    end;

    procedure Write2File(s: string);
    var
      cnt, t: byte;
    begin
      seek(f2, filesize(f2));
      for cnt := 1 to length(s) do
      begin
        t := ord(s[cnt]);
        write(f2, t);
      end;
    end;

  begin
    seek(f1, N2Q - 1);
    read(f1, QNdx);
    seek(f1, filesize(f1));
    write2file('Start Quote'#13#10);
    cnt := 0;
    size := qndx.msglen;
    qloc := qndx.msgloc;
    nl;
    prtln('Lines to quote: ');
    nl;
    xx := qloc;
    repeat
      readfile(qloc, temp);
      inc(cnt);
      prtln(v2str(cnt)+': '+temp);
    until (qloc >= xx + size);
    nl;
    prt('Start Quoting From: ');
    input1(temp);
    if str2v(temp) <= cnt then
      startq := str2v(temp)
    else
      startq := 1;
    prt('Stop Quoting At: ');
    input1(temp);
    if str2v(temp) <= cnt then
      endq := str2v(temp)
    else
      endq := cnt;
    nl;
    qloc := qndx.msgloc;
    for xxx := 1 to startq-1 do
      readfile(qloc, temp);
    for xxx := startq to endq do
    begin
      readfile(qloc, temp);
      write2file(temp+#13#10);
    end;
    Write2File('End Quote'#13#10);
  end;

procedure InfoMation;
begin
  ClearScreen;
  if info.title = '' then
  begin
    prt('[Title]: ');
    input1(ndx.title);
    if ndx.title='' then
    begin
      nl; nl;
      prtln('Aborted!');
      exit;
    end;
  end else
    ndx.title := info.title;
  if info.whoto = '' then
  begin
    prt('[To]: ');
    input1(ndx.whoto);
    if ndx.whoto = '' then
    begin
      ndx.whoto := 'All';
    end;
  end else
    ndx.whoto := info.whoto;
  prt('Anonymous? ');
  if (upcase(GetKey) = 'Y') then
    ndx.from:=stringf.anonymous
  else
    ndx.from:=thisuser.handle;
  nl;
  nl;
end;

{--------------------------------Header?-------------------------------------}

procedure Header;
var
  x: byte;
  f: file of messageheaderrec;
  mh: messageheaderrec;
begin
  ClearScreen;
  assign(f, systemf.datapath+'MESSHEAD.DAT');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('MESSHEAD.DAT missing or invalid!');
    ofs := wherey;
    exit;
  end;
  seek(f, thisuser.msgheadertype - 1);
  read(f, mh);
  printansi(mh.filename);
  close(f);
  ofs := wherey;
  nl;
end;

{------------------------Main-Get-Message-Procedure--------------------------}

begin
  assign(f1, systemf.messagepath+sub.filen+'.NDX');
  assign(f2, systemf.messagepath+sub.filen+'.SUB');
  {$I-} reset(f1); {$I+}
  if IOResult <> 0 then
    rewrite(f1);
  {$I-} reset(f2); {$I+}
  if IOResult <> 0 then
    rewrite(f2);

  InfoMation;

  seek(f2, filesize(f2));
  loc := filepos(f2);
  words := '';

  Header;
  Saving := False;
  LCount := 0;
  Line := 0;
  LSpace := filepos(f2) + 1;

  repeat
    c := GetKey;
    case c of
{---------------------------Backspace---------------------------------}
      #8: if (LCount > 0) then
          begin
            prt(#8#32#8);
            seek(f2, filesize(f2) - 1);
            truncate(f2);
            dec(LCount);
            words[0] := chr(ord(words[0]) - 1);
          end else if (Line > 0) and (LCount = 0) then
          begin
            seek(f2, filesize(f2) - 1);
            read(f2, x2);
            if x2 = 10 then
              seek(f2, filesize(f2) - 3)
            else if x2 = 13 then
              seek(f2, filesize(f2) - 2)
            else
              seek(f2, filesize(f2) - 1);
            truncate(f2);
            t1 := filesize(f2);
            words := '';
            x := 0;
            LSpace := 0;
            repeat
              dec(t1);
              inc(x);
              seek(f2, t1);
              read(f2, x2);
              if (x2 <> 32) and (LSpace = 0) then
                insert(char(x2), words, 1)
              else if LSpace = 0 then
                LSpace := T1;
            until (x2 = 10) or (t1 = loc) or (x2 = 13);
            if (x2 = 10) or (x2 = 13) then
            begin
              delete(words, 1, 1);
              LSpace := t1 + 1;
              dec(x);
            end else if t1 = loc then
              LSpace := t1 + 1;
            dec(Line);
            LCount := x;
            GoXY(x + 1, Line + ofs);
            prt(' ');
            GoXY(x + 1, Line + ofs);
          end;
{!--------------------------------Enter------------------------------------}
      #13: begin
             x := 13;
             write(f2, x);
             x := 10;
             write(f2, x);
             nl;
             LCount := 0;
             inc(Line);
             LSpace := filepos(f2) + 1;
             words := '';
           end;
{!-------------------------Space-Bar---------------------------}
      #32: begin
             x := ord(c);
             write(f2, x);
             prt(c);
             LSpace := filepos(f2) - 1;
             inc(LCount);
             words := '';
             if LCount = 80 then
             begin
               LCount := 0;
               LSpace := filepos(f2) + 1;
               inc(Line);
             end;
           end;
{!----------------------------'/'-Sequence----------------------------------}
      #47: begin
             if LCount = 0 then
             begin
               GoXY(1, Line + ofs + 3);
               prt('|D[|WA|D]');
               prt('|wborts ');
               prt('|D[|WS|D]');
               prt('|waves ');
               prt('|D[|WQ|D]');
               prt('|wuotes: ');
               c := GetKey;
               case upcase(c) of
                 'Q': quoter(filepos(f2), info.numto);
                 'S': Saving := true;
                 'A': begin
                        seek(f2, Loc+1);
                        truncate(f2);
                        close(f1);
                        close(f2);
                        prtln('Message Aborted...');
                        exit;
                      end;
                 else
                 begin
                   GoXY(1, Line + ofs + 3);
                   prt('                             ');
                   GoXY(1, Line + ofs);
                 end;
               end;
             end else
             begin
               x := ord(c);
               write(f2, x);
               prt(c);
               inc(LCount);
               words := words + c;
             end;
           end;
{!---------------------------Normal-Characters-------------------------------}
      #33..#46,#48..#254: begin
                            inc(LCount);
                            x := ord(c);
                            if (LCount = 80) and (Length(words) < 35) then
                            begin
                              words := words + c;
                              seek(f2, LSpace);
                              truncate(f2);
                              x := 13;
                              write(f2, x);
                              x := 10;
                              write(f2, x);
                              LSpace := filepos(f2) + 1;
                              for x := 1 to length(words) do
                              begin
                                prt(#8#32#8);
                                x1 := ord(words[x]);
                                write(f2, x1);
                              end;
                              nl;
                              prt(words);
                              LCount := length(words);
                              inc(Line);
                            end
                            else if (LCount = 80) and
                                    (length(words) >= 35) then
                            begin
                              write(f2, x);
                              x := 13;
                              write(f2, x);
                              prt(c);
                              LCount := 0;
                              inc(Line);
                              words := '';
                              LSpace := filesize(f2) + 1;
                            end else
                            begin
                              write(f2, x);
                              prt(c);
                              words := words + c;
                            end;
                          end;
    end;
  until Saving;
  nl;

{save message length to ndx.msglen and message position to ndx.msgloc}
  ndx.msglen := filepos(f2)-loc;
  if ndx.msglen > 0 then
  begin
    ndx.msgloc := loc;
    seek(f1, filesize(f1));
    write(f1, ndx);
  end else
  begin
    prtln('Message Blank!!!!!');
  end;
  close(f1);
  close(f2);
end;

end.