{$V-}
unit Message2;

interface

uses common;

procedure LoadNDX(var NDX: indexrec; num: longint);
function NumNDX: longint;
procedure LoadConf(var Conf: confinforec; num: longint);
function NumConf: longint;
function ConfExist(num: longint): boolean;
procedure LoadSub(var Sub: subrec; num: longint);
function NumSub: longint;

implementation

uses message1;

procedure LoadNDX(var NDX: indexrec; num: longint);
var f: file of indexrec;
begin
  assign(f, systemf.messagepath+currsub[thisuser.confon].filen+'.NDX');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error opening: '+currsub[thisuser.confon].filen+'.NDX!');
    exit;
  end;
  if num >= filesize(f) then num := filesize(f)-1;
  if num < 0 then num := 0;
  seek(f, num);
  {$I-} read(f, ndx); {$I+}
  close(f);
end;

function NumNDX: longint;
var f: file of indexrec;
    l: longint;
begin
  assign(f, systemf.messagepath+currsub[thisuser.confon].filen+'.NDX');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error opening: '+currsub[thisuser.confon].filen+'.NDX!');
    exit;
  end;
  l := filesize(f);
  close(f);
  NumNDX := l;
end;

procedure LoadConf(var Conf: confinforec; num: longint);
var f: file of confinforec;
begin
  assign(f, systemf.messagepath+'GLOBAL.MAP');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error opening: GLOBAL.MAP');
    exit;
  end;
  if num >= filesize(f) then num := filesize(f)-1;
  if num < 0 then num := 0;
  seek(f, num);
  {$I-} read(f, Conf); {$I+}
  close(f);
end;

function NumConf: longint;
var f: file of confinforec;
    l: longint;
begin
  assign(f, systemf.messagepath+'GLOBAL.MAP');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error opening: GLOBAL.MAP');
    exit;
  end;
  l := filesize(f);
  close(f);
  NumConf := l;
end;

function ConfExist(num: longint): boolean;
var f: file of subrec;
    t: boolean;
begin
  assign(f, systemf.messagepath+'CONF'+v2str(num)+'.DAT');
  {$I-} reset(f); {$I+}
  t := IOResult = 0;
  if t then close(f);
  ConfExist := t;
end;

procedure LoadSub(var Sub: subrec; num: longint);
var f: file of subrec;
begin
  assign(f, systemf.messagepath+'CONF'+v2str(thisuser.confon)+'.DAT');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error opening: CONF'+v2str(thisuser.confon)+'.DAT');
    exit;
  end;
  if num >= filesize(f) then num := filesize(f)-1;
  if num < 0 then num := 0;
  seek(f, num);
  {$I-} read(f, Sub); {$I+}
  close(f);
end;

function NumSub: longint;
var f: file of subrec;
    l: longint;
begin
  assign(f, systemf.messagepath+'CONF'+v2str(thisuser.confon)+'.DAT');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error opening: CONF'+v2str(thisuser.confon)+'.DAT');
    exit;
  end;
  l := filesize(f);
  close(f);
  NumSub := l;
end;

end.