{$V-}
unit Message1;

interface

uses Common, Message2, Message3;

const
  messnum: longint = 0;

var
  currsub: array[1 .. 5] of subrec;

procedure MessageCmd(FString: str2; PString: str50; Access: ACS;
                     result: boolean);
procedure InitMSubs;

implementation

procedure InitMSubs;
var x,y,ct: byte;
    temp: subrec;
    ctemp: confinforec;
begin
  ct := thisuser.confon;
  if systemf.useconfs then
  begin
    for x := 1 to NumConf do
    begin
      if ConfExist(x) then
      begin
        thisuser.confon := x;
        for y := 1 to NumSub do
        begin
          LoadSub(temp, y - 1);
          if Access(thisuser, temp.readsec) then
            currsub[x] := temp;
        end;
      end;
    end;
  end;
  thisuser.confon := ct;
end;

procedure AreaChange(PString: str50);
var
  temp: subrec;
  x: word;
  temp2: string;
begin
  temp := currsub[thisuser.confon];

  if PString = '' then
  begin
    prtln('Message Subs - ');
    nl;
    for x := 0 to NumSub - 1 do
    begin
      LoadSub(temp, x);
      if Access(thisuser, temp.ReadSec) then
        prtln('['+v2str(temp.num)+'] '+temp.name);
    end;
    nl;
    prt('Which? ');
    input1(temp2);
    if ((0 < str2v(temp2)) and (str2v(temp2) <= NumSub)) then
      pstring := temp2
    else
      prtln('Invalid Sub');
  end else
  begin
    x := str2v(PString);
    if x = 0 then
      exit;
    if x > NumSub then
      prtln('Invalid Sub')
    else
    begin
      LoadSub(temp, x - 1);
      if Access(thisuser, temp.ReadSec) then
        currsub[thisuser.confon] := temp;
    end;
  end;
end;

procedure GlobScan;
begin
end;

procedure JumpConf(PString: str50);
var temp: byte;
    temp2: string;
    ctemp: confinforec;
begin
  if not systemf.useconfs then
  begin
    prt('Conferences NOT enabled!');
    exit;
  end;

  if PString = '' then
  begin
    prtln('Conferences -');
    nl;
    for temp := 1 to NumConf do
    begin
      if ConfExist(temp) then
      begin
        LoadConf(ctemp, temp - 1);
        if systemf.useconf[temp] and Access(thisuser, ctemp.MAccess) then
        begin
          prt('  ');
          prtln('['+v2str(temp)+'] '+systemf.confa[temp]);
        end;
      end;
    end;
    nl;
    prt('Jump to? ');
    input1(temp2);
    if ((0 < str2v(temp2)) and (str2v(temp2) <= NumConf)) then
      pstring := temp2
    else
      prtln('Invalid Conference');
  end;
  if pstring[1] in ['1' .. '5'] then
  begin
    temp := str2v(pstring[1]);
    if ConfExist(temp) then
    begin
      LoadConf(ctemp, temp - 1);
      if not Access(thisuser, ctemp.MAccess) then
        prtln('|WYou can''t access conference '+pstring+'!')
      else
        thisuser.confon := temp;
     end else
       prtln('Bad Conference');
  end else prtln('Bad Conference');
end;

procedure QuikScan; forward;

procedure NewScan;
var x: word;
    sub: subrec;
begin
  for x := 1 to NumSub do
  begin
    LoadSub(sub, x - 1);
    currsub[thisuser.confon] := sub;
    QuikScan;
  end;
end;

procedure ReadMessage(PString: str50);
var num,x: longint;
    temp: string;
    ndx: indexrec;
    f: file of char;
    c: char;
begin
  if Pstring <> '' then
    num := str2v(Pstring)
  else
  begin
    num := thisuser.lastread[thisuser.confon][currsub[thisuser.confon].num];
  end;
  if (num <= 0) or (num > NumNDX) then
  begin
    prtln('Message ain''t there!');
    exit;
  end;
  LoadNdx(ndx, num-1);
  assign(f, systemf.messagepath+currsub[thisuser.confon].filen+'.SUB');
  prtln('Title: '+ndx.title);
  prtln('From: '+ndx.from);
  prtln('To: '+ndx.whoto);
  nl;
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Can''t read that one!');
    exit;
  end;
  seek(f, ndx.msgloc);
  for x := 1 to ndx.msglen do
  begin
    read(f, c);
    Prt(c);
  end;
  close(f);
  nl;
  thisuser.lastread[thisuser.confon][currsub[thisuser.confon].num] := num;
  messnum := num;
  prt('('+v2str(num)+') of (50): ');
  getkey;
end;

procedure Scan;
var oldndx,ndx: indexrec;
    x: longint;
    s: string;
begin
  prtln('Next Ten Message Titles: ');
  for x := 1 to 10 do
  begin
    loadndx(ndx, messnum + x);
    if oldndx.msgloc <> ndx.msgloc then
    begin
      prtln('('+v2str(messnum + x)+') '+ndx.title);
      oldndx := ndx;
    end;
  end;
  nl;
  prt('Which? ');
  input1(s);
  messnum := str2v(s);
end;

procedure Post(PString: str50);
var
  temp1, temp2: str50;
  info: inforec;
begin
  {check post access}
  info.whoto := '';
  info.title := '';
  if PString <> '' then
  begin
    temp1 := PString;
    delete(temp1,pos(';',temp1),length(temp1) - pos(';',temp1) + 1);
    temp2 := PString;
    delete(temp2, 1, pos(';',temp2));
    info.title := temp1;
    info.whoto := temp2;
  end;
  info.numto := 0;
  writemsg(currsub[thisuser.confon], info);
end;

procedure QuikScan;
var x,y: word;
begin
  y := 0;
  nl;
  prtln('QuickScanning - '+currsub[thisuser.confon].name+'...');
  for x := thisuser.lastread[thisuser.confon][currsub[thisuser.confon].num]+1
      to NumNDX do
  begin
    readmessage(v2str(x));
    inc(y);
  end;
  if y = 0 then prtln('No new messages...');
  prtln('QuickScan Done.');
  nl;
end;

procedure Upload;
begin
end;

procedure Reply(PString: str50);
var
  ndx: indexrec;
  info: inforec;
begin
  {check post access}
  if (PString = '') then
    info.numto := messnum
  else
    info.numto := str2v(PString);
  if info.numto = 0 then info.numto := messnum;
  LoadNDX(ndx, info.numto);
  info.whoto := ndx.from;
  info.title := 'RE: '+ndx.title;
  writemsg(currsub[thisuser.confon], info);
end;

procedure MessageCmd(FString: str2; PString: str50; Access: ACS;
                     result: boolean);
begin
  case FString[2] of
    'A': AreaChange(PString);
    'G': GlobScan;
    'J': JumpConf(PString);
    'N': Newscan;
    'P': Post(PString);
    'Q': QuikScan;
    'R': ReadMessage(PString);
    'S': Scan;
    'U': Upload;
    'W': Reply(PString);
  end;
end;

end.
