unit Menu2;

interface

procedure SaveScreen;
procedure SetupMainMenu;
procedure MenuStuff;
procedure RestoreScreen;

implementation

uses Crt, Common;

type
  hmenubar = object
    Selections: array[1 .. 20] of string;
    procedure AddSelection(X: byte; S: string);
    procedure Highlight(X: byte);
    procedure Unhighlight(X: byte);
  end;
  vmenubar = object
    Len: byte;
    XLoc: byte;
    Selections: array[1 .. 20] of string;
    Buff: array[1 .. 20,1..20] of byte;
    procedure AddSelection(X: byte; S: string);
    procedure Highlight(X: byte);
    procedure Unhighlight(X: byte);
    procedure DrawBox(Y: byte);
    procedure EraseBox;
    procedure GetBuff(Y: byte);
    procedure PutBuff(Y: byte);
  end;
  dump = array[0 .. 3999] of byte;
  pdump = ^dump;

var
  Main: hmenubar;
  User: vmenubar;
  ScrDump: pdump;

procedure hmenubar.AddSelection(X: byte; S: string);
begin
  Selections[x] := s;
  gotoxy((16*(x-1))+10,1);
  textbackground(white);
  write(selections[x]);
end;

procedure hmenubar.Highlight(X: byte);
begin
  gotoxy((16*(x-1))+10,1);
  textcolor(white);
  write(selections[x]);
  textcolor(black);
  textbackground(white);
end;

procedure hmenubar.Unhighlight(X: byte);
begin
  gotoxy((16*(x-1))+10,1);
  textbackground(white);
  textcolor(black);
  write(selections[x]);
end;

procedure vmenubar.AddSelection(X: byte; S: string);
begin
  Selections[x] := s;
  gotoxy(XLoc-1,3+(x-1));
  textcolor(black);
  textbackground(white);
  write(selections[x]);
end;

procedure vmenubar.Highlight(X: byte);
begin
  gotoxy(xloc-1,3+(x-1));
  textcolor(white);
  write(selections[x]);
  textcolor(black);
  textbackground(white);
end;

procedure vmenubar.Unhighlight(X: byte);
begin
  gotoxy(xloc-1,3+(x-1));
  textbackground(white);
  textcolor(black);
  write(selections[x]);
end;

procedure vmenubar.DrawBox(Y: byte);
var xx: byte;
begin
  len := y;
  GetBuff(Y);
  gotoxy(xloc-3,2);
  write('Ŀ');
  for xx := 1 to y-2 do
  begin
    gotoxy(xloc-3,3+(xx-1));
    write('        ');
  end;
  gotoxy(xloc-3,6+(xx-3));
  write('');
end;

procedure vmenubar.EraseBox;
begin
  PutBuff(len);
end;

procedure vmenubar.GetBuff(Y: byte);
var x,z,a: word;
begin
  for z := 1 to y do
  begin
    a := 1;
    for x := (z*160)+((xloc-4)*2) to (z*160)+((xloc+6)*2)-1 do
    begin
      buff[z][a]:=mem[$b800:x];
      inc(a);
    end;
  end;
end;

procedure vmenubar.PutBuff(Y: byte);
var x,z,a: word;
begin
  for z := 1 to y do
  begin
    a := 1;
    for x := ((z)*160)+((xloc-4)*2) to ((z)*160)+((xloc+6)*2)-1 do
    begin
      mem[$b800:x]:=buff[z][a];
      inc(a);
    end;
  end;
end;

procedure SaveScreen;
var f: file;
begin
  assign(f, '##@@!!&&.~l~');
  rewrite(f, 1);
  blockwrite(f, screenadr, 4000);
  close(f);
end;

procedure SetupMainMenu;
begin
  gotoxy(1,1);
  textcolor(black);
  textbackground(white);
  clreol;
  main.AddSelection(1,'User');
  main.AddSelection(2,'Chats');
  main.AddSelection(3,'asdf');
  main.AddSelection(4,'asdfasdfafasf');
  main.highlight(1);
end;

procedure MenuStuff;

  procedure DoStuff(X: byte);

    procedure SetupStuff(X: byte);
    begin
      case x of
        1: begin
             user.xloc := 10;
             user.drawbox(5);
             user.addselection(1, ' Edit');
             user.addselection(2, 'Delete');
             user.addselection(3, ' Boot');
             user.highlight(1);
           end;
        2: begin
             user.xloc := 26;
             user.drawbox(10);
             user.addselection(1, ' Edit');
             user.addselection(2, 'Delete');
             user.addselection(3, ' Boot');
             user.highlight(1);
           end;
        3: begin
             user.xloc := 42;
             user.drawbox(5);
             user.addselection(1, ' Edit');
             user.addselection(2, 'Delete');
             user.addselection(3, ' Boot');
             user.highlight(1);
           end;
        4: begin
             user.xloc := 58;
             user.drawbox(5);
             user.addselection(1, ' Edit');
             user.addselection(2, 'Delete');
             user.addselection(3, ' Boot');
             user.highlight(1);
           end;
      end;
    end;

  var c: char;
      x2: byte;
      exitthen: boolean;

  begin
    exitthen := false;
    SetupStuff(X);
    x2:=1;
    repeat
      c := readkey;
      case c of
        #0: begin
              c := readkey;
              case c of
                #72: begin
                       user.Unhighlight(x2);
                       if x2 = 1 then x2:= 3 else dec(x2);
                       user.Highlight(x2);
                     end;
                #75: begin
                     end;
                #77: begin
                     end;
                #80: begin
                       user.Unhighlight(x2);
                       if x2 = 3 then x2 := 1 else inc(x2);
                       user.Highlight(x2);
                     end;
                end;
            end;
        #13: ;
        #27: begin
               {UnSetupStuff;}
               user.EraseBox;
               exitthen := true;
             end;
      end;
    until exitthen;
  end;

var exitnow: boolean;
    c: char;
    x: byte;
begin
  x := 1;
  exitnow := false;
  repeat
    c := readkey;
    case c of
      #0: begin
            c := readkey;
            case c of
              #75: begin
                     main.Unhighlight(x);
                     if x = 1 then x := 4 else dec(x);
                     main.Highlight(x);
                   end;
              #77: begin
                     main.Unhighlight(x);
                     if x = 4 then x := 1 else inc(x);
                     main.Highlight(x);
                   end;
              #80: begin

                   end;
            end;
          end;
      #13: DoStuff(x);
      #27: exitnow := true;
    end;
  until exitnow;
end;

procedure RestoreScreen;
var f: file;
begin
  assign(f, '##@@!!&&.~l~');
  reset(f, 1);
  blockread(f, screenadr, 4000);
  close(f);
end;

end.