{$M 50000,0,32767}
{$O+}
(****************************************************************************
 ** UNIT: Init.Pas                                                         **
 ** PURPOSE: To initialize the data at runtime, and to close and save data **
 **          upon exiting.                                                 **
 ****************************************************************************)


unit Init;

interface

uses Dos, Crt, Common, Setup1, Fossil, ExecSwap, DataFunc;

procedure Initialize;
(* Initializes the BBS *)
procedure DeInitialize;
(* Shuts down the BBS *)

implementation

procedure InitilizeModem;
begin
  messagebox('Initializing Modem');
  delay(10);
  prt2m(modemf.initstr);
  delay(2000);
end;

procedure checkfordsz(s: string);

var
  f: searchrec;

begin
  findfirst(s,anyfile,f);
  if doserror <> 0 then error(1,s+' not found in current directory!');
end;

procedure checkforpkzip(s: string);

var
  f: searchrec;

begin
  findfirst(s,anyfile,f);
  if doserror <> 0 then error(1,s+' not found in current directory!');
end;

procedure checkforpkunzip(s: string);

var
  f: searchrec;

begin
  findfirst(s,anyfile,f);
  if doserror <> 0 then error(1,s+' not found in current directory!');
end;

function CheckDir(S: string): boolean;
var
  O: string;
  I: byte;
  F: searchrec;
  T: boolean;

begin
  s[0] := chr(ord(s[0]) - 1);
  checkdir := false;
  O := S;
  repeat
    I := pos('\',S);
    if i > 0 then
      delete(s,1,i);
  until I <= 0;
  findfirst(s,directory,f);
  if doserror <> 0 then t := false else begin checkdir := true; t := true; end;
  if t <> true then
  begin
    messagebox('Creating '+O+'...');
    mkdir(s);
    checkdir := true;
  end;
end;

procedure ReadData(var A: byte);
var f: file of systemrec;
    m: file of modemrec;
    h: file of historyrec;
    u: file of userrec;
    uif: file of userindexrec;
    s: file of stringrec;
    i: byte;
    ui: userindexrec;
begin
  a := 0;
  assign(f, 'setup.dat');
  {$I-} reset(f); {$I+}
  if IOResult = 0 then
    read(f, systemf)
  else
  begin
    a:=1;
    cursoroff;
    MessageBox('SETUP.DAT Missing or Invalid!  Running Setup...');
    delay(2000);
    cursoron;
  end;
  assign(m, systemf.datapath+'modem.dat');
  {$I-} reset(m); {$I+}
  if IOResult = 0 then
    read(m, modemf)
  else
  begin
    a:=1;
    cursoroff;
    MessageBox('MODEM.DAT Missing or Invalid!  Running Setup...');
    delay(2000);
    cursoron;
  end;
  assign(h, systemf.datapath+'history.dat');
  {$I-} reset(h); {$I+}
  if IOResult = 0 then
    read(h, historyf)
  else
  begin
    cursoroff;
    MessageBox('HISTORY.DAT Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    GetHDefaults(historyf);
    rewrite(h);
    write(h, historyf);
    close(h);
  end;
  assign(u, systemf.datapath+'user.lst');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then
  begin
    cursoroff;
    MessageBox('USER.LST Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    GetUDefaults(thisuser);
    Rewrite(U);
    write(u, thisuser);
    close(u);
  end;
  assign(uif, systemf.datapath+'user.ndx');
  {$I-} reset(uif); {$I+}
  if IOResult <> 0 then
  begin
    cursoroff;
    MessageBox('USER.NDX Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    GetIDefaults(ui);
    rewrite(uif);
    write(uif, ui);
    close(uif);
  end;
  assign(s, systemf.datapath+'string.dat');
  {$I-} reset(s); {$I+}
  if IOResult = 0 then
    read(s,stringf)
  else
  begin
    cursoroff;
    MessageBox('STRING.DAT Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    GetSDefaults(stringf);
    rewrite(s);
    write(s,stringf);
    close(s);
  end;
end;

procedure Initialize;
type
  TerminalType = (TermTTY, TermANSI);
var
  F: File of systemrec;
  B: boolean;
  t: terminalType;
  a,i: byte;
  directory: string;
begin
  b := FALSE;
  CursorOff;

  if not exist('setup.dat') then
  begin
    assign(f, 'setup.dat');
    GetYDefaults(systemf);
    rewrite(f);
    write(f, systemf);
    close(f);
    Setup;
  end
  else
  begin
    assign(f, 'setup.dat');
    {$I-} reset(f); {$I+}
    if IOResult <> 0 then ;
    read(f, systemf);
  end;

(* Check if Directories Exist *)

  if not checkdir(systemf.datapath) then
  begin
    b := true;
    Error(0, 'Directory '+systemf.datapath+' not found!');
  end;
  if not checkdir(systemf.messagepath) then
  begin
    b := true;
    Error(0, 'Directory '+systemf.messagepath+' not found!');
  end;
  if not checkdir(systemf.textfilepath) then
  begin
    b := true;
    Error(0, 'Directory '+systemf.textfilepath+' not found!');
  end;
  if not checkdir(systemf.menupath) then
  begin
    b := true;
    Error(0, 'Directory '+systemf.menupath+' not found!');
  end;
  if not checkdir(systemf.xferpath) then
  begin
    b := true;
    Error(0, 'Directory '+systemf.xferpath+' not found!');
  end;
  if not checkdir(systemf.temppath) then
  begin
    b := true;
    Error(0, 'Directory '+systemf.temppath+' not found!');
  end;
  if b then error(1, '');

  CheckForDSZ(systemf.zmodem);
  CheckForPKZip(systemf.zip);
  CheckForPKUnzip(systemf.unzip);

  ReadData(a);
  if a = 1 then
  begin
    Setup;
    halt(a);
  end;

  UseEMSIfAvailable:= TRUE;
  if not InitExecSwap(HeapPtr, 'ONYXSWAP.$$$') then
    Error(1, 'Unable to allocate swap space!');

  if InitDriver(modemf.comport) then
  begin
    InitModem(modemf.comport, modemf.speed, 'N', 8, 1);
    InitilizeModem;
    CursorOn;
  end
  else
    Error(10, 'FOSSIL Driver not Installed!');

(* Set Thisuser.etc to defaults *)
  ResetUser(thisuser);
end;

procedure DeInitialize;
var s: file of systemrec;
    m: file of modemrec;
    h: file of historyrec;

begin
  ClrScr;
  PurgeBuffer(modemf.comport, 'B');
  DeinitDriver(modemf.comport);
  assign(s, 'setup.dat');
  assign(m, 'modem.dat');
  assign(h, 'history.dat');
  {$I-}
  reset(s);
  if IOResult = 0 then
  begin
    write(s, systemf);
    close(s);
  end;
  reset(m);
  if IOResult = 0 then
  begin
    write(m, modemf);
    close(m);
  end;
  reset(h);
  if IOResult = 0 then
  begin
    write(h, historyf);
    close(h);
  end;
  {$I+}
  ShutDownExecSwap;
end;

end.