(* Global Records and Types *)

type
(* String types *)
str2 = string[2];
str3 = string[3];
str8 = string[8];
str50 = string[50];

(* Access String Definition *)
ACS = string[80];

(* Color Record *)
ColorRec = record
  Regular,
  Prompt,
  Stat,
  Input,
  Message: byte;
end;

(* User Index Record *)
UserIndexRec = record
  Handle: string[30];
  Password: string[15];
end;

(* User Access Restrictions *)
UserARRec = array[0 .. 61] of boolean;

(* User Flags *)
UserFlagRec = record
  Wanted,
  NoFile,
  NoMessage,
  NoDL,
  NoNUV,
  NoChat,
  CoSysOp,
  NoNet,
  OncePerDay,
  LockedOut: boolean;
end;

(* User Record *)
UserRec = record
  Handle: string[30];
  Baud: string[6];
  RealName: string[50];
  Sex: char;
  VoiceNum,
  DataNum: string[20];
  Password: string[15];
  Address1,
  Address2: string[50];
  Birthday: string[8];
  UserNote: string[30];
  SysOpNote: string[50];
  LastOn: string[8];
  NumOn: word;
  TimeAllowed: word;
  TimeOn: word;
  TimeLeft: word;
  UploadK: longint;
  Uploads: word;
  DownloadK: longint;
  Downloads: word;
  TotalTimeOn: longint;
  AccessLev: integer;
  FilePoints: longint;
  Colors: colorrec;
  Xpert: boolean;
  MsgHeaderType,
  PromptType,
  MenuType,
  StringType: byte;
  NFO: array[1 .. 5] of boolean;
  Validated: boolean;
  DisplayLength: byte;
  VideoMode: (TTY, ANSI, AVATAR);
  LastRead: array[1 .. 5, 0 .. 255] of word;
  TimeInBank: longint;
  ConfOn,
  MSubOn,
  FSubOn: byte;
  TimePerDay: integer;
  PCRratio: integer;
  UDratio: integer;
  HackAttempts: byte;
  Posted: word;
  ARs: UserARRec;
  UserFlags: UserFlagRec;
  DownloadKLimit: longint;
  EmailWaiting: byte;
end;

(* Prompt Record *)
PromptRec = record
  Name: string[50];
  Number: byte;
  PromptData: string[255];
end;

(* Menu Type Record *)
MenuTypeRec = record
  Name: string[50];
  Number: byte;
  MenuFile: string[12];
  MenuDir: string[60];
end;

(* String Record *)
StringTypeRec = record
  Name: string[50];
  Number: byte;
  StringFile: string[12];
end;

(* Message Header Record *)
MessageHeaderRec = record
  Name: string[50];
  Number: byte;
  Filename: string[12];
end;

(* Menu Command Record *)
MenuCommandRec = record
  Description: string[50];
  Default: string[50];
  CMDKey: string[50];
  FString: string[2];
  PString: string[50];
  Access: ACS;
  Hidden: boolean;
end;

(* Menu Record *)
MenuRec = record
  Name: string[8];
  Command: array[0 .. 99] of MenuCommandRec;
end;

(* System Setup Record *)
SystemRec = record
  BBSNameLng: string[80];
  BBSNameSht: string[50];
  BBSPhone: string[12];
  SysOp: string[30];
  MainPath,
  DataPath,
  MessagePath,
  TextfilePath,
  MenuPath,
  XferPath,
  TempPath: string[80];
  InfoForm: array[1 .. 5] of boolean;
  Zmodem,
  Zip,
  Unzip: string[80];
  NUP: string[50];
  System: string[50];
  LockOutBaud: string[6];
  LockOutPw: string[50];
  UseConfs: boolean;
  UseConf: array[1 .. 5] of boolean;
  Confa,
  Confb: array [1 .. 5] of string[80];
  HangupOnNewbies: boolean;
  Numtries: byte;
  Maskchar: char;
  IdleTime: byte;
  MaxEmail: word;
end;

(* Modem Record *)
ModemRec = record
  Speed: longint;
  ComPort: byte;
  InitStr: string[80];
  AnswerStr: string[80];
  HangupStr: string[80];
  OffhookStr: string[80];
  SoundOnStr: string[80];
  SoundOffStr: string[80];
  TimeToWait: byte;
end;

(* History Record *)
HistoryRec = record
  TotalCalls: word;
  TotalDays: word;
  RecentPosts: word;
  RecentCalls: word;
  RecentULs: word;
  RecentDLs: word;
  MinsUsed: word;
  NumFeedBack: word;
  NewEmail: word;
  Available: boolean;
  CallsToday: word;
  LastOn: string[50];
end;

(* String Record *)
StringRec = record
  Anonymous: string[30];      { Anonymous String }
  Logon: string[50];          { Logon Name String }
  Password: string[50];       { Logon Password String }
  System: string[50];         { System Password Prompts }
  Detect: string[80];         { Detecting ANSI String }
  Ansi: string[80];           { ANSI Detected String }
  Avatar: string[80];         { Avatar Detected String }
  Nothing: string[80];        { Nothing Detected String }
  Pause: string[80];          { Pause Prompt }
  NewUserName: string[50];    { Desired Name For New Users String }
  NUP: string[50];            { Enter NUP String }
  NUPWrong: string[80];       { NUP Incorrect String }
  AlreadyUser: string[80];    { Person Is Already A User String }
  Realname: string[50];       { Real Name Prompt }
  Realnamebad: string[80];    { Bad Realname Entered String }
  RandPass: string[50];       { Random Password Prompt }
  UseRandPass: string[50];    { Use Random Password Prompt }
  DesiredPW: string[50];      { Desired Password String }
  DPassInvalid,               { Desired Password Invalid }
  DPassShort: string[80];     { Desired Password Short }
  PhoneNum1,
  PhoneNum2,                  { Phone Number Prompt }
  PhoneBad: string[80];       { Bad Phone Number Entered Prompt }
  DataNum1,
  DataNum2,                   { Modem Number Prompt }
  DataBad: string[80];        { Bad Modem Number Entered Prompt }
  Address1,
  Address2: string[50];       { Address Prompts }
  AddressBad: string[80];
  Age: string[50];            { Age Prompt }
  Sex: string[50];            { Sex Prompt }
  Birthday: string[50];       { Birthday Prompt }
  Handlebad: string[80];      { Bad Handle Entered String }
end;

(* Message Sub Record *)
SubRec = record
  Num: word;
  Name: string[50];
  FileN: string[8];
  MaxMsgs: word;
  ReadSec: ACS;
  PostSec: ACS;
end;

(* Index Record *)
IndexRec = record
  Number: word;
  Title: string[50];
  From: string[30];
  WhoTo: string[30];
  DateSent: word;
  TimeSent: word;
  MsgLoc: longint;
  MsgLen: longint;
end;

(* EMail Index Record *)
EIndexRec = record
  Title: string[50];
  From: string[30];
  WhoTo: string[30];
  DateSent: word;
  TimeSent: word;
  MsgLoc: longint;
  MsgLen: longint;
end;

(* Message Info Record *)
InfoRec = record
  Title: string[50];
  WhoTo: string[30];
  NumTo: word;
end;

(* Conference Info Record *)
ConfInfoRec = record
  Num: byte;
  MName: string[50];
  MAccess: ACS;
  FName: string[50];
  FAccess: ACS;
end;

(* Window Record *)
WindowRec = record
  X,Y,X2,Y2: byte;
end;
