unit Fossil;

interface

function InitDriver(Port: byte): boolean;
procedure DeInitDriver(Port: byte);
procedure InitModem(Port: byte; Baud: longint; Parity: char; Data, Stop: byte);
procedure HangUp(Port: byte);
function GetChar(Port: byte): char;
function RemoteKeyHit(Port: byte): boolean;
procedure XmitChar(Port: byte; C: char);
procedure XmitString(Port: byte; S: string; CR: boolean);
procedure FlushOutBuffer(Port: byte);
procedure PurgeBuffer(Port: byte; Buf: char);
procedure SetCTS_RTS(Port: byte; Enable: boolean);
function Carrier(Port: byte): boolean;
function Ringing(Port: byte): boolean;

implementation

uses Crt;

function InitDriver(Port: byte): boolean; assembler;
asm
  dec Port
  mov ah,04h
  mov dx,word(Port)
  int 14h
  cmp ax,1954h
  jne @@1
  mov ax,0001h
  jmp @@2
@@1:
  mov ax,0000h
@@2:
end;

procedure DeInitDriver(Port: byte); assembler;
asm
  dec Port
  mov ah,05h
  mov dx,word(Port)
  int 14h
end;

procedure InitModem(Port:byte; Baud: longint; Parity: char; Data, Stop: byte);
var temp: byte;
begin
  dec(Port);
  temp := $00;
  case Baud of
    300: temp := temp or $40;
    600: temp := temp or $60;
    1200: temp := temp or $80;
    2400: temp := temp or $A0;
    4800: temp := temp or $C0;
    9600: temp := temp or $E0;
    19200: temp := temp or $00;
  else
    if Baud = 38400 then temp := temp or $20;
  end;
  case Parity of
    'N': temp := temp or $00;
    'O': temp := temp or $08;
    'E': temp := temp or $18;
  end;
  case Data of
    5: temp := temp or $00;
    6: temp := temp or $01;
    7: temp := temp or $02;
    8: temp := temp or $03;
  end;
  case Stop of
    1: temp := temp or $00;
    2: temp := temp or $04;
  end;
  asm
    mov ah,00h
    mov al,temp
    mov dx,word(Port)
    int 14h
  end
end;

procedure HangUp(Port: byte); assembler;
asm
  dec Port
  mov ah,06h
  mov al,00h
  mov dx,word(Port)
  int 14h
end;

function GetChar(Port: byte): char; assembler;
asm
  dec Port
  mov ah,02h
  mov dx,word(Port)
  int 14h
end;

function RemoteKeyHit(Port: byte): boolean; assembler;
asm
  dec Port
  mov ah,03h
  mov dx,word(Port)
  int 14h
  and ah,01h
  cmp ah,01h
  jne @@1
  mov ax, 0001h
  jmp @@2
@@1:
  mov ax, 0000h
@@2:
end;

procedure XmitChar(Port: byte; C: char); assembler;
asm
    dec Port
@@1:
    mov ah,0Bh
    mov al,byte(C)
    mov dx,word(Port)
    int 14h
    cmp ax,0001h
    jne @@1
    mov ax, 0001h
end;

procedure XmitString(Port: byte; S: string; CR: boolean);
var x: byte;
begin
  if CR then S := S + #13#10;
  for x := 1 to length(S) do
    XmitChar(Port, S[x]);
end;

procedure FlushOutBuffer(Port: byte); assembler;
asm
  dec Port
  mov ah,08h
  mov dx,word(Port)
  int 14h
end;

procedure PurgeBuffer(Port: byte; Buf: char);
begin
  dec(Port);
  case Buf of
    'I','B': asm
               mov ah,0Ah
               mov dx,word(Port)
               int 14h
             end;
    'O','B': asm
               mov ah,09h
               mov dx,word(Port)
               int 14h
             end;
  end;
end;

procedure SetCTS_RTS(Port: byte; Enable: boolean); assembler;
asm
  dec Port
  mov ah,0Fh
  mov al,00h
  cmp Enable,01h
  jne @@1
  or al,0F2h
  jmp @@2
@@1:
  or al,0F0h
@@2:
  mov dx,word(Port)
  int 14h
end;

function Carrier(Port: byte): boolean; assembler;
asm
  dec Port
  mov ah,03h
  mov dx,word(Port)
  int 14h
  and al,80h
  cmp al,80h
  jne @@1
  mov ax, 0001h
  jmp @@2
@@1:
  mov ax, 0000h
@@2:
end;

function Ringing(Port: byte): boolean; assembler;
asm
  dec Port
  mov ah,03h
  mov dx,word(Port)
  int 14h
  and al,40h
  cmp al,40h
  jne @@1
  mov ax, 0001h
  jmp @@2
@@1:
  mov ax, 0000h
@@2:
end;

end.
