unit FastWrit;

interface

procedure FastWrite(X, Y: byte; Fore, Back: byte; S: string);
procedure FastClrEol(X, Y, Back: byte);
procedure FastSetBack(Y, Back: byte);
procedure WaitForRetrace;

implementation

uses Crt;

procedure WaitForRetrace; assembler;
label Wait, Retr;
asm
          mov dx,3DAh
Wait:     in al,dx
          test al,08h
          jz Wait
Retr:     in al,dx
          test al,08h
          jnz Retr
end;

procedure FastWrite(X, Y: byte; Fore, Back: byte; S: string);
var cnt: word;
    saved: byte;
begin
  dec(x);
  dec(y);
  saved := textattr;
  textattr := fore;
  back := back shl 4;
  textattr := textattr or back;
  cnt:=0;
  while cnt < ord(s[0]) do
  begin
    mem[$b800:(y*160)+((x+cnt)*2)] := ord(s[cnt+1]);
    mem[$b800:(y*160)+((x+cnt)*2)+1] := textattr;
    inc(cnt);
  end;
  textattr := saved;
end;

procedure FastClrEol(X, Y, Back: byte);
var cnt: word;
    saved: byte;
begin
  dec(x);
  dec(y);
  saved := textattr;
  back := back shl 4;
  textattr := textattr or back;
  cnt:=x;
  while cnt <= 80 do
  begin
    mem[$b800:(y*160)+((x+cnt)*2)] := 32;
    mem[$b800:(y*160)+((x+cnt)*2)+1] := textattr;
    inc(cnt);
  end;
  textattr := saved;
end;

procedure FastSetBack(Y, Back: byte);
var cnt: word;
    saved: byte;
begin
  dec(y);
  saved := textattr;
  back := back shl 4;
  textattr := textattr or back;
  cnt:=0;
  while cnt <= 80 do
  begin
    mem[$b800:(y*160)+(cnt*2)+1] := textattr;
    inc(cnt);
  end;
  textattr := saved;
end;

end.