unit DataFunc;

interface

uses Common;

procedure FindUserName(var Name: string);
(* Searches for a User by Name or Number *)
procedure LoadUser(Name: string);
(* Loads thisuser with Name *)
procedure CreateUserIndex;
(* Creates the USER.NDX file from USER.LST *)
procedure ResetUser(var U: userrec);
(* Resets U to a blank user *)
function UserPos(S: string): longint;
(* Returns user S's position in USER.LST or USER.NDX *)
procedure AddUser(U: userrec);
(* Adds Name to USER.NDX and USER.LST *)
procedure DeleteUser(Name: string);
(* Deletes Name from USER.NDX and USER.LST *)
function CheckBlackLst(Name: string): boolean;
(* Checks to see if Name is in BLACK.LST *)
function TestPassword(Prompt, Pw, Bad: string): boolean;
(* Tests a password, and prints an error msg if test fails *)
function Prompt(Number: byte): string;
(* Returns the users prompt *)
procedure GetUDefaults(var U: userrec);
(* Same as above, but for userrec *)
procedure GetIDefaults(var I: userindexrec);
(* Same as above, but for userindexrec *)
procedure GetHDefaults(var H: historyrec);
(* Sets H to the defaults for historyrec *)
procedure GetSDefaults(var S: stringrec);
(* Same as above, but for stringrec *)
procedure GetYDefaults(var Y: systemrec);
(* Same as above, but for systemrec *)
procedure GetMDefaults(var M: modemrec);
(* Same as above, but for modemrec *)
procedure GetEMailDefaults(var EM: subrec);
(* Sets EMAIL.DAT *)

implementation


procedure FindUserName(var Name: string);
var UI: file of userindexrec;
    x: word;
    tui: userindexrec;
begin
  if Name = '' then exit;
  assign(ui, systemf.datapath+'user.ndx');
  {$I-} reset(ui); {$I+}
  if IOResult <> 0 then
  begin
    CreateUserIndex;
    reset(ui);
  end;
  for x := 1 to filesize(ui) do
  begin
    read(ui, tui);
    if (ToUpper(tui.handle) = ToUpper(name)) or (v2str(x) = name) then
    begin
      close(ui);
      exit;
    end;
  end;
  name := '';
  close(ui);
end;

procedure LoadUser(Name: string);
var u: file of userrec;
    x: word;
    tu: userrec;
begin
  assign(u, systemf.datapath+'user.lst');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then begin name:=''; exit; end;

  x:=1;
  while ((x <= filesize(u)) and
         (ToUpper(thisuser.handle) <> ToUpper(name))) do
  begin
    read(u, tu);
    if (ToUpper(tu.handle) = ToUpper(name)) or
       (v2str(x) = name) then
      thisuser := tu;
  end;
  if ToUpper(thisuser.handle) <> ToUpper(name) then
    Error(0, 'User Not Found!');
  close(u);
end;

procedure CreateUserIndex;
var uf: file of userrec;
    uif: file of userindexrec;
    u: userrec;
    ui: userindexrec;
begin
  assign(uf, systemf.datapath+'USER.LST');
  assign(uif, systemf.datapath+'USER.NDX');
  {$I-} reset(uf); {$I+}
  if IOResult <> 0 then exit;
  rewrite(uif);
  while not eof(uf) do
  begin
    read(uf, u);
    ui.handle := u.handle;
    ui.password := u.password;
    write(uif, ui);
  end;
  close(uif);
  close(uf);
end;

procedure ResetUser(var U: userrec);
var x,y: word;
begin
  with u do
  begin
    Handle:='';
    Baud:='';
    RealName:='';
    Sex:='M';
    VoiceNum:='000-000-0000';
    DataNum:='000-000-0000';
    Password:='';
    Address1:='';
    Address2:='';
    UserNote:='';
    SysOpNote:='';
    LastOn:='00/00/00';
    NumOn:=0;
    TimeAllowed:=20;
    TimeOn:=0;
    TimeLeft:=20;
    UploadK:=0;
    Uploads:=0;
    DownloadK:=0;
    Downloads:=0;
    TotalTimeOn:=0;
    AccessLev:=0;
    FilePoints:=0;
    with Colors do
    begin
      Regular:=0;
      Prompt:=0;
      Stat:=0;
      Input:=0;
      Message:=0;
    end;
    Xpert:=false;
    MsgHeaderType:=1;
    PromptType:=1;
    MenuType:=1;
    StringType:=1;
    for x := 1 to 5 do
      NFO[x] := FALSE;
    Validated:=false;
    DisplayLength:=20;
    VideoMode:=TTY;
    for x := 1 to 5 do
      for y := 0 to 255 do
        LastRead[x][y]:=0;
    TimeInBank:=0;
    ConfOn:=1;
    MSubOn:=1;
    FSubOn:=1;
    TimePerDay:=20;
    PCRratio:=0;
    UDratio:=0;
    HackAttempts:=0;
    Posted:=0;
    DownloadKLimit:=0;
    EmailWaiting:=0;
  end;
end;

function UserPos(S: string): longint;
var u: file of UserIndexRec;
    temp: UserIndexRec;
    x: longint;
begin
  x := 0;
  temp.handle := '';
  assign(u, systemf.datapath+'USER.NDX');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then begin CreateUserIndex; reset(u); end;
  read(u, temp);
  while ((not eof(u)) and (ToUpper(s) <> ToUpper(temp.handle))) do
  begin
    inc(x);
    read(u, temp);
  end;
  close(u);
  if ToUpper(s) <> ToUpper(temp.handle) then
    userpos := -1
  else
    userpos := x;
end;

procedure AddUser(U: userrec);
var
  uf: file of userrec;
  uif: file of userindexrec;
  ui: userindexrec;
begin
  if u.handle = '' then exit;
  ui.handle := u.handle;
  ui.password := u.password;
  assign(uf, systemf.datapath+'USER.LST');
  assign(uif, systemf.datapath+'USER.NDX');
  {$I-}
  reset(uf);
  if IOResult <> 0 then
  begin
    prtln('Error reading USER.LST');
    exit;
  end;
  reset(uif);
  if IOResult <> 0 then
  begin
    CreateUserIndex;
    reset(uif);
  end;
  {$I+}
  seek(uf, filesize(uf));
  seek(uif, filesize(uif));
  write(uf, u);
  write(uif, ui);
  close(uf);
  close(uif);
end;

procedure DeleteUser(Name: string);
var
  x: longint;
  uf: file of userrec;
  u: userrec;
  uif: file of userindexrec;
  ui: userindexrec;
begin
  FindUserName(Name);
  if Name = '' then exit;
  assign(uf, systemf.datapath+'USER.LST');
  {$I-} reset(uf); {$I+}
  if IOResult <> 0 then
  begin
    prtln('Error reading USER.LST');
    exit;
  end;
  if UserPos(Name) = filesize(uf)-1 then
    seek(uf, filesize(uf)-1)
  else
    for x := UserPos(Name) to filesize(uf)-2 do
    begin
      seek(uf, x+1);
      read(uf, u);
      seek(uf, x);
      write(uf, u);
    end;
  truncate(uf);
  close(uf);
  assign(uif, systemf.datapath+'USER.NDX');
  {$I-} reset(uif); {$I+}
  if IOResult <> 0 then
  begin
    CreateUserIndex;
    exit;
  end;
  if UserPos(Name) = filesize(uif)-1 then
    seek(uif, filesize(uif)-1)
  else
    for x := UserPos(Name) to filesize(uif)-2 do
    begin
      seek(uif, x+1);
      read(uif, ui);
      seek(uif, x);
      write(uif, ui);
    end;
  truncate(uif);
  close(uif);
end;

function CheckBlackLst(Name: string): boolean;
var
  f: text;
  s: string;
  b: boolean;
begin
  b := false;
  if exist(systemf.datapath+'BLACK.LST') then
  begin
    assign(f, systemf.datapath+'BLACK.LST');
    {$I-} reset(f); {$I+}
    if IOResult <> 0 then
    begin
      prtln('Error reading BLACK.LST');
      exit;
    end;
    while not eof(f) do
    begin
      readln(f, s);
      if ToUpper(Name) = ToUpper(s) then
      begin
        b := true;
        break;
      end;
    end;
    close(f);
  end;
  CheckBlackLst := b;
end;

function TestPassword(Prompt, Pw, Bad: string): boolean;
var x: byte;
    s: string;
begin
  TestPassword := false;
  if Pw = '' then begin TestPassword := true; exit; end;
  for x := 1 to systemf.numtries do
  begin
    prt(Prompt);
    input2(s, systemf.maskchar);
    if ToUpper(s) = ToUpper(Pw) then
    begin
      TestPassword := true;
      exit;
    end;
    nl;
    prtln(Bad);
    nl;
  end;
end;

function Prompt(Number: byte): string;
var
  f: file of promptrec;
  s: string;
  p: promptrec;
begin
  prompt:='Command: ';
  p.number:=0;
  assign(f, systemf.datapath+'prompts.dat');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    error(0,'PROMPTS.DAT missing or invalid!');
    exit;
  end;
  {$I-}
  while ((IOResult = 0) and (number <> p.number)) do
    read(f,p);
  close(f);
  prompt:=p.promptdata;
end;

procedure GetUDefaults(var U: userrec);
var i,j: byte;
begin
  with U do
  begin
    Handle := 'SysOp';
    Baud := '14400';
    RealName := 'Bob Jones';
    Sex := 'M';
    VoiceNum := '214-555-ASDF';
    DataNum := '214-555-WiSH';
    Password := 'SYSOP';
    Address1 := '123 Seasame St.';
    Address2 := 'Anywhere, Tx  75119';
    Birthday := '11/18/77';
    UserNote := 'SysOp Type Dude';
    SysOpNote := 'I''m the SysOp, therefore I need no note!';
    LastOn := '00/00/00';
    NumOn := 0;
    TimeAllowed := 1440;
    TimeOn := 0;
    TimeLeft := 1440;
    UploadK := 0;
    Uploads := 0;
    DownloadK := 0;
    Downloads := 0;
    TotalTimeOn := 0;
    AccessLev:=100;
    FilePoints:=500;
    with Colors do
    begin
      Regular := 0;
      Prompt := 0;
      Stat := 0;
      Input := 0;
      Message := 0;
    end;
    Xpert := FALSE;
    MsgHeaderType := 1;
    PromptType := 1;
    MenuType := 1;
    StringType := 1;
    for i := 1 to 5 do
      NFO[i] := FALSE;
    Validated := TRUE;
    DisplayLength := 24;
    VideoMode := ANSI;
    for i := 1 to 5 do
      for j := 0 to 255 do
        LastRead[i,j] := 0;
    TimeInBank := 0;
    ConfOn := 1;
    MSubOn := 1;
    FSubOn := 1;
    TimePerDay := 32767;
    PCRratio := 0;
    UDratio := 0;
    HackAttempts := 0;
    Posted := 0;
    with UserFlags do
    begin
      {assign flags}
    end;
    DownloadKLimit := 100000;
    EmailWaiting := 0;
  end;
end;

procedure GetIDefaults(var I: userindexrec);
begin
  I.Handle := 'SysOp';
  I.Password := 'SYSOP';
end;

procedure GetHDefaults(var H: historyrec);
begin
  with H do
  begin
    TotalCalls := 1;
    TotalDays := 1;
    RecentPosts := 0;
    RecentCalls := 1;
    RecentULs := 0;
    RecentDLs := 0;
    MinsUsed := 0;
    NumFeedBack := 0;
    NewEmail := 0;
    Available := FALSE;
    CallsToday := 1;
    LastOn := 'DarkHawk & TES';
  end;
end;


procedure GetSDefaults(var S: stringrec);
begin
  with S do
  begin
    Anonymous := 'Some Lamer';
    Logon := '|BLogin ID: ';
    Password := '|BPassword: ';
    System := 'System 1 Password: ';
    Detect := 'Detecting Your Terminal Emulation';
    Ansi := 'You Have Ansi';
    Avatar := 'You Have Avatar';
    Nothing := 'You Have TTY';
    Pause := 'This Is A Pause';
    NewUserName := 'Desired Handle: ';
    NUP := 'Enter the NUP: ';
    NUPWrong := 'Sorry, that''s the wrong NUP!';
    AlreadyUser := 'You''re alread on this bbs!';
    Realname := 'Enter your Realname: ';
    Realnamebad := 'You MUST enter your real name for access!';
    RandPass := 'Random Password: ';
    UseRandPass := 'Use Random Password (Y/N/M): ';
    DesiredPW := 'Enter a Password to use: ';
    DPassInvalid := 'Password Invalid';
    DPassShort := 'Your password must have 4 or more characters!';
    PhoneNum1 := 'Enter your phone number in the format ###-###-#### or';
    PhoneNum2 := 'for international numbers precede number with a "+".';
    PhoneBad := 'You must enter the number in the correct format!';
    DataNum1 := 'Enter your data number in the format ###-###-#### or';
    DataNum2 := 'for international numbers precede number with a "+".';
    DataBad := 'You must enter the number in the correct format!';
    Address1 := 'Street Address: ';
    Address2 := 'City/State/Zip: ';
    AddressBad := 'You MUST enter a valid address!';
    Age := 'Age: ';
    Sex := 'Sex (M/F): ';
    Birthday := 'Date of Birth: ';
    Handlebad := 'You MUST enter SOMETHING!';
  end;
end;

procedure GetYDefaults(var Y: systemrec);
var
  Directory: string;
  x: byte;
begin
  with Y do
  begin
    BBSNameLng := '';
    BBSNameSht := '';
    BBSPhone := '';
    SysOp := '';
    GetDir(0,Directory);
    MainPath := Directory + '\';
    DataPath := Directory + '\DATA\';
    MessagePath := Directory + '\MESSAGES\';
    TextfilePath := Directory + '\TEXTFILE\';
    MenuPath := Directory + '\MENU\';
    XferPath := Directory + '\XFER\';
    TempPath := Directory + '\TEMP\';
    for x := 1 to 5 do
      InfoForm[x] := FALSE;
    Zmodem := Directory + '\DSZ.EXE';
    Zip := Directory + '\PKZIP.EXE';
    Unzip := Directory + '\PKUNZIP.EXE';
    NUP := 'Red Sphinx!';
    System := 'FORMAT C:';
    LockOutBaud := '1200';
    LockOutPW := 'I''m TOO Slow!';
    UseConfs := FALSE;
    for x := 1 to 5 do
      UseConf[x] := FALSE;
    for x := 1 to 5 do
    begin
      Confa[x] := '';
      Confb[x] := '';
    end;
    HangupOnNewbies := FALSE;
    NumTries := 4;
    Maskchar := 'X';
    IdleTime := 5;
  end;
end;

procedure GetMDefaults(var M: modemrec);
begin
  with M do
  begin
    Speed := 14400;
    ComPort := 1;
    InitStr := 'ATZ';
    AnswerStr := 'ATA';
    HangupStr := 'ATH0';
    OffhookStr := 'ATH1';
    SoundOnStr := 'ATM3';
    SoundOffStr := 'ATM0';
    TimeToWait := 80;
  end;
end;

procedure GetEMailDefaults(var EM: subrec);
begin
  with EM do
  begin
    Num := 0;
    Name := 'EMail';
    FileN := 'EMAIL';
    MaxMsgs := systemf.maxemail;
    ReadSec := '';
    PostSec := '';
  end;
end;

end.