unit Convert;

interface

function Dec2Hex(L: longint): string;
function Dec2Str(L: longint; Base: byte): string;
function Hex2Dec(S: string): longint;

implementation

function v2str(L: longint): string;
var temp: string;
begin
  str(L, temp);
  v2str := temp;
end;

function Dec2Hex(L: longint): string;
type union = record
       case integer of
         0: (X: longint);
         1: (L, H: word);
       end;
var
  u: union;
  s: string;
  y, x: byte;
begin
  s := '';
  u.x := L;
  y := u.l mod 16;
  u.l := u.l div 16;
  for x := 1 to 4 do
  begin
    case y of
      0 .. 9: s := v2str(y) + s;
      10 .. 15: s := chr(ord('A') + y - 10) + s;
    end;
    y := u.l mod 16;
    u.l := u.l div 16;
  end;
  y := u.h mod 16;
  u.h := u.h div 16;
  for x := 1 to 4 do
  begin
    case y of
      0 .. 9: s := v2str(y) + s;
      10 .. 15: s := chr(ord('A') + y - 10) + s;
    end;
    y := u.h mod 16;
    u.h := u.h div 16;
  end;
  Dec2Hex := s;
end;

function Dec2Str(L: longint; Base: byte): string;
type union = record
       case integer of
         0: (X: longint);
         1: (L, H: word);
       end;
var
  u: union;
  s: string;
  y, x: byte;
  Done: boolean;
begin
  Done := false;
  s := '';
  u.x := L;
  y := u.l mod Base;
  u.l := u.l div Base;
  repeat
    if u.l = 0 then Done := true;
    case y of
      0 .. 9: s := v2str(y) + s;
      10 .. 15: s := chr(ord('A') + y - 10) + s;
    end;
    y := u.l mod Base;
    u.l := u.l div Base;
  until Done;
  Done := false;
  y := u.h mod Base;
  u.h := u.h div Base;
  repeat
    if u.h = 0 then Done := true;
    case y of
      0 .. 9: s := v2str(y) + s;
      10 .. 15: s := chr(ord('A') + y - 10) + s;
    end;
    y := u.h mod Base;
    u.h := u.h div Base;
  until Done;
  Dec2Str := s;
end;

function Hex2Dec(S: string): longint;
var
  x: byte;
  l, t: longint;
begin
  for x := 1 to length(s) do
    s[x] := Upcase(s[x]);
  l := 0;
  for x := 1 to length(s) do
    case s[x] of
      '0' .. '9': begin
                    t := ord(s[x])-48;
                    l := l + t * (1 shl (4*(length(s)-x)));
                  end;
      'A' .. 'F': begin
                    t := ord(s[x])-55;
                    l := l + t * (1 shl (4*(length(s)-x)));
                  end;
    end;
  Hex2Dec := l;
end;

end.