{$M 50000,2000,32767}
{$O+}
(***************************************************************************
 **  UNIT: Common.Pas                                                         **
 **  PURPOSE: Provides a set of procedures and functions that most other  **
 **           units will need to share.                                   **
 ***************************************************************************)

unit Common;

interface

uses Dos, Crt, Fossil, Overlay, FastWrit, Menu2, Ansiwrit, Setup1, TimeFunc,
     Convert;

{$I GlobType.Pas}

(* Global Variable and Constant Definitions *)

const
  Version = '0.69B';
  DateReleased = 'xx/xx/xx';

  HexChars = ['0' .. '9', 'A' .. 'F'];
  debug: boolean = false;
  local: boolean = false;
  window1: windowrec = (x:1;y:1;x2:80;y2:24);
  window2: windowrec = (x:1;y:25;x2:80;y2:25);
  window3: windowrec = (x:1;y:1;x2:80;y2:25);

type
  ScreenType = array[0 .. 3999] of byte;
  MenuStack = array[1 .. 10] of string[8];

var
  thisuser: userrec;
  Stack: MenuStack;
  CurrS: byte;
  screenadr: screentype absolute $B800:0000;
  Done: Boolean;
  IncomingCall,Online: boolean;
  SysTemF: systemrec;
  ModemF: modemrec;
  HistoryF: historyrec;
  StringF: stringrec;
  CurrMenu: menurec;

(* Procedures *)

procedure TwoWayChat;
(* Two way chat *)
procedure SwitchWindows(W: windowrec);
(* Switches the current window to W *)
procedure PrintFile(Filename: string);
(* Prints a normal ASCII file *)
procedure PrintAnsi(Filename: string);
(* Prints an ANSI or ASCII file depending on user settings *)
procedure ClearScreen;
(* Clears the screen (on both sides) *)
procedure Color(b: byte);
(* Changes the foreground color (on both sides) *)
procedure GoXY(X, Y: byte);
(* Moves the cursor to X, Y (on both sides) *)
procedure AnsiDetect;
(* Detects the terminal emulation on the remote system *)
procedure Error(I: integer; S: string);
(* Error procedure *)
procedure WriteAt(X,Y:byte; s: string);
(* Writes string s at X, Y *)
procedure WriteCon(s:string);
(* Local ANSI-parsed write procedure *)
procedure Prt(s:string);
(* Print a string (| codes recognized) (both sides) *)
procedure Prtln(s:string);
(* Same as Prt() except it sends a CRLF at the end *)
procedure Prt2M(s:string);
(* Sends a string to the modem only *)
procedure Prt2S(s:string);
(* Sends a string to the local screen only *)
procedure Uncrunch(var Addr1, Addr2; BlkLen: Integer);
(* Decompresses and displays crunched ANSI's *)
procedure Input1(var Sn: string);
(* Normal input procedure (both sides) *)
procedure Input2(var Sn: string; maskchar: char);
(* Same as above, but remote characters are masked *)
procedure Input3(var Sn: string; Len: byte);
(* Same as Input1(), but Sn may not be longer than Len *)
procedure Toggle(var B: boolean);
(* Toggles a boolean variable *)
procedure PhoneInput(var S: string);
(* Inputs a phone number (both sides) *)
procedure Nl;
(* Same as Prtln('');, but saves typing *)
procedure BackGround(b: byte);
(* Sets the background color (on both sides) *)
procedure CursorOff;
(* Turns the local cursor off *)
procedure CursorOn;
(* Turns the local cursor on *)
procedure MessageBox(S: string);
(* Displays message, S, in a nice box *)
procedure Hangup;
(* Drops carrier on the user *)
procedure InfoBar(Barnum: byte);
(* Draws the status bar at the bottom of the screen *)
procedure Pause;
(* Pauses for a keypress (both sides) *)
procedure DateInput(var S: string);
(* Inputs a date (both sides) *)
procedure ScreenAttr(Attr: byte);
(* Sets the textattr for both sides using ANSI *)


(* Functions *)

function NumValid(S: string): boolean;
(* Checks if S is a valid phone number *)
function FormatString(s: string; x: byte): string;
(* Makes a string's length = x by adding trailing spaces or truncating *)
function DateValid(S: string): boolean;
(* Checks to see if S is a valid date *)
function Exist(S: string): boolean;
(* Checks to see if file S exists *)
function Expand(S: string; Num: byte): string;
(* Makes the string's length = Num if it is less by adding spaces *)
function v2str(I: longint): string;
(* Converts a value to a string *)
function str2v(S: string): longint;
(* Converts a string to a value *)
function b2str(B: boolean): string;
(* Converts a boolean to a string *)
function KeyHit: boolean;
(* Checks to see if a key is hit on either side *)
function GetKey: char;
(* Gets a key (from either side) *)
function ToUpper(S: string): string;
(* Converts S to all uppercase *)
function Carrier: boolean;
(* Tests for a Carrier *)
function Access(U: userrec; Level: ACS): boolean;
(* Tests if user U has high enough access to clear Level *)
function GetAge(Birthday: string): byte;
(* Returns how old some one is, if Birthday is his birthday *)
function GetString(var F: file; Len: byte): string;
(* Gets a string of length Len from file F *)
function Translate(Code: str2): string;
(* Translates pipe codes *)

implementation

function Translate(Code: str2): string;
begin
  Code := ToUpper(Code);
  if (Code[1] in HexChars) and (Code[2] in HexChars) then
  begin
    ScreenAttr(Hex2Dec(Code));
    Translate := '';
    exit;
  end;
  if Code = 'HN' then
  begin
    Translate := thisuser.Handle;
    exit;
  end;
  Translate := '|'+Code;
end;

function GetString(var F: file; Len: byte): string;
type
  Union = record
    case boolean of
      TRUE: (L: byte; A: array[1 .. 255] of char);
      FALSE: (S: string);
    end;
var
  Buffer: union;
  count: integer;
begin
  blockread(f, buffer.a, len, count);
  buffer.l := count;
  GetString := buffer.s;
end;

procedure DateInput(var S: string);
var cnt: byte;
    temp: string;
    c: char;
begin
  temp := '';
  cnt := 0;
  prt('  /  /  '#8#8#8#8#8#8#8#8);
  repeat
    repeat until KeyHit;
    c := GetKey;
    case c of
      #8: if cnt > 0 then
          begin
            if ((cnt = 3) or (cnt = 6)) then
            begin
              dec(cnt); dec(cnt);
              prt(#8#8#32#8);
              temp[0] := chr(cnt);
            end else
            begin
              dec(cnt);
              prt(#8#32#8);
              temp[0] := chr(cnt)
            end;
          end;
      #13: prt(#13#10);
      #48 .. #57: if (cnt < 8) then
                  begin
                    if ((cnt = 1) or (cnt = 4)) then
                    begin
                      inc(cnt); inc(cnt);
                      prt(c+'/');
                      temp := temp + c + '/';
                    end else
                    begin
                      inc(cnt);
                      prt(c);
                      temp := temp + c;
                    end;
                  end;
    end;
  until c = #13;
  S := temp;
end;

function DateValid(S: string): boolean;
var x: byte;
    b: boolean;
begin
  b := true;
  if ord(s[0]) < 8 then b := false;
  for x := 1 to 8 do
  begin
    case x of
      1,2,4,5,7,8: if (not (s[x] in ['0' .. '9'])) then
                     b := false;
      3,6: if not (s[x] = '/') then b := false;
    end;
  end;
  DateValid := b;
end;

function NumValid(S: string): boolean;
var x: byte;
    b: boolean;
begin
  b := true;
  if ord(s[0]) < 12 then b := false;
  for x := 1 to 12 do
  begin
    case x of
      1,2,3,5,6,7,9,10,11,12: if (not (s[x] in ['0' .. '9'])) then
                                b := false;
      4,8: if (not (s[x] = '-')) then b := false;
    end;
  end;
  if s[1] = '+' then
  begin
    b := true;
    for x := 2 to length(s) do
      if (not (s[x] in [#48 .. #57, '-'])) then
        b := false;
  end;
  NumValid := b;
end;

procedure Pause;
begin
  prt('- Pause -');
  getkey;
  prt(#8#8#8#8#8#8#8#8#8'         '#8#8#8#8#8#8#8#8#8);
end;

procedure TwoWayChat;
var exitchat: boolean;
    c: char;
begin
  exitchat := false;
  clearscreen;
  repeat
    c := getkey;
    if (c <> #27) and (c <> #8) then prt(c);
    if c = #27 then exitchat := true;
    if c = #8 then prt(#8#32#8);
    if c = #13 then prt(#10);
  until exitchat;
  clearscreen;
end;

procedure InfoBar(Barnum: byte);
begin
  case barnum of
    0: begin
         WaitForRetrace;
         fastsetback(25,1);
         if thisuser.handle = '' then thisuser.handle := 'Nobody';
         fastwrite(1,25,15,1,'Handle: '+thisuser.handle+'  Main Level: '
         +v2str(thisuser.accesslev)+'  Time Left: '+v2str(thisuser.timeleft)+
         '                                    ');
       end;
    1: begin
         WaitForRetrace;
         fastsetback(25,1);
         fastwrite(1,25,15,1,'Time On: '+v2str(thisuser.timeon)+
         '  Time Left: '+v2str(thisuser.timeleft)+'  Time: '+v2str(timer)+
         '                                                             ');
       end;
    2: begin
         WaitForRetrace;
         fastsetback(25,0);
         fastwrite(1,25,0,0,'                                           '+
         '                                                              ');
       end;
  end;
end;

procedure SwitchWindows(W: windowrec);
begin
  window(w.x, w.y, w.x2, w.y2);
end;

function FormatString(s: string; x: byte): string;
var b: byte;
begin
  if ord(s[0]) < x then
  begin
    for b := ord(s[0])+1 to x do
      insert(' ', s, b);
  end;
  if ord(s[0]) > x then
    delete(s, x+1, ord(s[0]) - x);
    FormatString := s;
end;

function Exist(S: string): boolean;
var sr: searchrec;
begin
  findfirst(s, AnyFile, sr);
  if doserror = 0 then exist := true else exist := false;
end;

function Expand(S: string; Num: byte): string;
var temp: string;
    x: integer;
    y: byte;
begin
  temp := '';
  x := num - length(s);
  if x < 0 then begin expand := s; exit; end;
  for y := 1 to x do
    temp := temp + ' ';
  insert(temp, s, 1);
  expand := s;
end;

function Count(S: string; C: char): byte;
var x: byte;
begin
  x := 0;
  while pos(C, S) <> 0 do
  begin
    inc(x);
    delete(S, 1, pos(C, S));
  end;
  Count := x;
end;

procedure Split(var S, temp: string; C: char; N: byte);
var x: byte;
begin
  temp := s;
  for x := 1 to N do
    delete(temp, 1, pos(C, temp));
  s[0] := char(ord(s[0]) - ord(temp[0]));
end;

procedure PrintFile(Filename: string);
var f: file;
    x: byte;
    s, temp: string;
    saved: byte;
begin
  saved := textattr;
  assign(f, filename);
  {$I-} reset(f,1); {$I+}
  if IOResult <> 0 then
  begin
    prtln(filename+' not found!');
    exit;
  end;
  x := 0;
  while not eof(f) do
  begin
    s := getstring(f, 80);
    inc(x, count(s, #10));
    if x >= thisuser.displaylength then
    begin
      Split(s, temp, #10, x-thisuser.displaylength+1);
      prt(s);
      pause;
      x := 0;
      s := temp;
    end;
    if keyhit then
      if getkey = ' ' then
      begin
        nl;
        break;
      end;
    prt(s);
  end;
  close(f);
  textattr := saved;
end;

procedure PrintAnsi(Filename: string);
var f: file;
    x: byte;
    s, temp: string;
    saved: byte;
begin
  saved := textattr;
  if thisuser.videomode <> tty then
    filename := filename + '.ANS'
  else
    filename := filename + '.ASC';
  assign(f, systemf.textfilepath+filename);
  {$I-} reset(f,1); {$I+}
  if IOResult <> 0 then
  begin
    prtln(filename+' not found!');
    exit;
  end;
  x := 0;
  while not eof(f) do
  begin
    s := getstring(f, 80);
    inc(x, count(s, #10));
    if x >= thisuser.displaylength then
    begin
      Split(s, temp, #10, x-thisuser.displaylength+1);
      prt(s);
      pause;
      x := 0;
      s := temp;
    end;
    if keyhit then
      if getkey = ' ' then
      begin
        nl;
        break;
      end;
    prt(s);
  end;
  close(f);
  textattr := saved;
end;

procedure Hangup;
begin
  local := false;
  if Carrier then fossil.hangup(modemf.comport);
end;

procedure MessageBox(S: string);
var x,y,z: byte;
begin
  clrscr;
  x := 40 - (length(s) div 2);
  z := length(s) mod 2;
  textcolor(red);
  gotoxy(x-5,11); write(#218);
  textcolor(darkgray); textbackground(lightgray);
  write(#221);
  textcolor(black);
  write(#218);
  for y := x to (80 - (x - 3) + z) do
    write(#196);
  write(#191);
  textcolor(darkgray);
  write(#222);
  textcolor(red); textbackground(black);
  write(#191);
  gotoxy(x-5,12); write('');
  textcolor(darkgray); textbackground(lightgray);
  write(#221);
  textcolor(black);
  write(#179'  ');
  textcolor(white);
  write(s);
  textcolor(black);
  write('  '#179);
  textcolor(darkgray);
  write(#222);
  textcolor(red); textbackground(black);
  write(#179' ');
  gotoxy(x-5,13); write(#192);
  textcolor(darkgray); textbackground(lightgray);
  write(#221);
  textcolor(black);
  write(#192);
  for y := x to (80 - (x - 3) + z) do
    write(#196);
  write(#217);
  textcolor(darkgray);
  write(#222);
  textcolor(red); textbackground(black);
  write(#217);
end;

procedure CursorOff; assembler;
asm
  mov ax, 0100h
  mov cx, 2000h

  int 10h
end;

procedure CursorOn; assembler;
asm
  mov ax, 0100h
  mov cx, 0607h

  int 10h
end;

procedure Print(F, B: byte; S: string);
begin
  Color(f);
  BackGround(b);
  prt(s);
end;

procedure BackGround(b: byte);
const colors: array[0 .. 7] of string[2] =
              ('40','44','42','46','41','45','43','47');
var s: string[20];
begin
  textbackground(b);
  case thisuser.videomode of
    ansi: begin
            s := #27'[' + colors[b] + 'm';
            xmitstring(modemf.comport,s,false);
          end;
    avatar: begin
            end;
  end;
end;

procedure Color(b: byte);
const colors: array[0 .. 7] of string[2] =
              ('30','34','32','36','31','35','33','37');
var s: string[20];
begin
  textattr:=b;
  case thisuser.videomode of
    ansi: begin
            s := #27'[';
            if b > 7 then
            begin
              s := s + '1;';
              b := b - 8;
            end
            else
              s := s + '0;';
            s := s + colors[b] + 'm';
            xmitstring(modemf.comport,s,false);
          end;
    avatar: begin
            end;
  end;
end;

procedure ClearScreen;
var x: word;
begin
  clrscr;
  case thisuser.videomode of
    ansi: xmitstring(modemf.comport,#27'[2J',false);
    avatar: ;
    tty: for x := 1 to thisuser.displaylength do
           xmitstring(modemf.comport,'',true);
  end;
end;

procedure Nl;
begin
  prtln('');
end;

procedure PhoneInput(var S: string);
var cnt: byte;
    temp: string;
    c: char;
    FreeFormat: boolean;
begin
  FreeFormat := FALSE;
  temp := '';
  cnt := 0;
  prt(':    -   -    '#8#8#8#8#8#8#8#8#8#8#8#8);
  repeat
    repeat until KeyHit;
    c := GetKey;
    if (cnt = 0) and (c = '+') then
    begin
      prt('            '#8#8#8#8#8#8#8#8#8#8#8#8);
      FreeFormat := TRUE;
    end;
    case c of
      #8: if cnt > 0 then
          begin
            if cnt = 1 then
            begin
              FreeFormat := FALSE;
              prt(#8'   -   -    '#8#8#8#8#8#8#8#8#8#8#8);
            end;
            if ((cnt = 4) or (cnt = 8)) and not FreeFormat then
            begin
              dec(cnt); dec(cnt);
              prt(#8#8#32#8);
              temp[0] := chr(cnt);
            end else
            begin
              dec(cnt);
              prt(#8#32#8);
              temp[0] := chr(cnt)
            end;
          end;
      #13: prt(#13#10);
      #48 .. #57,
      '+','-': if ((FreeFormat) and (cnt < 30)) or (cnt < 12) then
               begin
                 if ((cnt = 2) or (cnt = 6)) and not FreeFormat then
                 begin
                   inc(cnt); inc(cnt);
                   prt(c+'-');
                   temp := temp + c + '-';
                 end else
                 begin
                   inc(cnt);
                   prt(c);
                   temp := temp + c;
                 end;
               end;
    end;
  until c = #13;
  S := temp;
end;

procedure GoXY(X, Y: byte);
begin
  if thisuser.videomode = ansi then
    prt(#27+'['+v2str(Y)+';'+v2str(X)+'H');
end;

function Carrier: boolean;
begin
  if debug then carrier := false else
    Carrier := Fossil.Carrier(modemf.comport);
end;

function ToUpper(S: string): string;
var x: byte;
begin
  if s='' then exit;
  for x:= 1 to length(s) do
    s[x]:=Upcase(s[x]);
  ToUpper := S;
end;

procedure Toggle(var B: boolean);
begin
  if b then b:=false else b:=true;
end;

function Date: string;
var Day, Month, Year, DOW: word;
    temp, temp2: string;
begin
  GetDate(Year, Month, Day, DOW);
  temp2:=v2str(year);
  temp[1]:=temp2[3];
  temp[2]:=temp2[4];
  temp[0]:=chr(2);
  Date:=v2str(month)+'/'+v2str(Day)+'/'+temp;
end;

function Time: string;
var
  H, M, S, Hund: word;
  PM: char;
  Min: string;
begin
  PM := 'a';
  GetTime(h, m, s, hund);
  if h > 12 then
  begin
    h := h - 12;
    PM := 'p';
  end;
  if h = 0 then h := 12;
  if m < 10 then
    min := '0'+v2str(m)
  else
    min := v2str(m);
  Time := v2str(h)+':'+min+pm;
end;

procedure Uncrunch(var Addr1, Addr2; BlkLen: integer);
begin
  inline (
    $1E/$C5/$B6/ADDR1/$C4/$BE/ADDR2/$8B/$8E/BLKLEN/$E3/$5B/$8B/$D7/
    $33/$C0/$FC/$AC/$3C/$20/$72/$05/$AB/$E2/$F8/$EB/$4C/$3C/$10/
    $73/$07/$80/$E4/$F0/$0A/$E0/$EB/$F1/$3C/$18/$74/$13/$73/$19/
    $2C/$10/$02/$C0/$02/$C0/$02/$C0/$02/$C0/$80/$E4/$8F/$0A/$E0/
    $EB/$DA/$81/$C2/$A0/$00/$8B/$FA/$EB/$D2/$3C/$1B/$72/$07/$75/$CC/
    $80/$F4/$80/$EB/$C7/$3C/$19/$8B/$D9/$AC/$8A/$C8/$B0/$20/$74/$02/
    $AC/$4B/$32/$ED/$41/$F3/$AB/$8B/$CB/$49/$E0/$AA/$1F);
end;

function b2str(B: boolean): string;
begin
  if b = false then begin b2str := 'NO '; exit; end;
  if b = true then begin b2str := 'YES'; exit; end;
end;

procedure ScreenAttr(Attr: byte);
const
  FT: array[0 .. 7] of string[3] =
      ('30m', '34m', '31m', '35m', '32m', '36m', '33m', '37m');
  BT: array[0 .. 7] of string[3] =
      ('40;', '44;', '41;', '45;', '42;', '46;', '43;', '47;');
var
  temp: string;
begin
  AnsiWrite(#27'[0m');
  temp := #27'[';
  if attr and $08 = $08 then
    temp := temp + '1;'
  else
    temp := temp + '0;';
  if attr and $80 = $80 then
    temp := temp + '5;';
  temp := temp + BT[(attr shr 4) and $07];
  temp := temp + FT[attr and $07];
  AnsiWrite(temp);
end;

procedure Prt2S;
var c: char;
    cnt: byte;
begin
  while pos('|',s) > 0 do
  begin
    cnt:=pos('|',s);
    c:= s[cnt+1];
    case c of
      'B': begin
             delete(s,cnt,2);
             insert(#27'[1;34m',s,cnt);
           end;
      'b': begin
             delete(s,cnt,2);
             insert(#27'[0;34m',s,cnt);
           end;
      'R': begin
             delete(s,cnt,2);
             insert(#27'[1;31m',s,cnt);
           end;
      'r': begin
             delete(s,cnt,2);
             insert(#27'[0;31m',s,cnt);
           end;
      'Y': begin
             delete(s,cnt,2);
             insert(#27'[1;33m',s,cnt);
           end;
      'y': begin
             delete(s,cnt,2);
             insert(#27'[0;33m',s,cnt);
           end;
      'G': begin
             delete(s,cnt,2);
             insert(#27'[1;32m',s,cnt);
           end;
      'g': begin
             delete(s,cnt,2);
             insert(#27'[0;32m',s,cnt);
           end;
      'W': begin
             delete(s,cnt,2);
             insert(#27'[1;37m',s,cnt);
           end;
      'w': begin
             delete(s,cnt,2);
             insert(#27'[0;37m',s,cnt);
           end;
      'M': begin
             delete(s,cnt,2);
             insert(#27'[1;35m',s,cnt);
           end;
      'm': begin
             delete(s,cnt,2);
             insert(#27'[0;35m',s,cnt);
           end;
      'D': begin
             delete(s,cnt,2);
             insert(#27'[1;30m',s,cnt);
           end;
      'd': begin
             delete(s,cnt,2);
             insert(#27'[0;30m',s,cnt);
           end;
      'C': begin
             delete(s,cnt,2);
             insert(#27'[1;36m',s,cnt);
           end;
      'c': begin
             delete(s,cnt,2);
             insert(#27'[0;36m',s,cnt);
           end;
    end;
  end;
  writecon(s+#13#10);
end;

procedure PrtChar(C: char);
const s: string[3] = '';
var temp: string;
begin
  if (s = '') and (c <> '|') then
  begin
    writecon(c);
    if Carrier then XmitChar(modemf.comport, c);
    exit;
  end;
  if c = '|' then
    if s = '|' then
    begin
      s := '';
      writecon(c);
      if Carrier then XmitChar(modemf.comport, c);
      exit;
    end
    else
    begin
      s := c;
      exit;
    end;
  if s[1] = '|' then
    s := s + c;
  if ord(s[0]) = 3 then
  begin
    temp := Translate(s[2]+s[3]);
    writecon(temp);
    if Carrier then XmitString(modemf.comport, temp, false);
{    if (Upcase(s[2]) in ['0' .. '9','A' .. 'F']) and
       (Upcase(s[3]) in ['0' .. '9','A' .. 'F']) then
      ScreenAttr(Hex2Dec(s[2]+s[3]))
    else
    begin
      if s[2]+s[3] = 'HN' then
        writecon(thisuser.handle)
      else
        writecon(s);
      if Carrier then XmitString(modemf.comport, s, false);
    end;
}    s := '';
  end;
end;

procedure Prt;
var b: byte;
    c: char;
    cnt: byte;
begin
  for b := 1 to length(s) do
    PrtChar(s[b]);
{  while pos('|',s) > 0 do
  begin
    cnt:=pos('|',s);
    c:= s[cnt+1];
    case c of
      'B': begin
             delete(s,cnt,2);
             insert(#27'[1;34m',s,cnt);
           end;
      'b': begin
             delete(s,cnt,2);
             insert(#27'[0;34m',s,cnt);
           end;
      'R': begin
             delete(s,cnt,2);
             insert(#27'[1;31m',s,cnt);
           end;
      'r': begin
             delete(s,cnt,2);
             insert(#27'[0;31m',s,cnt);
           end;
      'Y': begin
             delete(s,cnt,2);
             insert(#27'[1;33m',s,cnt);
           end;
      'y': begin
             delete(s,cnt,2);
             insert(#27'[0;33m',s,cnt);
           end;
      'G': begin
             delete(s,cnt,2);
             insert(#27'[1;32m',s,cnt);
           end;
      'g': begin
             delete(s,cnt,2);
             insert(#27'[0;32m',s,cnt);
           end;
      'W': begin
             delete(s,cnt,2);
             insert(#27'[1;37m',s,cnt);
           end;
      'w': begin
             delete(s,cnt,2);
             insert(#27'[0;37m',s,cnt);
           end;
      'M': begin
             delete(s,cnt,2);
             insert(#27'[1;35m',s,cnt);
           end;
      'm': begin
             delete(s,cnt,2);
             insert(#27'[0;35m',s,cnt);
           end;
      'D': begin
             delete(s,cnt,2);
             insert(#27'[1;30m',s,cnt);
           end;
      'd': begin
             delete(s,cnt,2);
             insert(#27'[0;30m',s,cnt);
           end;
      'C': begin
             delete(s,cnt,2);
             insert(#27'[1;36m',s,cnt);
           end;
      'c': begin
             delete(s,cnt,2);
             insert(#27'[0;36m',s,cnt);
           end;
    else
      delete(s,cnt,1);
    end;
  end;
  writecon(s);
  if Carrier then
    XmitString(modemf.comport,s,FALSE);
}end;

procedure Prtln;
begin
  Prt(S+#13#10);
end;

procedure Prt2M;
var b: byte;
begin
  s:=s+#13;
  XmitString(modemf.comport,s,FALSE);
end;

procedure Input1;
const t: str3 = '';
var s, temp: string;
    c: char;
    b: byte;
begin
  s := '';
  b := 0;
  repeat
    c := GetKey;
    if (not Carrier) and (not Local) and (not Debug) then exit;

    if c = '|' then
      if t = '|' then
      begin
        t := '';
        s := s + c;
        inc(b);
        Prt('||');
        continue;
      end
      else
      begin
        t := '|';
        continue;
      end;

    if not (c in [#8, #13, #255]) then
    begin
      if t <> '' then
      begin
        t := t + c;
        if t[0] = #3 then
        begin
          if (t[2] in HexChars) and (t[3] in HexChars) then
          begin
            temp := Translate(t[2]+t[3]);
            s := s + #255 + t + #255;
            b := ord(s[0]);
            t := '';
          end
          else
          begin
            temp := Translate(t[2]+t[3]);
            s := s + #255 + t + #255#255 + temp + #255;
            b := ord(s[0]);
            Prt(t);
            t := '';
          end;
        end;
      end
      else
      begin
        s := s + c;
        inc(b);
        Prt(c);
      end;
    end
    else if (c = #8) and (b > 0) then
    begin
      if t <> '' then
        t := ''
      else
      begin
        if b > 0 then
          if s[b] <> #255 then
          begin
            Prt(#8#32#8);
            dec(b);
            s[0] := char(b);
          end;
      end;
    end;
    if c = #13 then Nl;
  until c = #13;
  sn := s;
end;

procedure Input2;
var s: string;
    c: char;
    b: byte;
begin
  s:='';
  b:=0;
  repeat
    c:=getkey;
    if not carrier and not local then exit;
    if (c <> #8) and (c <> #13) and (c <> #255) then
    begin
      s:=s+c;
      inc(b);
    end else
    if (c = #8) and (b > 0) then
    begin
      s[0] := chr(ord(length(s)-1));
      prt(#8#32#8);
      dec(b);
    end;
    if (c <> #8) and (c <> #255) then
    begin
      writecon(c);
      xmitchar(modemf.comport,maskchar);
    end;
    if c = #13 then nl;
  until c = #13;
  sn:=s;
end;

procedure Input3;
var s: string;
    c: char;
    b: byte;
begin
  s:='';
  b:=0;
  repeat
    c:=getkey;
    if not carrier and not local and not debug then exit;
    if (c <> #8) and (c <> #13) and (b < Len) and (c <> #255) then
    begin
      s:=s+c;
      inc(b);
      prt(c);
    end else
    if (c = #8) and (b > 0) then
    begin
      s[0] := chr(ord(length(s)-1));
      prt(#8#32#8);
      dec(b);
    end;
    if c = #13 then nl;
  until c=#13;
  sn:=s;
end;

function GetKey;
label Label_A_S_D_F;
const barnumber: byte = 0;
      oldtimer: word = 0;
var IdleStart, IdleTime: word;
    xx,yy,saved: byte;
    c,c2: char;
begin
Label_A_S_D_F:
  if ((not carrier) and (not local)) then exit;
  IdleStart := timer;
  repeat
    oldtimer := timer;
    xx := wherex;
    yy := wherey;
{    cursoroff;
    SwitchWindows(window2);
}    InfoBar(barnumber);
    SwitchWindows(window1);
    gotoxy(xx,yy);
    IdleTime := timer;
    if IdleTime < IdleStart then IdleTime := IdleTime + 1440;
    if IdleTime - IdleStart >= systemf.IdleTime then begin Hangup; exit; end;
    if thisuser.timeleft <= 0 then begin Hangup; exit; end;
    if oldtimer <> timer then thisuser.timeleft := thisuser.timeleft - 1;
  until KeyHit;
  if keypressed then
  begin
    c := Readkey;
    if c = #0 then
    begin
      c2 := readkey;
      case c2 of
        #48: begin    (* Alt-B *)
               inc(Barnumber);
               if Barnumber > 2 then Barnumber := 0;
               InfoBar(BarNumber);
               Getkey := #255;
               exit;
             end;
        #46: begin    (* Alt-C *)
               twowaychat;
             end;
        #63: begin    (* F5 *)
               if thisuser.timeleft <> 65535 then
                 inc(thisuser.timeleft);
             end;
        #64: begin    (* F6 *)
               if thisuser.timeleft <> 0 then
                 dec(thisuser.timeleft);
             end;
        #67: begin
               AnsiDetect;
             end;
        #68: begin    (* F10 *)
               prt('[WAIT]');
               saved := textattr;
               xx := wherex;
               yy := wherey;
               cursoroff;
               SaveScreen;
               SetupMainMenu;
               MenuStuff;
               RestoreScreen;
               textattr := saved;
               gotoxy(xx,yy);
               prt(#8#8#8#8#8#8'      '#8#8#8#8#8#8);
               cursoron;
             end;
        #108: begin   (* Alt-F5 *)
                if thisuser.timeleft < 65526 then
                  inc(thisuser.timeleft,10)
                else
                  thisuser.timeleft := 65535;
              end;
        #109: begin   (* Alt-F6 *)
                if thisuser.timeleft > 9 then
                  dec(thisuser.timeleft,10)
                else thisuser.timeleft := 0;
              end;
      end;
      goto Label_A_S_D_F;
    end else
    begin
      GetKey := c;
      exit;
    end;
  end;
  if carrier then
    if remotekeyhit(modemf.comport) then
    begin
      GetKey := GetChar(modemf.comport);
      exit;
    end;
end;

function KeyHit;
begin
  KeyHit := false;
  if keypressed then keyhit := true;
  if carrier then
    if remotekeyhit(modemf.comport) then KeyHit := true;
end;

function str2v(S: string): longint;
var L,code: integer;
begin
  val(S,L,code);
  str2v:=L;
end;

function v2str(I: Longint): string;
var s: string;
    b: byte;
begin
  str(I,s);
  v2str:=s;
end;

procedure AnsiDetect;
var
  s,s2: string;
  c: char;
  x: word;
begin
  purgebuffer(modemf.comport, 'B');
  while remotekeyhit(modemf.comport) do c := getchar(modemf.comport);

  prtln('Detecting Ansi');
  prt2m(#27'[6n');
  x := 1;
  repeat
    delay(200);
    inc(x);
  until (remotekeyhit(modemf.comport)) or (x > 15);

  if remotekeyhit(modemf.comport) then
  begin
    c := getchar(modemf.comport);
    if c = #27 then
      if remotekeyhit(modemf.comport) then
      begin
        c := getchar(modemf.comport);
        if (((c < '0') or (c > '9')) and ((c <> ';') and (c <> '['))) then
        begin
          prtln('Nothing Detected (1)');
          delay(1000);
          exit;
        end else
        begin
          prtln('ANSI Detected');
          thisuser.videomode := ANSI;
        end;
      end else
      begin
        prtln('Nothing Detected (2)');
        delay(1000);
        exit;
      end;
  end else
  begin
    prtln('Nothing Detected (3)');
    delay(1000);
    exit;
  end;

  PurgeBuffer(modemf.comport,'B');

  prtln('Detecting Avatar...');
  prt2m(#27'[2J'#25#32#25#27'[6n');
  x := 1;
  repeat
    delay(200);
    inc(x);
  until (remotekeyhit(modemf.comport)) or (x > 15);
  c := #0;
  s := '';
  while remotekeyhit(modemf.comport) do
  begin
    c := getchar(modemf.comport);
    s := s + c;
  end;

  s2 := '  ';
  s2[1] := s[3];
  if s[4] <> ';' then s2[2] := s[4];
  if s2[2] = ' ' then s2[0] := #1;

  x := str2v(s2);
  if x >= 25 then
  begin
    prtln('Avatar Detected');
    thisuser.videomode := AVATAR;
  end else
    prtln('Avatar Not Detected');
end;

procedure WriteAt(X,Y:byte; S: string);
begin
  gotoxy(x,y);
  write(s);
end;

procedure Error(I: integer; S: string);
begin
  if i <> 0 then
  begin
    writeln(s);
    cursoron;
    halt(i);
  end;

  if i = 0 then
  begin
    writeln(s);
  end;
end;

procedure writecon(s:string);
var x: byte;
begin
  for x := 1 to ord(s[0]) do
    AnsiParse(s[x]);
end;

function Access(U: userrec; Level: ACS): boolean;
var stat, oldf, olds, oldso, final, stateN, stateO: boolean;
    num: string;
    trash, dow: word;
    safety: byte;

  function GetNum(S: string): string;
  var x: byte; t: string; d: boolean;
  begin
    d := false;
    t := '';
    for x := 2 to length(s) do
      if (ord(s[x]) in [48 .. 57]) and (not d) then
        t := t + s[x]
      else
        d := true;
    GetNum := t;
  end;

  function GetARs(S: string): string;
  var x: byte; t: string; d: boolean;
  begin
    d := false;
    t := '';
    for x := 2 to length(s) do
      if (ord(s[x]) in [48 .. 57, 65 .. 90, 97 .. 122]) and (not d) then
        t := t + s[x]
      else if s[x] = '.' then
        d := true;
    GetARs := t;
  end;

  function CheckARs(ARs: UserARRec; Test: string): boolean;
  var x: byte;
  begin
    for x := 1 to length(Test) do
      Test[x] := char(ord(Test[x]) - 48);
    for x := 1 to length(Test) do
      if ord(Test[x]) <= 9 then
        if not ARs[ord(Test[x])] then
        begin
          CheckArs := false;
          exit;
        end;
    for x := 1 to length(Test) do
      Test[x] := char(ord(Test[x]) - 7);
    for x := 1 to length(Test) do
      if (ord(Test[x]) >= 10) and (ord(Test[x]) <= 35) then
        if not ARs[ord(Test[x])] then
        begin
          CheckArs := false;
          exit;
        end;
    for x := 1 to length(Test) do
      Test[x] := char(ord(Test[x]) - 6);
    for x := 1 to length(Test) do
      if (ord(Test[x]) >= 36) and (ord(Test[x]) <= 61) then
        if not ARs[ord(Test[x])] then
        begin
          CheckArs := false;
          exit;
        end;
    CheckARs := true;
  end;

begin
  safety := 0;
  stat := true;
  final := true;
  stateO := true;
  repeat
    inc(safety);
    oldso := stateO;
    stateN := false;
    stateO := false;
    olds := stat;
    oldf := final;
    if Level[1] = '|' then
    begin
      stateO := true;
      delete(Level, 1, 1);
    end;
    if Level[1] = '!' then
    begin
      stateN := true;
      delete(Level, 1, 1);
    end;
    case Level[1] of
      'a': begin
             num := GetNum(Level);
             stat := getage(u.birthday) >= str2v(num);
           end;
      'b': begin
             num := GetNum(Level);
             stat := str2v(u.baud) >= str2v(num) * 100;
           end;
      'c': begin
             num := GetNum(Level);
             stat := u.confon = str2v(num);
           end;
      'd': begin
             num := GetNum(Level);
             stat := ord(u.videomode) = str2v(num);
           end;
      'f': begin
             num := GetNum(Level);
             stat := u.fsubon = str2v(num);
           end;
      'h': begin
             num := GetNum(Level);
             stat := (timer div 60) = str2v(num);
           end;
      'l': begin
             num := GetNum(Level);
             stat := u.accesslev >= str2v(num);
           end;
      'm': begin
             num := GetNum(Level);
             stat := u.msubon = str2v(num);
           end;
      'o': begin
             num := '';
             stat := local;
           end;
      'p': begin
             num := GetNum(Level);
             stat := u.filepoints >= str2v(num);
           end;
      'r': begin
             num := GetARs(Level);
             stat := CheckARs(u.ars, num);
             delete(Level, 1, 1);
           end;
      's': begin
             num := Level[2];
             stat := u.sex = num;
           end;
      'v': begin
             num := '';
             stat := u.validated;
           end;
      'w': begin
             num := GetNum(Level);
             GetDate(trash, trash, trash, dow);
             stat := dow = str2v(num);
           end;
    end;
    delete(Level, 1, length(num) + 1);
    if stateN then stat := not stat;
    if stateO then
    begin
      stat := olds or stat;
      if oldso then
        final := oldf or stat
      else
        final := oldf and stat;
    end else
      final := final and stat;
  until (ord(Level[0]) = 0) or (safety = 100);
  Access := final;
end;

function GetAge(Birthday: string): byte;
var ts: string[2];
    x, m, d: byte;
    y, yy, dd, mm, dow: word;
begin
  if Birthday = '' then
  begin
    GetAge := 0;
    exit;
  end;
  ts := '';
  for x := 1 to 2 do
    if ord(Birthday[x]) in [48 .. 57] then
      ts := ts + Birthday[x];
  m := str2v(ts);
  delete(Birthday, 1, length(ts) + 1);
  ts := '';
  for x := 1 to 2 do
    if ord(Birthday[x]) in [48 .. 57] then
      ts := ts + Birthday[x];
  d := str2v(ts);
  delete(Birthday, 1, length(ts) + 1);
  ts := '';
  for x := 1 to 2 do
    if ord(Birthday[x]) in [48 .. 57] then
      ts := ts + Birthday[x];
  y := str2v(ts);
  getdate(yy, mm, dd, dow);
  y := y + 1900;
  x := yy - y;
  if m > mm then
    dec(x)
  else if m = mm then
    if d > dd then dec(x);
  GetAge := x;
end;

end.