unit windows;
 interface
  Uses Crt,Dos;
   TYPE
    Windowrec= Record
                x1,y1,x2,y2,cx,cy,color:byte;
               End;
   Var
    winds:array [0..4] of windowrec;
    inuse:integer;

   Procedure getcoor;
   Procedure usewind (n:byte);
   Procedure setwind (n:byte; nx1,ny1,nx2,ny2:byte);
   Procedure initwind (n,nx1,ny1,nx2,ny2,ncolor:byte);
   Procedure top;
   Procedure bottom;
   Procedure wholescreen;
   Procedure initwinds;
   Procedure VGATop;
   Procedure VGABottom;

 implementation

procedure getcoor;
 begin
  with winds[inuse] do
   begin
    cx:=wherex;
    cy:=wherey;
    If cy<1 then
     Cy:=1;
    If cy>(y2-y1)+1 then
     Cy:=(y2-y1)+1
  end
 end;

procedure usewind (n:byte);
 begin
  getcoor;
  inuse:=n;
  with winds[n] do
    Begin
      window (x1,y1,x2,y2);
      gotoxy (cx,cy);
      TextAttr:=color;
    End
 end;

procedure setwind (n:byte; nx1,ny1,nx2,ny2:byte);
 var
  i:integer;
 begin
  i:=inuse;
  usewind(n);
  with winds[n] do begin
    x1:=nx1;
    y1:=ny1;
    x2:=nx2;
    y2:=ny2
  end;
  usewind(n);
  if n<>i then usewind(i)
 end;

procedure initwind (n,nx1,ny1,nx2,ny2,ncolor:byte);
 begin
  with winds[n] do begin
    x1:=nx1;
    y1:=ny1;
    x2:=nx2;
    y2:=ny2;
    cx:=1;
    cy:=1;
    color:=ncolor
  end
 end;

Procedure Top;
 Begin
  UseWind(1);
  Inuse:=1;
 End;

procedure bottom;
 Begin
  usewind (2);
  InUse:=2;
 End;

Procedure VGATop;
 Begin
  UseWind(3);
  InUse:=3;
 End;

Procedure VGABottom;
 Begin
  UseWind(4);
  InUse:=4;
 End;

procedure wholescreen;
 Begin
  usewind (0);
  inuse:=0;
 End;

procedure initwinds;
begin
  initwind (0,1,01,80,25,7);
  initwind (1,1,01,80,24,7);
  InitWind (2,1,25,80,25,7);
  InitWind (3,1,1,80,40,7);
  InitWind (4,1,41,80,50,7);
  inuse:=0;
  bottom
end;

end.

