program SubEditor;

uses Crt, Common;

var
  temp: string;
  x: word;
  c: char;

procedure ShowSubs;
var f: file of subrec;
    s: subrec;
    x: word;
begin
  assign(f, 'CONF'+temp+'.DAT');
  reset(f);
  for x := 1 to filesize(f) do
  begin
    read(f, s);
    writeln(' ',x:3,' | ',s.name:30,' | ',s.filen:8);
  end;
  close(f);
  writeln;
end;

procedure Bar;
begin
  writeln;
  writeln(' Num | Sub Name                       | Filename ');
  writeln('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
  ShowSubs;
end;

procedure AddSub;
var f: file of subrec;
    s: subrec;
    t: string[30];
    d: string[8];
begin
  writeln;
  write('Sub Name: ');
  readln(t);
  s.name := t;
  write('Filename: ');
  readln(d);
  s.filen := d;
  assign(f, 'CONF'+temp+'.DAT');
  reset(f);
  s.num := filesize(f) + 1;
  seek(f, filesize(f));
  write(f,s);
  close(f);
end;

procedure DeleteSub;
var f: file of subrec;
    s: subrec;
    x: word;
    t: string;
begin
  writeln;
  write('Number: ');
  readln(t);
  x := str2v(t);
  assign(f, 'CONF'+temp+'.DAT');
  reset(f);
  if x <> filesize(f)  then
  begin
    while x <> filesize(f) do
    begin
      seek(f, x);
      read(f, s);
      seek(f, x - 1);
      write(f, s);
      inc(x);
    end;
    seek(f, x - 1);
    truncate(f);
  end else
  begin
    seek(f, x - 1);
    truncate(f);
  end;
  close(f);
end;

procedure ModifySub;
var f: file of subrec;
    s: subrec;
    t: string;
    x: word;
begin
  writeln;
  write('Number: ');
  readln(t);
  x := str2v(t);
  assign(f, 'CONF'+temp+'.DAT');
  reset(f);
  seek(f, x - 1);
  read(f, s);
  writeln('Sub Name: ',s.name);
  write('New Name: ');
  readln(t);
  s.name := t;
  writeln('Filename: ',s.filen);
  write('New filename: ');
  readln(t);
  s.filen := t;
  seek(f, x - 1);
  write(f, s);
  close(f);
end;

procedure InsertSub;
var f: file of subrec;
    s: subrec;
    t: string;
    x,z: word;
begin
  writeln;
  write('Before: ');
  readln(t);
  x := str2v(t);
  assign(f, 'CONF'+temp+'.DAT');
  reset(f);
  z := filesize(f);
  while z >= x do
  begin
    seek(f, z - 1);
    read(f, s);
    write(f, s);
    dec(z);
  end;
  write('Sub Name: ');
  readln(t);
  s.name := t;
  write('Filename: ');
  readln(t);
  s.filen := t;
  seek(f, x - 1);
  write(f, s);
  close(f);
end;

procedure MoveSub;
var f: file of subrec;
    s,s2: subrec;
    t: string;
    x,z,y,a: word;
begin
  writeln;
  write('Number: ');
  readln(t);
  y := str2v(t);
  write('Before: ');
  readln(t);
  a := str2v(t);
  assign(f, 'CONF'+temp+'.DAT');
  reset(f);
  seek(f, y - 1);
  read(f, s2);
  x := y;
  if x <> filesize(f)  then
  begin
    while x <> filesize(f) do
    begin
      seek(f, x);
      read(f, s);
      seek(f, x - 1);
      write(f, s);
      inc(x);
    end;
    seek(f, x - 1);
    truncate(f);
  end else
  begin
    seek(f, x - 1);
    truncate(f);
  end;
  z := filesize(f);
  if y < x then dec(a);
  while z >= a do
  begin
    seek(f, z - 1);
    read(f, s);
    write(f, s);
    dec(z);
  end;
  s.name := s2.name;
  s.filen := s2.filen;
  seek(f, a - 1);
  write(f, s);
  close(f);
end;

begin
  clrscr;
  writeln; writeln;
  write('Conference: ');
  readln(temp);
  x := str2v(temp);
  repeat
    Bar;
    write('SubEdit: ');
    c := Upcase(readkey);
    writeln(c);
    case c of
      'A': AddSub;
      'D': DeleteSub;
      'E': ModifySub;
      'Q': exit;
      'I': InsertSub;
      'M': MoveSub;
    end;
  until 1 < 1;
end.
