{$V-}
unit Message1;

interface

uses Common, Message2, Message3;

const
  messnum: longint = 0;

var
  currsub: subrec;

procedure MessageCmd(FString: str2; PString: str50; Access: integer;
                     result: boolean);

implementation

procedure AreaChange(PString: str50);
var
  f: file of subrec;
  temp: subrec;
  x,y,z: word;
begin
  temp := currsub;
  assign(f, 'CONF'+v2str(thisuser.confon)+'.DAT');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    Prtln('Conference Not Found'){error};
    exit;
  end;
  x := str2v(PString);
  if x = 0 then begin close(f); exit; end;
  if x > filesize(f) then
    prtln('Invalid Sub')
  else
  begin
    seek(f, x - 1);
    read(f, temp);
    currsub := temp;
  end;
  close(f);
end;

procedure GlobScan;
begin
end;

procedure JumpConf(PString: str50);
var temp: byte;
    c: file of confinforec;
    ctemp: confinforec;
begin
  if not systemf.useconfs then
  begin
    prt('Conferences NOT enabled!');
    exit;
  end;
  assign(c, 'GLOBAL.MAP');
  {$I-} reset(c); {$I+}
  if IOResult <> 0 then exit;
  if PString = '' then
  begin
    prtln('LIST:');
    {Show list and ask}
  end;
  if not thisuser.confaccessa[str2v(pstring)] then
   begin
    prtln('|WYou can''t access this conference!'+pstring);
    exit;
   end;
  if pstring[1] in ['1' .. '5'] then
   begin
    temp := str2v(pstring);
    seek(c, temp - 1);
    {$I-} read(c, ctemp); {$I+}
    if (IOresult <> 0) then
      prt('Bad Conference')
    else
      thisuser.confon := temp;
   end
  else {some error stuff};
   close(c);
end;

procedure NewScan;
begin
end;

procedure ReadMessage(PString: str50);
var num,x: longint;
    temp: string;
    ndx: indexrec;
    f: file of char;
    c: char;
begin
  if Pstring <> '' then
    num := str2v(Pstring)
  else
  begin
    prt('Which? ');
    input1(temp);
    num := str2v(temp);
  end;
  LoadNdx(ndx, num);
  assign(f, currsub.filen+'.SUB');
  prtln('Title: '+ndx.title);
  prtln('From: '+ndx.from);
  prtln('To: '+ndx.whoto);
  nl;
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
   Begin
    prtln('Can''t read that one!');
    exit;
   End;
  Seek(f, ndx.msgloc);
  For x := 1 to ndx.msglen do
   Begin
    read(f, c);
    prt(c);
   End;
  close(f);
  nl;
 End;

procedure Scan;
 var
  ndx: indexrec;
  x: longint;
  s: string;
 Begin
  prtln('Next Ten Message Titles: ');
  for x := 1 to 10 do
   begin
    loadndx(ndx, messnum + x);
    prtln('('+v2str(messnum + x)+') '+ndx.title);
   end;
  nl;
  prt('Which? ');
  input1(s);
  messnum := str2v(s);
 end;

procedure Post(PString: str50);
var
  temp1, temp2: str50;
  info: inforec;
begin
  info.whoto := '';
  info.title := '';
  if PString <> '' then
  begin
    temp1 := PString;
    delete(temp1,pos(';',temp1),length(temp1) - pos(';',temp1) + 1);
    temp2 := PString;
    delete(temp2, 1, pos(';',temp2));
    info.title := temp1;
    info.whoto := temp2;
  end;
  info.numto := 1;
  writemsg(currsub, info);
end;

procedure QuikScan;
begin
end;

procedure Upload;
begin
end;

procedure Reply(PString: str50);
var
  ndx: indexrec;
  info: inforec;
begin
  if (PString = '') then
    info.numto := messnum
  else
    info.numto := str2v(PString);
  if info.numto = 0 then info.numto := messnum;
  LoadNDX(ndx, info.numto);
  info.whoto := ndx.from;
  info.title := 'RE: '+ndx.title;
  writemsg(currsub, info);
end;

procedure MessageCmd(FString: str2; PString: str50; Access: integer;
                     result: boolean);
begin
  case FString[2] of
    'A': AreaChange(PString);
    'G': GlobScan;
    'J': JumpConf(PString);
    'N': Newscan;
    'P': Post(PString);
    'Q': QuikScan;
    'R': ReadMessage(PString);
    'S': Scan;
    'U': Upload;
    'W': Reply(PString);
  end;
end;

end.
